/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.scenegraph.SceneGraph;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public abstract class AbstractSceneGraphParser {
    protected StanfordCoreNLP pipeline;

    public abstract SceneGraph parse(SemanticGraph var1);

    public SceneGraph parse(Annotation annotation) {
        Iterator iterator = ((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).iterator();
        if (iterator.hasNext()) {
            CoreMap sentence = (CoreMap)iterator.next();
            SemanticGraph sg = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.CollapsedCCProcessedDependenciesAnnotation.class);
            return this.parse(sg);
        }
        return null;
    }

    private void initPipeline() {
        Properties props = new Properties();
        props.setProperty("annotators", "tokenize,ssplit,parse,lemma,ner");
        props.setProperty("depparse.model", "edu/stanford/nlp/models/scenegraph/englishPCFG-3.5.2+brown.ser.gz");
        props.setProperty("depparse.extradependencies", "MAXIMAL");
        this.pipeline = new StanfordCoreNLP(props);
    }

    protected AbstractSceneGraphParser() {
    }

    public SceneGraph parse(String input) {
        if (this.pipeline == null) {
            this.initPipeline();
        }
        Annotation ann = new Annotation(input);
        this.pipeline.annotate(ann);
        return this.parse(ann);
    }
}

