/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.scenegraph.AbstractSceneGraphParser;
import edu.stanford.nlp.scenegraph.SceneGraph;
import edu.stanford.nlp.scenegraph.SceneGraphEvaluation;
import edu.stanford.nlp.scenegraph.SceneGraphNode;
import edu.stanford.nlp.scenegraph.SemanticGraphEnhancer;
import edu.stanford.nlp.scenegraph.image.SceneGraphImage;
import edu.stanford.nlp.scenegraph.image.SceneGraphImageRegion;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Triple;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import java.util.List;
import java.util.Scanner;

public class RuleBasedParser
extends AbstractSceneGraphParser {
    public static SemgrexPattern SUBJ_PRED_OBJ_TRIPLET_PATTERN = SemgrexPattern.compile("{}=pred >nsubj {tag:/NNP?S?/}=subj >/(iobj|obj|nmod:.*|obl:.*)/=objreln {tag:/NNP?S?/}=obj !> cop {}");
    public static SemgrexPattern SUBJ_PRED_PAIR_PATTERN = SemgrexPattern.compile("{}=pred >nsubj {tag:/NNP?S?/}=subj !>/(iobj|obj|nmod:.*|obl:.*)/ {tag:/NNP?S?/} !>cop {}");
    public static SemgrexPattern COPULAR_PATTERN = SemgrexPattern.compile("{}=pred >nsubj {tag:/NNP?S?/}=subj >cop {}");
    public static SemgrexPattern ADJ_MOD_PATTERN = SemgrexPattern.compile("{}=obj >/(amod)/ {}=adj");
    public static SemgrexPattern ADJ_PRED_PATTERN = SemgrexPattern.compile("{tag:/J.*/}=adj >nsubj {}=obj");
    public static SemgrexPattern PP_MOD_PATTERN = SemgrexPattern.compile("{tag:/NNP?S?/}=gov >/(nmod:.*|obl:.*)/=reln {}=mod");
    public static SemgrexPattern POSS_PATTERN = SemgrexPattern.compile("{tag:/NNP?S?/}=gov >/nmod:poss/=reln {tag:/NNP?S?/}=mod");
    public static SemgrexPattern AGENT_PATTERN = SemgrexPattern.compile("{tag:/V.*/}=pred >/obl:agent/=reln {tag:/NNP?S?/}=subj >/nsubj:pass/ {tag:/NNP?S?/}=obj ");
    public static SemgrexPattern ACL_PATTERN = SemgrexPattern.compile("{}=subj >acl ({tag:/V.*/}=pred >/(iobj|obj|nmod:.*|obl:.*)/=objreln {tag:/NNP?S?/}=obj)");
    private static final SemgrexPattern NUMMOD_PATTERN = SemgrexPattern.compile("{} >/(nummod|qmod)/ {}");

    private String getPredicate(SemanticGraph sg, IndexedWord mainPred) {
        if (sg.hasChildWithReln(mainPred, UniversalEnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE)) {
            IndexedWord part = sg.getChildWithReln(mainPred, UniversalEnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE);
            return String.format("%s %s", mainPred.lemma().equals("be") ? "" : mainPred.lemma(), part.value());
        }
        return mainPred.lemma();
    }

    @Override
    public SceneGraph parse(SemanticGraph sg) {
        SemgrexPattern[] subjPredPatterns;
        SceneGraphNode node2;
        SceneGraphNode node1;
        String predicate;
        String reln;
        IndexedWord pred;
        IndexedWord subj;
        SemanticGraphEnhancer.enhance(sg);
        SceneGraph scene = new SceneGraph();
        scene.sg = sg;
        SemgrexMatcher matcher = SUBJ_PRED_OBJ_TRIPLET_PATTERN.matcher(sg);
        while (matcher.find()) {
            subj = matcher.getNode("subj");
            IndexedWord indexedWord = matcher.getNode("obj");
            pred = matcher.getNode("pred");
            reln = matcher.getRelnString("objreln");
            predicate = this.getPredicate(sg, pred);
            if (reln.startsWith("nmod:") && !reln.equals("nmod:poss") && !reln.equals("nmod:agent")) {
                predicate = predicate + reln.replace("nmod:", " ").replace("_", " ");
            }
            node1 = new SceneGraphNode(subj);
            node2 = new SceneGraphNode(indexedWord);
            scene.addEdge(node1, node2, predicate);
        }
        matcher = ACL_PATTERN.matcher(sg);
        while (matcher.find()) {
            subj = matcher.getNode("subj");
            IndexedWord indexedWord = matcher.getNode("obj");
            pred = matcher.getNode("pred");
            reln = matcher.getRelnString("objreln");
            predicate = this.getPredicate(sg, pred);
            if (reln.startsWith("nmod:") && !reln.equals("nmod:poss") && !reln.equals("nmod:agent")) {
                predicate = predicate + reln.replace("nmod:", " ").replace("_", " ");
            }
            node1 = new SceneGraphNode(subj);
            node2 = new SceneGraphNode(indexedWord);
            scene.addEdge(node1, node2, predicate);
        }
        for (SemgrexPattern p : subjPredPatterns = new SemgrexPattern[]{SUBJ_PRED_PAIR_PATTERN, COPULAR_PATTERN}) {
            matcher = p.matcher(sg);
            while (matcher.find()) {
                IndexedWord subj2 = matcher.getNode("subj");
                IndexedWord pred2 = matcher.getNode("pred");
                if (sg.hasChildWithReln(pred2, UniversalEnglishGrammaticalRelations.CASE_MARKER)) {
                    IndexedWord caseMarker = sg.getChildWithReln(pred2, UniversalEnglishGrammaticalRelations.CASE_MARKER);
                    String prep = caseMarker.value();
                    if (sg.hasChildWithReln(caseMarker, UniversalEnglishGrammaticalRelations.MULTI_WORD_EXPRESSION)) {
                        for (IndexedWord additionalCaseMarker : sg.getChildrenWithReln(caseMarker, UniversalEnglishGrammaticalRelations.MULTI_WORD_EXPRESSION)) {
                            prep = prep + " " + additionalCaseMarker.value();
                        }
                    }
                    SceneGraphNode node12 = new SceneGraphNode(subj2);
                    SceneGraphNode node22 = new SceneGraphNode(pred2);
                    scene.addEdge(node12, node22, prep);
                    continue;
                }
                if (pred2.lemma().equals("be")) continue;
                SceneGraphNode node = scene.getOrAddNode(subj2);
                node.addAttribute(pred2);
            }
        }
        matcher = ADJ_MOD_PATTERN.matcher(sg);
        while (matcher.find()) {
            IndexedWord indexedWord = matcher.getNode("obj");
            IndexedWord adj = matcher.getNode("adj");
            SceneGraphNode node = scene.getOrAddNode(indexedWord);
            node.addAttribute(adj);
        }
        matcher = ADJ_PRED_PATTERN.matcher(sg);
        while (matcher.find()) {
            IndexedWord indexedWord = matcher.getNode("obj");
            IndexedWord adj = matcher.getNode("adj");
            SceneGraphNode node = scene.getOrAddNode(indexedWord);
            node.addAttribute(adj);
        }
        matcher = PP_MOD_PATTERN.matcher(sg);
        while (matcher.find()) {
            IndexedWord indexedWord = matcher.getNode("gov");
            IndexedWord mod = matcher.getNode("mod");
            String reln2 = matcher.getRelnString("reln");
            predicate = reln2.replace("nmod:", "").replace("_", " ");
            if (predicate.equals("poss") || predicate.equals("agent")) continue;
            node1 = new SceneGraphNode(indexedWord);
            node2 = new SceneGraphNode(mod);
            scene.addEdge(node1, node2, predicate);
        }
        matcher = POSS_PATTERN.matcher(sg);
        while (matcher.find()) {
            IndexedWord indexedWord = matcher.getNode("gov");
            IndexedWord mod = matcher.getNode("mod");
            SceneGraphNode node13 = new SceneGraphNode(mod);
            SceneGraphNode node23 = new SceneGraphNode(indexedWord);
            scene.addEdge(node13, node23, "have");
        }
        matcher = AGENT_PATTERN.matcher(sg);
        while (matcher.find()) {
            IndexedWord indexedWord = matcher.getNode("subj");
            IndexedWord obj2 = matcher.getNode("obj");
            IndexedWord pred3 = matcher.getNode("pred");
            SceneGraphNode node14 = new SceneGraphNode(indexedWord);
            SceneGraphNode node24 = new SceneGraphNode(obj2);
            scene.addEdge(node14, node24, this.getPredicate(sg, pred3));
        }
        return scene;
    }

    public static void countDoubleNumMods(List<SceneGraphImage> images) {
        RuleBasedParser parser = new RuleBasedParser();
        int doubleMatches = 0;
        for (SceneGraphImage img : images) {
            for (SceneGraphImageRegion region : img.regions) {
                SceneGraph scene = parser.parse(region.phrase);
                SemgrexMatcher matcher = NUMMOD_PATTERN.matcher(scene.sg);
                int matches = 0;
                while (matcher.findNextMatchingNode()) {
                    ++matches;
                }
                if (matches <= 1) continue;
                System.err.println(region.phrase);
                ++doubleMatches;
            }
        }
        System.err.println(doubleMatches);
    }

    public static void main(String[] args) throws IOException {
        RuleBasedParser parser = new RuleBasedParser();
        SceneGraphEvaluation eval = new SceneGraphEvaluation();
        if (args.length < 1) {
            String line;
            System.err.println("Processing from stdin. Enter one sentence per line.");
            System.err.print("> ");
            Scanner scanner = new Scanner(System.in);
            while ((line = scanner.nextLine()) != null) {
                SceneGraph scene = parser.parse(line);
                System.err.println(scene.toReadableString());
                System.err.println("------------------------");
                System.err.print("> ");
            }
            scanner.close();
        } else {
            String filename = args[0];
            BufferedReader reader = IOUtils.readerFromString(filename);
            PrintWriter predWriter = IOUtils.getPrintWriter(args[1]);
            PrintWriter goldWriter = IOUtils.getPrintWriter(args[2]);
            if (args.length > 1 && args[1].equals("n")) {
                LinkedList<SceneGraphImage> images = Generics.newLinkedList();
                String line = reader.readLine();
                while (line != null) {
                    SceneGraphImage img = SceneGraphImage.readFromJSON(line);
                    if (img != null) {
                        images.add(img);
                    }
                    line = reader.readLine();
                }
                RuleBasedParser.countDoubleNumMods(images);
            } else {
                double count = 0.0;
                double f1Sum = 0.0;
                String line = reader.readLine();
                while (line != null) {
                    SceneGraphImage img = SceneGraphImage.readFromJSON(line);
                    if (img != null) {
                        for (SceneGraphImageRegion region : img.regions) {
                            count += 1.0;
                            SceneGraph scene = parser.parse(region.phrase);
                            System.err.println(region.phrase);
                            System.out.println(scene.toJSON(img.id, img.url, region.phrase));
                            System.err.println(scene.toReadableString());
                            System.err.println(region.toReadableString());
                            Triple<Double, Double, Double> scores = eval.evaluate(scene, region);
                            System.err.printf("Prec: %f, Recall: %f, F1: %f%n", scores.first, scores.second, scores.third);
                            eval.toSmatchString(scene, region, predWriter, goldWriter);
                            f1Sum += ((Double)scores.third).doubleValue();
                            System.err.println("------------------------");
                        }
                    }
                    line = reader.readLine();
                }
                System.err.println("#########################################################");
                System.err.printf("Macro-averaged F1: %f%n", f1Sum / count);
                System.err.println("#########################################################");
            }
        }
    }
}

