/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.scenegraph.SceneGraphAttribute;
import edu.stanford.nlp.scenegraph.SceneGraphNode;
import edu.stanford.nlp.scenegraph.SceneGraphRelation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.util.MapFactory;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;

public class SceneGraph {
    private final DirectedMultiGraph<SceneGraphNode, SceneGraphRelation> graph = new DirectedMultiGraph<SceneGraphNode, SceneGraphRelation>(outerMapFactory, innerMapFactory);
    private static final MapFactory<SceneGraphNode, Map<SceneGraphNode, List<SceneGraphRelation>>> outerMapFactory = MapFactory.hashMapFactory();
    private static final MapFactory<SceneGraphNode, List<SceneGraphRelation>> innerMapFactory = MapFactory.hashMapFactory();
    public SemanticGraph sg;

    public void addEdge(SceneGraphNode source, SceneGraphNode target, String relation) {
        relation = relation.replaceAll("^be ", "");
        SceneGraphRelation edge = new SceneGraphRelation(source, target, relation);
        this.graph.add(source, target, edge);
    }

    public List<SceneGraphRelation> relationListSorted() {
        ArrayList<SceneGraphRelation> relations = new ArrayList<SceneGraphRelation>(this.graph.getAllEdges());
        Collections.sort(relations);
        return relations;
    }

    public List<SceneGraphNode> nodeListSorted() {
        ArrayList<SceneGraphNode> nodes = new ArrayList<SceneGraphNode>(this.graph.getAllVertices());
        Collections.sort(nodes);
        return nodes;
    }

    public String toReadableString() {
        StringBuilder buf = new StringBuilder();
        buf.append(String.format("%-20s%-20s%-20s%n", "source", "reln", "target"));
        buf.append(String.format("%-20s%-20s%-20s%n", "---", "----", "---"));
        for (SceneGraphRelation edge : this.relationListSorted()) {
            buf.append(String.format("%-20s%-20s%-20s%n", edge.getSource(), edge.getRelation(), edge.getTarget()));
        }
        buf.append(String.format("%n%n", new Object[0]));
        buf.append(String.format("%-20s%n", "Nodes"));
        buf.append(String.format("%-20s%n", "---"));
        for (SceneGraphNode node : this.nodeListSorted()) {
            buf.append(String.format("%-20s%n", node));
            for (SceneGraphAttribute attr : node.getAttributes()) {
                buf.append(String.format("  -%-20s%n", attr));
            }
        }
        return buf.toString();
    }

    public static void main(String[] args) {
        SceneGraph sg = new SceneGraph();
        System.out.println(sg.toReadableString());
    }

    public void addNode(IndexedWord value) {
        this.addNode(new SceneGraphNode(value));
    }

    public void addNode(SceneGraphNode node) {
        this.graph.addVertex(node);
    }

    public SceneGraphNode getOrAddNode(IndexedWord value) {
        SceneGraphNode node = new SceneGraphNode(value);
        for (SceneGraphNode node2 : this.graph.getAllVertices()) {
            if (!node2.equals(node)) continue;
            return node2;
        }
        this.graph.addVertex(node);
        return node;
    }

    public String toJSON(int imageID, String url, String phrase) {
        JsonObjectBuilder obj = Json.createObjectBuilder();
        obj.add("id", imageID);
        obj.add("url", url);
        obj.add("phrase", phrase);
        List<SceneGraphNode> objects = this.nodeListSorted();
        JsonArrayBuilder attrs = Json.createArrayBuilder();
        for (SceneGraphNode sceneGraphNode : objects) {
            for (SceneGraphAttribute attr : sceneGraphNode.getAttributes()) {
                JsonObjectBuilder attrObj = Json.createObjectBuilder();
                attrObj.add("attribute", attr.toString());
                attrObj.add("object", attr.toString());
                attrObj.add("predicate", "is");
                attrObj.add("subject", objects.indexOf(sceneGraphNode));
                JsonArrayBuilder text = Json.createArrayBuilder();
                text.add(sceneGraphNode.toJSONString());
                text.add("is");
                text.add(attr.toString());
                attrObj.add("text", (JsonValue)text.build());
                attrs.add((JsonValue)attrObj.build());
            }
        }
        obj.add("attributes", (JsonValue)attrs.build());
        JsonArrayBuilder relns = Json.createArrayBuilder();
        for (SceneGraphRelation reln : this.relationListSorted()) {
            JsonObjectBuilder relnObj = Json.createObjectBuilder();
            relnObj.add("predicate", reln.getRelation());
            relnObj.add("subject", objects.indexOf(reln.getSource()));
            relnObj.add("object", objects.indexOf(reln.getTarget()));
            JsonArrayBuilder text = Json.createArrayBuilder();
            text.add(reln.getSource().toJSONString());
            text.add(reln.getRelation());
            text.add(reln.getTarget().toJSONString());
            relnObj.add("text", (JsonValue)text.build());
            relns.add((JsonValue)relnObj.build());
        }
        obj.add("relationships", (JsonValue)relns.build());
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (SceneGraphNode node : objects) {
            JsonObjectBuilder objObj = Json.createObjectBuilder();
            JsonArrayBuilder names = Json.createArrayBuilder();
            names.add(node.toJSONString());
            objObj.add("names", (JsonValue)names.build());
            jsonArrayBuilder.add((JsonValue)objObj.build());
        }
        obj.add("objects", (JsonValue)jsonArrayBuilder.build());
        return obj.build().toString();
    }
}

