/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.scenegraph.SceneGraphAttribute;
import edu.stanford.nlp.scenegraph.SceneGraphCoreAnnotations;
import java.util.HashSet;
import java.util.Set;

public class SceneGraphNode
implements Comparable<SceneGraphNode> {
    private IndexedWord value;
    private Set<SceneGraphAttribute> attributes;

    public SceneGraphNode(IndexedWord value) {
        this.value = value;
        this.attributes = new HashSet<SceneGraphAttribute>();
    }

    public IndexedWord value() {
        return this.value;
    }

    public void addAttribute(IndexedWord value) {
        SceneGraphAttribute attribute = new SceneGraphAttribute(value);
        this.addAttribute(attribute);
    }

    public void addAttribute(SceneGraphAttribute attribute) {
        this.attributes.add(attribute);
    }

    public boolean hasAttribute(SceneGraphAttribute attribute) {
        return this.attributes.contains(attribute);
    }

    public void removeAttribute(SceneGraphAttribute attribute) {
        this.attributes.remove(attribute);
    }

    public Set<SceneGraphAttribute> getAttributes() {
        return this.attributes;
    }

    @Override
    public int compareTo(SceneGraphNode o) {
        if (o == null) {
            return 1;
        }
        return this.value.compareTo(o.value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (!(o instanceof SceneGraphNode)) {
            return false;
        }
        SceneGraphNode otherNode = (SceneGraphNode)o;
        return this.value.equals(otherNode.value);
    }

    public String toString() {
        return this.value().toString(CoreLabel.OutputFormat.LEMMA_INDEX);
    }

    public String toJSONString() {
        if (this.value.containsKey(SceneGraphCoreAnnotations.PredictedEntityAnnotation.class)) {
            return this.value.getString(SceneGraphCoreAnnotations.PredictedEntityAnnotation.class);
        }
        if (this.value.containsKey(SceneGraphCoreAnnotations.CompoundLemmaAnnotation.class)) {
            return this.value.getString(SceneGraphCoreAnnotations.CompoundLemmaAnnotation.class);
        }
        return this.value.lemma();
    }
}

