/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.scenegraph.SceneGraphCoreAnnotations;
import edu.stanford.nlp.scenegraph.SimplePronounResolution;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.NPTmpRetainingTreeNormalizer;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalRelations;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.HashIndex;
import edu.stanford.nlp.util.Index;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class SemanticGraphEnhancer {
    public static final SemgrexPattern QUANT_MOD_PATTERN = SemgrexPattern.compile("{word:/(?i:lot|assortment|number|couple|bunch|handful|litany|sheaf|slew|dozen|series|variety|multitude|wad|clutch|wave|mountain|array|spate|string|ton|range|plethora|heap|sort|form|kind|type|version|bit|pair|triple|total)/}=w2 >det {word:/(?i:an?)/}=w1 >/nmod.*/ ({tag:/(NN.*|PRP.*)/}=gov >case {word:/(?i:of)/}=w3) . {}=w3");
    public static final SemgrexPattern QUANT_MOD_PATTERN2 = SemgrexPattern.compile("{word:/(?i:lots|many|several|plenty|tons|dozens|multitudes|mountains|loads|pairs|tens|hundreds|thousands|millions|billions|trillions|[0-9]+s)/}=w1 >/nmod.*/ ({tag:/(NN.*|PRP.*)/}=gov >case {word:/(?i:of)/}=w2) . {}=w2");
    public static final SemgrexPattern QUANT_MOD_PATTERN3 = SemgrexPattern.compile("{word:/(?i:some|all|both|neither|everyone|nobody|one|two|three|four|five|six|seven|eight|nine|ten|hundred|thousand|million|billion|trillion|[0-9]+)/}=w1 [>/nmod.*/ ({tag:/(NN.*)/}=gov >case ({word:/(?i:of)/}=w2 $+ {}=det) >det {}=det) |  >/nmod.*/ ({tag:/(PRP.*)/}=gov >case {word:/(?i:of)/}=w2)] . {}=w2");
    private static SimplePronounResolution pronounResolver = new SimplePronounResolution();
    private static final SemgrexPattern PLURAL_SUBJECT_OBJECT_PATTERN = SemgrexPattern.compile("{}=pred >nsubj {tag:/NNP?S/}=subj [ >/(.obj)/ ({tag:/NNP?S/}=obj) |  >/(nmod:((?!agent).)*$)/ ({tag:/NNP?S/}=obj >case {}) ] ");
    private static final SemgrexPattern PLURAL_SUBJECT_PATTERN = SemgrexPattern.compile("{tag:/NNP?S/}=subj [ == {$} | <nsubj ({} !>/.obj/ {tag:/NNP?S/} !>/(nmod:((?!agent).)*$)/ ({tag:/NNP?S/} > case {}) )]");
    private static final SemgrexPattern PLURAL_OTHER_PATTERN = SemgrexPattern.compile("{tag:/NNP?S/}=word !== {$} !<nsubj {} !</.obj|nmod.*/ ({} >nsubj {tag:/NNP?S/})");

    public static void processQuanftificationModifiers(SemanticGraph sg) {
        LinkedList<IndexedWord> otherDeps;
        Object edge;
        IndexedWord parent;
        IndexedWord gov;
        IndexedWord w2;
        IndexedWord w1;
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = QUANT_MOD_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            w1 = matcher.getNode("w1");
            w2 = matcher.getNode("w2");
            IndexedWord w3 = matcher.getNode("w3");
            IndexedWord gov2 = matcher.getNode("gov");
            if (!sg.getRoots().contains(w2)) {
                IndexedWord parent2 = sg.getParent(w2);
                if (parent2 == null) {
                    return;
                }
                SemanticGraphEdge edge2 = sg.getEdge(parent2, w2);
                sg.removeEdge(edge2);
                sg.addEdge(parent2, gov2, edge2.getRelation(), edge2.getWeight(), edge2.isExtra());
            } else {
                sg.getRoots().remove(w2);
                sg.addRoot(gov2);
            }
            sg.removeEdge(sg.getEdge(w2, gov2));
            LinkedList<IndexedWord> otherDeps2 = Generics.newLinkedList();
            otherDeps2.add(w1);
            otherDeps2.add(w2);
            otherDeps2.add(w3);
            for (IndexedWord child : sg.getChildrenWithReln(w2, UniversalEnglishGrammaticalRelations.ADJECTIVAL_MODIFIER)) {
                if (child.index() >= w2.index()) continue;
                otherDeps2.add(child);
            }
            Collections.sort(otherDeps2);
            SemanticGraphEnhancer.createMultiWordExpression(sg, gov2, UniversalEnglishGrammaticalRelations.QMOD, otherDeps2.toArray(new IndexedWord[otherDeps2.size()]));
        }
        sgCopy = sg.makeSoftCopy();
        matcher = QUANT_MOD_PATTERN2.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            w1 = matcher.getNode("w1");
            w2 = matcher.getNode("w2");
            gov = matcher.getNode("gov");
            if (!sg.getRoots().contains(w1)) {
                parent = sg.getParent(w1);
                if (parent == null) {
                    return;
                }
                edge = sg.getEdge(parent, w1);
                sg.removeEdge((SemanticGraphEdge)edge);
                sg.addEdge(parent, gov, ((SemanticGraphEdge)edge).getRelation(), ((SemanticGraphEdge)edge).getWeight(), ((SemanticGraphEdge)edge).isExtra());
            } else {
                sg.getRoots().remove(w1);
                sg.addRoot(gov);
            }
            sg.removeEdge(sg.getEdge(w1, gov));
            otherDeps = Generics.newLinkedList();
            otherDeps.add(w1);
            otherDeps.add(w2);
            for (IndexedWord child : sg.getChildren(w1)) {
                if (child.index() >= w1.index()) continue;
                otherDeps.add(child);
            }
            Collections.sort(otherDeps);
            SemanticGraphEnhancer.createMultiWordExpression(sg, gov, UniversalEnglishGrammaticalRelations.QMOD, otherDeps.toArray(new IndexedWord[otherDeps.size()]));
        }
        sgCopy = sg.makeSoftCopy();
        matcher = QUANT_MOD_PATTERN3.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            w1 = matcher.getNode("w1");
            w2 = matcher.getNode("w2");
            gov = matcher.getNode("gov");
            if (!sg.getRoots().contains(w1)) {
                parent = sg.getParent(w1);
                if (parent == null) {
                    return;
                }
                edge = sg.getEdge(parent, w1);
                sg.removeEdge((SemanticGraphEdge)edge);
                sg.addEdge(parent, gov, ((SemanticGraphEdge)edge).getRelation(), ((SemanticGraphEdge)edge).getWeight(), ((SemanticGraphEdge)edge).isExtra());
            } else {
                sg.getRoots().remove(w1);
                sg.addRoot(gov);
            }
            sg.removeEdge(sg.getEdge(w1, gov));
            otherDeps = Generics.newLinkedList();
            otherDeps.add(w1);
            otherDeps.add(w2);
            for (IndexedWord child : sg.getChildren(w1)) {
                if (child.index() >= w1.index()) continue;
                otherDeps.add(child);
            }
            Collections.sort(otherDeps);
            SemanticGraphEnhancer.createMultiWordExpression(sg, gov, UniversalEnglishGrammaticalRelations.QMOD, otherDeps.toArray(new IndexedWord[otherDeps.size()]));
        }
    }

    private static void createMultiWordExpression(SemanticGraph sg, IndexedWord gov, GrammaticalRelation reln, IndexedWord ... words) {
        if (sg.getRoots().isEmpty() || gov == null || words.length < 1) {
            return;
        }
        boolean first = true;
        IndexedWord mweHead = null;
        for (IndexedWord word : words) {
            for (SemanticGraphEdge edge : sg.incomingEdgeList(word)) {
                sg.removeEdge(edge);
            }
            if (first) {
                sg.addEdge(gov, word, reln, Double.NEGATIVE_INFINITY, false);
                mweHead = word;
                first = false;
                continue;
            }
            sg.addEdge(mweHead, word, UniversalEnglishGrammaticalRelations.MULTI_WORD_EXPRESSION, Double.NEGATIVE_INFINITY, false);
        }
    }

    public static void resolvePlurals(SemanticGraph sg) {
        IndexedWord qmod;
        IndexedWord nummod;
        IndexedWord subj;
        SemanticGraph sgCopy = sg.makeSoftCopy();
        SemgrexMatcher matcher = PLURAL_SUBJECT_OBJECT_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            IndexedWord qmod2;
            subj = matcher.getNode("subj");
            IndexedWord obj = matcher.getNode("obj");
            IndexedWord pred = matcher.getNode("pred");
            int numCopies = 1;
            if (sg.hasChildWithReln(subj, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER)) {
                IndexedWord nummod2 = sg.getChildWithReln(subj, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER);
                if (nummod2.index() > subj.index()) continue;
                if (nummod2.get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)nummod2.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                    numCopies = ((Number)nummod2.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
                }
            } else if (sg.hasChildWithReln(subj, UniversalEnglishGrammaticalRelations.QMOD) && (qmod2 = sg.getChildWithReln(subj, UniversalEnglishGrammaticalRelations.QMOD)).get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)qmod2.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                numCopies = ((Number)qmod2.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
            }
            for (int i = 0; i < numCopies; ++i) {
                IndexedWord predCopy = pred.makeSoftCopy();
                IndexedWord subjCopy = subj.makeSoftCopy();
                IndexedWord objCopy = obj.makeSoftCopy();
                SemanticGraphEdge subjEdge = sg.getEdge(pred, subj);
                SemanticGraphEdge objEdge = sg.getEdge(pred, obj);
                sg.addEdge(predCopy, subjCopy, subjEdge.getRelation(), subjEdge.getWeight(), subjEdge.isExtra());
                sg.addEdge(predCopy, objCopy, objEdge.getRelation(), objEdge.getWeight(), objEdge.isExtra());
                if (sg.getRoots().contains(pred)) {
                    sg.addRoot(subjCopy);
                } else {
                    for (SemanticGraphEdge edge : sg.incomingEdgeIterable(pred)) {
                        sg.addEdge(edge.getGovernor(), predCopy, edge.getRelation(), edge.getWeight(), edge.isExtra());
                    }
                }
                for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(pred)) {
                    if (edge.getDependent().equals(subj) || edge.getDependent().equals(obj)) continue;
                    sg.addEdge(predCopy, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
                }
                for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(subj)) {
                    if (edge.getDependent() == obj) {
                        sg.addEdge(subjCopy, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
                        continue;
                    }
                    sg.addEdge(subjCopy, objCopy, edge.getRelation(), edge.getWeight(), edge.isExtra());
                }
                for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(obj)) {
                    if (edge.getDependent() == subj) {
                        sg.addEdge(objCopy, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
                        continue;
                    }
                    sg.addEdge(objCopy, subjCopy, edge.getRelation(), edge.getWeight(), edge.isExtra());
                }
            }
        }
        matcher = PLURAL_SUBJECT_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            subj = matcher.getNode("subj");
            int numCopies = 1;
            if (sg.hasChildWithReln(subj, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER)) {
                nummod = sg.getChildWithReln(subj, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER);
                if (nummod.index() > subj.index()) continue;
                if (nummod.get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)nummod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                    numCopies = ((Number)nummod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
                }
            } else if (sg.hasChildWithReln(subj, UniversalEnglishGrammaticalRelations.QMOD) && (qmod = sg.getChildWithReln(subj, UniversalEnglishGrammaticalRelations.QMOD)).get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)qmod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                numCopies = ((Number)qmod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
            }
            SemanticGraphEnhancer.copyNode(sg, subj, numCopies);
        }
        matcher = PLURAL_OTHER_PATTERN.matcher(sgCopy);
        while (matcher.findNextMatchingNode()) {
            IndexedWord word = matcher.getNode("word");
            int numCopies = 0;
            if (sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER)) {
                nummod = sg.getChildWithReln(word, UniversalEnglishGrammaticalRelations.NUMERIC_MODIFIER);
                if (nummod.index() > word.index()) continue;
                if (nummod.get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)nummod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                    numCopies = ((Number)nummod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
                }
            } else if (sg.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.QMOD) && (qmod = sg.getChildWithReln(word, UniversalEnglishGrammaticalRelations.QMOD)).get(CoreAnnotations.NumericValueAnnotation.class) != null && ((Number)qmod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() < 20) {
                numCopies = ((Number)qmod.get(CoreAnnotations.NumericValueAnnotation.class)).intValue() - 1;
            }
            SemanticGraphEnhancer.copyNode(sg, word, numCopies);
        }
    }

    private static void copyNode(SemanticGraph sg, IndexedWord node, int numCopies) {
        for (int i = 0; i < numCopies; ++i) {
            IndexedWord copy = node.makeSoftCopy();
            for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(node)) {
                sg.addEdge(copy, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
            for (SemanticGraphEdge edge : sg.incomingEdgeIterable(node)) {
                sg.addEdge(edge.getGovernor(), copy, edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
            if (!sg.getRoots().contains(node)) continue;
            sg.addRoot(copy);
        }
    }

    public static void collapseCompounds(SemanticGraph sg) {
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (IndexedWord word : sgCopy.vertexSet()) {
            int i;
            if (!sgCopy.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER)) continue;
            ArrayList<IndexedWord> compound = Generics.newArrayList();
            compound.add(word);
            for (IndexedWord word2 : sgCopy.getChildrenWithReln(word, UniversalEnglishGrammaticalRelations.COMPOUND_MODIFIER)) {
                compound.add(word2);
            }
            Collections.sort(compound);
            boolean collapse = true;
            int idx = ((IndexedWord)compound.get(i)).index() - 1;
            int sz = compound.size();
            for (i = 0; i < sz; ++i) {
                if (((IndexedWord)compound.get(i)).index() != idx + 1 || ((IndexedWord)compound.get(i)).index() > word.index()) {
                    collapse = false;
                    break;
                }
                idx = ((IndexedWord)compound.get(i)).index();
            }
            if (!collapse) continue;
            String lemma = StringUtils.join(compound.stream().map(x -> x.lemma() != null ? x.lemma() : x.word()), " ");
            word.set(SceneGraphCoreAnnotations.CompoundWordAnnotation.class, StringUtils.join(compound.stream().map(IndexedWord::word), " "));
            word.set(SceneGraphCoreAnnotations.CompoundLemmaAnnotation.class, lemma);
        }
    }

    public static void collapseParticles(SemanticGraph sg) {
        SemanticGraph sgCopy = sg.makeSoftCopy();
        for (IndexedWord word : sgCopy.vertexSet()) {
            if (!sgCopy.hasChildWithReln(word, UniversalEnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE)) continue;
            ArrayList<IndexedWord> compound = Generics.newArrayList();
            compound.add(word);
            for (IndexedWord word2 : sgCopy.getChildrenWithReln(word, UniversalEnglishGrammaticalRelations.PHRASAL_VERB_PARTICLE)) {
                compound.add(word2);
            }
            Collections.sort(compound);
            boolean collapse = true;
            int sz = compound.size();
            for (int i = 0; i < sz; ++i) {
                if (((IndexedWord)compound.get(i)).index() >= word.index()) continue;
                collapse = false;
                break;
            }
            if (!collapse) continue;
            String lemma = StringUtils.join(compound.stream().map(x -> x.lemma() != null ? x.lemma() : x.word()), " ");
            word.set(SceneGraphCoreAnnotations.CompoundWordAnnotation.class, StringUtils.join(compound.stream().map(IndexedWord::word), " "));
            word.set(SceneGraphCoreAnnotations.CompoundLemmaAnnotation.class, lemma);
        }
    }

    public static void resolvePronouns(SemanticGraph sg) {
        HashMap<Integer, Integer> resolvedPronouns = pronounResolver.resolvePronouns(sg);
        for (Integer key : resolvedPronouns.keySet()) {
            Integer mentionIdx = resolvedPronouns.get(key);
            IndexedWord mention = sg.getNodeByIndexSafe(mentionIdx);
            IndexedWord pronoun = sg.getNodeByIndexSafe(key);
            if (mention == null || pronoun == null) continue;
            if (sg.getRoots().contains(pronoun)) {
                sg.getRoots().remove(pronoun);
                sg.getRoots().add(mention);
            } else {
                List<SemanticGraphEdge> incomingEdges = sg.getIncomingEdgesSorted(pronoun);
                for (SemanticGraphEdge edge : incomingEdges) {
                    sg.removeEdge(edge);
                    sg.addEdge(edge.getGovernor(), mention, edge.getRelation(), edge.getWeight(), edge.isExtra());
                }
            }
            if (mention.get(SceneGraphCoreAnnotations.IndicesAnnotation.class) == null) {
                mention.set(SceneGraphCoreAnnotations.IndicesAnnotation.class, Generics.newHashSet());
                ((Set)mention.get(SceneGraphCoreAnnotations.IndicesAnnotation.class)).add(mention.index());
            }
            ((Set)mention.get(SceneGraphCoreAnnotations.IndicesAnnotation.class)).add(pronoun.index());
            List<SemanticGraphEdge> outgoingEdges = sg.getOutEdgesSorted(pronoun);
            for (SemanticGraphEdge edge : outgoingEdges) {
                sg.removeEdge(edge);
                sg.addEdge(mention, edge.getDependent(), edge.getRelation(), edge.getWeight(), edge.isExtra());
            }
        }
    }

    public static void enhance(SemanticGraph sg) {
        SemanticGraphEnhancer.processQuanftificationModifiers(sg);
        SemanticGraphEnhancer.collapseCompounds(sg);
        SemanticGraphEnhancer.collapseParticles(sg);
        SemanticGraphEnhancer.resolvePronouns(sg);
        SemanticGraphEnhancer.resolvePlurals(sg);
    }

    public static void main(String[] args) throws IOException {
        String treeFile = args[0];
        MemoryTreebank tb = new MemoryTreebank(new NPTmpRetainingTreeNormalizer(0, false, 1, false));
        tb.loadPath(treeFile);
        Iterator<Tree> it = tb.iterator();
        Index<Object> relationIndex = new HashIndex<String>();
        relationIndex.addToIndex("root");
        if (args.length > 1) {
            relationIndex = HashIndex.loadFromFilename(args[1]);
            relationIndex.lock();
        }
        HashIndex<String> vectorIndex = new HashIndex<String>();
        if (args.length > 2) {
            BufferedReader reader = IOUtils.readerFromString(args[2]);
            vectorIndex.addToIndex("--UNK--");
            reader.lines().forEach(x -> vectorIndex.addToIndex((String)x));
            reader.close();
            System.err.println(vectorIndex.size());
            vectorIndex.lock();
        }
        while (it.hasNext()) {
            int idx;
            Tree t = it.next();
            SemanticGraph sg = SemanticGraphFactory.makeFromTree(t, SemanticGraphFactory.Mode.CCPROCESSED, GrammaticalStructure.Extras.MAXIMAL);
            SemanticGraphEnhancer.processQuanftificationModifiers(sg);
            SemanticGraphEnhancer.resolvePronouns(sg);
            SemanticGraphEnhancer.resolvePlurals(sg);
            int rootIndex = sg.getFirstRoot().index();
            boolean printedRoot = false;
            for (SemanticGraphEdge edge : sg.edgeListSorted()) {
                if (!printedRoot && edge.getTarget().index() > rootIndex) {
                    for (IndexedWord root : sg.getRoots()) {
                        int idx2 = vectorIndex.addToIndex(root.value().toLowerCase());
                        if (idx2 < 1) {
                            idx2 = 1;
                        }
                        System.out.printf("%s|%d|%d|%d|%s|%d%n", "root", relationIndex.addToIndex("root"), 0, root.index(), root.value().toLowerCase(), idx2);
                    }
                    printedRoot = true;
                }
                if ((idx = vectorIndex.addToIndex(edge.getTarget().value().toLowerCase())) < 1) {
                    idx = 1;
                }
                String reln = edge.getRelation().toString();
                System.out.printf("%s|%d|%d|%d|%s|%d%n", reln, relationIndex.addToIndex(reln), edge.getSource().index(), edge.getTarget().index(), edge.getTarget().value().toLowerCase(), idx);
            }
            if (!printedRoot) {
                for (IndexedWord root : sg.getRoots()) {
                    idx = vectorIndex.addToIndex(root.value().toLowerCase());
                    if (idx < 1) {
                        idx = 1;
                    }
                    System.out.printf("%s|%d|%d|%d|%s|%d%n", "root", relationIndex.addToIndex("root"), 0, root.index(), root.value().toLowerCase(), idx);
                }
            }
            System.out.println();
        }
        if (args.length < 2) {
            relationIndex.saveToFilename("relations.index");
        }
        System.err.println(relationIndex.size());
    }
}

