/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph;

import edu.stanford.nlp.dcoref.Dictionaries;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.scenegraph.AbstractPronounResolver;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;

public class SimplePronounResolution
extends AbstractPronounResolver {
    private StanfordCoreNLP pipeline;
    private Dictionaries dict = new Dictionaries();

    private void loadPipeline() {
        Properties props = new Properties();
        props.setProperty("annotators", "lemma,parse");
        props.setProperty("parse.model", "edu/stanford/nlp/models/scenegraph/englishPCFG-3.5.2+brown.ser.gz");
        props.setProperty("enforceRequirements", "false");
        this.pipeline = new StanfordCoreNLP(props);
    }

    public static void main(String[] args) throws IOException {
        SimplePronounResolution resolver = new SimplePronounResolution();
        resolver.run(args);
    }

    private IndexedWord bfsNPSearch(SemanticGraph sg, IndexedWord start, boolean singular) {
        LinkedList<IndexedWord> queue = new LinkedList<IndexedWord>();
        queue.add(start);
        while (!queue.isEmpty()) {
            IndexedWord current = (IndexedWord)queue.remove(0);
            if (current.tag().matches("^NNP?$") || !singular && current.tag().matches("^NNP?S?$")) {
                return current;
            }
            for (IndexedWord child : sg.getChildList(current)) {
                queue.add(child);
            }
        }
        IndexedWord gov = sg.getParent(start);
        return gov == null ? null : this.bfsNPSearch(sg, gov, singular);
    }

    @Override
    protected HashMap<Integer, Integer> resolvePronouns(SemanticGraph sg) {
        HashMap<Integer, Integer> pronPairs = new HashMap<Integer, Integer>(1);
        for (IndexedWord token : sg.vertexListSorted()) {
            IndexedWord antecedent;
            IndexedWord gov;
            if (token.index() <= 1 || !token.tag().startsWith("PRP")) continue;
            boolean isSingular = this.dict.singularPronouns.contains(token.word());
            IndexedWord iw = sg.getNodeByIndexSafe(token.index());
            if (iw == null || (gov = sg.getParent(iw)) == null || (antecedent = this.bfsNPSearch(sg, sg.getFirstRoot(), isSingular)) == null || antecedent.index() >= iw.index()) continue;
            pronPairs.put(token.index(), antecedent.index());
        }
        return pronPairs;
    }

    @Override
    protected HashMap<Integer, Integer> resolvePronouns(List<CoreLabel> tokens) {
        if (this.pipeline == null) {
            this.loadPipeline();
        }
        CoreLabel sentence = new CoreLabel();
        sentence.set(CoreAnnotations.TokensAnnotation.class, tokens);
        sentence.set(CoreAnnotations.SentenceIndexAnnotation.class, 1);
        ArrayList<CoreMap> sentences = new ArrayList<CoreMap>(1);
        sentences.add(sentence);
        Annotation annotation = new Annotation(sentences);
        this.pipeline.annotate(annotation);
        CoreMap annotatedSentence = (CoreMap)((List)annotation.get(CoreAnnotations.SentencesAnnotation.class)).get(0);
        SemanticGraph sg = (SemanticGraph)annotatedSentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
        return this.resolvePronouns(sg);
    }
}

