/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.scenegraph.image;

import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.scenegraph.SceneGraphImageCleaner;
import edu.stanford.nlp.scenegraph.image.SceneGraphImageAttribute;
import edu.stanford.nlp.scenegraph.image.SceneGraphImageObject;
import edu.stanford.nlp.scenegraph.image.SceneGraphImageRegion;
import edu.stanford.nlp.scenegraph.image.SceneGraphImageRelationship;
import edu.stanford.nlp.util.Generics;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.json.Json;
import javax.json.JsonArray;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import javax.json.JsonReader;
import javax.json.JsonValue;

public class SceneGraphImage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public int id;
    public String url;
    public int height;
    public int width;
    public List<SceneGraphImageObject> objects = Generics.newArrayList();
    public List<SceneGraphImageRegion> regions = Generics.newArrayList();
    public List<SceneGraphImageRelationship> relationships = Generics.newArrayList();
    public List<SceneGraphImageAttribute> attributes = Generics.newArrayList();

    public static SceneGraphImage readFromJSON(String json) {
        try {
            StringReader reader = new StringReader(json);
            JsonReader parser = Json.createReader((Reader)reader);
            JsonObject obj = parser.readObject();
            SceneGraphImage img = new SceneGraphImage();
            JsonArray regions = obj.getJsonArray("regions");
            if (regions != null) {
                for (JsonObject region : regions.getValuesAs(JsonObject.class)) {
                    img.regions.add(SceneGraphImageRegion.fromJSONObject(img, region));
                }
            }
            JsonArray objects = obj.getJsonArray("objects");
            for (Object object : objects.getValuesAs(JsonObject.class)) {
                img.objects.add(SceneGraphImageObject.fromJSONObject(img, (JsonObject)object));
            }
            JsonArray attributes = obj.getJsonArray("attributes");
            for (Object object : attributes.getValuesAs(JsonObject.class)) {
                img.addAttribute(SceneGraphImageAttribute.fromJSONObject(img, (JsonObject)object));
            }
            JsonArray relationships = obj.getJsonArray("relationships");
            for (JsonObject relation : relationships.getValuesAs(JsonObject.class)) {
                img.addRelationship(SceneGraphImageRelationship.fromJSONObject(img, relation));
            }
            img.id = obj.getInt("id");
            Integer height = obj.getInt("height");
            Integer width = obj.getInt("width");
            if (height == null) {
                throw new NullPointerException("Image does not have height");
            }
            if (width == null) {
                throw new NullPointerException("Image does not have width");
            }
            img.height = height;
            img.width = width;
            img.url = obj.getString("url");
            return img;
        }
        catch (RuntimeException e) {
            throw new RuntimeException("Couldn't parse \n" + json, e);
        }
    }

    public String toJSON() {
        JsonObjectBuilder json = Json.createObjectBuilder();
        json.add("id", this.id);
        json.add("height", this.height);
        json.add("width", this.width);
        json.add("url", this.url);
        JsonArrayBuilder attributes = Json.createArrayBuilder();
        for (SceneGraphImageAttribute sceneGraphImageAttribute : this.attributes) {
            attributes.add((JsonValue)sceneGraphImageAttribute.toJSONObject(this));
        }
        json.add("attributes", (JsonValue)attributes.build());
        JsonArrayBuilder objects = Json.createArrayBuilder();
        for (SceneGraphImageObject sceneGraphImageObject : this.objects) {
            objects.add((JsonValue)sceneGraphImageObject.toJSONObject(this));
        }
        json.add("objects", (JsonValue)objects.build());
        JsonArrayBuilder jsonArrayBuilder = Json.createArrayBuilder();
        for (SceneGraphImageRegion region : this.regions) {
            jsonArrayBuilder.add((JsonValue)region.toJSONObject(this));
        }
        json.add("regions", (JsonValue)jsonArrayBuilder.build());
        JsonArrayBuilder jsonArrayBuilder2 = Json.createArrayBuilder();
        for (SceneGraphImageRelationship relation : this.relationships) {
            jsonArrayBuilder2.add((JsonValue)relation.toJSONObject(this));
        }
        json.add("relationships", (JsonValue)jsonArrayBuilder2.build());
        return json.build().toString();
    }

    public static void main(String[] args) throws IOException {
        String filename = args[0];
        BufferedReader reader = IOUtils.readerFromString(filename);
        SceneGraphImageCleaner cleaner = new SceneGraphImageCleaner();
        LinkedList<SceneGraphImage> images = Generics.newLinkedList();
        String line = reader.readLine();
        while (line != null) {
            SceneGraphImage img = SceneGraphImage.readFromJSON(line);
            if (img != null) {
                cleaner.cleanupImage(img);
                images.add(img);
            }
            line = reader.readLine();
        }
        SceneGraphImageCleaner.extractAllAttributes(images);
        for (SceneGraphImage img : images) {
            cleaner.splitAttributeConjunctions(img);
            cleaner.trimFunctionWords(img);
            System.out.println(img.toJSON());
        }
    }

    public void addAttribute(SceneGraphImageAttribute attr) {
        this.attributes.add(attr);
        if (attr.region != null) {
            attr.region.attributes.add(attr);
        }
    }

    public void addRelationship(SceneGraphImageRelationship reln) {
        this.relationships.add(reln);
        if (reln.region != null) {
            reln.region.relationships.add(reln);
        }
    }

    public void removeRegion(SceneGraphImageRegion region) {
        this.regions.remove(region);
        for (SceneGraphImageRelationship reln : region.relationships) {
            this.relationships.remove(reln);
        }
        for (SceneGraphImageAttribute attr : region.attributes) {
            this.attributes.remove(attr);
        }
    }
}

