/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.process.Morphology;
import edu.stanford.nlp.semgraph.ISemanticGraphEdgeEql;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.EnglishGrammaticalRelations;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.CollectionUtils;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapList;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;

public class SemanticGraphUtils {
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemanticGraphUtils.class);
    public static final String WILDCARD_VERTICE_TOKEN = "WILDCARD";
    public static final IndexedWord WILDCARD_VERTICE = new IndexedWord();
    public static final String SHARED_NODE_ANON_PREFIX = "A";
    public static final String BLANKET_NODE_ANON_PREFIX = "B";

    private SemanticGraphUtils() {
    }

    public static SemanticGraph makeGraphFromNodes(Collection<IndexedWord> nodes, SemanticGraph srcGraph) {
        if (nodes.size() == 1) {
            SemanticGraph retSg = new SemanticGraph();
            for (IndexedWord node : nodes) {
                retSg.addVertex(node);
            }
            return retSg;
        }
        if (nodes.isEmpty()) {
            return null;
        }
        ArrayList<SemanticGraphEdge> edges = new ArrayList<SemanticGraphEdge>();
        for (IndexedWord nodeG : nodes) {
            for (IndexedWord nodeD : nodes) {
                List<SemanticGraphEdge> existingEdges = srcGraph.getAllEdges(nodeG, nodeD);
                if (existingEdges == null) continue;
                edges.addAll(existingEdges);
            }
        }
        return SemanticGraphFactory.makeFromEdges(edges);
    }

    public static IndexedWord findMatchingNode(IndexedWord node, SemanticGraph sg) {
        for (IndexedWord tgt : sg.vertexSet()) {
            if (tgt.index() != node.index() || tgt.sentIndex() != node.sentIndex() || !tgt.word().equals(node.word())) continue;
            return tgt;
        }
        return null;
    }

    public static Set<SemanticGraphEdge> getSubTreeEdges(IndexedWord vertice, SemanticGraph sg, SemanticGraphEdge excludedEdge) {
        Set<SemanticGraphEdge> tabu = Generics.newHashSet();
        tabu.add(excludedEdge);
        SemanticGraphUtils.getSubTreeEdgesHelper(vertice, sg, tabu);
        tabu.remove(excludedEdge);
        return tabu;
    }

    public static void getSubTreeEdgesHelper(IndexedWord vertice, SemanticGraph sg, Set<SemanticGraphEdge> tabuEdges) {
        for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(vertice)) {
            if (tabuEdges.contains(edge)) continue;
            IndexedWord dep = edge.getDependent();
            tabuEdges.add(edge);
            SemanticGraphUtils.getSubTreeEdgesHelper(dep, sg, tabuEdges);
        }
    }

    public static Collection<SemanticGraphEdge> getEdgesSpannedByVertices(Collection<IndexedWord> nodes, SemanticGraph sg) {
        Set<SemanticGraphEdge> ret = Generics.newHashSet();
        for (IndexedWord n1 : nodes) {
            for (IndexedWord n2 : nodes) {
                List<SemanticGraphEdge> edges;
                if (n1 == n2 || (edges = sg.getAllEdges(n1, n2)) == null) continue;
                ret.addAll(edges);
            }
        }
        return ret;
    }

    public static List<IndexedWord> getChildrenWithRelnPrefix(SemanticGraph graph, IndexedWord vertex, String relnPrefix) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!graph.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : graph.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().toString().startsWith(relnPrefix)) continue;
            childList.add(edge.getTarget());
        }
        return childList;
    }

    public static List<IndexedWord> getChildrenWithRelnPrefix(SemanticGraph graph, IndexedWord vertex, Collection<String> relnPrefixes) {
        if (vertex.equals(IndexedWord.NO_WORD)) {
            return new ArrayList<IndexedWord>();
        }
        if (!graph.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        ArrayList<IndexedWord> childList = new ArrayList<IndexedWord>();
        block0: for (SemanticGraphEdge edge : graph.outgoingEdgeIterable(vertex)) {
            String edgeString = edge.getRelation().toString();
            for (String relnPrefix : relnPrefixes) {
                if (!edgeString.startsWith(relnPrefix)) continue;
                childList.add(edge.getTarget());
                continue block0;
            }
        }
        return childList;
    }

    public static List<IndexedWord> getChildrenWithPrepC(SemanticGraph sg, IndexedWord vertex) {
        ArrayList<IndexedWord> ret = new ArrayList<IndexedWord>();
        for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(vertex)) {
            if (!edge.getRelation().toString().startsWith("prep")) continue;
            ret.add(edge.getDependent());
        }
        return ret;
    }

    public static List<SemanticGraphEdge> incomingEdgesWithReln(IndexedWord node, SemanticGraph sg, GrammaticalRelation reln) {
        return SemanticGraphUtils.edgesWithReln(sg.incomingEdgeIterable(node), reln);
    }

    public static List<SemanticGraphEdge> outgoingEdgesWithReln(IndexedWord node, SemanticGraph sg, GrammaticalRelation reln) {
        return SemanticGraphUtils.edgesWithReln(sg.outgoingEdgeIterable(node), reln);
    }

    public static List<SemanticGraphEdge> edgesWithReln(Iterable<SemanticGraphEdge> edges, GrammaticalRelation reln) {
        ArrayList<SemanticGraphEdge> found = Generics.newArrayList();
        for (SemanticGraphEdge edge : edges) {
            GrammaticalRelation tgtReln = edge.getRelation();
            if (!tgtReln.equals(reln)) continue;
            found.add(edge);
        }
        return found;
    }

    public static List<SemanticGraphEdge> findAllRelnsWithPrefix(SemanticGraph sg, String prefix) {
        ArrayList<SemanticGraphEdge> relns = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            GrammaticalRelation edgeRelation = edge.getRelation();
            if (!edgeRelation.toString().startsWith(prefix)) continue;
            relns.add(edge);
        }
        return relns;
    }

    public static Set<IndexedWord> tabuDescendants(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabu) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabu, null, (Predicate<IndexedWord>)null);
        return descendantSet;
    }

    public static Set<IndexedWord> tabuDescendants(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabu, Collection<GrammaticalRelation> tabuRelns) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabu, tabuRelns, (Predicate<IndexedWord>)null);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuRelns(SemanticGraph sg, IndexedWord vertex, Collection<GrammaticalRelation> tabuRelns) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, Generics.newHashSet(), tabuRelns, (Predicate<IndexedWord>)null);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuTestAndRelns(SemanticGraph sg, IndexedWord vertex, Collection<GrammaticalRelation> tabuRelns, Predicate<IndexedWord> tabuTest) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, Generics.newHashSet(), tabuRelns, tabuTest);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuTestAndRelns(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabuNodes, Collection<GrammaticalRelation> tabuRelns, Predicate<IndexedWord> tabuTest) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabuNodes, tabuRelns, tabuTest);
        return descendantSet;
    }

    public static Set<IndexedWord> descendantsTabuTestAndRelns(SemanticGraph sg, IndexedWord vertex, Collection<IndexedWord> tabuNodes, Collection<GrammaticalRelation> tabuRelns, BiPredicate<IndexedWord, SemanticGraph> tabuTest) {
        if (!sg.containsVertex(vertex)) {
            throw new IllegalArgumentException();
        }
        Set<IndexedWord> descendantSet = Generics.newHashSet();
        SemanticGraphUtils.tabuDescendantsHelper(sg, vertex, descendantSet, tabuNodes, tabuRelns, tabuTest);
        return descendantSet;
    }

    private static void tabuDescendantsHelper(SemanticGraph sg, IndexedWord curr, Set<IndexedWord> descendantSet, Collection<IndexedWord> tabu, Collection<GrammaticalRelation> relnsToAvoid, Predicate<IndexedWord> tabuTest) {
        if (tabu.contains(curr)) {
            return;
        }
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : sg.getChildren(curr)) {
            for (SemanticGraphEdge edge : sg.getAllEdges(curr, child)) {
                if (relnsToAvoid != null && relnsToAvoid.contains(edge.getRelation()) || tabuTest != null && tabuTest.test(edge.getDependent())) continue;
                SemanticGraphUtils.tabuDescendantsHelper(sg, child, descendantSet, tabu, relnsToAvoid, tabuTest);
            }
        }
    }

    private static void tabuDescendantsHelper(SemanticGraph sg, IndexedWord curr, Set<IndexedWord> descendantSet, Collection<IndexedWord> tabu, Collection<GrammaticalRelation> relnsToAvoid, BiPredicate<IndexedWord, SemanticGraph> tabuTest) {
        if (tabu.contains(curr)) {
            return;
        }
        if (descendantSet.contains(curr)) {
            return;
        }
        descendantSet.add(curr);
        for (IndexedWord child : sg.getChildren(curr)) {
            for (SemanticGraphEdge edge : sg.getAllEdges(curr, child)) {
                if (relnsToAvoid != null && relnsToAvoid.contains(edge.getRelation()) || tabuTest != null && tabuTest.test(edge.getDependent(), sg)) continue;
                SemanticGraphUtils.tabuDescendantsHelper(sg, child, descendantSet, tabu, relnsToAvoid, tabuTest);
            }
        }
    }

    public static IndexedWord leftMostChildVertice(IndexedWord startNode, SemanticGraph sg) {
        TreeSet<IndexedWord> vertices = new TreeSet<IndexedWord>();
        for (IndexedWord vertex : sg.descendants(startNode)) {
            vertices.add(vertex);
        }
        return (IndexedWord)vertices.first();
    }

    public static Pair<IndexedWord, IndexedWord> leftRightMostChildVertices(IndexedWord startNode, SemanticGraph sg) {
        TreeSet<IndexedWord> vertices = new TreeSet<IndexedWord>();
        for (IndexedWord vertex : sg.descendants(startNode)) {
            vertices.add(vertex);
        }
        return Pair.makePair(vertices.first(), vertices.last());
    }

    public static Collection<IndexedWord> getDependencyBlanket(SemanticGraph sg, Collection<IndexedWord> assertedNodes) {
        Set<IndexedWord> retSet = Generics.newHashSet();
        for (IndexedWord curr : sg.vertexSet()) {
            if (assertedNodes.contains(curr) || retSet.contains(curr)) continue;
            for (IndexedWord assertedNode : assertedNodes) {
                if (!sg.containsEdge(assertedNode, curr) && !sg.containsEdge(curr, assertedNode)) continue;
                retSet.add(curr);
            }
        }
        return retSet;
    }

    public static SemanticGraph resetVerticeOrdering(SemanticGraph sg) {
        SemanticGraph nsg = new SemanticGraph();
        List<IndexedWord> vertices = sg.vertexListSorted();
        int index = 1;
        Map<IndexedWord, IndexedWord> oldToNewVertices = Generics.newHashMap();
        ArrayList<IndexedWord> newVertices = new ArrayList<IndexedWord>();
        for (IndexedWord vertex : vertices) {
            IndexedWord newVertex = new IndexedWord(vertex);
            newVertex.setIndex(index++);
            oldToNewVertices.put(vertex, newVertex);
            newVertices.add(newVertex);
        }
        for (IndexedWord nv : newVertices) {
            nsg.addVertex(nv);
        }
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (IndexedWord or : sg.getRoots()) {
            newRoots.add((IndexedWord)oldToNewVertices.get(or));
        }
        nsg.setRoots(newRoots);
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            IndexedWord newGov = (IndexedWord)oldToNewVertices.get(edge.getGovernor());
            IndexedWord newDep = (IndexedWord)oldToNewVertices.get(edge.getDependent());
            nsg.addEdge(newGov, newDep, edge.getRelation(), edge.getWeight(), edge.isExtra());
        }
        return nsg;
    }

    private static void enRepairEdges(SemanticGraph sg, boolean verbose) {
        for (SemanticGraphEdge edge : sg.edgeIterable()) {
            if (!edge.getRelation().isFromString()) continue;
            GrammaticalRelation newReln = EnglishGrammaticalRelations.valueOf(edge.getRelation().toString());
            if (newReln != null) {
                IndexedWord gov = edge.getGovernor();
                IndexedWord dep = edge.getDependent();
                double weight = edge.getWeight();
                boolean isExtra = edge.isExtra();
                sg.removeEdge(edge);
                sg.addEdge(gov, dep, newReln, weight, isExtra);
                continue;
            }
            if (!verbose) continue;
            log.info("Warning, could not find matching GrammaticalRelation for reln=" + edge.getRelation());
        }
    }

    public static void enRepairEdges(SemanticGraph sg) {
        SemanticGraphUtils.enRepairEdges(sg, false);
    }

    public static void killNonRooted(SemanticGraph sg) {
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>(sg.vertexSet());
        Set<IndexedWord> guaranteed = Generics.newHashSet();
        for (IndexedWord root : sg.getRoots()) {
            guaranteed.add(root);
            guaranteed.addAll(sg.descendants(root));
        }
        for (IndexedWord node : nodes) {
            if (guaranteed.contains(node)) continue;
            sg.removeVertex(node);
        }
    }

    public static void replaceNode(IndexedWord newNode, IndexedWord oldNode, SemanticGraph sg) {
        List<SemanticGraphEdge> govEdges = sg.outgoingEdgeList(oldNode);
        List<SemanticGraphEdge> depEdges = sg.incomingEdgeList(oldNode);
        boolean oldNodeRemoved = sg.removeVertex(oldNode);
        if (oldNodeRemoved) {
            if (!sg.containsVertex(newNode)) {
                sg.addVertex(newNode);
            }
            for (SemanticGraphEdge govEdge : govEdges) {
                sg.removeEdge(govEdge);
                sg.addEdge(newNode, govEdge.getDependent(), govEdge.getRelation(), govEdge.getWeight(), govEdge.isExtra());
            }
            for (SemanticGraphEdge depEdge : depEdges) {
                sg.removeEdge(depEdge);
                sg.addEdge(depEdge.getGovernor(), newNode, depEdge.getRelation(), depEdge.getWeight(), depEdge.isExtra());
            }
        } else {
            log.info("SemanticGraphUtils.replaceNode: previous node does not exist");
        }
    }

    public static Map<IndexedWord, IndexedWord> anonymyizeNodes(Iterable<IndexedWord> verts, String prefix) {
        Map<IndexedWord, IndexedWord> retMap = Generics.newHashMap();
        int index = 1;
        for (IndexedWord orig : verts) {
            IndexedWord genericVert = new IndexedWord(orig);
            genericVert.set(CoreAnnotations.LemmaAnnotation.class, "");
            String genericValue = prefix + index;
            genericVert.setValue(genericValue);
            genericVert.setWord(genericValue);
            genericVert.setOriginalText(genericValue);
            ++index;
            retMap.put(orig, genericVert);
        }
        return retMap;
    }

    public static Map<IndexedWord, IndexedWord> makeGenericVertices(Iterable<IndexedWord> verts) {
        return SemanticGraphUtils.anonymyizeNodes(verts, SHARED_NODE_ANON_PREFIX);
    }

    public static Map<IndexedWord, IndexedWord> makeBlanketVertices(Iterable<IndexedWord> verts) {
        return SemanticGraphUtils.anonymyizeNodes(verts, BLANKET_NODE_ANON_PREFIX);
    }

    public static List<SemanticGraphEdge> makeReplacedEdges(Iterable<SemanticGraphEdge> edges, Map<IndexedWord, IndexedWord> vertReplacementMap, boolean useGenericReplacement) {
        ArrayList<SemanticGraphEdge> retList = new ArrayList<SemanticGraphEdge>();
        for (SemanticGraphEdge edge : edges) {
            IndexedWord gov = edge.getGovernor();
            IndexedWord dep = edge.getDependent();
            IndexedWord newGov = vertReplacementMap.get(gov);
            IndexedWord newDep = vertReplacementMap.get(dep);
            if (useGenericReplacement) {
                if (newGov == null) {
                    newGov = new IndexedWord(gov);
                    newGov.set(CoreAnnotations.TextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newGov.set(CoreAnnotations.OriginalTextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newGov.set(CoreAnnotations.LemmaAnnotation.class, WILDCARD_VERTICE_TOKEN);
                }
                if (newDep == null) {
                    newDep = new IndexedWord(dep);
                    newDep.set(CoreAnnotations.TextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newDep.set(CoreAnnotations.OriginalTextAnnotation.class, WILDCARD_VERTICE_TOKEN);
                    newDep.set(CoreAnnotations.LemmaAnnotation.class, WILDCARD_VERTICE_TOKEN);
                }
            } else {
                if (newGov == null) {
                    newGov = edge.getGovernor();
                }
                if (newDep == null) {
                    newDep = edge.getDependent();
                }
            }
            SemanticGraphEdge newEdge = new SemanticGraphEdge(newGov, newDep, edge.getRelation(), edge.getWeight(), edge.isExtra());
            retList.add(newEdge);
        }
        return retList;
    }

    public static Set<SemanticGraphEdge> allEdgesInSet(Iterable<IndexedWord> vertices, SemanticGraph sg) {
        Set<SemanticGraphEdge> edges = Generics.newHashSet();
        for (IndexedWord v1 : vertices) {
            for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(v1)) {
                edges.add(edge);
            }
            for (SemanticGraphEdge edge : sg.incomingEdgeIterable(v1)) {
                edges.add(edge);
            }
        }
        return edges;
    }

    public static EdgeDiffResult diffEdges(Collection<SemanticGraphEdge> edges1, Collection<SemanticGraphEdge> edges2, SemanticGraph sg1, SemanticGraph sg2, ISemanticGraphEdgeEql compareObj) {
        Set<SemanticGraphEdge> remainingEdges1 = Generics.newHashSet();
        Set<SemanticGraphEdge> remainingEdges2 = Generics.newHashSet();
        Set<SemanticGraphEdge> sameEdges = Generics.newHashSet();
        ArrayList<SemanticGraphEdge> edges2Cache = new ArrayList<SemanticGraphEdge>(edges2);
        block0: for (SemanticGraphEdge edge1 : edges1) {
            for (SemanticGraphEdge edge2 : edges2Cache) {
                if (!compareObj.equals(edge1, edge2, sg1, sg2)) continue;
                sameEdges.add(edge1);
                edges2Cache.remove(edge2);
                continue block0;
            }
            remainingEdges1.add(edge1);
        }
        ArrayList<SemanticGraphEdge> edges1Cache = new ArrayList<SemanticGraphEdge>(edges1);
        block2: for (SemanticGraphEdge edge2 : edges2) {
            for (SemanticGraphEdge edge1 : edges1) {
                if (!compareObj.equals(edge1, edge2, sg1, sg2)) continue;
                edges1Cache.remove(edge1);
                continue block2;
            }
            remainingEdges2.add(edge2);
        }
        return new EdgeDiffResult(sameEdges, remainingEdges1, remainingEdges2);
    }

    public static String printEdges(Iterable<SemanticGraphEdge> edges) {
        StringWriter buf = new StringWriter();
        for (SemanticGraphEdge edge : edges) {
            buf.append("\t");
            buf.append(edge.getRelation().toString());
            buf.append("(");
            buf.append(edge.getGovernor().toString());
            buf.append(", ");
            buf.append(edge.getDependent().toString());
            buf.append(")\n");
        }
        return buf.toString();
    }

    public static String printVertices(SemanticGraph sg) {
        return SemanticGraphUtils.printVertices(sg, new PrintVerticeParams());
    }

    public static String printVertices(SemanticGraph sg, PrintVerticeParams params) {
        StringWriter buf = new StringWriter();
        int count = 0;
        for (IndexedWord word : sg.vertexListSorted()) {
            if (++count % params.wrapAt == 0) {
                buf.write("\n\t");
            }
            if (params.showIndex) {
                buf.write(String.valueOf(word.index()));
                buf.write(":");
            }
            if (params.showSentIndex) {
                buf.write("s");
                buf.write(String.valueOf(word.sentIndex()));
                buf.write("/");
            }
            if (params.showPOS) {
                buf.write(word.tag());
                buf.write("/");
            }
            if (params.showWord) {
                buf.write(word.word());
            }
            buf.write(" ");
        }
        return buf.toString();
    }

    public static String semgrexFromGraph(SemanticGraph sg, boolean matchTag, boolean matchWord, Map<IndexedWord, String> nodeNameMap) {
        return SemanticGraphUtils.semgrexFromGraph(sg, null, matchTag, matchWord, nodeNameMap);
    }

    public static String semgrexFromGraph(SemanticGraph sg, Collection<IndexedWord> wildcardNodes, boolean useTag, boolean useWord, Map<IndexedWord, String> nodeNameMap) {
        Function<IndexedWord, String> transformNode = o -> {
            String str = "";
            if (useWord) {
                str = "{word: /" + Pattern.quote(o.word()) + "/";
            }
            if (useTag) {
                if (!str.isEmpty()) {
                    str = str + "; ";
                }
                str = "tag: " + o.tag();
            }
            if (!str.isEmpty()) {
                str = str + "}";
            }
            return str;
        };
        return SemanticGraphUtils.semgrexFromGraph(sg, wildcardNodes, nodeNameMap, transformNode);
    }

    public static String semgrexFromGraph(SemanticGraph sg, Collection<IndexedWord> wildcardNodes, Map<IndexedWord, String> nodeNameMap, Function<IndexedWord, String> wordTransformation) {
        IndexedWord patternRoot = sg.getFirstRoot();
        StringWriter buf = new StringWriter();
        Set<IndexedWord> tabu = Generics.newHashSet();
        Set<SemanticGraphEdge> seenEdges = Generics.newHashSet();
        buf.append(SemanticGraphUtils.semgrexFromGraphHelper(patternRoot, sg, tabu, seenEdges, true, true, wildcardNodes, nodeNameMap, false, wordTransformation));
        String patternString = buf.toString();
        return patternString;
    }

    public static String semgrexFromGraph(Iterable<SemanticGraphEdge> edges, boolean matchTag, boolean matchWord, Map<IndexedWord, String> nodeNameMap) {
        SemanticGraph sg = SemanticGraphFactory.makeFromEdges(edges);
        return SemanticGraphUtils.semgrexFromGraph(sg, matchTag, matchWord, nodeNameMap);
    }

    protected static String semgrexFromGraphHelper(IndexedWord vertice, SemanticGraph sg, Set<IndexedWord> tabu, Set<SemanticGraphEdge> seenEdges, boolean useWordAsLabel, boolean nameEdges, Collection<IndexedWord> wildcardNodes, Map<IndexedWord, String> nodeNameMap, boolean orderedNodes, Function<IndexedWord, String> nodeValuesTransformation) {
        StringWriter buf = new StringWriter();
        if (wildcardNodes != null && wildcardNodes.contains(vertice)) {
            buf.append("{}");
        } else {
            String vertexStr = nodeValuesTransformation.apply(vertice);
            if (vertexStr != null && !vertexStr.isEmpty()) {
                buf.append(vertexStr);
            }
        }
        if (nodeNameMap != null) {
            buf.append("=");
            buf.append(nodeNameMap.get(vertice));
            buf.append(" ");
        } else if (useWordAsLabel) {
            buf.append("=");
            buf.append(SemanticGraphUtils.sanitizeForSemgrexName(vertice.word()));
            buf.append(" ");
        }
        tabu.add(vertice);
        Iterable<SemanticGraphEdge> edgeIter = !orderedNodes ? sg.outgoingEdgeIterable(vertice) : CollectionUtils.sorted(sg.outgoingEdgeList(vertice), (arg0, arg1) -> arg0.getRelation().toString().compareTo(arg1.getRelation().toString()));
        for (SemanticGraphEdge edge : edgeIter) {
            seenEdges.add(edge);
            IndexedWord tgtVert = edge.getDependent();
            boolean applyParens = sg.outDegree(tgtVert) > 0 && !tabu.contains(tgtVert);
            buf.append(" >");
            buf.append(edge.getRelation().toString());
            if (nameEdges) {
                buf.append("=E");
                buf.write(String.valueOf(seenEdges.size()));
            }
            buf.append(" ");
            if (applyParens) {
                buf.append("(");
            }
            if (tabu.contains(tgtVert)) {
                buf.append("{tag:");
                buf.append(tgtVert.tag());
                buf.append("}");
                if (!useWordAsLabel) continue;
                buf.append("=");
                buf.append(tgtVert.word());
                buf.append(" ");
                continue;
            }
            buf.append(SemanticGraphUtils.semgrexFromGraphHelper(tgtVert, sg, tabu, seenEdges, useWordAsLabel, nameEdges, wildcardNodes, nodeNameMap, orderedNodes, nodeValuesTransformation));
            if (!applyParens) continue;
            buf.append(")");
        }
        return buf.toString();
    }

    public static String semgrexFromGraphOrderedNodes(SemanticGraph sg, Collection<IndexedWord> wildcardNodes, Map<IndexedWord, String> nodeNameMap, Function<IndexedWord, String> wordTransformation) {
        IndexedWord patternRoot = sg.getFirstRoot();
        StringWriter buf = new StringWriter();
        Set<IndexedWord> tabu = Generics.newHashSet();
        Set<SemanticGraphEdge> seenEdges = Generics.newHashSet();
        buf.append(SemanticGraphUtils.semgrexFromGraphHelper(patternRoot, sg, tabu, seenEdges, true, true, wildcardNodes, nodeNameMap, true, wordTransformation));
        String patternString = buf.toString();
        return patternString;
    }

    public static String sanitizeForSemgrexName(String text) {
        text = text.replaceAll("\\.", "_DOT_");
        text = text.replaceAll(",", "_COMMA_");
        text = text.replaceAll("\\\\", "_BSLASH_");
        text = text.replaceAll("/", "_BSLASH_");
        text = text.replaceAll("\\?", "_QUES_");
        text = text.replaceAll("!", "_BANG_");
        text = text.replaceAll("\\$", "_DOL_");
        text = text.replaceAll("&", "_AMP_");
        text = text.replaceAll(":", "_COL_");
        text = text.replaceAll(";", "_SCOL_");
        text = text.replaceAll("#", "_PND_");
        text = text.replaceAll("@", "_AND_");
        text = text.replaceAll("%", "_PER_");
        text = text.replaceAll("\\(", "_LRB_");
        text = text.replaceAll("\\)", "_RRB_");
        return text;
    }

    public static void lemmatize(SemanticGraph sg) {
        for (IndexedWord node : sg.vertexSet()) {
            node.setLemma(Morphology.lemmaStatic(node.word(), node.tag()));
        }
    }

    public static SemanticGraph setSentIndex(SemanticGraph sg, int newSentIndex) {
        SemanticGraph newGraph = new SemanticGraph(sg);
        ArrayList<IndexedWord> prevRoots = new ArrayList<IndexedWord>(newGraph.getRoots());
        ArrayList<IndexedWord> newRoots = new ArrayList<IndexedWord>();
        for (IndexedWord node : newGraph.vertexListSorted()) {
            IndexedWord newWord = new IndexedWord(node);
            newWord.setSentIndex(newSentIndex);
            SemanticGraphUtils.replaceNode(newWord, node, newGraph);
            if (!prevRoots.contains(node)) continue;
            newRoots.add(newWord);
        }
        newGraph.setRoots(newRoots);
        return newGraph;
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs) {
        Map<String, SemanticGraph> map = Generics.newHashMap();
        for (SemanticGraph sg : graphs) {
            String keyVal = sg.toString().intern();
            map.put(keyVal, sg);
        }
        return map.values();
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs, Collection<SemanticGraph> tabuGraphs) {
        Map<String, SemanticGraph> tabuMap = Generics.newHashMap();
        for (SemanticGraph tabuSg : tabuGraphs) {
            String keyVal = tabuSg.toString().intern();
            tabuMap.put(keyVal, tabuSg);
        }
        Map<String, SemanticGraph> map = Generics.newHashMap();
        for (SemanticGraph sg : graphs) {
            String keyVal = sg.toString().intern();
            if (tabuMap.containsKey(keyVal)) continue;
            map.put(keyVal, sg);
        }
        return map.values();
    }

    public static Collection<SemanticGraph> removeDuplicates(Collection<SemanticGraph> graphs, SemanticGraph tabuGraph) {
        Set<SemanticGraph> tabuSet = Generics.newHashSet();
        tabuSet.add(tabuGraph);
        return SemanticGraphUtils.removeDuplicates(graphs, tabuSet);
    }

    public static Map<PositionedTree, IndexedWord> mapTreeToSg(Tree tree, SemanticGraph sg) {
        MapList<String, TreeNodeProxy> lexToTreeNode = new MapList<String, TreeNodeProxy>();
        MapList<String, IndexedWordProxy> lexToSemNode = new MapList<String, IndexedWordProxy>();
        for (Object child : tree.getLeaves()) {
            List<TreeNodeProxy> leafProxies = TreeNodeProxy.create((Tree)child, tree);
            for (TreeNodeProxy proxy : leafProxies) {
                lexToTreeNode.add(proxy.lex, proxy);
            }
        }
        Map<IndexedWord, Integer> depthMap = Generics.newHashMap();
        for (IndexedWord node : sg.vertexSet()) {
            List<IndexedWord> path = sg.getPathToRoot(node);
            if (path != null) {
                depthMap.put(node, path.size());
            } else {
                depthMap.put(node, 99999);
            }
            List<IndexedWordProxy> nodeProxies = IndexedWordProxy.create(node);
            for (IndexedWordProxy proxy : nodeProxies) {
                lexToSemNode.add(proxy.lex, proxy);
            }
        }
        Map<PositionedTree, IndexedWord> map = Generics.newHashMap();
        for (String lex : lexToTreeNode.keySet()) {
            for (int i = 0; i < lexToTreeNode.size(lex) && i < lexToSemNode.size(lex); ++i) {
                map.put(new PositionedTree(((TreeNodeProxy)lexToTreeNode.get(lex, (int)i)).treeNode, tree), ((IndexedWordProxy)lexToSemNode.get(lex, (int)i)).node);
            }
        }
        for (Tree nonTerm : tree) {
            if (nonTerm.isLeaf()) continue;
            IndexedWord bestNode = null;
            int bestScore = 99999;
            for (Tree curr : nonTerm) {
                int currScore;
                IndexedWord equivNode = map.get(new PositionedTree(curr, tree));
                if (equivNode == null || !depthMap.containsKey(equivNode) || (currScore = ((Integer)depthMap.get(equivNode)).intValue()) >= bestScore) continue;
                bestScore = currScore;
                bestNode = equivNode;
            }
            if (bestNode == null) continue;
            map.put(new PositionedTree(nonTerm, tree), bestNode);
        }
        return map;
    }

    public static boolean isTree(SemanticGraph sg) {
        if (sg.getRoots().size() != 1) {
            return false;
        }
        IndexedWord root = sg.getFirstRoot();
        Set<IndexedWord> visitedNodes = Generics.newHashSet();
        LinkedList<IndexedWord> queue = Generics.newLinkedList();
        queue.add(root);
        while (!queue.isEmpty()) {
            IndexedWord current = (IndexedWord)queue.remove();
            visitedNodes.add(current);
            for (SemanticGraphEdge edge : sg.outgoingEdgeIterable(current)) {
                IndexedWord dep = edge.getDependent();
                if (visitedNodes.contains(dep)) {
                    return false;
                }
                if (dep.copyCount() > 0) {
                    return false;
                }
                queue.add(dep);
            }
        }
        return visitedNodes.size() == sg.size();
    }

    public static int maxIndex(SemanticGraph sg) {
        int index = Integer.MIN_VALUE;
        for (IndexedWord node : sg.vertexSet()) {
            if (node.index() <= index) continue;
            index = node.index();
        }
        return index;
    }

    public static int minIndex(SemanticGraph sg) {
        int index = Integer.MAX_VALUE;
        for (IndexedWord node : sg.vertexSet()) {
            if (node.index() >= index) continue;
            index = node.index();
        }
        return index;
    }

    static {
        WILDCARD_VERTICE.setWord("*");
        WILDCARD_VERTICE.setValue("*");
        WILDCARD_VERTICE.setOriginalText("*");
    }

    private static final class IndexedWordProxy {
        IndexedWord node;
        String lex;

        public String toString() {
            return this.lex + " -> " + this.node.word() + ":" + this.node.sentIndex() + "." + this.node.index();
        }

        private IndexedWordProxy(IndexedWord node, String lex) {
            this.node = node;
            this.lex = lex;
        }

        public static List<IndexedWordProxy> create(IndexedWord node) {
            ArrayList<IndexedWordProxy> ret = new ArrayList<IndexedWordProxy>();
            if (node.originalText().length() > 0) {
                for (String token : node.originalText().split(" ")) {
                    ret.add(new IndexedWordProxy(node, token));
                }
            } else {
                ret.add(new IndexedWordProxy(node, node.word()));
            }
            return ret;
        }
    }

    public static class PositionedTree {
        Tree tree;
        Tree root;
        int nodeNumber;

        public String toString() {
            return this.tree + "." + this.nodeNumber;
        }

        public PositionedTree(Tree tree, Tree root) {
            this.tree = tree;
            this.root = root;
            this.nodeNumber = tree.nodeNumber(root);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PositionedTree) {
                PositionedTree tgt = (PositionedTree)obj;
                return this.tree.equals(tgt.tree) && this.root.equals(tgt.root) && tgt.nodeNumber == this.nodeNumber;
            }
            return false;
        }

        public int hashCode() {
            int hc = this.tree.hashCode() ^ this.root.hashCode() << 8;
            return hc ^= 2 ^ this.nodeNumber;
        }
    }

    private static class TreeNodeProxy {
        Tree treeNode;
        String lex;
        Tree root;

        public String toString() {
            return this.lex + " -> " + this.treeNode + ", #=" + this.treeNode.nodeNumber(this.root);
        }

        private TreeNodeProxy(Tree intree, String lex, Tree root) {
            this.treeNode = intree;
            this.lex = lex;
            this.root = root;
        }

        public static List<TreeNodeProxy> create(Tree intree, Tree root) {
            ArrayList<TreeNodeProxy> ret = new ArrayList<TreeNodeProxy>();
            if (intree.isLeaf()) {
                ret.add(new TreeNodeProxy(intree, intree.label().value(), root));
            } else {
                for (LabeledWord lword : intree.labeledYield()) {
                    ret.add(new TreeNodeProxy(intree, lword.word(), root));
                }
            }
            return ret;
        }
    }

    public static class PrintVerticeParams {
        public boolean showWord = true;
        public boolean showIndex = true;
        public boolean showSentIndex = false;
        public boolean showPOS = false;
        public int wrapAt = 8;
    }

    public static class EdgeDiffResult {
        Set<SemanticGraphEdge> sameEdges;
        Set<SemanticGraphEdge> remaining1;
        Set<SemanticGraphEdge> remaining2;

        public EdgeDiffResult(Set<SemanticGraphEdge> sameEdges, Set<SemanticGraphEdge> remaining1, Set<SemanticGraphEdge> remaining2) {
            this.sameEdges = sameEdges;
            this.remaining1 = remaining1;
            this.remaining2 = remaining2;
        }

        public Set<SemanticGraphEdge> getRemaining1() {
            return this.remaining1;
        }

        public Set<SemanticGraphEdge> getRemaining2() {
            return this.remaining2;
        }

        public Set<SemanticGraphEdge> getSameEdges() {
            return this.sameEdges;
        }
    }
}

