/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;

public class ProcessSemgrexRequest
extends ProcessProtobufRequest {
    public static CoreNLPProtos.SemgrexResponse.SemgrexResult matchSentence(SemgrexPattern pattern, SemanticGraph graph, int patternIdx, int graphIdx) {
        CoreNLPProtos.SemgrexResponse.SemgrexResult.Builder semgrexResultBuilder = CoreNLPProtos.SemgrexResponse.SemgrexResult.newBuilder();
        SemgrexMatcher matcher = pattern.matcher(graph);
        while (matcher.find()) {
            CoreNLPProtos.SemgrexResponse.Match.Builder matchBuilder = CoreNLPProtos.SemgrexResponse.Match.newBuilder();
            matchBuilder.setMatchIndex(matcher.getMatch().index());
            matchBuilder.setSemgrexIndex(patternIdx);
            matchBuilder.setGraphIndex(graphIdx);
            for (String nodeName : matcher.getNodeNames()) {
                CoreNLPProtos.SemgrexResponse.NamedNode.Builder nodeBuilder = CoreNLPProtos.SemgrexResponse.NamedNode.newBuilder();
                nodeBuilder.setName(nodeName);
                nodeBuilder.setMatchIndex(matcher.getNode(nodeName).index());
                matchBuilder.addNode(nodeBuilder.build());
            }
            for (String relnName : matcher.getRelationNames()) {
                CoreNLPProtos.SemgrexResponse.NamedRelation.Builder relnBuilder = CoreNLPProtos.SemgrexResponse.NamedRelation.newBuilder();
                relnBuilder.setName(relnName);
                relnBuilder.setReln(matcher.getRelnString(relnName));
                matchBuilder.addReln(relnBuilder.build());
            }
            for (String edgeName : matcher.getEdgeNames()) {
                CoreNLPProtos.SemgrexResponse.NamedEdge.Builder edgeBuilder = CoreNLPProtos.SemgrexResponse.NamedEdge.newBuilder();
                edgeBuilder.setName(edgeName);
                SemanticGraphEdge edge = matcher.getEdge(edgeName);
                edgeBuilder.setSource(edge.getSource().index());
                edgeBuilder.setTarget(edge.getTarget().index());
                edgeBuilder.setReln(edge.getRelation().toString());
                edgeBuilder.setIsExtra(edge.isExtra());
                if (edge.getSource().copyCount() != 0) {
                    edgeBuilder.setSourceCopy(edge.getSource().copyCount());
                }
                if (edge.getTarget().copyCount() != 0) {
                    edgeBuilder.setTargetCopy(edge.getTarget().copyCount());
                }
                matchBuilder.addEdge(edgeBuilder.build());
            }
            semgrexResultBuilder.addMatch(matchBuilder.build());
        }
        return semgrexResultBuilder.build();
    }

    public static CoreNLPProtos.SemgrexResponse processRequest(CoreNLPProtos.SemgrexRequest request) {
        ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
        CoreNLPProtos.SemgrexResponse.Builder responseBuilder = CoreNLPProtos.SemgrexResponse.newBuilder();
        List patterns = request.getSemgrexList().stream().map(SemgrexPattern::compile).collect(Collectors.toList());
        int graphIdx = 0;
        for (CoreNLPProtos.SemgrexRequest.Dependencies sentence : request.getQueryList()) {
            CoreNLPProtos.SemgrexResponse.GraphResult.Builder graphResultBuilder = CoreNLPProtos.SemgrexResponse.GraphResult.newBuilder();
            List<CoreLabel> tokens = sentence.getTokenList().stream().map(serializer::fromProto).collect(Collectors.toList());
            SemanticGraph graph = ProtobufAnnotationSerializer.fromProto(sentence.getGraph(), tokens, "semgrex");
            int patternIdx = 0;
            for (SemgrexPattern pattern : patterns) {
                graphResultBuilder.addResult(ProcessSemgrexRequest.matchSentence(pattern, graph, patternIdx, graphIdx));
                ++patternIdx;
            }
            responseBuilder.addResult(graphResultBuilder.build());
            ++graphIdx;
        }
        return responseBuilder.build();
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.SemgrexRequest request = CoreNLPProtos.SemgrexRequest.parseFrom(in);
        CoreNLPProtos.SemgrexResponse response = ProcessSemgrexRequest.processRequest(request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        ProcessProtobufRequest.process(new ProcessSemgrexRequest(), args);
    }
}

