/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex;

import edu.stanford.nlp.semgraph.semgrex.CoordinationPattern;
import edu.stanford.nlp.semgraph.semgrex.GraphRelation;
import edu.stanford.nlp.semgraph.semgrex.NodeAttributes;
import edu.stanford.nlp.semgraph.semgrex.NodePattern;
import edu.stanford.nlp.semgraph.semgrex.ParseException;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParseException;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParserConstants;
import edu.stanford.nlp.semgraph.semgrex.SemgrexParserTokenManager;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.SimpleCharStream;
import edu.stanford.nlp.semgraph.semgrex.Token;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

class SemgrexParser
implements SemgrexParserConstants {
    private boolean underNegation = false;
    private boolean underNodeNegation = false;
    private Set<String> knownVariables = Generics.newHashSet();
    private static final Redwood.RedwoodChannels log = Redwood.channels(SemgrexParser.class);
    private boolean deprecatedAmp = false;
    private boolean deprecatedNodeConj = false;
    public SemgrexParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[28];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private boolean trace_enabled;

    private String fullExpression(Token startToken) {
        StringBuilder result = new StringBuilder();
        Token p = startToken;
        while (p != null) {
            if (p.specialToken != null) {
                result.append(p.specialToken.image);
            }
            result.append(p.image);
            p = p.next;
        }
        return result.toString();
    }

    private void warnDeprecated(String warning, Token startToken) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        new RuntimeException().printStackTrace(pw);
        String trace = sw.toString();
        trace = trace.substring(trace.lastIndexOf("SemgrexParser"));
        trace = trace.substring(trace.indexOf("at "));
        log.warn(warning + "\n    " + this.fullExpression(startToken) + "\n    Current stack: " + trace);
    }

    public final SemgrexPattern Root() throws ParseException {
        SemgrexPattern node;
        Token reverse = null;
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        Token startToken = null;
        startToken = this.getToken(1);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 3: {
                reverse = this.jj_consume_token(3);
                node = this.SubNode(GraphRelation.ALIGNED_ROOT);
                this.jj_consume_token(9);
                break;
            }
            case 11: 
            case 15: 
            case 17: 
            case 22: {
                node = this.SubNode(GraphRelation.ROOT);
                children.add(node);
                block7: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 10: {
                            break;
                        }
                        default: {
                            this.jj_la1[0] = this.jj_gen;
                            break block7;
                        }
                    }
                    this.jj_consume_token(10);
                    node = this.SubNode(GraphRelation.ITERATOR);
                    children.add(node);
                }
                this.jj_consume_token(9);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (children.size() > 1) {
            node = new CoordinationPattern(true, children, true, true);
        }
        if (this.deprecatedAmp) {
            throw new SemgrexParseException("Use of & in semgrex patterns is now illegal.  It is equivalent to the same expression without the &.  Offending expression: " + startToken);
        }
        if (this.deprecatedNodeConj) {
            throw new SemgrexParseException("Use of node conjugation (expressions such as '< [foo bar]' or '< [foo & bar]') is now illegal.  The issue is that expressions such as '[foo bar] < zzz' may intuitively mean that foo < zzz, bar < zzz, zzz the same for both cases, but that is not the way the parser interpreted this expression.  Changing the functionality might break existing expressions, and anyway this can be rewritten in various ways such as 'zzz > foo > bar' or 'foo < zzz=a : bar < zzz=a'.  Offending expression: " + startToken);
        }
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern SubNode(GraphRelation r) throws ParseException {
        SemgrexPattern result = null;
        SemgrexPattern child = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 11: {
                this.jj_consume_token(11);
                result = this.SubNode(r);
                this.jj_consume_token(12);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 15: 
                    case 16: 
                    case 17: {
                        child = this.RelationDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                    }
                }
                if (child != null) {
                    ArrayList<SemgrexPattern> newChildren = new ArrayList<SemgrexPattern>();
                    newChildren.addAll(result.getChildren());
                    newChildren.add(child);
                    result.setChild(new CoordinationPattern(false, newChildren, true, false));
                }
                if ("" == null) break;
                return result;
            }
            case 15: 
            case 17: 
            case 22: {
                result = this.ModNode(r);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 2: 
                    case 3: 
                    case 4: 
                    case 15: 
                    case 16: 
                    case 17: {
                        child = this.RelationDisj();
                        break;
                    }
                    default: {
                        this.jj_la1[3] = this.jj_gen;
                    }
                }
                if (child != null) {
                    result.setChild(child);
                }
                if ("" == null) break;
                return result;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern RelationDisj() throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.RelationConj();
        children.add(child);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[5] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            child = this.RelationConj();
            children.add(child);
        }
        if (children.size() == 1) {
            if ("" != null) {
                return child;
            }
        } else if ("" != null) {
            return new CoordinationPattern(false, children, false, false);
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern RelationConj() throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.ModRelation();
        children.add(child);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 2: 
                case 3: 
                case 4: 
                case 14: 
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[6] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    this.deprecatedAmp = true;
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                }
            }
            child = this.ModRelation();
            children.add(child);
        }
        if (children.size() == 1) {
            if ("" != null) {
                return child;
            }
        } else if ("" != null) {
            return new CoordinationPattern(false, children, true, false);
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern ModRelation() throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 3: 
            case 4: 
            case 17: {
                child = this.RelChild();
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                boolean startUnderNeg = this.underNegation;
                this.underNegation = true;
                child = this.RelChild();
                this.underNegation = startUnderNeg;
                child.negate();
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                child = this.RelChild();
                child.makeOptional();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return child;
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern RelChild() throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                this.jj_consume_token(17);
                child = this.RelationDisj();
                this.jj_consume_token(18);
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                child = this.Relation();
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return child;
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern Relation() throws ParseException {
        SemgrexPattern node;
        Token rel = null;
        Token relnType = null;
        Token numArg = null;
        Token numArg2 = null;
        Token name = null;
        Token edgeName = null;
        boolean pC = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 2: 
            case 4: {
                block4 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        numArg = this.jj_consume_token(4);
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 19: {
                                this.jj_consume_token(19);
                                numArg2 = this.jj_consume_token(4);
                                break block4;
                            }
                        }
                        this.jj_la1[10] = this.jj_gen;
                        break;
                    }
                    default: {
                        this.jj_la1[11] = this.jj_gen;
                    }
                }
                rel = this.jj_consume_token(2);
                block10 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: 
                    case 8: {
                        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                            case 4: {
                                relnType = this.jj_consume_token(4);
                                break block10;
                            }
                            case 8: {
                                relnType = this.jj_consume_token(8);
                                break block10;
                            }
                        }
                        this.jj_la1[12] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                    default: {
                        this.jj_la1[13] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 20: {
                        this.jj_consume_token(20);
                        name = this.jj_consume_token(4);
                        break;
                    }
                    default: {
                        this.jj_la1[14] = this.jj_gen;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 21: {
                        this.jj_consume_token(21);
                        edgeName = this.jj_consume_token(4);
                        break block0;
                    }
                }
                this.jj_la1[15] = this.jj_gen;
                break;
            }
            case 3: {
                rel = this.jj_consume_token(3);
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        GraphRelation reln = numArg == null && numArg2 == null ? GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, name != null ? name.image : null, edgeName != null ? edgeName.image : null) : (numArg2 == null ? GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, Integer.parseInt(numArg.image), name != null ? name.image : null, edgeName != null ? edgeName.image : null) : GraphRelation.getRelation(rel != null ? rel.image : null, relnType != null ? relnType.image : null, Integer.parseInt(numArg.image), Integer.parseInt(numArg2.image), name != null ? name.image : null, edgeName != null ? edgeName.image : null));
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 15: 
            case 17: 
            case 22: {
                node = this.ModNode(reln);
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                node = this.SubNode(reln);
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return node;
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern NodeDisj(GraphRelation r) throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        this.jj_consume_token(17);
        SemgrexPattern child = this.NodeConj(r);
        children.add(child);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 13: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(13);
            child = this.NodeConj(r);
            children.add(child);
        }
        this.jj_consume_token(18);
        if (children.size() == 1) {
            if ("" != null) {
                return child;
            }
        } else if ("" != null) {
            return new CoordinationPattern(true, children, false, false);
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern NodeConj(GraphRelation r) throws ParseException {
        ArrayList<SemgrexPattern> children = new ArrayList<SemgrexPattern>();
        SemgrexPattern child = this.ModNode(r);
        children.add(child);
        block6: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: 
                case 15: 
                case 17: 
                case 22: {
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    break block6;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                case 14: {
                    this.jj_consume_token(14);
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                }
            }
            child = this.ModNode(r);
            children.add(child);
            this.deprecatedNodeConj = true;
        }
        if (children.size() == 1) {
            if ("" != null) {
                return child;
            }
        } else if ("" != null) {
            return new CoordinationPattern(true, children, true, false);
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern ModNode(GraphRelation r) throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: 
            case 22: {
                child = this.Child(r);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                boolean startUnderNeg = this.underNodeNegation;
                this.underNodeNegation = true;
                child = this.Child(r);
                this.underNodeNegation = startUnderNeg;
                break;
            }
            default: {
                this.jj_la1[21] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return child;
        }
        throw new Error("Missing return statement in function");
    }

    public final SemgrexPattern Child(GraphRelation r) throws ParseException {
        SemgrexPattern child;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 17: {
                child = this.NodeDisj(r);
                break;
            }
            case 22: {
                child = this.Description(r);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if ("" != null) {
            return child;
        }
        throw new Error("Missing return statement in function");
    }

    public final void AddAttribute(NodeAttributes attributes) throws ParseException {
        Token attr = null;
        Token value = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: {
                attr = this.jj_consume_token(4);
                this.jj_consume_token(10);
                switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                    case 4: {
                        value = this.jj_consume_token(4);
                        break;
                    }
                    case 8: {
                        value = this.jj_consume_token(8);
                        break;
                    }
                    default: {
                        this.jj_la1[23] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                if (attr == null || value == null) break;
                attributes.setAttribute(attr.image, value.image);
                break;
            }
            case 7: {
                attr = this.jj_consume_token(7);
                attributes.setRoot(true);
                break;
            }
            case 6: {
                attr = this.jj_consume_token(6);
                attributes.setEmpty(true);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    public final NodePattern Description(GraphRelation r) throws ParseException {
        Token name = null;
        boolean link = false;
        NodeAttributes attributes = new NodeAttributes();
        this.jj_consume_token(22);
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 4: 
            case 6: 
            case 7: {
                this.AddAttribute(attributes);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
                        case 23: {
                            break;
                        }
                        default: {
                            this.jj_la1[25] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(23);
                    this.AddAttribute(attributes);
                }
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        this.jj_consume_token(24);
        switch (this.jj_ntk == -1 ? this.jj_ntk_f() : this.jj_ntk) {
            case 21: {
                this.jj_consume_token(21);
                link = true;
                name = this.jj_consume_token(4);
                String nodeName = name.image;
                if (this.underNegation) {
                    if (this.knownVariables.contains(nodeName)) break;
                    throw new ParseException("Cannot add new variable names under negation.  Node '" + nodeName + "' not seen before");
                }
                this.knownVariables.add(nodeName);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
            }
        }
        NodePattern pat = new NodePattern(r, this.underNodeNegation, attributes.attributes(), attributes.root(), attributes.empty(), name != null ? name.image : null);
        if (link) {
            pat.makeLink();
        }
        if ("" != null) {
            return pat;
        }
        throw new Error("Missing return statement in function");
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{1024, 4360200, 229404, 229404, 4360192, 8192, 245788, 16384, 229404, 131100, 524288, 16, 272, 272, 0x100000, 0x200000, 28, 4360192, 8192, 4374528, 16384, 4358144, 0x420000, 272, 208, 0x800000, 208, 0x200000};
    }

    public SemgrexParser(InputStream stream) {
        this(stream, null);
    }

    public SemgrexParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new SemgrexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SemgrexParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new SemgrexParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(Reader stream) {
        if (this.jj_input_stream == null) {
            this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        } else {
            this.jj_input_stream.ReInit(stream, 1, 1);
        }
        if (this.token_source == null) {
            this.token_source = new SemgrexParserTokenManager(this.jj_input_stream);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public SemgrexParser(SemgrexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    public void ReInit(SemgrexParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (int i = 0; i < 28; ++i) {
            this.jj_la1[i] = -1;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private int jj_ntk_f() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[25];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 28; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) == 0) continue;
                la1tokens[j] = true;
            }
        }
        for (i = 0; i < 25; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.add(this.jj_expentry);
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = this.jj_expentries.get(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final boolean trace_enabled() {
        return this.trace_enabled;
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    static {
        SemgrexParser.jj_la1_init_0();
    }
}

