/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Function;
import java.util.stream.Collectors;

public class AddDep
extends SsurgeonEdit {
    public static final String LABEL = "addDep";
    final Map<String, String> attributes;
    final GrammaticalRelation relation;
    final String govNodeName;
    final String position;
    final double weight;

    public AddDep(String govNodeName, GrammaticalRelation relation, Map<String, String> attributes, String position) {
        this(govNodeName, relation, attributes, position, 0.0);
    }

    public AddDep(String govNodeName, GrammaticalRelation relation, Map<String, String> attributes, String position, double weight) {
        if (position != null && !position.startsWith("-") && !position.startsWith("+")) {
            throw new SsurgeonParseException("Unknown position " + position + " in AddDep operation");
        }
        if (govNodeName == null) {
            throw new SsurgeonParseException("No governor given for an AddDep");
        }
        if (relation == null) {
            throw new SsurgeonParseException("No relation given for an AddDep");
        }
        AddDep.checkIllegalAttributes(attributes);
        this.attributes = new TreeMap<String, String>(attributes);
        this.relation = relation;
        this.govNodeName = govNodeName;
        this.position = position;
        this.weight = 0.0;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-gov");
        buf.write(" ");
        buf.write(this.govNodeName);
        buf.write("\t");
        buf.write("-reln");
        buf.write(" ");
        buf.write(this.relation.toString());
        buf.write("\t");
        if (this.position != null) {
            buf.write("-position");
            buf.write(" ");
            buf.write(this.position);
            buf.write("\t");
        }
        for (String key : this.attributes.keySet()) {
            buf.write("-");
            buf.write(key);
            buf.write(" ");
            buf.write(this.attributes.get(key));
            buf.write("\"\t");
        }
        buf.write("-weight");
        buf.write(" ");
        buf.write(String.valueOf(this.weight));
        return buf.toString();
    }

    public static void moveNode(SemanticGraph sg, SemgrexMatcher sm, IndexedWord word, int newIndex) {
        SemanticGraphEdge newEdge;
        List<SemanticGraphEdge> outgoing = sg.outgoingEdgeList(word);
        List<SemanticGraphEdge> incoming = sg.incomingEdgeList(word);
        boolean isRoot = sg.isRoot(word);
        sg.removeVertex(word);
        IndexedWord newWord = new IndexedWord(word.backingLabel());
        newWord.setIndex(newIndex);
        if (isRoot) {
            HashSet<IndexedWord> newRoots = new HashSet<IndexedWord>(sg.getRoots());
            newRoots.remove(word);
            newRoots.add(newWord);
            sg.setRoots(newRoots);
        }
        for (String name : sm.getNodeNames()) {
            if (sm.getNode(name) != word) continue;
            sm.putNode(name, newWord);
        }
        for (SemanticGraphEdge oldEdge : outgoing) {
            newEdge = new SemanticGraphEdge(newWord, oldEdge.getTarget(), oldEdge.getRelation(), oldEdge.getWeight(), oldEdge.isExtra());
            for (String name : sm.getEdgeNames()) {
                if (sm.getEdge(name) != oldEdge) continue;
                sm.putNamedEdge(name, newEdge);
            }
            sg.addEdge(newEdge);
        }
        for (SemanticGraphEdge oldEdge : incoming) {
            newEdge = new SemanticGraphEdge(oldEdge.getSource(), newWord, oldEdge.getRelation(), oldEdge.getWeight(), oldEdge.isExtra());
            for (String name : sm.getEdgeNames()) {
                if (sm.getEdge(name) != oldEdge) continue;
                sm.putNamedEdge(name, newEdge);
            }
            sg.addEdge(newEdge);
        }
    }

    public static void moveNodes(SemanticGraph sg, SemgrexMatcher sm, Function<Integer, Boolean> shouldMove, Function<Integer, Integer> destination, boolean reverse) {
        List toMove = sg.vertexSet().stream().filter(x -> (Boolean)shouldMove.apply(x.index())).collect(Collectors.toList());
        Collections.sort(toMove);
        if (reverse) {
            Collections.reverse(toMove);
        }
        for (IndexedWord word : toMove) {
            AddDep.moveNode(sg, sm, word, destination.apply(word.index()));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        int newIndex;
        int tempIndex;
        IndexedWord govNode = sm.getNode(this.govNodeName);
        CoreLabel newWord = AddDep.fromCheapStrings(this.attributes);
        IndexedWord newNode = new IndexedWord(newWord);
        if (this.position != null && !this.position.equals("+")) {
            tempIndex = SemanticGraphUtils.maxIndex(sg) + 2;
            if (this.position.equals("-")) {
                newIndex = SemanticGraphUtils.minIndex(sg);
            } else {
                if (!this.position.startsWith("-") && !this.position.startsWith("+")) throw new UnsupportedOperationException("Unknown position in AddDep: |" + this.position + "|");
                String targetName = this.position.substring(1);
                IndexedWord target = sm.getNode(targetName);
                if (target == null) {
                    return false;
                }
                newIndex = this.position.startsWith("-") ? target.index() : target.index() + 1;
            }
        } else {
            tempIndex = SemanticGraphUtils.maxIndex(sg) + 1;
            newIndex = -1;
        }
        newNode.setDocID(govNode.docID());
        newNode.setIndex(tempIndex);
        newNode.setSentIndex(govNode.sentIndex());
        sg.addVertex(newNode);
        sg.addEdge(govNode, newNode, this.relation, this.weight, false);
        if (this.position == null || this.position.equals("+")) return true;
        AddDep.moveNodes(sg, sm, x -> x >= newIndex && x != tempIndex, x -> x + 1, true);
        AddDep.moveNode(sg, sm, newNode, newIndex);
        return true;
    }

    public static void checkIllegalAttributes(Map<String, String> attributes) {
        if (attributes.containsKey("idx")) {
            throw new SsurgeonParseException("Cannot manually set the index attribute.  If you need a moveWord operation, please file an issue on github.");
        }
        if (attributes.containsKey("sentIndex")) {
            throw new SsurgeonParseException("Cannot manually change the sentence index.  If you need an operation to change an entire sentence's sentIndex, please file an issue on github.");
        }
        if (attributes.containsKey("docID")) {
            throw new SsurgeonParseException("Cannot manually change a document ID.  If you need an operation to change an entire sentence's document ID, please file an issue on github.");
        }
        try {
            CoreLabel coreLabel = AddDep.fromCheapStrings(attributes);
        }
        catch (UnsupportedOperationException e) {
            throw new SsurgeonParseException("Unable to process node attribute keys for Ssurgeon operation", e);
        }
    }

    public static CoreLabel fromCheapStrings(Map<String, String> attributes) {
        String[] keys = new String[attributes.size()];
        String[] values = new String[attributes.size()];
        int idx = 0;
        for (String key : attributes.keySet()) {
            String value = attributes.get(key);
            keys[idx] = key;
            values[idx] = value;
            ++idx;
        }
        CoreLabel newWord = new CoreLabel(keys, values);
        if (newWord.value() == null && newWord.word() != null) {
            newWord.setValue(newWord.word());
        }
        return newWord;
    }
}

