/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CombineMWT
extends SsurgeonEdit {
    public static final String LABEL = "combineMWT";
    final List<String> names;
    final String word;

    public CombineMWT(List<String> names, String word) {
        this.names = new ArrayList<String>(names);
        this.word = word;
        if (names.size() < 2) {
            throw new SsurgeonParseException("Cannot combine MWT out of only " + names.size() + " words");
        }
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        for (String name : this.names) {
            buf.write("\t");
            buf.write(name);
        }
        if (this.word != null && !this.word.equals("")) {
            buf.write("\t");
            buf.write(this.word);
        }
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        ArrayList<IndexedWord> nodes = new ArrayList<IndexedWord>();
        for (String name : this.names) {
            IndexedWord node = sm.getNode(name);
            if (node == null) {
                return false;
            }
            nodes.add(node);
        }
        Collections.sort(nodes);
        for (int i = 0; i < nodes.size() - 1; ++i) {
            if (((IndexedWord)nodes.get(i)).index() == ((IndexedWord)nodes.get(i + 1)).index() - 1) continue;
            return false;
        }
        String newWord = this.word;
        if (newWord == null || newWord.equals("")) {
            StringBuilder newWordBuilder = new StringBuilder();
            for (IndexedWord node : nodes) {
                newWordBuilder.append(node.word());
            }
            newWord = newWordBuilder.toString();
        }
        boolean changed = false;
        int startIndex = ((IndexedWord)nodes.get(0)).index();
        int endIndex = ((IndexedWord)nodes.get(nodes.size() - 1)).index();
        for (IndexedWord vertex : sg.vertexSet()) {
            if (vertex.index() < startIndex || vertex.index() > endIndex) continue;
            if (!vertex.containsKey(CoreAnnotations.IsMultiWordTokenAnnotation.class) || !((Boolean)vertex.get(CoreAnnotations.IsMultiWordTokenAnnotation.class)).booleanValue()) {
                changed = true;
                vertex.set(CoreAnnotations.IsMultiWordTokenAnnotation.class, true);
            }
            if (!vertex.containsKey(CoreAnnotations.MWTTokenTextAnnotation.class) || !((String)vertex.get(CoreAnnotations.MWTTokenTextAnnotation.class)).equals(newWord)) {
                changed = true;
                vertex.set(CoreAnnotations.MWTTokenTextAnnotation.class, newWord);
            }
            if (vertex.index() == startIndex) {
                if (vertex.containsKey(CoreAnnotations.IsFirstWordOfMWTAnnotation.class) && ((Boolean)vertex.get(CoreAnnotations.IsFirstWordOfMWTAnnotation.class)).booleanValue()) continue;
                changed = true;
                vertex.set(CoreAnnotations.IsFirstWordOfMWTAnnotation.class, true);
                continue;
            }
            if (vertex.containsKey(CoreAnnotations.IsFirstWordOfMWTAnnotation.class) && !((Boolean)vertex.get(CoreAnnotations.IsFirstWordOfMWTAnnotation.class)).booleanValue()) continue;
            changed = true;
            vertex.set(CoreAnnotations.IsFirstWordOfMWTAnnotation.class, false);
        }
        return false;
    }
}

