/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;
import java.util.Iterator;

public class DeleteLeaf
extends SsurgeonEdit {
    public static final String LABEL = "deleteLeaf";
    protected String nodeName;

    public DeleteLeaf(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord tgtNode = this.getNamedNode(this.nodeName, sm);
        if (tgtNode == null) {
            return false;
        }
        Iterator<SemanticGraphEdge> iterator = sg.outgoingEdgeList(tgtNode).iterator();
        if (iterator.hasNext()) {
            SemanticGraphEdge edge = iterator.next();
            return false;
        }
        boolean deletedEdge = false;
        for (SemanticGraphEdge edge : sg.incomingEdgeList(tgtNode)) {
            deletedEdge = deletedEdge || sg.removeEdge(edge);
        }
        int deletedIndex = tgtNode.index();
        boolean deletedNode = sg.removeVertex(tgtNode);
        if (deletedNode) {
            AddDep.moveNodes(sg, sm, x -> x >= deletedIndex, x -> x - 1, false);
        }
        return deletedEdge || deletedNode;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-node");
        buf.write("\t");
        buf.write(this.nodeName);
        return buf.toString();
    }
}

