/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import java.util.Map;
import java.util.TreeMap;

public class EditNode
extends SsurgeonEdit {
    public static final String LABEL = "editNode";
    final String nodeName;
    final Map<String, String> attributes;

    public EditNode(String nodeName, Map<String, String> attributes) {
        if (nodeName == null) {
            throw new SsurgeonParseException("Cannot make an EditNode with no nodeName");
        }
        if (attributes.size() == 0) {
            throw new SsurgeonParseException("Cannot make an EditNode with no attributes");
        }
        AddDep.checkIllegalAttributes(attributes);
        this.nodeName = nodeName;
        this.attributes = new TreeMap<String, String>(attributes);
    }

    @Override
    public String toEditString() {
        StringBuilder buf = new StringBuilder();
        buf.append(LABEL);
        buf.append("\t");
        buf.append("-node");
        buf.append(" ");
        buf.append(this.nodeName);
        buf.append("\t");
        for (String key : this.attributes.keySet()) {
            buf.append("-");
            buf.append(key);
            buf.append(" ");
            buf.append(this.attributes.get(key));
            buf.append("\"\t");
        }
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord word = sm.getNode(this.nodeName);
        if (word == null) {
            return false;
        }
        CoreLabel other = AddDep.fromCheapStrings(this.attributes);
        boolean changed = false;
        for (Class<?> key : other.keySet()) {
            Object thisV = word.get(key);
            Object otherV = other.get(key);
            if (thisV == null || otherV == null) {
                if (thisV == null && otherV == null) continue;
                changed = true;
                word.set(key, otherV);
                continue;
            }
            if (thisV.equals(otherV)) continue;
            changed = true;
            word.set(key, otherV);
        }
        return changed;
    }
}

