/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;

public class KillAllIncomingEdges
extends SsurgeonEdit {
    public static final String LABEL = "killAllIncomingEdges";
    protected String nodeName;

    public KillAllIncomingEdges(String nodeName) {
        this.nodeName = nodeName;
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord tgtNode = this.getNamedNode(this.nodeName, sm);
        if (tgtNode == null) {
            return false;
        }
        boolean success = false;
        for (SemanticGraphEdge edge : sg.incomingEdgeList(tgtNode)) {
            success = success || sg.removeEdge(edge);
        }
        return success;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-node");
        buf.write("\t");
        buf.write(this.nodeName);
        return buf.toString();
    }
}

