/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class MergeNodes
extends SsurgeonEdit {
    public static final String LABEL = "mergeNodes";
    final List<String> nodes;
    final Map<String, String> attributes;

    public MergeNodes(List<String> nodes, Map<String, String> attributes) {
        if (nodes.size() > 2) {
            throw new SsurgeonParseException("Cannot support MergeNodes of size " + nodes.size() + " yet... please file an issue on github if you need this feature");
        }
        this.nodes = new ArrayList<String>(nodes);
        this.attributes = new TreeMap<String, String>(attributes);
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        for (String name : this.nodes) {
            buf.write("\t");
            buf.write("-node " + name);
        }
        for (String key : this.attributes.keySet()) {
            buf.write("\t-");
            buf.write(key);
            buf.write(" ");
            buf.write(this.attributes.get(key));
        }
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        IndexedWord right;
        IndexedWord left;
        IndexedWord dep;
        IndexedWord head;
        String name1 = this.nodes.get(0);
        String name2 = this.nodes.get(1);
        IndexedWord node1 = sm.getNode(name1);
        IndexedWord node2 = sm.getNode(name2);
        if (node1 == null || node2 == null) {
            return false;
        }
        List<SemanticGraphEdge> n1_to_n2 = sg.getAllEdges(node1, node2);
        List<SemanticGraphEdge> n2_to_n1 = sg.getAllEdges(node2, node1);
        if (n1_to_n2.size() == 0 && n2_to_n1.size() == 0) {
            return false;
        }
        if (n1_to_n2.size() > 0) {
            head = node1;
            dep = node2;
        } else {
            head = node2;
            dep = node1;
        }
        for (SemanticGraphEdge e : sg.outgoingEdgeIterable(dep)) {
            if (e.getTarget() == head) continue;
            return false;
        }
        for (SemanticGraphEdge e : sg.incomingEdgeIterable(dep)) {
            if (e.getSource() == head) continue;
            return false;
        }
        if (node1.index() < node2.index()) {
            left = node1;
            right = node2;
        } else {
            left = node2;
            right = node1;
        }
        CoreLabel newLabel = AddDep.fromCheapStrings(this.attributes);
        String lemma = newLabel.lemma();
        if (newLabel.word() == null) {
            String newWord = left.word() + right.word();
            newLabel.setWord(newWord);
        }
        if (newLabel.value() == null) {
            newLabel.setValue(newLabel.word());
        }
        newLabel.setLemma(lemma);
        if (newLabel.lemma() == null) {
            String newLemma = left.lemma() != null && right.lemma() != null ? left.lemma() + right.lemma() : null;
            newLabel.setLemma(newLemma);
        }
        if (newLabel.get(CoreAnnotations.AfterAnnotation.class) == null) {
            newLabel.setAfter(right.after());
        }
        if (newLabel.get(CoreAnnotations.BeforeAnnotation.class) == null) {
            newLabel.setBefore(right.before());
        }
        for (IndexedWord vertex : sg.vertexSet()) {
            if (vertex.index() != head.index()) continue;
            for (Class<?> key : newLabel.keySet()) {
                Object value = newLabel.get(key);
                vertex.set(key, value);
            }
        }
        for (IndexedWord vertex : sg.vertexListSorted()) {
            if (vertex.index() != dep.index()) continue;
            sg.removeVertex(vertex);
        }
        AddDep.moveNodes(sg, sm, x -> x >= dep.index(), x -> x - 1, false);
        return true;
    }
}

