/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import java.io.StringWriter;

public class ReattachNamedEdge
extends SsurgeonEdit {
    public static final String LABEL = "reattachNamedEdge";
    protected final String edgeName;
    protected final String govNodeName;
    protected final String depNodeName;

    public ReattachNamedEdge(String edgeName, String gov, String dep) {
        if (edgeName == null) {
            throw new SsurgeonParseException("ReattachNamedEdge created with no edge name!");
        }
        if (gov == null && dep == null) {
            throw new SsurgeonParseException("ReattachNamedEdge created with both gov and dep missing!");
        }
        this.edgeName = edgeName;
        this.govNodeName = gov;
        this.depNodeName = dep;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-edge");
        buf.write(" ");
        buf.write(this.edgeName);
        if (this.govNodeName != null) {
            buf.write("\t");
            buf.write("-gov");
            buf.write(" ");
            buf.write(this.govNodeName);
        }
        if (this.depNodeName != null) {
            buf.write("\t");
            buf.write("-dep");
            buf.write(" ");
            buf.write(this.depNodeName);
        }
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        SemanticGraphEdge edge = sm.getEdge(this.edgeName);
        if (edge != null) {
            SemanticGraphEdge newEdge;
            block4: {
                IndexedWord dep;
                IndexedWord gov = this.govNodeName != null ? sm.getNode(this.govNodeName) : edge.getSource();
                IndexedWord indexedWord = dep = this.depNodeName != null ? sm.getNode(this.depNodeName) : edge.getTarget();
                if (gov == edge.getSource() && dep == edge.getTarget()) {
                    return false;
                }
                boolean success = sg.removeEdge(edge);
                if (!success) {
                    return false;
                }
                for (SemanticGraphEdge existingEdge : sg.getAllEdges(edge.getSource(), edge.getTarget())) {
                    if (!existingEdge.getRelation().equals(edge.getRelation())) continue;
                    newEdge = existingEdge;
                    break block4;
                }
                newEdge = new SemanticGraphEdge(gov, dep, edge.getRelation(), edge.getWeight(), edge.isExtra());
                sg.addEdge(newEdge);
            }
            sm.putNamedEdge(this.edgeName, newEdge);
            return true;
        }
        return false;
    }
}

