/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.trees.GrammaticalRelation;
import java.io.StringWriter;
import java.util.ArrayList;

public class RemoveEdge
extends SsurgeonEdit {
    public static final String LABEL = "removeEdge";
    protected GrammaticalRelation relation;
    protected String govName;
    protected String depName;
    public static final String WILDCARD_NODE = "**WILDNODE**";

    public RemoveEdge(GrammaticalRelation relation, String govName, String depName) {
        this.relation = relation;
        this.govName = govName;
        this.depName = depName;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        if (this.relation != null) {
            buf.write("-reln");
            buf.write(" ");
            buf.write(this.relation.toString());
            buf.write("\t");
        }
        buf.write("-gov");
        buf.write(" ");
        buf.write(this.govName);
        buf.write("\t");
        buf.write("-dep");
        buf.write(" ");
        buf.write(this.depName);
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        boolean govWild = this.govName.equals(WILDCARD_NODE);
        boolean depWild = this.depName.equals(WILDCARD_NODE);
        IndexedWord govNode = this.getNamedNode(this.govName, sm);
        IndexedWord depNode = this.getNamedNode(this.depName, sm);
        boolean success = false;
        ArrayList<Object> edgesToDelete = null;
        if (govNode != null && depNode != null) {
            if (this.relation == null) {
                edgesToDelete = new ArrayList<SemanticGraphEdge>(sg.getAllEdges(govNode, depNode));
            } else {
                SemanticGraphEdge edge = sg.getEdge(govNode, depNode, this.relation);
                while (edge != null) {
                    if (!sg.removeEdge(edge)) {
                        throw new IllegalStateException("Found an edge and tried to delete it, but somehow this didn't work!  " + edge);
                    }
                    edge = sg.getEdge(govNode, depNode, this.relation);
                    success = true;
                }
            }
        } else if (depNode != null && govWild) {
            if (this.relation == null) {
                edgesToDelete = new ArrayList();
                sg.incomingEdgeIterable(depNode).forEach(edgesToDelete::add);
            } else {
                edgesToDelete = new ArrayList();
                for (SemanticGraphEdge semanticGraphEdge : sg.incomingEdgeIterable(depNode)) {
                    if (!semanticGraphEdge.getRelation().equals(this.relation)) continue;
                    edgesToDelete.add(semanticGraphEdge);
                }
            }
        } else if (govNode != null && depWild) {
            if (this.relation == null) {
                edgesToDelete = new ArrayList();
                sg.outgoingEdgeIterable(govNode).forEach(edgesToDelete::add);
            } else {
                edgesToDelete = new ArrayList();
                for (SemanticGraphEdge semanticGraphEdge : sg.outgoingEdgeIterable(govNode)) {
                    if (!semanticGraphEdge.getRelation().equals(this.relation)) continue;
                    edgesToDelete.add(semanticGraphEdge);
                }
            }
        }
        if (edgesToDelete != null) {
            for (SemanticGraphEdge semanticGraphEdge : edgesToDelete) {
                if (!sg.removeEdge(semanticGraphEdge)) {
                    throw new IllegalStateException("Found an edge and tried to delete it, but somehow this didn't work!  " + semanticGraphEdge);
                }
                success = true;
            }
        }
        return success;
    }

    public String getDepName() {
        return this.depName;
    }

    public String getGovName() {
        return this.govName;
    }

    public String getRelationName() {
        return this.relation.toString();
    }
}

