/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphEdge;
import edu.stanford.nlp.semgraph.semgrex.SemgrexMatcher;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import java.io.StringWriter;

public class RemoveNamedEdge
extends SsurgeonEdit {
    public static final String LABEL = "removeNamedEdge";
    protected final String edgeName;

    public RemoveNamedEdge(String edgeName) {
        this.edgeName = edgeName;
    }

    @Override
    public String toEditString() {
        StringWriter buf = new StringWriter();
        buf.write(LABEL);
        buf.write("\t");
        buf.write("-edge");
        buf.write(" ");
        buf.write(this.edgeName);
        buf.write("\t");
        return buf.toString();
    }

    @Override
    public boolean evaluate(SemanticGraph sg, SemgrexMatcher sm) {
        SemanticGraphEdge edge = sm.getEdge(this.edgeName);
        if (edge != null) {
            sg.removeEdge(edge);
            return true;
        }
        return false;
    }

    public String getEdgeName() {
        return this.edgeName;
    }
}

