/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.semgraph.semgrex.ssurgeon;

import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.ling.AnnotationLookup;
import edu.stanford.nlp.ling.CoreAnnotation;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphUtils;
import edu.stanford.nlp.semgraph.semgrex.SemgrexPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddDep;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.AddNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.CombineMWT;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.DeleteGraphFromNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.DeleteLeaf;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.EditNode;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.KillAllIncomingEdges;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.KillNonRootedNodes;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.MergeNodes;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.ReattachNamedEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RelabelNamedEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RemoveEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.RemoveNamedEdge;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SetRoots;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonEdit;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonParseException;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonPattern;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.SsurgeonWordlist;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgAndPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgOrPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.SsurgPred;
import edu.stanford.nlp.semgraph.semgrex.ssurgeon.pred.WordlistTest;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.XMLUtils;
import edu.stanford.nlp.util.logging.Redwood;
import edu.stanford.nlp.util.logging.RedwoodConfiguration;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class Ssurgeon {
    private static final boolean VERBOSE = false;
    private static Ssurgeon instance = null;
    private static final Redwood.RedwoodChannels log = Redwood.channels(Ssurgeon.class);
    private String logPrefix = null;
    private Map<String, SsurgeonWordlist> wordListResources = Generics.newHashMap();
    public static final String GOV_NODENAME_ARG = "-gov";
    public static final String DEP_NODENAME_ARG = "-dep";
    public static final String EDGE_NAME_ARG = "-edge";
    public static final String NODENAME_ARG = "-node";
    public static final String RELN_ARG = "-reln";
    public static final String NODE_PROTO_ARG = "-nodearg";
    public static final String WEIGHT_ARG = "-weight";
    public static final String NAME_ARG = "-name";
    public static final String POSITION_ARG = "-position";
    protected static ArgsBox argsBox = new ArgsBox();

    private Ssurgeon() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Ssurgeon inst() {
        Class<Ssurgeon> clazz = Ssurgeon.class;
        synchronized (Ssurgeon.class) {
            if (instance == null) {
                instance = new Ssurgeon();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initLog(File logFilePath) throws IOException {
        RedwoodConfiguration.empty().handlers(RedwoodConfiguration.Handlers.chain(RedwoodConfiguration.Handlers.showAllChannels(), RedwoodConfiguration.Handlers.stderr), RedwoodConfiguration.Handlers.file(logFilePath.toString())).apply();
        System.out.println("Starting Ssurgeon log, at " + logFilePath.getAbsolutePath() + " date=" + DateFormat.getDateInstance(0).format(new Date()));
        log.info("Starting Ssurgeon log, date=" + DateFormat.getDateInstance(0).format(new Date()));
    }

    public void setLogPrefix(String logPrefix) {
        this.logPrefix = logPrefix;
    }

    public List<SemanticGraph> expandFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg) throws Exception {
        ArrayList<SemanticGraph> retList = new ArrayList<SemanticGraph>();
        for (SsurgeonPattern pattern : patternList) {
            Collection<SemanticGraph> generated = pattern.execute(sg);
            for (SemanticGraph orderedGraph : generated) {
                retList.add(orderedGraph);
                System.out.println("\ncompact = " + orderedGraph.toCompactString());
                System.out.println("regular=" + orderedGraph);
            }
            if (generated.size() <= 0) continue;
            if (log != null) {
                log.info("* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *");
                log.info("Pre remove duplicates, num=" + generated.size());
            }
            SemanticGraphUtils.removeDuplicates(generated, sg);
            if (log == null) continue;
            log.info("Expand from patterns");
            if (this.logPrefix != null) {
                log.info(this.logPrefix);
            }
            log.info("Pattern = '" + pattern.getUID() + "' generated " + generated.size() + " matches");
            log.info("= = = = = = = = = =\nSrc graph:\n" + sg + "\n= = = = = = = = = =\n");
            int index = 1;
            for (SemanticGraph genSg : generated) {
                log.info("REWRITE " + index++);
                log.info(genSg.toString());
                log.info(". . . . .\n");
            }
        }
        return retList;
    }

    public Collection<SemanticGraph> exhaustFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg) throws Exception {
        Collection<SemanticGraph> generated = this.exhaustFromPatterns(patternList, sg, 1);
        if (generated.size() > 1) {
            if (log != null) {
                log.info("Before remove dupe, size=" + generated.size());
            }
            generated = SemanticGraphUtils.removeDuplicates(generated, sg);
            if (log != null) {
                log.info("AFTER remove dupe, size=" + generated.size());
            }
        }
        return generated;
    }

    private List<SemanticGraph> exhaustFromPatterns(List<SsurgeonPattern> patternList, SemanticGraph sg, int depth) throws Exception {
        ArrayList<SemanticGraph> retList = new ArrayList<SemanticGraph>();
        for (SsurgeonPattern pattern : patternList) {
            Collection<SemanticGraph> generated = pattern.execute(sg);
            for (SemanticGraph modGraph : generated) {
                retList.add(modGraph);
            }
            if (log == null || generated.size() <= 0) continue;
            log.info("* * * * * * * * * ** * * * * * * * * *");
            log.info("Exhaust from patterns, depth=" + depth);
            if (this.logPrefix != null) {
                log.info(this.logPrefix);
            }
            log.info("Pattern = '" + pattern.getUID() + "' generated " + generated.size() + " matches");
            log.info("= = = = = = = = = =\nSrc graph:\n" + sg.toString() + "\n= = = = = = = = = =\n");
            int index = 1;
            for (SemanticGraph genSg : generated) {
                log.info("REWRITE " + index++);
                log.info(genSg.toString());
                log.info(". . . . .\n");
            }
        }
        if (retList.size() > 0) {
            ArrayList<SemanticGraph> referenceList = new ArrayList<SemanticGraph>(retList);
            for (SemanticGraph childGraph : referenceList) {
                if (depth >= 3) continue;
                retList.addAll(this.exhaustFromPatterns(patternList, childGraph, depth + 1));
            }
        }
        return retList;
    }

    public static SsurgeonPattern getOperationFromFile(String path) {
        return null;
    }

    private void addResource(SsurgeonWordlist resource) {
        this.wordListResources.put(resource.getID(), resource);
    }

    public SsurgeonWordlist getResource(String id) {
        return this.wordListResources.get(id);
    }

    public Collection<SsurgeonWordlist> getResources() {
        return this.wordListResources.values();
    }

    private static List<Pair<String, String>> parseArgs(String argsString) {
        ArrayList<String> retList = new ArrayList<String>();
        String patternString = "(?:[^\\s\\\"]++|\\\"[^\\\"]*+\\\"|(\\\"))++";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(argsString);
        while (matcher.find()) {
            if (matcher.group(1) == null) {
                String matched = matcher.group();
                if (matched.charAt(0) == '\"' && matched.charAt(matched.length() - 1) == '\"') {
                    retList.add(matched.substring(1, matched.length() - 1));
                    continue;
                }
                retList.add(matched);
                continue;
            }
            throw new SsurgeonParseException("Unmatched quote in string to parse");
        }
        ArrayList<Pair<String, String>> parsedArgs = new ArrayList<Pair<String, String>>();
        for (int i = 0; i < retList.size() - 1; i += 2) {
            parsedArgs.add(new Pair(retList.get(i), retList.get(i + 1)));
        }
        return parsedArgs;
    }

    private static SsurgeonArgs parseArgsBox(String args, Map<String, String> additionalArgs) {
        SsurgeonArgs argsBox = new SsurgeonArgs();
        List<Pair<String, String>> argsArray = Ssurgeon.parseArgs(args);
        for (String string : additionalArgs.keySet()) {
            argsArray.add(new Pair<String, String>("-" + string, additionalArgs.get(string)));
        }
        block23: for (Pair pair : argsArray) {
            String argsKey = (String)pair.first;
            String argsValue = (String)pair.second;
            switch (argsKey) {
                case "-gov": {
                    argsBox.govNodeName = argsValue;
                    continue block23;
                }
                case "-dep": {
                    argsBox.dep = argsValue;
                    continue block23;
                }
                case "-edge": {
                    argsBox.edge = argsValue;
                    continue block23;
                }
                case "-reln": {
                    argsBox.reln = argsValue;
                    continue block23;
                }
                case "-node": {
                    argsBox.nodes.add(argsValue);
                    continue block23;
                }
                case "-nodearg": {
                    argsBox.nodeString = argsValue;
                    continue block23;
                }
                case "-weight": {
                    argsBox.weight = Double.valueOf(argsValue);
                    continue block23;
                }
                case "-name": {
                    argsBox.name = argsValue;
                    continue block23;
                }
                case "-position": {
                    argsBox.position = argsValue;
                    continue block23;
                }
            }
            String key = argsKey.substring(1);
            Class<? extends CoreAnnotation<?>> annotation = AnnotationLookup.toCoreKey(key);
            if (annotation == null) {
                throw new SsurgeonParseException("Parsing Ssurgeon args: unknown flag " + argsKey);
            }
            argsBox.annotations.put(key, argsValue);
        }
        return argsBox;
    }

    public static SsurgeonEdit parseEditLine(String editLine, Map<String, String> attributeArgs, Language language) {
        try {
            String[] tuples1 = editLine.split("\\s+", 2);
            if (tuples1.length < 1) {
                throw new SsurgeonParseException("Error in SsurgeonEdit.parseEditLine: invalid number of arguments");
            }
            String command = tuples1[0];
            if (command.equalsIgnoreCase("setRoots")) {
                String[] names = tuples1[1].split("\\s+");
                List<String> newRoots = Arrays.asList(names);
                return new SetRoots(newRoots);
            }
            if (command.equalsIgnoreCase("killNonRooted")) {
                return new KillNonRootedNodes();
            }
            SsurgeonArgs argsBox = Ssurgeon.parseArgsBox(tuples1.length == 1 ? "" : tuples1[1], attributeArgs);
            if (command.equalsIgnoreCase("addDep")) {
                if (argsBox.reln == null) {
                    throw new SsurgeonParseException("Relation not specified for AddDep");
                }
                GrammaticalRelation reln = GrammaticalRelation.valueOf(language, argsBox.reln);
                return new AddDep(argsBox.govNodeName, reln, argsBox.annotations, argsBox.position);
            }
            if (command.equalsIgnoreCase("addNode")) {
                return AddNode.createAddNode(argsBox.nodeString, argsBox.name);
            }
            if (command.equalsIgnoreCase("addEdge")) {
                if (argsBox.reln == null) {
                    throw new SsurgeonParseException("Relation not specified for AddEdge");
                }
                GrammaticalRelation reln = GrammaticalRelation.valueOf(language, argsBox.reln);
                return new AddEdge(argsBox.govNodeName, argsBox.dep, reln, argsBox.weight);
            }
            if (command.equalsIgnoreCase("reattachNamedEdge")) {
                return new ReattachNamedEdge(argsBox.edge, argsBox.govNodeName, argsBox.dep);
            }
            if (command.equalsIgnoreCase("delete")) {
                if (argsBox.nodes.size() != 1) {
                    throw new SsurgeonParseException("Cannot make a DeleteGraphFromNode out of " + argsBox.nodes.size() + " nodes");
                }
                return new DeleteGraphFromNode(argsBox.nodes.get(0));
            }
            if (command.equalsIgnoreCase("deleteLeaf")) {
                if (argsBox.nodes.size() != 1) {
                    throw new SsurgeonParseException("Cannot make a DeleteLeaf out of " + argsBox.nodes.size() + " nodes");
                }
                return new DeleteLeaf(argsBox.nodes.get(0));
            }
            if (command.equalsIgnoreCase("editNode")) {
                if (argsBox.nodes.size() != 1) {
                    throw new SsurgeonParseException("Cannot make an EditNode out of " + argsBox.nodes.size() + " nodes");
                }
                return new EditNode(argsBox.nodes.get(0), argsBox.annotations);
            }
            if (command.equalsIgnoreCase("mergeNodes")) {
                if (argsBox.nodes.size() < 2) {
                    throw new SsurgeonParseException("Cannot make a MergeNodes out of fewer than 2 nodes (got " + argsBox.nodes.size() + ")");
                }
                return new MergeNodes(argsBox.nodes, argsBox.annotations);
            }
            if (command.equalsIgnoreCase("relabelNamedEdge")) {
                if (argsBox.reln == null) {
                    throw new SsurgeonParseException("Relation not specified for AddEdge");
                }
                GrammaticalRelation reln = GrammaticalRelation.valueOf(language, argsBox.reln);
                return new RelabelNamedEdge(argsBox.edge, reln);
            }
            if (command.equalsIgnoreCase("removeEdge")) {
                GrammaticalRelation reln = null;
                if (argsBox.reln != null) {
                    reln = GrammaticalRelation.valueOf(argsBox.reln);
                }
                return new RemoveEdge(reln, argsBox.govNodeName, argsBox.dep);
            }
            if (command.equalsIgnoreCase("removeNamedEdge")) {
                return new RemoveNamedEdge(argsBox.edge);
            }
            if (command.equalsIgnoreCase("killAllIncomingEdges")) {
                if (argsBox.nodes.size() != 1) {
                    throw new SsurgeonParseException("Cannot make a KillAllIncomingEdges out of " + argsBox.nodes.size() + " nodes");
                }
                return new KillAllIncomingEdges(argsBox.nodes.get(0));
            }
            if (command.equalsIgnoreCase("combineMWT")) {
                return new CombineMWT(argsBox.nodes, argsBox.annotations.get("word"));
            }
            throw new SsurgeonParseException("Error in SsurgeonEdit.parseEditLine: command '" + command + "' is not supported");
        }
        catch (SsurgeonParseException e) {
            throw new SsurgeonParseException("Unable to process Ssurgeon edit line: " + editLine, e);
        }
    }

    public static void writeToFile(File tgtFile, List<SsurgeonPattern> patterns) {
        try {
            Document domDoc = Ssurgeon.createPatternXMLDoc(patterns);
            if (domDoc != null) {
                Transformer tformer = TransformerFactory.newInstance().newTransformer();
                tformer.setOutputProperty("indent", "yes");
                tformer.transform(new DOMSource(domDoc), new StreamResult(tgtFile));
            } else {
                log.warning("Was not able to create XML document for pattern list, file not written.");
            }
        }
        catch (Exception e) {
            log.error(Ssurgeon.class.getName(), "writeToFile");
            log.error(e);
        }
    }

    public static String writeToString(SsurgeonPattern pattern) {
        try {
            LinkedList<SsurgeonPattern> patterns = new LinkedList<SsurgeonPattern>();
            patterns.add(pattern);
            Document domDoc = Ssurgeon.createPatternXMLDoc(patterns);
            if (domDoc != null) {
                Transformer tformer = TransformerFactory.newInstance().newTransformer();
                tformer.setOutputProperty("indent", "yes");
                StringWriter sw = new StringWriter();
                tformer.transform(new DOMSource(domDoc), new StreamResult(sw));
                return sw.toString();
            }
            log.warning("Was not able to create XML document for pattern list.");
        }
        catch (Exception e) {
            log.info("Error in writeToString, could not process pattern=" + pattern);
            log.info(e);
            return null;
        }
        return "";
    }

    private static Document createPatternXMLDoc(List<SsurgeonPattern> patterns) {
        try {
            DocumentBuilderFactory dbf = XMLUtils.safeDocumentBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document domDoc = db.newDocument();
            Element rootElt = domDoc.createElement("ssurgeon-pattern-list");
            domDoc.appendChild(rootElt);
            int ordinal = 1;
            for (SsurgeonPattern pattern : patterns) {
                Element patElt = domDoc.createElement("ssurgeon-pattern");
                patElt.setAttribute("ordinal", String.valueOf(ordinal));
                Element semgrexElt = domDoc.createElement("semgrex");
                semgrexElt.appendChild(domDoc.createTextNode(pattern.getSemgrexPattern().pattern()));
                patElt.appendChild(semgrexElt);
                Element uidElem = domDoc.createElement("uid");
                uidElem.appendChild(domDoc.createTextNode(pattern.getUID()));
                patElt.appendChild(uidElem);
                Element notesElem = domDoc.createElement("notes");
                notesElem.appendChild(domDoc.createTextNode(pattern.getNotes()));
                patElt.appendChild(notesElem);
                SemanticGraph semgrexGraph = pattern.getSemgrexGraph();
                if (semgrexGraph != null) {
                    Element patNode = domDoc.createElement("semgrex-graph");
                    patNode.appendChild(domDoc.createTextNode(semgrexGraph.toCompactString()));
                }
                Element editList = domDoc.createElement("edit-list");
                patElt.appendChild(editList);
                int editOrdinal = 1;
                for (SsurgeonEdit edit : pattern.getEditScript()) {
                    Element editElem = domDoc.createElement("edit");
                    editElem.setAttribute("ordinal", String.valueOf(editOrdinal));
                    editElem.appendChild(domDoc.createTextNode(edit.toEditString()));
                    editList.appendChild(editElem);
                    ++editOrdinal;
                }
                rootElt.appendChild(patElt);
                ++ordinal;
            }
            return domDoc;
        }
        catch (Exception e) {
            log.error(Ssurgeon.class.getName(), "createPatternXML");
            log.error(e);
            return null;
        }
    }

    public List<SsurgeonPattern> readFromString(String text) {
        try {
            Document doc = XMLUtils.readDocumentFromString(text);
            return this.readFromDocument(doc);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SsurgeonParseException("XML failure while reading string", e);
        }
    }

    public List<SsurgeonPattern> readFromFile(File file) {
        try {
            Document doc = XMLUtils.readDocumentFromFile(file.getPath());
            return this.readFromDocument(doc);
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new SsurgeonParseException("XML failure while reading " + file, e);
        }
    }

    public List<SsurgeonPattern> readFromDocument(Document doc) {
        ArrayList<SsurgeonPattern> retList = new ArrayList<SsurgeonPattern>();
        NodeList patternNodes = doc.getElementsByTagName("ssurgeon-pattern");
        for (int i = 0; i < patternNodes.getLength(); ++i) {
            Node node = patternNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element elt = (Element)node;
            SsurgeonPattern pattern = Ssurgeon.ssurgeonPatternFromXML(elt);
            retList.add(pattern);
        }
        NodeList resourceNodes = doc.getElementsByTagName("resource");
        for (int i = 0; i < resourceNodes.getLength(); ++i) {
            Node node = patternNodes.item(i);
            if (node.getNodeType() != 1) continue;
            Element resourceElt = (Element)node;
            SsurgeonWordlist wlRsrc = new SsurgeonWordlist(resourceElt);
            this.addResource(wlRsrc);
        }
        return retList;
    }

    public List<SsurgeonPattern> readFromDirectory(File dir) throws Exception {
        if (!dir.isDirectory()) {
            throw new Exception("Given path not a directory, path=" + dir.getAbsolutePath());
        }
        File[] files = dir.listFiles((dir1, name) -> name.toLowerCase().endsWith(".xml"));
        ArrayList<SsurgeonPattern> patterns = new ArrayList<SsurgeonPattern>();
        for (File file : files) {
            try {
                patterns.addAll(this.readFromFile(file));
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return patterns;
    }

    public static SsurgeonPattern ssurgeonPatternFromXML(Element elt) {
        String uid = Ssurgeon.getTagText(elt, "uid");
        String notes = Ssurgeon.getTagText(elt, "notes");
        String semgrexString = Ssurgeon.getTagText(elt, "semgrex");
        SemgrexPattern semgrexPattern = SemgrexPattern.compile(semgrexString);
        SsurgeonPattern retPattern = new SsurgeonPattern(uid, semgrexPattern);
        retPattern.setNotes(notes);
        String language = Ssurgeon.getTagText(elt, "language");
        if (!language.equals("")) {
            retPattern.setLanguage(language);
        }
        NodeList editNodes = elt.getElementsByTagName("edit-list");
        for (int i = 0; i < editNodes.getLength(); ++i) {
            Node node = editNodes.item(i);
            if (node.getNodeType() != 1) continue;
            LinkedHashMap<String, String> attributeArgs = new LinkedHashMap<String, String>();
            for (int j = 0; j < node.getAttributes().getLength(); ++j) {
                Node attrNode = node.getAttributes().item(j);
                if (attrNode.getNodeType() != 2) continue;
                Attr attr = (Attr)attrNode;
                attributeArgs.put(attr.getName(), attr.getValue());
            }
            Element editElt = (Element)node;
            String editVal = Ssurgeon.getEltText(editElt);
            retPattern.addEdit(Ssurgeon.parseEditLine(editVal, attributeArgs, retPattern.getLanguage()));
        }
        Element predElt = Ssurgeon.getFirstTag(elt, "predicate");
        if (predElt != null) {
            SsurgPred pred = Ssurgeon.assemblePredFromXML(Ssurgeon.getFirstChildElement(predElt));
            retPattern.setPredicate(pred);
        }
        return retPattern;
    }

    public static SsurgPred assemblePredFromXML(Element elt) {
        String eltName;
        switch (eltName = elt.getTagName()) {
            case "and": {
                SsurgAndPred andPred = new SsurgAndPred();
                Iterator<Element> iterator = Ssurgeon.getChildElements(elt).iterator();
                if (!iterator.hasNext()) break;
                Element childElt = iterator.next();
                SsurgPred childPred = Ssurgeon.assemblePredFromXML(childElt);
                andPred.add(childPred);
                return andPred;
            }
            case "or": {
                SsurgOrPred orPred = new SsurgOrPred();
                Iterator<Element> childElt = Ssurgeon.getChildElements(elt).iterator();
                if (!childElt.hasNext()) break;
                Element childElt2 = childElt.next();
                SsurgPred childPred = Ssurgeon.assemblePredFromXML(childElt2);
                orPred.add(childPred);
                return orPred;
            }
            case "wordlist-test": {
                String id = elt.getAttribute("id");
                String resourceID = elt.getAttribute("resourceID");
                String typeStr = elt.getAttribute("type");
                String matchName = Ssurgeon.getEltText(elt).trim();
                if (matchName == null) {
                    throw new SsurgeonParseException("Could not find match name for " + elt);
                }
                if (id == null) {
                    throw new SsurgeonParseException("No ID attribute for element = " + elt);
                }
                return new WordlistTest(id, resourceID, typeStr, matchName);
            }
        }
        throw new SsurgeonParseException("Invalid node encountered during Ssurgeon predicate processing, node name=" + eltName);
    }

    public void testRead(File tgtDirPath) throws Exception {
        List<SsurgeonPattern> patterns = this.readFromDirectory(tgtDirPath);
        System.out.println("Patterns, num = " + patterns.size());
        int num = 1;
        for (SsurgeonPattern pattern : patterns) {
            System.out.println("\n# " + num++);
            System.out.println(pattern);
        }
        System.out.println("\n\nRESOURCES ");
        for (SsurgeonWordlist rsrc : Ssurgeon.inst().getResources()) {
            System.out.println(rsrc + "* * * * *");
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        boolean runFlag = true;
        Ssurgeon.inst().initLog(new File("./ssurgeon_run.log"));
        while (runFlag) {
            try {
                System.out.println("Enter a sentence:");
                String line = in.readLine();
                if (line.isEmpty()) {
                    System.exit(0);
                }
                System.out.println("Parsing...");
                SemanticGraph sg = SemanticGraph.valueOf(line);
                System.out.println("Graph = " + sg);
                Collection<SemanticGraph> generated = Ssurgeon.inst().exhaustFromPatterns(patterns, sg);
                System.out.println("# generated = " + generated.size());
                int index = 1;
                for (SemanticGraph gsg : generated) {
                    System.out.println("\n# " + index);
                    System.out.println(gsg);
                    ++index;
                }
            }
            catch (Exception e) {
                log.error(e);
            }
        }
    }

    public static String getTagText(Element element, String tag) {
        try {
            Element firstElt = Ssurgeon.getFirstTag(element, tag);
            if (firstElt == null) {
                return "";
            }
            return Ssurgeon.getEltText(firstElt);
        }
        catch (Exception e) {
            log.warning("Exception thrown attempting to get tag text for tag=" + tag + ", from element=" + element);
            return "";
        }
    }

    public static String getEltText(Element element) {
        try {
            NodeList childNodeList = element.getChildNodes();
            if (childNodeList.getLength() == 0) {
                return "";
            }
            return childNodeList.item(0).getNodeValue();
        }
        catch (Exception e) {
            log.warning("Exception e=" + e.getMessage() + " thrown calling getEltText on element=" + element);
            return "";
        }
    }

    private static Element getFirstTag(Element element, String tag) {
        try {
            NodeList nodeList = element.getElementsByTagName(tag);
            if (nodeList.getLength() == 0) {
                return null;
            }
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
        }
        catch (Exception e) {
            log.warning("Error getting first tag " + tag + " under element=" + element);
        }
        return null;
    }

    private static Element getFirstChildElement(Element element) {
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                return (Element)node;
            }
        }
        catch (Exception e) {
            log.warning("Error getting first child Element for element=" + element + ", exception=" + e);
        }
        return null;
    }

    private static List<Element> getChildElements(Element element) {
        LinkedList<Element> childElements = new LinkedList<Element>();
        try {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                childElements.add((Element)node);
            }
        }
        catch (Exception e) {
            log.warning("Exception thrown getting all children for element=" + element + ", e=" + e);
        }
        return childElements;
    }

    public static void main(String[] args) {
        for (int argIndex = 0; argIndex < args.length; ++argIndex) {
            if (args[argIndex].equalsIgnoreCase("-info")) {
                Ssurgeon.argsBox.info = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (args[argIndex].equalsIgnoreCase("-patterns")) {
                Ssurgeon.argsBox.patternDirStr = args[argIndex + 1];
                argIndex += 2;
                continue;
            }
            if (!args[argIndex].equalsIgnoreCase("-type")) continue;
            Ssurgeon.argsBox.type = RUNTYPE.valueOf(args[argIndex + 1]);
            argIndex += 2;
        }
        if (Ssurgeon.argsBox.patternDirStr == null) {
            throw new IllegalArgumentException("Need to give a pattern location with -patterns");
        }
        argsBox.init();
        System.out.println(argsBox);
        try {
            if (Ssurgeon.argsBox.type == RUNTYPE.interactive) {
                Ssurgeon.inst().testRead(Ssurgeon.argsBox.patternDir);
            }
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    public static class ArgsBox {
        public RUNTYPE type = RUNTYPE.interactive;
        public String patternDirStr = null;
        public File patternDir = null;
        public String info = null;
        public File infoPath = null;

        public void init() {
            this.patternDir = new File(this.patternDirStr);
            if (this.type == RUNTYPE.testinfo) {
                this.infoPath = new File(this.info);
            }
        }

        public String toString() {
            StringWriter buf = new StringWriter();
            buf.write("type =" + (Object)((Object)this.type) + "\n");
            buf.write("pattern dir = " + this.patternDir.getAbsolutePath());
            if (this.type == RUNTYPE.testinfo) {
                buf.write("info file = " + this.info);
                if (this.info != null) {
                    buf.write(", path = " + this.infoPath.getAbsolutePath());
                }
            }
            return buf.toString();
        }
    }

    public static enum RUNTYPE {
        interactive,
        testinfo;

    }

    protected static class SsurgeonArgs {
        public String govNodeName = null;
        public String dep = null;
        public String edge = null;
        public String reln = null;
        public List<String> nodes = new ArrayList<String>();
        public String nodeString = null;
        public double weight = 0.0;
        public String name = null;
        public String position = null;
        public Map<String, String> annotations = new TreeMap<String, String>();

        protected SsurgeonArgs() {
        }
    }
}

