/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.sequences.BestSequenceFinder;
import edu.stanford.nlp.sequences.SequenceModel;
import edu.stanford.nlp.util.Beam;
import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.ScoredComparator;
import edu.stanford.nlp.util.logging.Redwood;
import java.util.NoSuchElementException;

public class BeamBestSequenceFinder
implements BestSequenceFinder {
    private static final Redwood.RedwoodChannels log = Redwood.channels(BeamBestSequenceFinder.class);
    private static int[] tmp = null;
    private final int beamSize;
    private final boolean exhaustiveStart;
    private final boolean recenter;

    @Override
    public int[] bestSequence(SequenceModel ts) {
        return this.bestSequence(ts, 131072);
    }

    public int[] bestSequence(SequenceModel ts, int size) {
        int length = ts.length();
        int leftWindow = ts.leftWindow();
        int rightWindow = ts.rightWindow();
        int padLength = length + leftWindow + rightWindow;
        int[][] tags = new int[padLength][];
        int[] tagNum = new int[padLength];
        for (int pos = 0; pos < padLength; ++pos) {
            tags[pos] = ts.getPossibleValues(pos);
            tagNum[pos] = tags[pos].length;
        }
        Beam<Scored> newBeam = new Beam<Scored>(this.beamSize, ScoredComparator.ASCENDING_COMPARATOR);
        TagSeq initSeq = new TagSeq();
        newBeam.add(initSeq);
        for (int pos = 0; pos < padLength; ++pos) {
            TagSeq tagSeq;
            if (Thread.interrupted()) {
                throw new RuntimeInterruptedException();
            }
            Beam<Scored> oldBeam = newBeam;
            newBeam = pos < leftWindow + rightWindow && this.exhaustiveStart ? new Beam<Scored>(100000, ScoredComparator.ASCENDING_COMPARATOR) : new Beam<Scored>(this.beamSize, ScoredComparator.ASCENDING_COMPARATOR);
            for (TagSeq tagSeq2 : oldBeam) {
                if (Thread.interrupted()) {
                    throw new RuntimeInterruptedException();
                }
                for (int nextTagNum = 0; nextTagNum < tagNum[pos]; ++nextTagNum) {
                    TagSeq nextSeq = tagSeq2.tclone();
                    if (pos >= leftWindow + rightWindow) {
                        nextSeq.extendWith(tags[pos][nextTagNum], ts, size);
                    } else {
                        nextSeq.extendWith(tags[pos][nextTagNum]);
                    }
                    newBeam.add(nextSeq);
                }
            }
            if (!this.recenter) continue;
            double max = Double.NEGATIVE_INFINITY;
            for (Scored aNewBeam1 : newBeam) {
                tagSeq = (TagSeq)aNewBeam1;
                if (!(tagSeq.score > max)) continue;
                max = tagSeq.score;
            }
            for (Scored aNewBeam : newBeam) {
                TagSeq tagSeq3 = tagSeq = (TagSeq)aNewBeam;
                tagSeq3.score = tagSeq3.score - max;
            }
        }
        try {
            TagSeq bestSeq = (TagSeq)newBeam.iterator().next();
            int[] seq = bestSeq.tags();
            return seq;
        }
        catch (NoSuchElementException e) {
            log.info("Beam empty -- no best sequence.");
            return null;
        }
    }

    public BeamBestSequenceFinder(int beamSize) {
        this(beamSize, false, false);
    }

    public BeamBestSequenceFinder(int beamSize, boolean exhaustiveStart) {
        this(beamSize, exhaustiveStart, false);
    }

    public BeamBestSequenceFinder(int beamSize, boolean exhaustiveStart, boolean recenter) {
        this.exhaustiveStart = exhaustiveStart;
        this.beamSize = beamSize;
        this.recenter = recenter;
    }

    static /* synthetic */ int[] access$002(int[] x0) {
        tmp = x0;
        return x0;
    }

    private static class TagSeq
    implements Scored {
        private double score = 0.0;
        private int size = 0;
        private TagList info = null;

        private TagSeq() {
        }

        @Override
        public double score() {
            return this.score;
        }

        public int size() {
            return this.size;
        }

        public int[] tmpTags(int count, int s) {
            if (tmp == null || tmp.length < s) {
                BeamBestSequenceFinder.access$002(new int[s]);
            }
            TagList tl = this.info;
            int i = this.size() - 1;
            while (tl != null && count >= 0) {
                tmp[i] = tl.tag;
                --i;
                --count;
                tl = tl.last;
            }
            return tmp;
        }

        public int[] tags() {
            int[] t = new int[this.size()];
            int i = this.size() - 1;
            TagList tl = this.info;
            while (tl != null) {
                t[i] = tl.tag;
                --i;
                tl = tl.last;
            }
            return t;
        }

        public void extendWith(int tag) {
            TagList last = this.info;
            this.info = new TagList();
            this.info.tag = tag;
            this.info.last = last;
            ++this.size;
        }

        public void extendWith(int tag, SequenceModel ts, int s) {
            this.extendWith(tag);
            int[] tags = this.tmpTags(ts.leftWindow() + 1 + ts.rightWindow(), s);
            this.score += ts.scoreOf(tags, this.size() - ts.rightWindow() - 1);
        }

        public TagSeq tclone() {
            TagSeq o = new TagSeq();
            o.info = this.info;
            o.size = this.size;
            o.score = this.score;
            return o;
        }

        private static class TagList {
            int tag = -1;
            TagList last = null;

            private TagList() {
            }
        }
    }
}

