/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.sequences;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.objectbank.ObjectBank;
import edu.stanford.nlp.process.Americanize;
import edu.stanford.nlp.process.WordShapeClassifier;
import edu.stanford.nlp.process.WordToSentenceProcessor;
import edu.stanford.nlp.sequences.SeqClassifierFlags;
import edu.stanford.nlp.util.AbstractIterator;
import edu.stanford.nlp.util.CoreMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class ObjectBankWrapper<IN extends CoreMap>
extends ObjectBank<List<IN>> {
    private static final long serialVersionUID = -3838331732026362075L;
    private final SeqClassifierFlags flags;
    private final ObjectBank<List<IN>> wrapped;
    private final Set<String> knownLCWords;
    private static final Pattern monthDayPattern = Pattern.compile("Monday|Tuesday|Wednesday|Thursday|Friday|Saturday|Sunday|January|February|March|April|May|June|July|August|September|October|November|December", 2);

    public ObjectBankWrapper(SeqClassifierFlags flags, ObjectBank<List<IN>> wrapped, Set<String> knownLCWords) {
        super(null, null);
        this.flags = flags;
        this.wrapped = wrapped;
        this.knownLCWords = knownLCWords;
    }

    @Override
    public Iterator<List<IN>> iterator() {
        return new WrappedIterator(this.wrapped.iterator());
    }

    public List<IN> processDocument(List<IN> doc) {
        if (this.flags.mergeTags) {
            this.mergeTags(doc);
        }
        if (this.flags.iobTags) {
            this.iobTags(doc);
        }
        this.doBasicStuff(doc);
        return doc;
    }

    private String intern(String s) {
        if (this.flags.intern) {
            return s.intern();
        }
        return s;
    }

    private String fix(String word) {
        if ((this.flags.normalizeTerms || this.flags.normalizeTimex) && monthDayPattern.matcher(word).matches()) {
            return word.toLowerCase();
        }
        if (this.flags.normalizeTerms) {
            return Americanize.americanize(word, false);
        }
        return word;
    }

    private void doBasicStuff(List<IN> doc) {
        int position = 0;
        for (CoreMap fl : doc) {
            fl.set(CoreAnnotations.PositionAnnotation.class, Integer.toString(position++).intern());
            if (this.flags.wordShape > -1 && !this.flags.useShapeStrings) {
                String word = (String)fl.get(CoreAnnotations.TextAnnotation.class);
                if (this.flags.wordFunction != null) {
                    word = this.flags.wordFunction.apply(word);
                }
                if (!word.isEmpty() && Character.isLowerCase(word.codePointAt(0))) {
                    this.knownLCWords.add(this.intern(word));
                }
                String s = this.intern(WordShapeClassifier.wordShape(word, this.flags.wordShape, this.knownLCWords));
                fl.set(CoreAnnotations.ShapeAnnotation.class, s);
            }
            if ("edu.stanford.nlp.wordseg.Sighan2005DocumentReaderAndWriter".equalsIgnoreCase(this.flags.readerAndWriter)) {
                fl.set(CoreAnnotations.CharAnnotation.class, this.intern(this.fix((String)fl.get(CoreAnnotations.CharAnnotation.class))));
                continue;
            }
            fl.set(CoreAnnotations.TextAnnotation.class, this.intern(this.fix((String)fl.get(CoreAnnotations.TextAnnotation.class))));
            if (fl.get(CoreAnnotations.GoldAnswerAnnotation.class) != null) continue;
            fl.set(CoreAnnotations.GoldAnswerAnnotation.class, fl.get(CoreAnnotations.AnswerAnnotation.class));
        }
    }

    private void fixDocLengths(List<List<IN>> docs) {
        int maxDocSize = this.flags.maxDocSize;
        WordToSentenceProcessor<IN> wts = null;
        ArrayList<List<Object>> newDocuments = new ArrayList<List<Object>>();
        for (List<IN> document : docs) {
            if (maxDocSize <= 0 || document.size() <= maxDocSize) {
                if (!this.flags.keepEmptySentences && document.isEmpty()) continue;
                newDocuments.add(document);
                continue;
            }
            if (wts == null) {
                wts = new WordToSentenceProcessor<IN>();
            }
            List<List<IN>> sentences = wts.process(document);
            ArrayList<IN> newDocument = new ArrayList<IN>();
            for (List<IN> sentence : sentences) {
                if (newDocument.size() + sentence.size() > maxDocSize) {
                    if (!newDocument.isEmpty()) {
                        newDocuments.add(newDocument);
                    }
                    newDocument = new ArrayList();
                }
                newDocument.addAll(sentence);
            }
            if (!this.flags.keepEmptySentences && newDocument.isEmpty()) continue;
            newDocuments.add(newDocument);
        }
        docs.clear();
        docs.addAll(newDocuments);
    }

    private void iobTags(List<IN> doc) {
        String lastTag = "";
        for (CoreMap wi : doc) {
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            if (!this.flags.backgroundSymbol.equals(answer) && answer != null) {
                String label;
                String prefix;
                int index = answer.indexOf(45);
                if (index < 0) {
                    prefix = "";
                    label = answer;
                } else {
                    prefix = answer.substring(0, index);
                    label = answer.substring(index + 1);
                }
                if (!prefix.equals("B")) {
                    if (!label.equals(lastTag)) {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, "B-" + label);
                    } else {
                        wi.set(CoreAnnotations.AnswerAnnotation.class, "I-" + label);
                    }
                }
                lastTag = label;
                continue;
            }
            lastTag = answer;
        }
    }

    private void mergeTags(List<IN> doc) {
        for (CoreMap wi : doc) {
            int index;
            String answer = (String)wi.get(CoreAnnotations.AnswerAnnotation.class);
            if (answer == null) continue;
            if (!answer.equals(this.flags.backgroundSymbol) && (index = answer.indexOf(45)) >= 0) {
                answer = answer.substring(index + 1);
            }
            wi.set(CoreAnnotations.AnswerAnnotation.class, answer);
        }
    }

    @Override
    public boolean add(List<IN> o) {
        return this.wrapped.add(o);
    }

    @Override
    public boolean addAll(Collection<? extends List<IN>> c) {
        return this.wrapped.addAll(c);
    }

    @Override
    public void clear() {
        this.wrapped.clear();
    }

    @Override
    public void clearMemory() {
        this.wrapped.clearMemory();
    }

    @Override
    public boolean contains(Object o) {
        return this.wrapped.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.wrapped.containsAll(c);
    }

    @Override
    public boolean isEmpty() {
        return this.wrapped.isEmpty();
    }

    @Override
    public void keepInMemory(boolean keep) {
        this.wrapped.keepInMemory(keep);
    }

    @Override
    public boolean remove(Object o) {
        return this.wrapped.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.wrapped.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.wrapped.retainAll(c);
    }

    @Override
    public int size() {
        return this.wrapped.size();
    }

    private class WrappedIterator
    extends AbstractIterator<List<IN>> {
        private final Iterator<List<IN>> wrappedIter;
        private Iterator<List<IN>> spilloverIter;

        public WrappedIterator(Iterator<List<IN>> wrappedIter) {
            this.wrappedIter = wrappedIter;
        }

        private void primeNextHelper() {
            while ((this.spilloverIter == null || !this.spilloverIter.hasNext()) && this.wrappedIter.hasNext()) {
                List doc = this.wrappedIter.next();
                ArrayList docs = new ArrayList();
                docs.add(doc);
                ObjectBankWrapper.this.fixDocLengths(docs);
                this.spilloverIter = docs.iterator();
            }
        }

        @Override
        public boolean hasNext() {
            this.primeNextHelper();
            return this.wrappedIter.hasNext() || this.spilloverIter != null && this.spilloverIter.hasNext();
        }

        @Override
        public List<IN> next() {
            this.primeNextHelper();
            return ObjectBankWrapper.this.processDocument(this.spilloverIter.next());
        }
    }
}

