/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.coref.CorefCoreAnnotations;
import edu.stanford.nlp.coref.CorefProperties;
import edu.stanford.nlp.coref.data.CorefChain;
import edu.stanford.nlp.coref.data.Dictionaries;
import edu.stanford.nlp.io.RuntimeIOException;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.naturalli.NaturalLogicAnnotations;
import edu.stanford.nlp.naturalli.OperatorSpec;
import edu.stanford.nlp.naturalli.Polarity;
import edu.stanford.nlp.pipeline.Annotation;
import edu.stanford.nlp.pipeline.AnnotationOutputter;
import edu.stanford.nlp.pipeline.Annotator;
import edu.stanford.nlp.pipeline.AnnotatorImplementations;
import edu.stanford.nlp.pipeline.AnnotatorPool;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.JSONOutputter;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.pipeline.ServerAnnotatorImplementations;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import edu.stanford.nlp.pipeline.XMLOutputter;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphCoreAnnotations;
import edu.stanford.nlp.sentiment.SentimentCoreAnnotations;
import edu.stanford.nlp.simple.Sentence;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.IntTuple;
import edu.stanford.nlp.util.Lazy;
import edu.stanford.nlp.util.PropertiesUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;

public class Document {
    static final Properties EMPTY_PROPS = PropertiesUtils.asProperties("language", "english", "annotators", "", "tokenize.class", "PTBTokenizer", "tokenize.language", "en", "parse.binaryTrees", "true", "mention.type", "dep", "coref.mode", "statistical", "coref.md.type", "dep");
    static final Properties CASELESS_PROPS = PropertiesUtils.asProperties("language", "english", "annotators", "", "tokenize.class", "PTBTokenizer", "tokenize.language", "en", "parse.binaryTrees", "true", "pos.model", "edu/stanford/nlp/models/pos-tagger/wsj-0-18-caseless-left3words-distsim.tagger", "parse.model", "edu/stanford/nlp/models/lexparser/englishPCFG.caseless.ser.gz", "ner.model", "edu/stanford/nlp/models/ner/english.muc.7class.caseless.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.conll.4class.caseless.distsim.crf.ser.gz,edu/stanford/nlp/models/ner/english.all.3class.caseless.distsim.crf.ser.gz");
    private static AnnotatorImplementations backend = new AnnotatorImplementations();
    private static final Annotator defaultTokenize = backend.tokenizer(EMPTY_PROPS);
    private static final Annotator defaultSSplit = backend.wordToSentences(EMPTY_PROPS);
    private static Supplier<Annotator> defaultPOS = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("pos", PropertiesUtils.getSignature("pos", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.posTagger(EMPTY_PROPS))).get();
        }
    };
    private static final Supplier<Annotator> defaultLemma = () -> backend.morpha(EMPTY_PROPS, false);
    private static Supplier<Annotator> defaultNER = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("ner", PropertiesUtils.getSignature("ner", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.ner(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultRegexner = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("regexner", PropertiesUtils.getSignature("regexner", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.tokensRegexNER(EMPTY_PROPS, "regexner"))).get();
        }
    };
    private static Supplier<Annotator> defaultParse = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("parse", PropertiesUtils.getSignature("parse", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.parse(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultDepparse = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("depparse", PropertiesUtils.getSignature("depparse", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.dependencies(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultNatlog = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("natlog", PropertiesUtils.getSignature("natlog", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.natlog(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultEntityMentions = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("entitymentions", PropertiesUtils.getSignature("entitymentions", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.entityMentions(EMPTY_PROPS, "entitymentions"))).get();
        }
    };
    private static Supplier<Annotator> defaultKBP = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("kbp", PropertiesUtils.getSignature("kbp", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.kbp(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultOpenie = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("openie", PropertiesUtils.getSignature("openie", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.openie(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultMention = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("coref.mention", PropertiesUtils.getSignature("coref.mention", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.corefMention(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultCoref = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("coref", PropertiesUtils.getSignature("coref", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.coref(EMPTY_PROPS))).get();
        }
    };
    private static Supplier<Annotator> defaultSentiment = new Supplier<Annotator>(){
        private StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature("sentiment", PropertiesUtils.getSignature("sentiment", EMPTY_PROPS));

        @Override
        public synchronized Annotator get() {
            return (Annotator)StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(this.key, x -> Lazy.of(() -> backend.sentiment(EMPTY_PROPS, "sentiment"))).get();
        }
    };
    private static final AnnotatorPool customAnnotators = new AnnotatorPool();
    protected final CoreNLPProtos.Document.Builder impl;
    protected List<Sentence> sentences = null;
    protected final ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer(false);
    private boolean haveRunOpenie = false;
    private boolean haveRunKBP = false;
    private Properties defaultProps;
    private SoftReference<Annotation> cachedAnnotation = null;

    private static synchronized Supplier<Annotator> getOrCreate(String name, Properties props, Supplier<Annotator> annotator) {
        StanfordCoreNLP.AnnotatorSignature key = new StanfordCoreNLP.AnnotatorSignature(name, PropertiesUtils.getSignature(name, props));
        customAnnotators.register(name, props, StanfordCoreNLP.GLOBAL_ANNOTATOR_CACHE.computeIfAbsent(key, sig -> Lazy.cache(annotator)));
        return () -> customAnnotators.get(name);
    }

    public static void setBackend(AnnotatorImplementations backend) {
        Document.backend = backend;
    }

    public static void useServer(String host, int port) {
        backend = new ServerAnnotatorImplementations(host, port);
    }

    public static void useServer(String host, int port, String apiKey, String apiSecret, boolean lazy) {
        backend = new ServerAnnotatorImplementations(host, port, apiKey, apiSecret, lazy);
    }

    public static void useServer(String host, String apiKey, String apiSecret, boolean lazy) {
        Document.useServer(host, host.startsWith("http://") ? 80 : 443, apiKey, apiSecret, lazy);
    }

    public static void useServer(String host, String apiKey, String apiSecret) {
        Document.useServer(host, host.startsWith("http://") ? 80 : 443, apiKey, apiSecret, true);
    }

    public Document(Properties props, String text) {
        this.defaultProps = props;
        this.impl = CoreNLPProtos.Document.newBuilder().setText(text);
    }

    public Document(String text) {
        this(EMPTY_PROPS, text);
    }

    public Document(Properties props, Annotation ann) {
        this.defaultProps = props;
        StanfordCoreNLP.getDefaultAnnotatorPool(props, new AnnotatorImplementations());
        this.impl = new ProtobufAnnotationSerializer(false).toProtoBuilder(ann);
        List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
        this.sentences = new ArrayList<Sentence>(sentences.size());
        for (CoreMap sentence : sentences) {
            this.sentences.add(new Sentence(this, this.serializer.toProtoBuilder(sentence), (String)sentence.get(CoreAnnotations.TextAnnotation.class), this.defaultProps));
        }
    }

    public Document(Annotation ann) {
        this(EMPTY_PROPS, ann);
    }

    public Document(Properties props, CoreNLPProtos.Document proto) {
        this.defaultProps = props;
        StanfordCoreNLP.getDefaultAnnotatorPool(props, new AnnotatorImplementations());
        this.impl = proto.toBuilder();
        if (proto.getSentenceCount() > 0) {
            this.sentences = new ArrayList<Sentence>(proto.getSentenceCount());
            for (CoreNLPProtos.Sentence sentence : proto.getSentenceList()) {
                this.sentences.add(new Sentence(this, sentence.toBuilder(), this.defaultProps));
            }
        }
    }

    public Document(CoreNLPProtos.Document proto) {
        this(EMPTY_PROPS, proto);
    }

    public Document caseless() {
        this.defaultProps = CASELESS_PROPS;
        return this;
    }

    public Document cased() {
        this.defaultProps = EMPTY_PROPS;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CoreNLPProtos.Document serialize() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            List<Sentence> sentences = this.sentences();
            this.impl.clearSentence();
            for (Sentence s : sentences) {
                this.impl.addSentence(s.serialize());
            }
            return this.impl.build();
        }
    }

    public void serialize(OutputStream out2) throws IOException {
        this.serialize().writeDelimitedTo(out2);
        out2.flush();
    }

    public static Document deserialize(InputStream in) throws IOException {
        return new Document(CoreNLPProtos.Document.parseDelimitedFrom(in));
    }

    @SafeVarargs
    public final String json(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            return new JSONOutputter().print(this.asAnnotation());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String jsonMinified(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            AnnotationOutputter.Options options = new AnnotationOutputter.Options(false);
            return new JSONOutputter().print(this.asAnnotation(), options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String xml(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            return new XMLOutputter().print(this.asAnnotation());
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    @SafeVarargs
    public final String xmlMinified(Function<Sentence, Object> ... functions) {
        for (Function<Sentence, Object> f : functions) {
            f.apply(this.sentence(0));
        }
        try {
            AnnotationOutputter.Options options = new AnnotationOutputter.Options(false);
            return new XMLOutputter().print(this.asAnnotation(false), options);
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public List<Sentence> sentences(Properties props) {
        return this.sentences(props, props == EMPTY_PROPS ? defaultTokenize : Document.getOrCreate("tokenize", props, () -> backend.tokenizer(props)).get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<Sentence> sentences(Properties props, Annotator tokenizer) {
        if (this.sentences == null) {
            Document document = this;
            synchronized (document) {
                if (this.sentences == null) {
                    Annotator ssplit = props == EMPTY_PROPS ? defaultSSplit : Document.getOrCreate("ssplit", props, () -> backend.wordToSentences(props)).get();
                    Annotation ann = new Annotation(this.impl.getText());
                    tokenizer.annotate(ann);
                    ssplit.annotate(ann);
                    if (ann.containsKey(CoreAnnotations.DocIDAnnotation.class)) {
                        this.impl.setDocID((String)ann.get(CoreAnnotations.DocIDAnnotation.class));
                    }
                    List sentences = (List)ann.get(CoreAnnotations.SentencesAnnotation.class);
                    this.sentences = new ArrayList<Sentence>(sentences.size());
                    this.impl.clearSentence();
                    for (CoreMap sentence : sentences) {
                        Sentence sent = new Sentence(this, this.serializer.toProtoBuilder(sentence), (String)sentence.get(CoreAnnotations.TextAnnotation.class), this.defaultProps);
                        this.sentences.add(sent);
                        this.impl.addSentence(sent.serialize());
                    }
                }
            }
        }
        return this.sentences;
    }

    public List<Sentence> sentences() {
        return this.sentences(EMPTY_PROPS);
    }

    public Sentence sentence(int sentenceIndex, Properties props) {
        return this.sentences(props).get(sentenceIndex);
    }

    public Sentence sentence(int sentenceIndex) {
        return this.sentences().get(sentenceIndex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String text() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            return this.impl.getText();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Integer, CorefChain> coref(Properties props) {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            if (this.impl.getCorefChainCount() == 0) {
                this.runLemma(props).runNER(props);
                if (CorefProperties.mdType(props) != CorefProperties.MentionDetectionType.DEPENDENCY) {
                    this.runParse(props);
                } else {
                    this.runDepparse(props);
                }
                Supplier<Annotator> mention = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultMention : Document.getOrCreate("coref.mention", props, () -> backend.corefMention(props));
                Supplier<Annotator> coref = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultCoref : Document.getOrCreate("coref", props, () -> backend.coref(props));
                Annotation ann = this.asAnnotation(true);
                mention.get().annotate(ann);
                coref.get().annotate(ann);
                ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
                synchronized (protobufAnnotationSerializer) {
                    for (CorefChain chain : ((Map)ann.get(CorefCoreAnnotations.CorefChainAnnotation.class)).values()) {
                        this.impl.addCorefChain(this.serializer.toProto(chain));
                    }
                }
            }
            Map<Integer, CorefChain> corefs = Generics.newHashMap();
            for (CoreNLPProtos.CorefChain chain : this.impl.getCorefChainList()) {
                corefs.put(chain.getChainID(), this.fromProto(chain));
            }
            return corefs;
        }
    }

    public Map<Integer, CorefChain> coref() {
        return this.coref(this.defaultProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Optional<String> docid() {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            if (this.impl.hasDocID()) {
                return Optional.of(this.impl.getDocID());
            }
            return Optional.empty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document setDocid(String docid) {
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.setDocID(docid);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceSentences(List<Sentence> sentences) {
        this.sentences = sentences;
        CoreNLPProtos.Document.Builder builder = this.impl;
        synchronized (builder) {
            this.impl.clearSentence();
            for (Sentence sent : sentences) {
                this.impl.addSentence(sent.serialize());
            }
        }
    }

    synchronized Document runPOS(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawToken(0).hasPos()) {
            return this;
        }
        this.sentences();
        Supplier<Annotator> pos = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultPOS : Document.getOrCreate("pos", props, () -> backend.posTagger(props));
        Annotation ann = this.asAnnotation(false);
        pos.get().annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setPos((String)pair.second), CoreLabel::tag);
        }
        return this;
    }

    synchronized Document runLemma(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawToken(0).hasLemma()) {
            return this;
        }
        this.runPOS(props);
        Supplier<Annotator> lemma = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultLemma : Document.getOrCreate("lemma", props, () -> backend.morpha(props, false));
        Annotation ann = this.asAnnotation(true);
        lemma.get().annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setLemma((String)pair.second), CoreLabel::lemma);
        }
        return this;
    }

    synchronized Document mockLemma(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawToken(0).hasLemma()) {
            return this;
        }
        this.runPOS(props);
        Annotation ann = this.asAnnotation(true);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setLemma((String)pair.second), CoreLabel::word);
        }
        return this;
    }

    synchronized Document runNER(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawToken(0).hasNer()) {
            return this;
        }
        this.runPOS(props);
        Supplier<Annotator> ner = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultNER : Document.getOrCreate("ner", props, () -> backend.ner(props));
        Annotation ann = this.asAnnotation(true);
        ner.get().annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setNer((String)pair.second), CoreLabel::ner);
        }
        return this;
    }

    synchronized Document runRegexner(Properties props) {
        this.runNER(props);
        Supplier<Annotator> ner = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultRegexner : Document.getOrCreate("regexner", props, () -> backend.tokensRegexNER(props, "regexner"));
        Annotation ann = this.asAnnotation(true);
        ner.get().annotate(ann);
        for (int i = 0; i < this.sentences.size(); ++i) {
            this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first).setNer((String)pair.second), CoreLabel::ner);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runParse(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawSentence().hasParseTree()) {
            return this;
        }
        boolean cacheAnnotation = false;
        Annotator parse = (props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultParse : Document.getOrCreate("parse", props, () -> backend.parse(props))).get();
        if (parse.requires().contains(CoreAnnotations.PartOfSpeechAnnotation.class) || System.getenv("CORENLP_HOST") != null) {
            this.runPOS(props);
            cacheAnnotation = true;
        } else {
            this.sentences();
        }
        Annotation ann = this.asAnnotation(cacheAnnotation);
        parse.annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                Tree tree = (Tree)sentence.get(TreeCoreAnnotations.TreeAnnotation.class);
                Tree binaryTree = (Tree)sentence.get(TreeCoreAnnotations.BinarizedTreeAnnotation.class);
                this.sentences.get(i).updateParse(ProtobufAnnotationSerializer.toProto(tree), binaryTree == null ? null : ProtobufAnnotationSerializer.toProto(binaryTree));
                SemanticGraph basicDependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class);
                SemanticGraph enhancedDependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class);
                SemanticGraph enhancedPlusPlusDependencies = (SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class);
                if (basicDependencies == null || enhancedDependencies == null || enhancedPlusPlusDependencies == null) continue;
                this.sentences.get(i).updateDependencies(this.serializer.toProto(basicDependencies), this.serializer.toProto(enhancedDependencies), this.serializer.toProto(enhancedPlusPlusDependencies));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runDepparse(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawSentence().hasBasicDependencies()) {
            return this;
        }
        this.runPOS(props);
        Supplier<Annotator> depparse = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultDepparse : Document.getOrCreate("depparse", props, () -> backend.dependencies(props));
        Annotation ann = this.asAnnotation(true);
        depparse.get().annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                this.sentences.get(i).updateDependencies(this.serializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.BasicDependenciesAnnotation.class)), this.serializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedDependenciesAnnotation.class)), this.serializer.toProto((SemanticGraph)sentence.get(SemanticGraphCoreAnnotations.EnhancedPlusPlusDependenciesAnnotation.class)));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runNatlog(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawToken(0).hasPolarity()) {
            return this;
        }
        this.runLemma(props);
        this.runDepparse(props);
        Supplier<Annotator> natlog = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultNatlog : Document.getOrCreate("natlog", props, () -> backend.natlog(props));
        Annotation ann = this.asAnnotation(true);
        natlog.get().annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first()).setPolarity(ProtobufAnnotationSerializer.toProto((Polarity)pair.second())), x -> (Polarity)x.get(NaturalLogicAnnotations.PolarityAnnotation.class));
                this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first()).setPolarityDir((String)pair.second()), x -> (String)x.get(NaturalLogicAnnotations.PolarityDirectionAnnotation.class));
                this.sentences.get(i).updateTokens((List)((CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i)).get(CoreAnnotations.TokensAnnotation.class), pair -> ((CoreNLPProtos.Token.Builder)pair.first()).setOperator(ProtobufAnnotationSerializer.toProto((OperatorSpec)pair.second())), x -> (OperatorSpec)x.get(NaturalLogicAnnotations.OperatorAnnotation.class));
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runOpenie(Properties props) {
        if (this.haveRunOpenie) {
            return this;
        }
        this.runNatlog(props);
        Supplier<Annotator> openie = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultOpenie : Document.getOrCreate("openie", props, () -> backend.openie(props));
        Annotation ann = this.asAnnotation(true);
        openie.get().annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                Collection triples = (Collection)sentence.get(NaturalLogicAnnotations.RelationTriplesAnnotation.class);
                this.sentences.get(i).updateOpenIE(triples.stream().map(this.serializer::toProto));
            }
        }
        this.haveRunOpenie = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runKBP(Properties props) {
        if (this.haveRunKBP) {
            return this;
        }
        this.coref(props);
        Supplier<Annotator> entityMention = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultEntityMentions : Document.getOrCreate("entitymentions", props, () -> backend.entityMentions(props, "entitymentions"));
        Annotation ann = this.asAnnotation(true);
        entityMention.get().annotate(ann);
        Supplier<Annotator> kbp = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultKBP : Document.getOrCreate("kbp", props, () -> backend.kbp(props));
        kbp.get().annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                Collection triples = (Collection)sentence.get(CoreAnnotations.KBPTriplesAnnotation.class);
                this.sentences.get(i).updateKBP(triples.stream().map(this.serializer::toProto));
            }
        }
        this.haveRunKBP = true;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized Document runSentiment(Properties props) {
        if (this.sentences != null && !this.sentences.isEmpty() && this.sentences.get(0).rawSentence().hasSentiment()) {
            return this;
        }
        this.runParse(props);
        if (this.sentences != null && !this.sentences.isEmpty() && !this.sentences.get(0).rawSentence().hasBinarizedParseTree()) {
            throw new IllegalStateException("No binarized parse tree (perhaps it's not supported in this language?)");
        }
        Annotation ann = this.asAnnotation(true);
        Supplier<Annotator> sentiment = props == EMPTY_PROPS || props == Sentence.SINGLE_SENTENCE_DOCUMENT ? defaultSentiment : Document.getOrCreate("sentiment", props, () -> backend.sentiment(props, "sentiment"));
        sentiment.get().annotate(ann);
        ProtobufAnnotationSerializer protobufAnnotationSerializer = this.serializer;
        synchronized (protobufAnnotationSerializer) {
            for (int i = 0; i < this.sentences.size(); ++i) {
                CoreMap sentence = (CoreMap)((List)ann.get(CoreAnnotations.SentencesAnnotation.class)).get(i);
                String sentimentClass = (String)sentence.get(SentimentCoreAnnotations.SentimentClass.class);
                this.sentences.get(i).updateSentiment(sentimentClass);
            }
        }
        return this;
    }

    public Annotation asAnnotation() {
        return this.asAnnotation(false);
    }

    Annotation asAnnotation(boolean cache) {
        Annotation ann;
        Annotation annotation = ann = this.cachedAnnotation == null ? null : this.cachedAnnotation.get();
        if (!cache || ann == null) {
            ann = this.serializer.fromProto(this.serialize());
        }
        this.cachedAnnotation = new SoftReference<Annotation>(ann);
        return ann;
    }

    private CorefChain fromProto(CoreNLPProtos.CorefChain proto) {
        int cid = proto.getChainID();
        HashMap<IntPair, Set<CorefChain.CorefMention>> mentions = new HashMap<IntPair, Set<CorefChain.CorefMention>>();
        CorefChain.CorefMention representative = null;
        for (int i = 0; i < proto.getMentionCount(); ++i) {
            CoreNLPProtos.CorefChain.CorefMention mentionProto = proto.getMention(i);
            StringBuilder mentionSpan = new StringBuilder();
            Sentence sentence = this.sentence(mentionProto.getSentenceIndex());
            for (int k = mentionProto.getBeginIndex(); k < mentionProto.getEndIndex(); ++k) {
                mentionSpan.append(' ').append(sentence.word(k));
            }
            CorefChain.CorefMention mention = new CorefChain.CorefMention(Dictionaries.MentionType.valueOf(mentionProto.getMentionType()), Dictionaries.Number.valueOf(mentionProto.getNumber()), Dictionaries.Gender.valueOf(mentionProto.getGender()), Dictionaries.Animacy.valueOf(mentionProto.getAnimacy()), mentionProto.getBeginIndex() + 1, mentionProto.getEndIndex() + 1, mentionProto.getHeadIndex() + 1, cid, mentionProto.getMentionID(), mentionProto.getSentenceIndex() + 1, new IntTuple(new int[]{mentionProto.getSentenceIndex() + 1, mentionProto.getPosition()}), mentionSpan.substring(mentionSpan.length() > 0 ? 1 : 0));
            IntPair key = new IntPair(mentionProto.getSentenceIndex() - 1, mentionProto.getHeadIndex() - 1);
            if (!mentions.containsKey(key)) {
                mentions.put(key, new HashSet());
            }
            ((Set)mentions.get(key)).add(mention);
            if (!proto.hasRepresentative() || i != proto.getRepresentative()) continue;
            representative = mention;
        }
        return new CorefChain(cid, mentions, representative);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Document)) {
            return false;
        }
        Document document = (Document)o;
        if (this.impl.hasText() && !this.impl.getText().equals(document.impl.getText())) {
            return false;
        }
        return this.impl.build().equals(document.impl.build()) && this.sentences.equals(document.sentences);
    }

    public int hashCode() {
        if (this.impl.hasText()) {
            return this.impl.getText().hashCode();
        }
        return this.impl.build().hashCode();
    }

    public String toString() {
        return this.impl.getText();
    }

    static {
        String host = System.getenv("CORENLP_HOST");
        String portStr = System.getenv("CORENLP_PORT");
        String key = System.getenv("CORENLP_KEY");
        String secret = System.getenv("CORENLP_SECRET");
        String lazystr = System.getenv("CORENLP_LAZY");
        if (host != null) {
            int port = 443;
            if (portStr == null) {
                if (host.startsWith("http://")) {
                    port = 80;
                }
            } else {
                port = Integer.parseInt(portStr);
            }
            boolean lazy = true;
            if (lazystr != null) {
                lazy = Boolean.parseBoolean(lazystr);
            }
            if (key != null && secret != null) {
                Document.useServer(host, port, key, secret, lazy);
            } else {
                Document.useServer(host, port);
            }
        }
    }
}

