/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.simple;

import edu.stanford.nlp.ling.AbstractToken;
import edu.stanford.nlp.simple.Sentence;
import java.util.Optional;
import java.util.function.Supplier;

public class Token
implements AbstractToken {
    public final Sentence sentence;
    public final int index;

    public Token(Sentence sentence, int index) {
        this.sentence = sentence;
        this.index = index;
    }

    public Token previous() {
        return new Token(this.sentence, this.index - 1);
    }

    public Token next() {
        return new Token(this.sentence, this.index + 1);
    }

    @Override
    public String word() {
        return this.sentence.word(this.index);
    }

    @Override
    public void setWord(String word) {
    }

    private String pad(Supplier<String> value) {
        if (this.index < 0) {
            return "^";
        }
        if (this.index >= this.sentence.length()) {
            return "$";
        }
        return value.get();
    }

    private <E> Optional<E> padOpt(Supplier<Optional<E>> value) {
        if (this.index < 0) {
            return Optional.empty();
        }
        if (this.index >= this.sentence.length()) {
            return Optional.empty();
        }
        return value.get();
    }

    @Override
    public String originalText() {
        return this.pad(() -> this.sentence.originalText(this.index));
    }

    @Override
    public void setOriginalText(String originalText) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String lemma() {
        return this.pad(() -> this.sentence.lemma(this.index));
    }

    @Override
    public void setLemma(String lemma) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String ner() {
        return this.pad(() -> this.sentence.nerTag(this.index));
    }

    @Override
    public void setNER(String ner) {
        throw new UnsupportedOperationException();
    }

    public String nerTag() {
        return this.ner();
    }

    @Override
    public String tag() {
        return this.pad(() -> this.sentence.posTag(this.index));
    }

    @Override
    public void setTag(String tag) {
        throw new UnsupportedOperationException();
    }

    public String posTag() {
        return this.tag();
    }

    public Optional<Integer> governor() {
        return this.padOpt(() -> this.sentence.governor(this.index));
    }

    public int characterOffsetBegin() {
        if (this.index < 0) {
            return -1;
        }
        if (this.index >= this.sentence.length()) {
            return -1;
        }
        return this.sentence.characterOffsetBegin(this.index);
    }

    public int characterOffsetEnd() {
        if (this.index < 0) {
            return -1;
        }
        if (this.index >= this.sentence.length()) {
            return -1;
        }
        return this.sentence.characterOffsetEnd(this.index);
    }

    @Override
    public String before() {
        if (this.index < 0) {
            return "";
        }
        if (this.index >= this.sentence.length()) {
            return "";
        }
        return this.sentence.before(this.index);
    }

    @Override
    public void setBefore(String before) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String after() {
        if (this.index < 0) {
            return "";
        }
        if (this.index >= this.sentence.length()) {
            return "";
        }
        return this.sentence.after(this.index);
    }

    @Override
    public void setAfter(String after) {
        throw new UnsupportedOperationException();
    }

    public Optional<String> incomingDependencyLabel() {
        return this.padOpt(() -> this.sentence.incomingDependencyLabel(this.index));
    }

    @Override
    public String docID() {
        return this.sentence.document.docid().orElse("");
    }

    @Override
    public void setDocID(String docID) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int sentIndex() {
        return this.sentence.sentenceIndex();
    }

    @Override
    public void setSentIndex(int sentIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int index() {
        return this.index;
    }

    @Override
    public void setIndex(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int beginPosition() {
        return this.characterOffsetBegin();
    }

    @Override
    public void setBeginPosition(int beginPos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int endPosition() {
        return this.characterOffsetEnd();
    }

    @Override
    public void setEndPosition(int endPos) {
        throw new UnsupportedOperationException();
    }
}

