/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.time;

import edu.stanford.nlp.ling.tokensregex.Env;
import edu.stanford.nlp.util.PropertiesUtils;
import java.util.HashMap;
import java.util.Properties;

public class Options {
    public boolean markTimeRanges = false;
    boolean restrictToTimex3 = false;
    RelativeHeuristicLevel teRelHeurLevel = RelativeHeuristicLevel.NONE;
    boolean includeNested = false;
    boolean includeRange = false;
    boolean searchForDocDate = false;
    public String language = "english";
    public static final HashMap<String, String> languageToRulesFiles = new HashMap();
    String grammarFilename = null;
    Env.Binder[] binders = null;
    static final String DEFAULT_GRAMMAR_FILES = "edu/stanford/nlp/models/sutime/defs.sutime.txt,edu/stanford/nlp/models/sutime/english.sutime.txt,edu/stanford/nlp/models/sutime/english.holidays.sutime.txt";
    static final String DEFAULT_BRITISH_GRAMMAR_FILES = "edu/stanford/nlp/models/sutime/defs.sutime.txt,edu/stanford/nlp/models/sutime/british.sutime.txt,edu/stanford/nlp/models/sutime/english.sutime.txt,edu/stanford/nlp/models/sutime/english.holidays.sutime.txt";
    static final String DEFAULT_SPANISH_GRAMMAR_FILES = "edu/stanford/nlp/models/sutime/defs.sutime.txt,edu/stanford/nlp/models/sutime/spanish.sutime.txt";
    static final String[] DEFAULT_BINDERS = new String[]{"edu.stanford.nlp.time.JollyDayHolidays"};
    boolean verbose = false;

    public Options() {
    }

    public Options(String name, Properties props) {
        int i;
        String[] binderClasses;
        int nBinders;
        this.includeRange = PropertiesUtils.getBool(props, name + ".includeRange", this.includeRange);
        this.markTimeRanges = PropertiesUtils.getBool(props, name + ".markTimeRanges", this.markTimeRanges);
        this.includeNested = PropertiesUtils.getBool(props, name + ".includeNested", this.includeNested);
        this.restrictToTimex3 = PropertiesUtils.getBool(props, name + ".restrictToTimex3", this.restrictToTimex3);
        this.teRelHeurLevel = RelativeHeuristicLevel.valueOf(props.getProperty(name + ".teRelHeurLevel", this.teRelHeurLevel.toString()));
        this.verbose = PropertiesUtils.getBool(props, name + ".verbose", this.verbose);
        this.language = props.getProperty(name + ".language", this.language);
        if (!languageToRulesFiles.keySet().contains(this.language)) {
            this.language = "english";
        }
        this.grammarFilename = languageToRulesFiles.get(this.language);
        this.grammarFilename = props.getProperty(name + ".rules", this.grammarFilename);
        this.searchForDocDate = PropertiesUtils.getBool(props, name + ".searchForDocDate", this.searchForDocDate);
        String binderProperty = props.getProperty(name + ".binders");
        if (binderProperty == null) {
            nBinders = DEFAULT_BINDERS.length;
            binderClasses = DEFAULT_BINDERS;
        } else {
            nBinders = PropertiesUtils.getInt(props, name + ".binders", 0);
            binderClasses = new String[nBinders];
            for (i = 0; i < nBinders; ++i) {
                String binderPrefix = name + ".binder." + (i + 1);
                binderClasses[i] = props.getProperty(binderPrefix);
            }
        }
        if (nBinders > 0 && System.getProperty("STS") == null) {
            this.binders = new Env.Binder[nBinders];
            for (i = 0; i < nBinders; ++i) {
                int bi = i + 1;
                String binderPrefix = name + ".binder." + bi;
                try {
                    Class<?> binderClass = Class.forName(binderClasses[i]);
                    binderPrefix = binderPrefix + '.';
                    this.binders[i] = (Env.Binder)binderClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.binders[i].init(binderPrefix, props);
                    continue;
                }
                catch (Exception ex) {
                    throw new RuntimeException("Error initializing binder " + bi, ex);
                }
            }
        }
    }

    static {
        languageToRulesFiles.put("english", DEFAULT_GRAMMAR_FILES);
        languageToRulesFiles.put("en", DEFAULT_GRAMMAR_FILES);
        languageToRulesFiles.put("british", DEFAULT_BRITISH_GRAMMAR_FILES);
        languageToRulesFiles.put("spanish", DEFAULT_SPANISH_GRAMMAR_FILES);
        languageToRulesFiles.put("es", DEFAULT_SPANISH_GRAMMAR_FILES);
    }

    public static enum RelativeHeuristicLevel {
        NONE,
        BASIC,
        MORE;

    }
}

