/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.graph.DirectedMultiGraph;
import edu.stanford.nlp.international.Language;
import edu.stanford.nlp.io.IOUtils;
import edu.stanford.nlp.ling.AbstractCoreLabel;
import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.GrammaticalRelation;
import edu.stanford.nlp.trees.GrammaticalStructureConversionUtils;
import edu.stanford.nlp.trees.GrammaticalStructureFromDependenciesFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.SemanticHeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeGraphNode;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.TypedDependency;
import edu.stanford.nlp.trees.UniversalEnglishGrammaticalStructure;
import edu.stanford.nlp.trees.UniversalSemanticHeadFinder;
import edu.stanford.nlp.trees.ud.EnhancementOptions;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.StringUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;

public abstract class GrammaticalStructure
implements Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(GrammaticalStructure.class);
    private static final boolean PRINT_DEBUGGING = System.getProperty("GrammaticalStructure", null) != null;
    protected final List<TypedDependency> typedDependencies;
    protected final List<TypedDependency> allTypedDependencies;
    protected final Predicate<String> puncFilter;
    protected final Predicate<String> tagFilter;
    private final TreeGraphNode root;
    private final Map<Integer, TreeGraphNode> indexMap = Generics.newHashMap();
    private static final long serialVersionUID = 2286294455343892678L;
    public static final int CoNLLX_WordField = 1;
    public static final int CoNLLX_POSField = 4;
    public static final int CoNLLX_GovField = 6;
    public static final int CoNLLX_RelnField = 7;
    public static final int CoNLLX_FieldCount = 10;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GrammaticalStructure(Tree t, Collection<GrammaticalRelation> relations, Lock relationsLock, TreeTransformer transformer, HeadFinder hf, Predicate<String> puncFilter, Predicate<String> tagFilter) {
        TreeGraphNode treeGraph = new TreeGraphNode(t, (TreeGraphNode)null);
        Trees.setLeafLabels(treeGraph, t.yield());
        Trees.setLeafTagsIfUnset(treeGraph);
        if (transformer != null) {
            Tree transformed = transformer.transformTree(treeGraph);
            if (!(transformed instanceof TreeGraphNode)) {
                throw new RuntimeException("Transformer did not change TreeGraphNode into another TreeGraphNode: " + transformer);
            }
            this.root = (TreeGraphNode)transformed;
        } else {
            this.root = treeGraph;
        }
        this.indexNodes(this.root);
        if (hf == null) {
            throw new AssertionError((Object)"Cannot use null HeadFinder");
        }
        try {
            this.root.percolateHeads(hf);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot process tree:\n" + t, e);
        }
        if (this.root.value() == null) {
            this.root.setValue("ROOT");
        }
        this.puncFilter = puncFilter;
        this.tagFilter = tagFilter;
        NoPunctTypedDependencyFilter puncTypedDepFilter = new NoPunctTypedDependencyFilter(puncFilter, tagFilter);
        DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph = new DirectedMultiGraph<TreeGraphNode, GrammaticalRelation>();
        DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph = new DirectedMultiGraph<TreeGraphNode, GrammaticalRelation>();
        if (relationsLock != null) {
            relationsLock.lock();
        }
        try {
            GrammaticalStructure.analyzeNode(this.root, this.root, relations, hf, puncFilter, tagFilter, basicGraph, completeGraph);
        }
        finally {
            if (relationsLock != null) {
                relationsLock.unlock();
            }
        }
        GrammaticalStructure.attachStrandedNodes(this.root, this.root, false, puncFilter, tagFilter, basicGraph);
        this.typedDependencies = this.getDeps(puncTypedDepFilter, basicGraph);
        this.allTypedDependencies = Generics.newArrayList(this.typedDependencies);
        this.getExtraDeps(this.allTypedDependencies, puncTypedDepFilter, completeGraph);
    }

    private void indexNodes(TreeGraphNode tree) {
        this.indexNodes(tree, this.indexLeaves(tree, 1));
    }

    private int indexLeaves(TreeGraphNode tree, int startIndex) {
        if (tree.isLeaf()) {
            int oldIndex = tree.index();
            if (oldIndex >= 0) {
                startIndex = oldIndex;
            } else {
                tree.setIndex(startIndex);
            }
            this.addNodeToIndexMap(startIndex, tree);
            ++startIndex;
        } else {
            for (TreeGraphNode child : tree.children) {
                startIndex = this.indexLeaves(child, startIndex);
            }
        }
        return startIndex;
    }

    private int indexNodes(TreeGraphNode tree, int startIndex) {
        if (tree.index() < 0) {
            this.addNodeToIndexMap(startIndex, tree);
            tree.setIndex(startIndex++);
        }
        if (!tree.isLeaf()) {
            for (TreeGraphNode child : tree.children) {
                startIndex = this.indexNodes(child, startIndex);
            }
        }
        return startIndex;
    }

    private void addNodeToIndexMap(int index, TreeGraphNode node) {
        this.indexMap.put(index, node);
    }

    private TreeGraphNode getNodeByIndex(int index) {
        return this.indexMap.get(index);
    }

    public TreeGraphNode root() {
        return this.root;
    }

    private static void throwDepFormatException(String dep) {
        throw new RuntimeException(String.format("Dependencies should be for the format 'type(arg-idx, arg-idx)'. Could not parse '%s'", dep));
    }

    public static GrammaticalStructure fromStringReps(List<String> tokens, List<String> posTags, List<String> deps) {
        if (tokens.size() != posTags.size()) {
            throw new RuntimeException(String.format("tokens.size(): %d != pos.size(): %d%n", tokens.size(), posTags.size()));
        }
        ArrayList<TreeGraphNode> tgWordNodes = new ArrayList<TreeGraphNode>(tokens.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokens.size());
        CoreLabel rootLabel = new CoreLabel();
        rootLabel.setValue("ROOT");
        ArrayList<IndexedWord> nodeWords = new ArrayList<IndexedWord>(tgPOSNodes.size() + 1);
        nodeWords.add(new IndexedWord(rootLabel));
        UniversalSemanticHeadFinder headFinder = new UniversalSemanticHeadFinder();
        Iterator<String> posIter = posTags.iterator();
        for (String wordString : tokens) {
            String posString = posIter.next();
            CoreLabel wordLabel = new CoreLabel();
            wordLabel.setWord(wordString);
            wordLabel.setValue(wordString);
            wordLabel.setTag(posString);
            TreeGraphNode word = new TreeGraphNode(wordLabel);
            CoreLabel tagLabel = new CoreLabel();
            tagLabel.setValue(posString);
            tagLabel.setWord(posString);
            TreeGraphNode pos = new TreeGraphNode(tagLabel);
            tgWordNodes.add(word);
            tgPOSNodes.add(pos);
            Tree[] childArr = new TreeGraphNode[]{word};
            pos.setChildren(childArr);
            word.setParent(pos);
            pos.percolateHeads(headFinder);
            nodeWords.add(new IndexedWord(wordLabel));
        }
        TreeGraphNode root = new TreeGraphNode(rootLabel);
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        root.setIndex(0);
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(deps.size());
        for (String depString : deps) {
            int childDash;
            String args;
            int argSep;
            int firstBracket = depString.indexOf(40);
            if (firstBracket == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String type = depString.substring(0, firstBracket);
            if (depString.charAt(depString.length() - 1) != ')') {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((argSep = (args = depString.substring(firstBracket + 1, depString.length() - 1)).indexOf(", ")) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            String parentArg = args.substring(0, argSep);
            String childArg = args.substring(argSep + 2);
            int parentDash = parentArg.lastIndexOf(45);
            if (parentDash == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            if ((childDash = childArg.lastIndexOf(45)) == -1) {
                GrammaticalStructure.throwDepFormatException(depString);
            }
            int parentIdx = Integer.parseInt(parentArg.substring(parentDash + 1).replace("'", ""));
            int childIdx = Integer.parseInt(childArg.substring(childDash + 1).replace("'", ""));
            GrammaticalRelation grel = new GrammaticalRelation(Language.Any, type, null, GrammaticalRelation.DEPENDENT);
            TypedDependency tdep = new TypedDependency(grel, (IndexedWord)nodeWords.get(parentIdx), (IndexedWord)nodeWords.get(childIdx));
            tdeps.add(tdep);
        }
        return new GrammaticalStructure(tdeps, root){
            private static final long serialVersionUID = 1L;
        };
    }

    public GrammaticalStructure(List<TypedDependency> projectiveDependencies, TreeGraphNode root) {
        this.root = root;
        this.indexNodes(this.root);
        this.puncFilter = Filters.acceptFilter();
        this.tagFilter = Filters.acceptFilter();
        this.typedDependencies = new ArrayList<TypedDependency>(projectiveDependencies);
        this.allTypedDependencies = this.typedDependencies;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.root.toPrettyString(0).substring(1));
        sb.append("Typed Dependencies:\n");
        sb.append(this.typedDependencies);
        return sb.toString();
    }

    private static void attachStrandedNodes(TreeGraphNode t, TreeGraphNode root, boolean attach, Predicate<String> puncFilter, Predicate<String> tagFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph) {
        TreeGraphNode parent;
        if (t.isLeaf()) {
            return;
        }
        if (attach && puncFilter.test(t.headWordNode().label().value()) && tagFilter.test(t.headWordNode().label().tag()) && !basicGraph.isEdge(parent = t.parent().highestNodeWithSameHead(), t) && basicGraph.getShortestPath(root, t, false) == null) {
            basicGraph.add(parent, t, GrammaticalRelation.DEPENDENT);
        }
        for (TreeGraphNode kid : t.children()) {
            GrammaticalStructure.attachStrandedNodes(kid, root, kid.headWordNode() != t.headWordNode(), puncFilter, tagFilter, basicGraph);
        }
    }

    private static void analyzeNode(TreeGraphNode t, TreeGraphNode root, Collection<GrammaticalRelation> relations, HeadFinder hf, Predicate<String> puncFilter, Predicate<String> tagFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph) {
        if (t.isPhrasal()) {
            TreeGraphNode tHigh = t.highestNodeWithSameHead();
            for (GrammaticalRelation egr : relations) {
                if (!egr.isApplicable(t)) continue;
                for (TreeGraphNode u : egr.getRelatedNodes(t, root, hf)) {
                    TreeGraphNode uHigh = u.highestNodeWithSameHead();
                    if (uHigh == tHigh || !puncFilter.test(uHigh.headWordNode().label().value()) || !tagFilter.test(uHigh.headWordNode().label().tag())) continue;
                    completeGraph.add(tHigh, uHigh, egr);
                    Set<TreeGraphNode> parents = basicGraph.getParents(uHigh);
                    if (parents != null && parents.size() != 0 && !parents.contains(tHigh) || basicGraph.getShortestPath(uHigh, tHigh, true) != null) continue;
                    basicGraph.add(tHigh, uHigh, egr);
                }
            }
            for (TreeGraphNode kid : t.children()) {
                GrammaticalStructure.analyzeNode(kid, root, relations, hf, puncFilter, tagFilter, basicGraph, completeGraph);
            }
        }
    }

    private void getExtraDeps(List<TypedDependency> deps, Predicate<TypedDependency> puncTypedDepFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph) {
        this.getExtras(deps);
        this.getTreeDeps(deps, completeGraph, puncTypedDepFilter, this.extraTreeDepFilter());
        Collections.sort(deps);
    }

    private List<TypedDependency> getDeps(Predicate<TypedDependency> puncTypedDepFilter, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> basicGraph) {
        List<Tree> leaves;
        ArrayList<TypedDependency> basicDep = Generics.newArrayList();
        for (TreeGraphNode gov : basicGraph.getAllVertices()) {
            for (TreeGraphNode dep : basicGraph.getChildren(gov)) {
                GrammaticalRelation reln = GrammaticalStructure.getGrammaticalRelationCommonAncestor(gov.headWordNode().label(), gov.label(), dep.headWordNode().label(), dep.label(), basicGraph.getEdges(gov, dep));
                basicDep.add(new TypedDependency(reln, new IndexedWord(gov.headWordNode().label()), new IndexedWord(dep.headWordNode().label())));
            }
        }
        TreeGraphNode dependencyRoot = new TreeGraphNode(new Word("ROOT"));
        dependencyRoot.setIndex(0);
        TreeGraphNode rootDep = this.root().headWordNode();
        if (rootDep == null && (leaves = Trees.leaves(this.root())).size() > 0) {
            Tree leaf = leaves.get(0);
            if (!(leaf instanceof TreeGraphNode)) {
                throw new AssertionError((Object)"Leaves should be TreeGraphNodes");
            }
            rootDep = (TreeGraphNode)leaf;
            if (rootDep.headWordNode() != null) {
                rootDep = rootDep.headWordNode();
            }
        }
        if (rootDep != null) {
            TypedDependency rootTypedDep = new TypedDependency(GrammaticalRelation.ROOT, new IndexedWord(dependencyRoot.label()), new IndexedWord(rootDep.label()));
            if (puncTypedDepFilter.test(rootTypedDep)) {
                basicDep.add(rootTypedDep);
            } else {
                IndexedWord root = rootTypedDep.dep();
                IndexedWord newRoot = null;
                Collections.sort(basicDep);
                for (TypedDependency td : basicDep) {
                    if (!td.gov().equals(root)) continue;
                    if (newRoot != null) {
                        td.setGov(newRoot);
                        continue;
                    }
                    td.setGov(td.gov());
                    td.setReln(GrammaticalRelation.ROOT);
                    newRoot = td.dep();
                }
            }
        }
        this.postProcessDependencies(basicDep);
        Collections.sort(basicDep);
        return basicDep;
    }

    protected Predicate<TypedDependency> extraTreeDepFilter() {
        return Filters.acceptFilter();
    }

    protected void postProcessDependencies(List<TypedDependency> basicDep) {
    }

    protected void getExtras(List<TypedDependency> basicDep) {
    }

    protected void getTreeDeps(List<TypedDependency> deps, DirectedMultiGraph<TreeGraphNode, GrammaticalRelation> completeGraph, Predicate<TypedDependency> puncTypedDepFilter, Predicate<TypedDependency> extraTreeDepFilter) {
        for (TreeGraphNode gov : completeGraph.getAllVertices()) {
            for (TreeGraphNode dep : completeGraph.getChildren(gov)) {
                for (GrammaticalRelation rel : GrammaticalStructure.removeGrammaticalRelationAncestors(completeGraph.getEdges(gov, dep))) {
                    TypedDependency newDep = new TypedDependency(rel, new IndexedWord(gov.headWordNode().label()), new IndexedWord(dep.headWordNode().label()));
                    if (deps.contains(newDep) || !puncTypedDepFilter.test(newDep) || !extraTreeDepFilter.test(newDep)) continue;
                    newDep.setExtra();
                    deps.add(newDep);
                }
            }
        }
    }

    public GrammaticalRelation getGrammaticalRelation(int govIndex, int depIndex) {
        TreeGraphNode gov = this.getNodeByIndex(govIndex);
        TreeGraphNode dep = this.getNodeByIndex(depIndex);
        return this.getGrammaticalRelation(new IndexedWord(gov.label()), new IndexedWord(dep.label()));
    }

    public GrammaticalRelation getGrammaticalRelation(IndexedWord gov, IndexedWord dep) {
        ArrayList<GrammaticalRelation> labels = Generics.newArrayList();
        for (TypedDependency dependency : this.typedDependencies(Extras.MAXIMAL)) {
            if (!dependency.gov().equals(gov) || !dependency.dep().equals(dep)) continue;
            labels.add(dependency.reln());
        }
        return GrammaticalStructure.getGrammaticalRelationCommonAncestor(gov, gov, dep, dep, labels);
    }

    private static GrammaticalRelation getGrammaticalRelationCommonAncestor(AbstractCoreLabel gov, AbstractCoreLabel govH, AbstractCoreLabel dep, AbstractCoreLabel depH, List<GrammaticalRelation> labels) {
        List<GrammaticalRelation> sortedLabels;
        GrammaticalRelation reln = GrammaticalRelation.DEPENDENT;
        if (labels.size() <= 1) {
            sortedLabels = labels;
        } else {
            sortedLabels = new ArrayList<GrammaticalRelation>(labels);
            Collections.sort(sortedLabels, new NameComparator());
        }
        for (GrammaticalRelation reln2 : sortedLabels) {
            if (reln.isAncestor(reln2)) {
                reln = reln2;
                continue;
            }
            if (!PRINT_DEBUGGING || reln2.isAncestor(reln)) continue;
            log.info("@@@\t" + reln + "\t" + reln2 + "\t" + (String)govH.get(CoreAnnotations.ValueAnnotation.class) + "\t" + (String)depH.get(CoreAnnotations.ValueAnnotation.class));
        }
        if (PRINT_DEBUGGING && reln.equals(GrammaticalRelation.DEPENDENT)) {
            String topCat = (String)govH.get(CoreAnnotations.ValueAnnotation.class);
            String topTag = gov.tag();
            String topWord = gov.value();
            String botCat = (String)depH.get(CoreAnnotations.ValueAnnotation.class);
            String botTag = dep.tag();
            String botWord = dep.value();
            log.info("### dep\t" + topCat + "\t" + topTag + "\t" + topWord + "\t" + botCat + "\t" + botTag + "\t" + botWord + "\t");
        }
        return reln;
    }

    private static List<GrammaticalRelation> removeGrammaticalRelationAncestors(List<GrammaticalRelation> original) {
        ArrayList<GrammaticalRelation> filtered = Generics.newArrayList();
        for (GrammaticalRelation reln : original) {
            boolean descendantFound = false;
            for (int index = 0; index < filtered.size(); ++index) {
                GrammaticalRelation gr = (GrammaticalRelation)filtered.get(index);
                if (gr.isAncestor(reln)) {
                    filtered.remove(index);
                    --index;
                    continue;
                }
                if (!reln.isAncestor(gr)) continue;
                descendantFound = true;
            }
            if (descendantFound) continue;
            filtered.add(reln);
        }
        return filtered;
    }

    public Collection<TypedDependency> typedDependencies() {
        return this.typedDependencies(Extras.NONE);
    }

    public Collection<TypedDependency> allTypedDependencies() {
        return this.typedDependencies(Extras.MAXIMAL);
    }

    public List<TypedDependency> typedDependencies(Extras includeExtras) {
        List<TypedDependency> source = includeExtras != Extras.NONE ? this.allTypedDependencies : this.typedDependencies;
        ArrayList<TypedDependency> deps = new ArrayList<TypedDependency>(source);
        this.correctDependencies(deps);
        return deps;
    }

    @Deprecated
    public List<TypedDependency> typedDependencies(boolean includeExtras) {
        return this.typedDependencies(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public Collection<TypedDependency> typedDependenciesCollapsed() {
        return this.typedDependenciesCollapsed(Extras.NONE);
    }

    public Collection<TypedDependency> typedDependenciesCollapsedTree() {
        List<TypedDependency> tdl = this.typedDependencies(Extras.NONE);
        this.collapseDependenciesTree(tdl);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCollapsed(Extras includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, false, includeExtras);
        return tdl;
    }

    @Deprecated
    public List<TypedDependency> typedDependenciesCollapsed(boolean includeExtras) {
        return this.typedDependenciesCollapsed(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public List<TypedDependency> typedDependenciesCCprocessed(Extras includeExtras) {
        List<TypedDependency> tdl = this.typedDependencies(includeExtras);
        this.collapseDependencies(tdl, true, includeExtras);
        return tdl;
    }

    @Deprecated
    public List<TypedDependency> typedDependenciesCCprocessed(boolean includeExtras) {
        return this.typedDependenciesCCprocessed(includeExtras ? Extras.MAXIMAL : Extras.NONE);
    }

    public List<TypedDependency> typedDependenciesEnhanced() {
        List<TypedDependency> tdl = this.typedDependencies(Extras.MAXIMAL);
        this.addEnhancements(tdl, UniversalEnglishGrammaticalStructure.ENHANCED_OPTIONS);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesEnhancedPlusPlus() {
        List<TypedDependency> tdl = this.typedDependencies(Extras.MAXIMAL);
        this.addEnhancements(tdl, UniversalEnglishGrammaticalStructure.ENHANCED_PLUS_PLUS_OPTIONS);
        return tdl;
    }

    public List<TypedDependency> typedDependenciesCCprocessed() {
        return this.typedDependenciesCCprocessed(Extras.MAXIMAL);
    }

    protected void collapseDependencies(List<TypedDependency> list, boolean CCprocess, Extras includeExtras) {
    }

    protected void addEnhancements(List<TypedDependency> list, EnhancementOptions options) {
    }

    protected void collapseDependenciesTree(List<TypedDependency> list) {
    }

    protected void correctDependencies(List<TypedDependency> list) {
    }

    public static boolean isConnected(Collection<TypedDependency> list) {
        return GrammaticalStructure.getRoots(list).size() <= 1;
    }

    public static Collection<TypedDependency> getRoots(Collection<TypedDependency> list) {
        ArrayList<TypedDependency> roots = new ArrayList<TypedDependency>();
        Set<IndexedWord> deps = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            deps.add(typedDep.dep());
        }
        Set<IndexedWord> govs = Generics.newHashSet();
        for (TypedDependency typedDep : list) {
            IndexedWord gov = typedDep.gov();
            if (!deps.contains(gov) && !govs.contains(gov)) {
                roots.add(typedDep);
            }
            govs.add(gov);
        }
        return roots;
    }

    public static List<GrammaticalStructure> readCoNLLXGrammaticalStructureCollection(String fileName, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) throws IOException {
        try (BufferedReader r = IOUtils.readerFromString(fileName);){
            LineNumberReader reader = new LineNumberReader(r);
            LinkedList<GrammaticalStructure> gsList = new LinkedList<GrammaticalStructure>();
            ArrayList<List<String>> tokenFields = new ArrayList<List<String>>();
            String inline = reader.readLine();
            while (inline != null) {
                if (!inline.isEmpty()) {
                    List<String> fields = Arrays.asList(inline.split("\t"));
                    if (fields.size() != 10) {
                        throw new RuntimeException(String.format("Error (line %d): 10 fields expected but %d are present", reader.getLineNumber(), fields.size()));
                    }
                    tokenFields.add(fields);
                } else if (!tokenFields.isEmpty()) {
                    gsList.add(GrammaticalStructure.buildCoNLLXGrammaticalStructure(tokenFields, shortNameToGRel, factory));
                    tokenFields = new ArrayList();
                }
                inline = reader.readLine();
            }
            LinkedList<GrammaticalStructure> linkedList = gsList;
            return linkedList;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GrammaticalStructure buildCoNLLXGrammaticalStructure(List<List<String>> tokenFields, Map<String, GrammaticalRelation> shortNameToGRel, GrammaticalStructureFromDependenciesFactory factory) {
        ArrayList<IndexedWord> tgWords = new ArrayList<IndexedWord>(tokenFields.size());
        ArrayList<TreeGraphNode> tgPOSNodes = new ArrayList<TreeGraphNode>(tokenFields.size());
        SemanticHeadFinder headFinder = new SemanticHeadFinder();
        for (List<String> fields : tokenFields) {
            CoreLabel word = new CoreLabel();
            word.setValue(fields.get(1));
            word.setWord(fields.get(1));
            word.setTag(fields.get(4));
            word.setIndex(tgWords.size() + 1);
            CoreLabel pos = new CoreLabel();
            pos.setTag(fields.get(4));
            pos.setValue(fields.get(4));
            TreeGraphNode wordNode = new TreeGraphNode(word);
            TreeGraphNode posNode = new TreeGraphNode(pos);
            tgWords.add(new IndexedWord(word));
            tgPOSNodes.add(posNode);
            Tree[] childArr = new TreeGraphNode[]{wordNode};
            posNode.setChildren(childArr);
            wordNode.setParent(posNode);
            posNode.percolateHeads(headFinder);
        }
        TreeGraphNode root = new TreeGraphNode(new Word("ROOT-" + (tgPOSNodes.size() + 1)));
        root.setChildren(tgPOSNodes.toArray(new TreeGraphNode[tgPOSNodes.size()]));
        ArrayList<TypedDependency> tdeps = new ArrayList<TypedDependency>(tgWords.size());
        CoreLabel rootLabel = new CoreLabel();
        rootLabel.setValue("ROOT");
        rootLabel.setWord("ROOT");
        rootLabel.setIndex(0);
        IndexedWord dependencyRoot = new IndexedWord(rootLabel);
        for (int i = 0; i < tgWords.size(); ++i) {
            TypedDependency tdep;
            String grelString;
            String parentIdStr = tokenFields.get(i).get(6);
            if (StringUtils.isNullOrEmpty(parentIdStr) || (grelString = tokenFields.get(i).get(7)).equals("null") || grelString.equals("erased")) continue;
            GrammaticalRelation grel = shortNameToGRel.get(grelString.toLowerCase());
            if (grel == null) {
                if (!grelString.toLowerCase().equals("root")) throw new RuntimeException("Unknown grammatical relation '" + grelString + "' fields: " + tokenFields.get(i) + "\nNode: " + tgWords.get(i) + '\n' + "Known Grammatical relations: [" + shortNameToGRel.keySet() + ']');
                tdep = new TypedDependency(GrammaticalRelation.ROOT, dependencyRoot, (IndexedWord)tgWords.get(i));
            } else {
                int parentId = Integer.parseInt(parentIdStr) - 1;
                if (parentId >= tgWords.size()) {
                    System.err.printf("Warning: Invalid Parent Id %d Sentence Length: %d%n", parentId + 1, tgWords.size());
                    System.err.printf("         Assigning to root (0)%n", new Object[0]);
                    parentId = -1;
                }
                tdep = new TypedDependency(grel, parentId == -1 ? dependencyRoot : (IndexedWord)tgWords.get(parentId), (IndexedWord)tgWords.get(i));
            }
            tdeps.add(tdep);
        }
        return factory.build(tdeps, root);
    }

    public static void main(String[] args) {
        GrammaticalStructureConversionUtils.convertTrees(args, "en");
    }

    private static class NameComparator<X>
    implements Comparator<X> {
        private NameComparator() {
        }

        @Override
        public int compare(X o1, X o2) {
            String n1 = o1.toString();
            String n2 = o2.toString();
            return n1.compareTo(n2);
        }
    }

    private static class NoPunctTypedDependencyFilter
    implements Predicate<TypedDependency>,
    Serializable {
        private Predicate<String> npf;
        private Predicate<String> tf;
        private static final long serialVersionUID = -2872766864289207468L;

        NoPunctTypedDependencyFilter(Predicate<String> f, Predicate<String> tf) {
            this.npf = f;
            this.tf = tf;
        }

        @Override
        public boolean test(TypedDependency d) {
            if (d == null) {
                return false;
            }
            IndexedWord l = d.dep();
            if (l == null) {
                return false;
            }
            return this.npf.test(l.value()) && this.tf.test(l.tag());
        }
    }

    private static class NoPunctFilter
    implements Predicate<Dependency<Label, Label, Object>>,
    Serializable {
        private Predicate<String> npf;
        private static final long serialVersionUID = -2319891944796663180L;

        NoPunctFilter(Predicate<String> f) {
            this.npf = f;
        }

        @Override
        public boolean test(Dependency<Label, Label, Object> d) {
            if (d == null) {
                return false;
            }
            Label lab = d.dependent();
            if (lab == null) {
                return false;
            }
            return this.npf.test(lab.value());
        }
    }

    public static enum Extras {
        NONE(false, false, false),
        REF_ONLY_UNCOLLAPSED(true, false, false),
        REF_ONLY_COLLAPSED(true, false, true),
        SUBJ_ONLY(false, true, false),
        REF_UNCOLLAPSED_AND_SUBJ(true, true, false),
        REF_COLLAPSED_AND_SUBJ(true, true, true),
        MAXIMAL(true, true, true);

        public final boolean doRef;
        public final boolean doSubj;
        public final boolean collapseRef;

        private Extras(boolean doRef, boolean doSubj, boolean collapseRef) {
            this.doRef = doRef;
            this.doSubj = doSubj;
            this.collapseRef = collapseRef;
        }
    }
}

