/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.IndexedWord;
import edu.stanford.nlp.pipeline.CoreNLPProtos;
import edu.stanford.nlp.pipeline.ProtobufAnnotationSerializer;
import edu.stanford.nlp.semgraph.SemanticGraph;
import edu.stanford.nlp.semgraph.SemanticGraphFactory;
import edu.stanford.nlp.trees.GrammaticalStructure;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.ProcessProtobufRequest;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;

public class ProcessDependencyConverterRequest
extends ProcessProtobufRequest {
    static SemanticGraph convert(Tree tree) {
        SemanticGraph uncollapsedDeps = SemanticGraphFactory.makeFromTree(tree, SemanticGraphFactory.Mode.BASIC, GrammaticalStructure.Extras.NONE, null, false, true);
        return uncollapsedDeps;
    }

    static CoreNLPProtos.DependencyConverterResponse processRequest(CoreNLPProtos.DependencyConverterRequest request) {
        ProtobufAnnotationSerializer serializer = new ProtobufAnnotationSerializer();
        CoreNLPProtos.DependencyConverterResponse.Builder responseBuilder = CoreNLPProtos.DependencyConverterResponse.newBuilder();
        List<CoreNLPProtos.FlattenedParseTree> flattenedTrees = request.getTreesList();
        int treeIdx = 0;
        for (CoreNLPProtos.FlattenedParseTree flattenedTree : flattenedTrees) {
            Tree tree = ProtobufAnnotationSerializer.fromProto(flattenedTree);
            SemanticGraph graph = ProcessDependencyConverterRequest.convert(tree);
            for (IndexedWord node : graph.vertexSet()) {
                node.set(CoreAnnotations.SentenceIndexAnnotation.class, treeIdx);
            }
            CoreNLPProtos.DependencyConverterResponse.DependencyConversion.Builder conversionBuilder = CoreNLPProtos.DependencyConverterResponse.DependencyConversion.newBuilder();
            conversionBuilder.setGraph(serializer.toProto(graph));
            conversionBuilder.setTree(flattenedTree);
            responseBuilder.addConversions(conversionBuilder.build());
            ++treeIdx;
        }
        return responseBuilder.build();
    }

    @Override
    public void processInputStream(InputStream in, OutputStream out2) throws IOException {
        CoreNLPProtos.DependencyConverterRequest request = CoreNLPProtos.DependencyConverterRequest.parseFrom(in);
        CoreNLPProtos.DependencyConverterResponse response = ProcessDependencyConverterRequest.processRequest(request);
        response.writeTo(out2);
    }

    public static void main(String[] args) throws IOException {
        ProcessProtobufRequest.process(new ProcessDependencyConverterRequest(), args);
    }
}

