/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.LabeledScoredTreeFactory;
import edu.stanford.nlp.trees.MemoryTreebank;
import edu.stanford.nlp.trees.PennTreeReader;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import edu.stanford.nlp.util.StringUtils;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.AbstractCollection;
import java.util.Properties;

public class QPTreeTransformer
implements TreeTransformer {
    private boolean universalDependencies;
    private static final TregexPattern flattenNPoverQPTregex = TregexPattern.compile("NP < (QP=left $+ (QP=right < CC))");
    private static final TsurgeonPattern flattenNPoverQPTsurgeon = Tsurgeon.parseOperation("[createSubtree QP left right] [excise left left] [excise right right]");
    private static final TregexPattern multiwordXSLTregex = TregexPattern.compile("QP < ( RB|IN|RP=left < /^(?i:up)$/ $+ ( IN|TO=right < /^(?i:to)$/ ))");
    private static final TsurgeonPattern multiwordXSLTsurgeon = Tsurgeon.parseOperation("createSubtree XSL left right");
    private static final TregexPattern multiwordXSTregex = TregexPattern.compile("QP <1 /^RB|JJ|IN/=left [ ( <2 /^JJ|IN/=right <3 /^CD|DT/ ) | ( <2 /^JJ|IN/ <3 ( IN=right < /^(?i:as|than)$/ ) <4 /^CD|DT/ ) ] ");
    private static final TsurgeonPattern multiwordXSTsurgeon = Tsurgeon.parseOperation("createSubtree XS left right");
    private static final TregexPattern splitCCTregex = TregexPattern.compile("QP < (CC $- __=r1 $+ __=l2 ?$-- /^[$]|CC$/=lnum ?$++ /^[$]|CC$/=rnum) <1 __=l1 <- __=r2 !< (__ < (__ < __))");
    private static final TsurgeonPattern splitCCTsurgeon = Tsurgeon.parseOperation("[if exists lnum createSubtree QP l1 r1] [if not exists lnum createSubtree NP l1 r1] [if exists rnum createSubtree QP l2 r2] [if not exists rnum createSubtree NP l2 r2]");
    private static final TregexPattern splitMoneyTregex = TregexPattern.compile("QP < (/^[$]$/ !$++ /^(?!([$]|CD)).*$/ !$++ (__ < (__ < __)) $+ __=left) <- __=right");
    private static final TsurgeonPattern splitMoneyTsurgeon = Tsurgeon.parseOperation("createSubtree QP left right");

    public QPTreeTransformer() {
        this(false);
    }

    public QPTreeTransformer(boolean universalDependencies) {
        this.universalDependencies = universalDependencies;
    }

    @Override
    public Tree transformTree(Tree t) {
        return this.QPtransform(t);
    }

    public Tree QPtransform(Tree t) {
        t = Tsurgeon.processPattern(flattenNPoverQPTregex, flattenNPoverQPTsurgeon, t);
        if (!this.universalDependencies) {
            t = Tsurgeon.processPattern(multiwordXSLTregex, multiwordXSLTsurgeon, t);
            t = Tsurgeon.processPattern(multiwordXSTregex, multiwordXSTsurgeon, t);
        }
        t = Tsurgeon.processPattern(splitCCTregex, splitCCTsurgeon, t);
        t = Tsurgeon.processPattern(splitMoneyTregex, splitMoneyTsurgeon, t);
        return t;
    }

    public static void main(String[] args) {
        QPTreeTransformer transformer = new QPTreeTransformer();
        MemoryTreebank tb = new MemoryTreebank();
        Properties props = StringUtils.argsToProperties(args);
        String treeFileName = props.getProperty("treeFile");
        if (treeFileName != null) {
            try {
                Tree t;
                PennTreeReader tr = new PennTreeReader(new BufferedReader(new InputStreamReader(new FileInputStream(treeFileName))), new LabeledScoredTreeFactory());
                while ((t = tr.readTree()) != null) {
                    ((AbstractCollection)tb).add(t);
                }
            }
            catch (IOException e) {
                throw new RuntimeException("File problem: " + e);
            }
        }
        for (Tree t : tb) {
            System.out.println("Original tree");
            t.pennPrint();
            System.out.println();
            System.out.println("Tree transformed");
            Tree tree = transformer.transformTree(t);
            tree.pennPrint();
            System.out.println();
            System.out.println("----------------------------");
        }
    }
}

