/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.ling.CoreAnnotations;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.ling.HasIndex;
import edu.stanford.nlp.ling.HasTag;
import edu.stanford.nlp.ling.HasWord;
import edu.stanford.nlp.ling.Label;
import edu.stanford.nlp.ling.LabelFactory;
import edu.stanford.nlp.ling.LabeledWord;
import edu.stanford.nlp.ling.SentenceUtils;
import edu.stanford.nlp.ling.TaggedWord;
import edu.stanford.nlp.ling.Word;
import edu.stanford.nlp.trees.Constituent;
import edu.stanford.nlp.trees.ConstituentFactory;
import edu.stanford.nlp.trees.Dependency;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Labeled;
import edu.stanford.nlp.trees.LabeledScoredTreeReaderFactory;
import edu.stanford.nlp.trees.NamedDependency;
import edu.stanford.nlp.trees.SimpleConstituentFactory;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.trees.TreeFactory;
import edu.stanford.nlp.trees.TreeReaderFactory;
import edu.stanford.nlp.trees.TreeTransformer;
import edu.stanford.nlp.trees.UnnamedConcreteDependency;
import edu.stanford.nlp.trees.UnnamedDependency;
import edu.stanford.nlp.util.CoreMap;
import edu.stanford.nlp.util.Filters;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.IntPair;
import edu.stanford.nlp.util.MutableInteger;
import edu.stanford.nlp.util.Pair;
import edu.stanford.nlp.util.Scored;
import edu.stanford.nlp.util.XMLUtils;
import edu.stanford.nlp.util.logging.Redwood;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public abstract class Tree
extends AbstractCollection<Tree>
implements Label,
Labeled,
Scored,
Serializable {
    private static final Redwood.RedwoodChannels log = Redwood.channels(Tree.class);
    private static final long serialVersionUID = 5441849457648722744L;
    public static final Tree[] EMPTY_TREE_ARRAY = new Tree[0];
    private static final int initialPrintStringBuilderSize = 500;
    private static final Pattern LRB_PATTERN = Pattern.compile("[(]");
    private static final Pattern RRB_PATTERN = Pattern.compile("[)]");
    private static final int indentIncr = 2;

    public boolean isLeaf() {
        return this.numChildren() == 0;
    }

    public int numChildren() {
        return this.children().length;
    }

    public boolean isUnaryRewrite() {
        return this.numChildren() == 1;
    }

    public boolean isPreTerminal() {
        Tree[] kids = this.children();
        return kids.length == 1 && kids[0].isLeaf();
    }

    public boolean isPrePreTerminal() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return false;
        }
        for (Tree kid : kids) {
            if (kid.isPreTerminal()) continue;
            return false;
        }
        return true;
    }

    public boolean isPhrasal() {
        Tree[] kids = this.children();
        return kids != null && kids.length != 0 && (kids.length != 1 || !kids[0].isLeaf());
    }

    public boolean isBinary() {
        if (this.isLeaf() || this.isPreTerminal()) {
            return true;
        }
        Tree[] kids = this.children();
        if (kids.length != 2) {
            return false;
        }
        return kids[0].isBinary() && kids[1].isBinary();
    }

    public boolean isBinarized() {
        if (this.isLeaf() || this.isPreTerminal()) {
            return true;
        }
        Tree[] kids = this.children();
        if (kids.length > 2) {
            return false;
        }
        if (!kids[0].isBinarized()) {
            return false;
        }
        return kids.length != 2 || kids[1].isBinarized();
    }

    @Override
    public boolean equals(Object o) {
        Tree[] theirKids;
        if (o == this) {
            return true;
        }
        if (!(o instanceof Tree)) {
            return false;
        }
        Tree t = (Tree)o;
        String value1 = this.value();
        String value2 = t.value();
        if (!(value1 == null && value2 == null || value1 != null && value1.equals(value2))) {
            return false;
        }
        Tree[] myKids = this.children();
        if (myKids.length != (theirKids = t.children()).length) {
            return false;
        }
        for (int i = 0; i < myKids.length; ++i) {
            if (myKids[i].equals(theirKids[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        String v = this.value();
        int hc = v == null ? 1 : v.hashCode();
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            v = kids[i].value();
            int hc2 = v == null ? i : v.hashCode();
            hc ^= hc2 << i;
        }
        return hc;
    }

    public int objectIndexOf(Tree tree) {
        Tree[] kids = this.children();
        for (int i = 0; i < kids.length; ++i) {
            if (kids[i] != tree) continue;
            return i;
        }
        return -1;
    }

    public abstract Tree[] children();

    public List<Tree> getChildrenAsList() {
        return new ArrayList<Tree>(Arrays.asList(this.children()));
    }

    public void setChildren(Tree[] children) {
        throw new UnsupportedOperationException();
    }

    public void setChildren(List<? extends Tree> childTreesList) {
        if (childTreesList == null || childTreesList.isEmpty()) {
            this.setChildren(EMPTY_TREE_ARRAY);
        } else {
            Tree[] childTrees = new Tree[childTreesList.size()];
            childTreesList.toArray(childTrees);
            this.setChildren(childTrees);
        }
    }

    @Override
    public Label label() {
        return null;
    }

    @Override
    public void setLabel(Label label) {
    }

    @Override
    public double score() {
        return Double.NaN;
    }

    public void setScore(double score) {
        throw new UnsupportedOperationException("You must use a tree type that implements scoring in order call setScore()");
    }

    public Tree firstChild() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return null;
        }
        return kids[0];
    }

    public Tree lastChild() {
        Tree[] kids = this.children();
        if (kids.length == 0) {
            return null;
        }
        return kids[kids.length - 1];
    }

    public Tree upperMostUnary(Tree root) {
        Tree parent = this.parent(root);
        if (parent == null) {
            return this;
        }
        if (parent.numChildren() > 1) {
            return this;
        }
        return parent.upperMostUnary(root);
    }

    public void setSpans() {
        this.constituentsNodes(0);
    }

    public IntPair getSpan() {
        if (this.label() instanceof CoreMap && ((CoreMap)((Object)this.label())).containsKey(CoreAnnotations.SpanAnnotation.class)) {
            return (IntPair)((CoreMap)((Object)this.label())).get(CoreAnnotations.SpanAnnotation.class);
        }
        return null;
    }

    public Set<Constituent> constituents() {
        return this.constituents(new SimpleConstituentFactory());
    }

    public Set<Constituent> constituents(ConstituentFactory cf) {
        return this.constituents(cf, false);
    }

    public Set<Constituent> constituents(ConstituentFactory cf, int maxDepth) {
        Set<Constituent> constituentsSet = Generics.newHashSet();
        this.constituents(constituentsSet, 0, cf, false, null, maxDepth, 0);
        return constituentsSet;
    }

    public Set<Constituent> constituents(ConstituentFactory cf, boolean charLevel) {
        Set<Constituent> constituentsSet = Generics.newHashSet();
        this.constituents(constituentsSet, 0, cf, charLevel, null, -1, 0);
        return constituentsSet;
    }

    public Set<Constituent> constituents(ConstituentFactory cf, boolean charLevel, Predicate<Tree> filter) {
        Set<Constituent> constituentsSet = Generics.newHashSet();
        this.constituents(constituentsSet, 0, cf, charLevel, filter, -1, 0);
        return constituentsSet;
    }

    private int constituentsNodes(int left) {
        Tree[] kids;
        if (this.isLeaf()) {
            if (!(this.label() instanceof CoreLabel)) {
                throw new UnsupportedOperationException("Can only set spans on trees which use CoreLabel");
            }
            ((CoreLabel)this.label()).set(CoreAnnotations.SpanAnnotation.class, new IntPair(left, left));
            return left + 1;
        }
        int position = left;
        for (Tree kid : kids = this.children()) {
            position = kid.constituentsNodes(position);
        }
        if (!(this.label() instanceof CoreLabel)) {
            throw new UnsupportedOperationException("Can only set spans on trees which use CoreLabel");
        }
        ((CoreLabel)this.label()).set(CoreAnnotations.SpanAnnotation.class, new IntPair(left, position - 1));
        return position;
    }

    private int constituents(Set<Constituent> constituentsSet, int left, ConstituentFactory cf, boolean charLevel, Predicate<Tree> filter, int maxDepth, int depth) {
        Tree[] kids;
        if (this.isPreTerminal()) {
            return left + (charLevel ? this.firstChild().value().length() : 1);
        }
        int position = left;
        for (Tree kid : kids = this.children()) {
            position = kid.constituents(constituentsSet, position, cf, charLevel, filter, maxDepth, depth + 1);
        }
        if (!(filter != null && !filter.test(this) || maxDepth >= 0 && depth > maxDepth)) {
            constituentsSet.add(cf.newConstituent(left, position - 1, this.label(), this.score()));
        }
        return position;
    }

    public Tree localTree() {
        Tree[] kids = this.children();
        Tree[] newKids = new Tree[kids.length];
        TreeFactory tf = this.treeFactory();
        int n = kids.length;
        for (int i = 0; i < n; ++i) {
            newKids[i] = tf.newTreeNode(kids[i].label(), Arrays.asList(EMPTY_TREE_ARRAY));
        }
        return tf.newTreeNode(this.label(), Arrays.asList(newKids));
    }

    public Set<Tree> localTrees() {
        Set<Tree> set = Generics.newHashSet();
        for (Tree st : this) {
            if (!st.isPhrasal()) continue;
            set.add(st.localTree());
        }
        return set;
    }

    public StringBuilder toStringBuilder(StringBuilder sb) {
        return this.toStringBuilder(sb, label -> label.value() == null ? "" : label.value());
    }

    public static String updateBrackets(String text) {
        if (text == null) {
            return null;
        }
        text = LRB_PATTERN.matcher(text).replaceAll("-LRB-");
        text = RRB_PATTERN.matcher(text).replaceAll("-RRB-");
        return text;
    }

    public StringBuilder toStringBuilder(StringBuilder sb, Function<Label, String> labelFormatter) {
        Tree[] kids;
        if (this.isLeaf()) {
            if (this.label() != null) {
                String text = labelFormatter.apply(this.label());
                sb.append(Tree.updateBrackets(text));
            }
            return sb;
        }
        sb.append('(');
        if (this.label() != null) {
            String text = labelFormatter.apply(this.label());
            sb.append(text);
        }
        if ((kids = this.children()) != null) {
            for (Tree kid : kids) {
                sb.append(' ');
                kid.toStringBuilder(sb, labelFormatter);
            }
        }
        return sb.append(')');
    }

    @Override
    public String toString() {
        return this.toStringBuilder(new StringBuilder(500)).toString();
    }

    private static String makeIndentString(int indent) {
        StringBuilder sb = new StringBuilder(indent);
        for (int i = 0; i < 2; ++i) {
            sb.append(' ');
        }
        return sb.toString();
    }

    public void printLocalTree() {
        this.printLocalTree(new PrintWriter(System.out, true));
    }

    public void printLocalTree(PrintWriter pw) {
        pw.print("(" + this.label() + ' ');
        for (Tree kid : this.children()) {
            pw.print("(");
            pw.print(kid.label());
            pw.print(") ");
        }
        pw.println(")");
    }

    public void indentedListPrint() {
        this.indentedListPrint(new PrintWriter(System.out, true), false);
    }

    public void indentedListPrint(PrintWriter pw, boolean printScores) {
        this.indentedListPrint("", Tree.makeIndentString(2), pw, printScores);
    }

    private void indentedListPrint(String indent, String pad, PrintWriter pw, boolean printScores) {
        StringBuilder sb = new StringBuilder(indent);
        Label label = this.label();
        if (label != null) {
            sb.append(label);
        }
        if (printScores) {
            sb.append("  ");
            sb.append(this.score());
        }
        pw.println(sb);
        Tree[] children = this.children();
        String newIndent = indent + pad;
        for (Tree child : children) {
            child.indentedListPrint(newIndent, pad, pw, printScores);
        }
    }

    public void indentedXMLPrint() {
        this.indentedXMLPrint(new PrintWriter(System.out, true), false);
    }

    public void indentedXMLPrint(PrintWriter pw, boolean printScores) {
        this.indentedXMLPrint("", Tree.makeIndentString(2), pw, printScores);
    }

    private void indentedXMLPrint(String indent, String pad, PrintWriter pw, boolean printScores) {
        StringBuilder sb = new StringBuilder(indent);
        Tree[] children = this.children();
        Label label = this.label();
        if (label != null) {
            sb.append('<');
            if (children.length > 0) {
                sb.append("node value=\"");
            } else {
                sb.append("leaf value=\"");
            }
            sb.append(XMLUtils.escapeXML(SentenceUtils.wordToString(label, true)));
            sb.append('\"');
            if (printScores) {
                sb.append(" score=");
                sb.append(this.score());
            }
            if (children.length > 0) {
                sb.append('>');
            } else {
                sb.append("/>");
            }
        } else if (children.length > 0) {
            sb.append("<node>");
        } else {
            sb.append("<leaf/>");
        }
        pw.println(sb);
        if (children.length > 0) {
            String newIndent = indent + pad;
            for (Tree child : children) {
                child.indentedXMLPrint(newIndent, pad, pw, printScores);
            }
            pw.println(indent + "</node>");
        }
    }

    private static void displayChildren(Tree[] trChildren, int indent, boolean parentLabelNull, Function<Label, String> labelFormatter, PrintWriter pw) {
        boolean firstSibling = true;
        boolean leftSibIsPreTerm = true;
        for (Tree currentTree : trChildren) {
            currentTree.display(indent, parentLabelNull, firstSibling, leftSibIsPreTerm, false, labelFormatter, pw);
            leftSibIsPreTerm = currentTree.isPreTerminal();
            if (currentTree.value() != null && currentTree.value().startsWith("CC")) {
                leftSibIsPreTerm = false;
            }
            firstSibling = false;
        }
    }

    public String nodeString() {
        return this.value() == null ? "" : this.value();
    }

    private void display(int indent, boolean parentLabelNull, boolean firstSibling, boolean leftSiblingPreTerminal, boolean topLevel, Function<Label, String> labelFormatter, PrintWriter pw) {
        boolean suppressIndent;
        boolean bl = suppressIndent = parentLabelNull && firstSibling || firstSibling && this.isPreTerminal() || leftSiblingPreTerminal && this.isPreTerminal() && (this.label() == null || !this.label().value().startsWith("CC"));
        if (suppressIndent) {
            pw.print(" ");
        } else {
            if (!topLevel) {
                pw.println();
            }
            for (int i = 0; i < indent; ++i) {
                pw.print("  ");
            }
        }
        if (this.isLeaf() || this.isPreTerminal()) {
            String terminalString = this.toStringBuilder(new StringBuilder(), labelFormatter).toString();
            pw.print(terminalString);
            pw.flush();
            return;
        }
        pw.print("(");
        pw.print(labelFormatter.apply(this.label()));
        boolean parentIsNull = this.label() == null || this.label().value() == null;
        Tree.displayChildren(this.children(), indent + 1, parentIsNull, labelFormatter, pw);
        pw.print(")");
        pw.flush();
    }

    public void pennPrint(PrintWriter pw) {
        this.pennPrint(pw, (Label label) -> label.value() == null ? "" : label.value());
    }

    public void pennPrint(PrintWriter pw, Function<Label, String> labelFormatter) {
        this.display(0, false, false, false, true, labelFormatter, pw);
        pw.println();
        pw.flush();
    }

    public void pennPrint(PrintStream ps) {
        this.pennPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true));
    }

    public void pennPrint(PrintStream ps, Function<Label, String> labelFormatter) {
        this.pennPrint(new PrintWriter((Writer)new OutputStreamWriter(ps), true), labelFormatter);
    }

    public String pennString() {
        StringWriter sw = new StringWriter();
        this.pennPrint(new PrintWriter(sw));
        return sw.toString();
    }

    public String spanString() {
        List leaves = this.getLeaves();
        if (!(((Tree)leaves.get(0)).label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Expected leaves to be CoreLabels");
        }
        if (((CoreLabel)((Tree)leaves.get(0)).label()).word() == null) {
            throw new IllegalArgumentException("Expected CoreLabel's to have text");
        }
        if (((CoreLabel)((Tree)leaves.get(0)).label()).after() == null) {
            throw new IllegalArgumentException("Expected CoreLabel's to have after() text");
        }
        List coreLabels = this.getLeaves().stream().map(l -> (CoreLabel)l.label()).collect(Collectors.toList());
        String spanString = coreLabels.subList(0, Math.max(0, coreLabels.size() - 1)).stream().map(cl -> cl.word() + cl.after()).collect(Collectors.joining(""));
        spanString = spanString + ((CoreLabel)coreLabels.get(coreLabels.size() - 1)).word();
        return spanString;
    }

    public void pennPrint() {
        this.pennPrint(System.out);
    }

    public int depth() {
        Tree[] kids;
        if (this.isLeaf()) {
            return 0;
        }
        int maxDepth = 0;
        for (Tree kid : kids = this.children()) {
            int curDepth = kid.depth();
            if (curDepth <= maxDepth) continue;
            maxDepth = curDepth;
        }
        return maxDepth + 1;
    }

    public int depth(Tree node) {
        Tree p = node.parent(this);
        if (this == node) {
            return 0;
        }
        if (p == null) {
            return -1;
        }
        int depth = 1;
        while (this != p) {
            p = p.parent(this);
            ++depth;
        }
        return depth;
    }

    public Tree headTerminal(HeadFinder hf, Tree parent) {
        if (this.isLeaf()) {
            return this;
        }
        Tree head = hf.determineHead(this, parent);
        if (head != null) {
            return head.headTerminal(hf, parent);
        }
        log.info("Head is null: " + this);
        return null;
    }

    public Tree headTerminal(HeadFinder hf) {
        return this.headTerminal(hf, null);
    }

    public Tree headPreTerminal(HeadFinder hf) {
        if (this.isPreTerminal()) {
            return this;
        }
        if (this.isLeaf()) {
            throw new IllegalArgumentException("Called headPreTerminal on a leaf: " + this);
        }
        Tree head = hf.determineHead(this);
        if (head != null) {
            return head.headPreTerminal(hf);
        }
        log.info("Head preterminal is null: " + this);
        return null;
    }

    public void percolateHeadAnnotations(HeadFinder hf) {
        if (!(this.label() instanceof CoreLabel)) {
            throw new IllegalArgumentException("Expected CoreLabels in the trees");
        }
        CoreLabel nodeLabel = (CoreLabel)this.label();
        if (this.isLeaf()) {
            return;
        }
        if (this.isPreTerminal()) {
            nodeLabel.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, (CoreLabel)this.children()[0].label());
            nodeLabel.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, nodeLabel);
            return;
        }
        for (Tree kid : this.children()) {
            kid.percolateHeadAnnotations(hf);
        }
        Tree head = hf.determineHead(this);
        if (head == null) {
            throw new NullPointerException("HeadFinder " + hf + " returned null for " + this);
        }
        if (head.isLeaf()) {
            nodeLabel.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, (CoreLabel)head.label());
            nodeLabel.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, (CoreLabel)head.parent(this).label());
        } else if (head.isPreTerminal()) {
            nodeLabel.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, (CoreLabel)head.children()[0].label());
            nodeLabel.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, (CoreLabel)head.label());
        } else {
            if (!(head.label() instanceof CoreLabel)) {
                throw new AssertionError((Object)"Horrible bug");
            }
            CoreLabel headLabel = (CoreLabel)head.label();
            nodeLabel.set(TreeCoreAnnotations.HeadWordLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadWordLabelAnnotation.class));
            nodeLabel.set(TreeCoreAnnotations.HeadTagLabelAnnotation.class, headLabel.get(TreeCoreAnnotations.HeadTagLabelAnnotation.class));
        }
    }

    public void percolateHeads(HeadFinder hf) {
        Label nodeLabel = this.label();
        if (this.isLeaf()) {
            HasWord w;
            if (nodeLabel instanceof HasWord && (w = (HasWord)((Object)nodeLabel)).word() == null) {
                w.setWord(nodeLabel.value());
            }
        } else {
            for (Tree kid : this.children()) {
                kid.percolateHeads(hf);
            }
            Tree head = hf.determineHead(this);
            if (head != null) {
                int headIndex;
                String headWord;
                String headTag;
                Label headLabel = head.label();
                String string = headTag = headLabel instanceof HasTag ? ((HasTag)((Object)headLabel)).tag() : null;
                if (headTag == null && head.isLeaf()) {
                    headTag = nodeLabel.value();
                }
                String string2 = headWord = headLabel instanceof HasWord ? ((HasWord)((Object)headLabel)).word() : null;
                if (headWord == null && head.isLeaf()) {
                    headWord = headLabel.value();
                }
                int n = headIndex = headLabel instanceof HasIndex ? ((HasIndex)((Object)headLabel)).index() : -1;
                if (nodeLabel instanceof HasWord) {
                    ((HasWord)((Object)nodeLabel)).setWord(headWord);
                }
                if (nodeLabel instanceof HasTag) {
                    ((HasTag)((Object)nodeLabel)).setTag(headTag);
                }
                if (nodeLabel instanceof HasIndex && headIndex >= 0) {
                    ((HasIndex)((Object)nodeLabel)).setIndex(headIndex);
                }
            } else {
                log.info("Head is null: " + this);
            }
        }
    }

    public Set<Dependency<Label, Label, Object>> dependencies() {
        return this.dependencies(Filters.acceptFilter());
    }

    public Set<Dependency<Label, Label, Object>> dependencies(Predicate<Dependency<Label, Label, Object>> f) {
        return this.dependencies(f, true, true, false);
    }

    private static Label makeDependencyLabel(Label oldLabel, boolean copyLabel, boolean copyIndex, boolean copyPosTag) {
        if (!copyLabel) {
            return oldLabel;
        }
        String wordForm = oldLabel instanceof HasWord ? ((HasWord)((Object)oldLabel)).word() : oldLabel.value();
        Label newLabel = oldLabel.labelFactory().newLabel(wordForm);
        if (newLabel instanceof HasWord) {
            ((HasWord)((Object)newLabel)).setWord(wordForm);
        }
        if (copyPosTag && newLabel instanceof HasTag && oldLabel instanceof HasTag) {
            String tag = ((HasTag)((Object)oldLabel)).tag();
            ((HasTag)((Object)newLabel)).setTag(tag);
        }
        if (copyIndex && newLabel instanceof HasIndex && oldLabel instanceof HasIndex) {
            int index = ((HasIndex)((Object)oldLabel)).index();
            ((HasIndex)((Object)newLabel)).setIndex(index);
        }
        return newLabel;
    }

    public Set<Dependency<Label, Label, Object>> dependencies(Predicate<Dependency<Label, Label, Object>> f, boolean isConcrete, boolean copyLabel, boolean copyPosTag) {
        Set<Dependency<Label, Label, Object>> deps = Generics.newHashSet();
        for (Tree node : this) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Label headLabel = Tree.makeDependencyLabel(node.label(), copyLabel, isConcrete, copyPosTag);
            String headWord = ((HasWord)((Object)headLabel)).word();
            if (headWord == null) {
                headWord = headLabel.value();
            }
            int headIndex = isConcrete && headLabel instanceof HasIndex ? ((HasIndex)((Object)headLabel)).index() : -1;
            boolean seenHead = false;
            for (Tree child : node.children()) {
                UnnamedDependency dependency;
                int depIndex;
                Label depLabel = Tree.makeDependencyLabel(child.label(), copyLabel, isConcrete, copyPosTag);
                String depWord = ((HasWord)((Object)depLabel)).word();
                if (depWord == null) {
                    depWord = depLabel.value();
                }
                int n = depIndex = isConcrete && depLabel instanceof HasIndex ? ((HasIndex)((Object)depLabel)).index() : -1;
                if (!seenHead && headIndex == depIndex && headWord.equals(depWord)) {
                    seenHead = true;
                    continue;
                }
                UnnamedDependency unnamedDependency = dependency = isConcrete && depIndex != headIndex ? new UnnamedConcreteDependency(headLabel, depLabel) : new UnnamedDependency(headLabel, depLabel);
                if (!f.test(dependency)) continue;
                deps.add(dependency);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> mapDependencies(Predicate<Dependency<Label, Label, Object>> f, HeadFinder hf) {
        if (hf == null) {
            throw new IllegalArgumentException("mapDependencies: need HeadFinder");
        }
        Set<Dependency<Label, Label, Object>> deps = Generics.newHashSet();
        for (Tree node : this) {
            if (node.isLeaf() || node.children().length < 2) continue;
            Tree hwt = node.headTerminal(hf);
            if (hwt == null) {
                throw new IllegalStateException("mapDependencies: HeadFinder failed!");
            }
            for (Tree child : node.children()) {
                UnnamedDependency p;
                Tree dwt = child.headTerminal(hf);
                if (dwt == null) {
                    throw new IllegalStateException("mapDependencies: HeadFinder failed!");
                }
                if (dwt == hwt || !f.test(p = new UnnamedDependency(hwt.label(), dwt.label()))) continue;
                deps.add(p);
            }
        }
        return deps;
    }

    public Set<Dependency<Label, Label, Object>> mapDependencies(Predicate<Dependency<Label, Label, Object>> f, HeadFinder hf, String rootName) {
        Set<Dependency<Label, Label, Object>> deps = this.mapDependencies(f, hf);
        if (rootName != null) {
            Label hl = this.headTerminal(hf).label();
            CoreLabel rl = new CoreLabel();
            rl.set(CoreAnnotations.TextAnnotation.class, rootName);
            rl.set(CoreAnnotations.IndexAnnotation.class, 0);
            deps.add(new NamedDependency(rl, hl, (Object)rootName));
        }
        return deps;
    }

    public ArrayList<Label> yield() {
        return this.yield(new ArrayList<Label>());
    }

    public ArrayList<Label> yield(ArrayList<Label> y) {
        if (this.isLeaf()) {
            y.add(this.label());
        } else {
            Tree[] kids;
            for (Tree kid : kids = this.children()) {
                kid.yield(y);
            }
        }
        return y;
    }

    public ArrayList<Word> yieldWords() {
        return this.yieldWords(new ArrayList<Word>());
    }

    public ArrayList<Word> yieldWords(ArrayList<Word> y) {
        if (this.isLeaf()) {
            y.add(new Word(this.label()));
        } else {
            for (Tree kid : this.children()) {
                kid.yieldWords(y);
            }
        }
        return y;
    }

    public <X extends HasWord> ArrayList<X> yieldHasWord() {
        return this.yieldHasWord(new ArrayList());
    }

    public <X extends HasWord> ArrayList<X> yieldHasWord(ArrayList<X> y) {
        if (this.isLeaf()) {
            Label lab = this.label();
            if (lab instanceof HasWord) {
                if (lab instanceof CoreLabel) {
                    CoreLabel cl = (CoreLabel)lab;
                    if (cl.word() == null) {
                        cl.setWord(cl.value());
                    }
                    y.add(cl);
                } else {
                    y.add((HasWord)((Object)lab));
                }
            } else {
                y.add(new Word(lab));
            }
        } else {
            Tree[] kids;
            for (Tree kid : kids = this.children()) {
                kid.yield((List)y);
            }
        }
        return y;
    }

    public <T> List<T> yield(List<T> y) {
        if (this.isLeaf()) {
            if (this.label() instanceof HasWord) {
                HasWord hw = (HasWord)((Object)this.label());
                hw.setWord(this.label().value());
            }
            y.add(this.label());
        } else {
            Tree[] kids;
            for (Tree kid : kids = this.children()) {
                kid.yield(y);
            }
        }
        return y;
    }

    public ArrayList<TaggedWord> taggedYield() {
        return this.taggedYield(new ArrayList());
    }

    public List<LabeledWord> labeledYield() {
        return this.labeledYield(new ArrayList<LabeledWord>());
    }

    public <X extends List<TaggedWord>> X taggedYield(X ty) {
        if (this.isPreTerminal()) {
            ty.add((TaggedWord)new TaggedWord(this.firstChild().label(), this.label()));
        } else {
            for (Tree kid : this.children()) {
                kid.taggedYield(ty);
            }
        }
        return ty;
    }

    public List<LabeledWord> labeledYield(List<LabeledWord> ty) {
        if (this.isPreTerminal()) {
            ty.add(new LabeledWord(this.firstChild().label(), this.label()));
        } else {
            for (Tree kid : this.children()) {
                kid.labeledYield(ty);
            }
        }
        return ty;
    }

    public List<CoreLabel> taggedLabeledYield() {
        return this.taggedLabeledYield(true);
    }

    public List<CoreLabel> taggedLabeledYield(boolean tagValues) {
        ArrayList<CoreLabel> ty = new ArrayList<CoreLabel>();
        this.taggedLabeledYield(ty, 0, tagValues);
        return ty;
    }

    private int taggedLabeledYield(List<CoreLabel> ty, int termIdx, boolean tagValues) {
        if (this.isPreTerminal()) {
            String tag;
            CoreLabel taggedWord = new CoreLabel(this.firstChild().label());
            if (taggedWord.word() == null) {
                taggedWord.setWord(this.firstChild().value());
            }
            String string = tag = this.value() == null ? "" : this.value();
            if (tagValues) {
                taggedWord.setValue(tag);
            } else {
                taggedWord.setValue(taggedWord.word());
            }
            taggedWord.setTag(tag);
            taggedWord.setIndex(termIdx);
            ty.add(taggedWord);
            return termIdx + 1;
        }
        for (Tree kid : this.getChildrenAsList()) {
            termIdx = kid.taggedLabeledYield(ty, termIdx, tagValues);
        }
        return termIdx;
    }

    public List<Label> preTerminalYield() {
        return this.preTerminalYield(new ArrayList<Label>());
    }

    public List<Label> preTerminalYield(List<Label> y) {
        if (this.isPreTerminal()) {
            y.add(this.label());
        } else {
            Tree[] kids;
            for (Tree kid : kids = this.children()) {
                kid.preTerminalYield(y);
            }
        }
        return y;
    }

    public <T extends Tree> List<T> getLeaves() {
        return this.getLeaves(new ArrayList());
    }

    public <T extends Tree> List<T> getLeaves(List<T> list) {
        if (this.isLeaf()) {
            list.add(this);
        } else {
            for (Tree kid : this.children()) {
                kid.getLeaves(list);
            }
        }
        return list;
    }

    @Override
    public Collection<Label> labels() {
        Tree[] kids;
        Set<Label> n = Generics.newHashSet();
        n.add(this.label());
        for (Tree kid : kids = this.children()) {
            n.addAll(kid.labels());
        }
        return n;
    }

    @Override
    public void setLabels(Collection<Label> c) {
        throw new UnsupportedOperationException("Can't set Tree labels");
    }

    public Tree flatten() {
        return this.flatten(this.treeFactory());
    }

    public Tree flatten(TreeFactory tf) {
        if (this.isLeaf() || this.isPreTerminal()) {
            return this;
        }
        Tree[] kids = this.children();
        ArrayList<Tree> newChildren = new ArrayList<Tree>(kids.length);
        for (Tree child : kids) {
            if (child.isLeaf() || child.isPreTerminal()) {
                newChildren.add(child);
                continue;
            }
            Tree newChild = child.flatten(tf);
            if (this.label().equals(newChild.label())) {
                newChildren.addAll(newChild.getChildrenAsList());
                continue;
            }
            newChildren.add(newChild);
        }
        return tf.newTreeNode(this.label(), newChildren);
    }

    public Set<Tree> subTrees() {
        return this.subTrees(Generics.newHashSet());
    }

    public List<Tree> subTreeList() {
        return this.subTrees(new ArrayList());
    }

    public <T extends Collection<Tree>> T subTrees(T n) {
        Tree[] kids;
        n.add((Tree)this);
        for (Tree kid : kids = this.children()) {
            kid.subTrees(n);
        }
        return n;
    }

    public Tree deepCopy() {
        return this.deepCopy(this.treeFactory());
    }

    public Tree deepCopy(TreeFactory tf) {
        return this.deepCopy(tf, this.label().labelFactory());
    }

    public Tree deepCopy(TreeFactory tf, LabelFactory lf) {
        Label label = lf.newLabel(this.label());
        if (this.isLeaf()) {
            return tf.newLeaf(label);
        }
        Tree[] kids = this.children();
        ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
        for (Tree kid : kids) {
            newKids.add(kid.deepCopy(tf, lf));
        }
        return tf.newTreeNode(label, newKids);
    }

    public Tree treeSkeletonCopy() {
        return this.treeSkeletonCopy(this.treeFactory());
    }

    public Tree treeSkeletonCopy(TreeFactory tf) {
        Tree t;
        if (this.isLeaf()) {
            t = tf.newLeaf(this.label());
        } else {
            Tree[] kids = this.children();
            ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
            for (Tree kid : kids) {
                newKids.add(kid.treeSkeletonCopy(tf));
            }
            t = tf.newTreeNode(this.label(), newKids);
        }
        return t;
    }

    public Tree treeSkeletonConstituentCopy() {
        return this.treeSkeletonConstituentCopy(this.treeFactory(), this.label().labelFactory());
    }

    public Tree treeSkeletonConstituentCopy(TreeFactory tf, LabelFactory lf) {
        if (this.isLeaf()) {
            Tree newLeaf = tf.newLeaf(this.label());
            newLeaf.setLabel(this.label());
            return newLeaf;
        }
        Label label = lf.newLabel(this.label());
        Tree[] kids = this.children();
        ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
        for (Tree kid : kids) {
            newKids.add(kid.treeSkeletonConstituentCopy(tf, lf));
        }
        return tf.newTreeNode(label, newKids);
    }

    public Tree transform(TreeTransformer transformer) {
        return this.transform(transformer, this.treeFactory());
    }

    public Tree transform(TreeTransformer transformer, TreeFactory tf) {
        Tree t;
        if (this.isLeaf()) {
            t = tf.newLeaf(this.label());
        } else {
            Tree[] kids = this.children();
            ArrayList<Tree> newKids = new ArrayList<Tree>(kids.length);
            for (Tree kid : kids) {
                newKids.add(kid.transform(transformer, tf));
            }
            t = tf.newTreeNode(this.label(), newKids);
        }
        return transformer.transformTree(t);
    }

    public Tree spliceOut(Predicate<Tree> nodeFilter) {
        return this.spliceOut(nodeFilter, this.treeFactory());
    }

    public Tree spliceOut(Predicate<Tree> nodeFilter, TreeFactory tf) {
        List<Tree> l = this.spliceOutHelper(nodeFilter, tf);
        if (l.isEmpty()) {
            return null;
        }
        if (l.size() == 1) {
            return l.get(0);
        }
        return tf.newTreeNode((Label)null, l);
    }

    private List<Tree> spliceOutHelper(Predicate<Tree> nodeFilter, TreeFactory tf) {
        Tree[] kids = this.children();
        ArrayList<Tree> l = new ArrayList<Tree>();
        for (Tree kid : kids) {
            l.addAll(kid.spliceOutHelper(nodeFilter, tf));
        }
        if (nodeFilter.test(this)) {
            Tree t = !l.isEmpty() ? tf.newTreeNode(this.label(), l) : tf.newLeaf(this.label());
            l = new ArrayList(1);
            l.add(t);
            return l;
        }
        return l;
    }

    public Tree prune(Predicate<Tree> filter) {
        return this.prune(filter, this.treeFactory());
    }

    public Tree prune(Predicate<Tree> filter, TreeFactory tf) {
        Tree[] kids;
        if (!filter.test(this)) {
            return null;
        }
        ArrayList<Tree> l = new ArrayList<Tree>();
        for (Tree kid : kids = this.children()) {
            Tree prunedChild = kid.prune(filter, tf);
            if (prunedChild == null) continue;
            l.add(prunedChild);
        }
        if (l.isEmpty() && kids.length != 0) {
            return null;
        }
        if (this.isLeaf()) {
            return tf.newLeaf(this.label());
        }
        return tf.newTreeNode(this.label(), l);
    }

    public Tree skipRoot() {
        if (!this.isUnaryRewrite()) {
            return this;
        }
        String lab = this.label().value();
        return lab == null || lab.isEmpty() || "ROOT".equals(lab) ? this.firstChild() : this;
    }

    public abstract TreeFactory treeFactory();

    public Tree parent() {
        throw new UnsupportedOperationException();
    }

    public Tree parent(Tree root) {
        Tree[] kids = root.children();
        return Tree.parentHelper(root, kids, this);
    }

    private static Tree parentHelper(Tree parent, Tree[] kids, Tree node) {
        for (Tree kid : kids) {
            if (kid == node) {
                return parent;
            }
            Tree ret = node.parent(kid);
            if (ret == null) continue;
            return ret;
        }
        return null;
    }

    @Override
    public int size() {
        Tree[] kids;
        int size = 1;
        for (Tree kid : kids = this.children()) {
            size += kid.size();
        }
        return size;
    }

    public Tree ancestor(int height, Tree root) {
        if (height < 0) {
            throw new IllegalArgumentException("ancestor: height cannot be negative");
        }
        if (height == 0) {
            return this;
        }
        Tree par = this.parent(root);
        if (par == null) {
            return null;
        }
        return par.ancestor(height - 1, root);
    }

    @Override
    public Iterator<Tree> iterator() {
        return new TreeIterator(this);
    }

    public List<Tree> postOrderNodeList() {
        ArrayList<Tree> nodes = new ArrayList<Tree>();
        Tree.postOrderRecurse(this, nodes);
        return nodes;
    }

    private static void postOrderRecurse(Tree t, List<Tree> nodes) {
        for (Tree c : t.children()) {
            Tree.postOrderRecurse(c, nodes);
        }
        nodes.add(t);
    }

    public List<Tree> preOrderNodeList() {
        ArrayList<Tree> nodes = new ArrayList<Tree>();
        Tree.preOrderRecurse(this, nodes);
        return nodes;
    }

    private static void preOrderRecurse(Tree t, List<Tree> nodes) {
        nodes.add(t);
        for (Tree c : t.children()) {
            Tree.preOrderRecurse(c, nodes);
        }
    }

    public static Tree valueOf(String str) {
        return Tree.valueOf(str, new LabeledScoredTreeReaderFactory());
    }

    public static Tree valueOf(String str, TreeReaderFactory trf) {
        try {
            return trf.newTreeReader(new StringReader(str)).readTree();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Tree.valueOf() tree construction failed", ioe);
        }
    }

    public Tree getChild(int i) {
        Tree[] kids = this.children();
        return kids[i];
    }

    public Tree removeChild(int i) {
        Tree[] kids = this.children();
        Tree kid = kids[i];
        Tree[] newKids = new Tree[kids.length - 1];
        for (int j = 0; j < newKids.length; ++j) {
            newKids[j] = j < i ? kids[j] : kids[j + 1];
        }
        this.setChildren(newKids);
        return kid;
    }

    public void addChild(int i, Tree t) {
        Tree[] kids = this.children();
        Tree[] newKids = new Tree[kids.length + 1];
        if (i != 0) {
            System.arraycopy(kids, 0, newKids, 0, i);
        }
        newKids[i] = t;
        if (i != kids.length) {
            System.arraycopy(kids, i, newKids, i + 1, kids.length - i);
        }
        this.setChildren(newKids);
    }

    public void addChild(Tree t) {
        this.addChild(this.children().length, t);
    }

    public Tree setChild(int i, Tree t) {
        Tree[] kids = this.children();
        Tree old = kids[i];
        kids[i] = t;
        return old;
    }

    public boolean dominates(Tree t) {
        List<Tree> dominationPath = this.dominationPath(t);
        return dominationPath != null && dominationPath.size() > 1;
    }

    public List<Tree> dominationPath(Tree t) {
        Tree[] result = this.dominationPath(t, 0);
        if (result == null) {
            return null;
        }
        return Arrays.asList(result);
    }

    private Tree[] dominationPathHelper(Tree t, int depth) {
        Tree[] kids = this.children();
        for (int i = kids.length - 1; i >= 0; --i) {
            Tree t1 = kids[i];
            if (t1 == null) {
                return null;
            }
            Tree[] result = t1.dominationPath(t, depth + 1);
            if (result == null) continue;
            result[depth] = this;
            return result;
        }
        return null;
    }

    private Tree[] dominationPath(Tree t, int depth) {
        if (this == t) {
            Tree[] result = new Tree[depth + 1];
            result[depth] = this;
            return result;
        }
        return this.dominationPathHelper(t, depth);
    }

    public List<Tree> pathNodeToNode(Tree t1, Tree t2) {
        if (!this.contains(t1) || !this.contains(t2)) {
            return null;
        }
        if (t1 == t2) {
            return Collections.singletonList(t1);
        }
        if (t1.dominates(t2)) {
            return t1.dominationPath(t2);
        }
        if (t2.dominates(t1)) {
            List<Tree> path = t2.dominationPath(t1);
            Collections.reverse(path);
            return path;
        }
        Tree joinNode = this.joinNode(t1, t2);
        if (joinNode == null) {
            return null;
        }
        List<Tree> t1DomPath = joinNode.dominationPath(t1);
        List<Tree> t2DomPath = joinNode.dominationPath(t2);
        if (t1DomPath == null || t2DomPath == null) {
            return null;
        }
        ArrayList<Tree> path = new ArrayList<Tree>(t1DomPath);
        Collections.reverse(path);
        path.remove(joinNode);
        path.addAll(t2DomPath);
        return path;
    }

    public Tree joinNode(Tree t1, Tree t2) {
        Tree n2;
        Tree n1;
        if (!this.contains(t1) || !this.contains(t2)) {
            return null;
        }
        if (this == t1 || this == t2) {
            return this;
        }
        Tree joinNode = null;
        List<Tree> t1DomPath = this.dominationPath(t1);
        List<Tree> t2DomPath = this.dominationPath(t2);
        if (t1DomPath == null || t2DomPath == null) {
            return null;
        }
        Iterator<Tree> it1 = t1DomPath.iterator();
        Iterator<Tree> it2 = t2DomPath.iterator();
        while (it1.hasNext() && it2.hasNext() && (n1 = it1.next()) == (n2 = it2.next())) {
            joinNode = n1;
        }
        return joinNode;
    }

    public boolean cCommands(Tree t1, Tree t2) {
        List<Tree> sibs = t1.siblings(this);
        if (sibs == null) {
            return false;
        }
        for (Tree sib : sibs) {
            if (sib != t2 && !sib.contains(t2)) continue;
            return true;
        }
        return false;
    }

    public List<Tree> siblings(Tree root) {
        Tree parent = this.parent(root);
        if (parent == null) {
            return null;
        }
        List<Tree> siblings = parent.getChildrenAsList();
        siblings.remove(this);
        return siblings;
    }

    public void insertDtr(Tree dtr, int position) {
        int i;
        Tree[] kids = this.children();
        if (position > kids.length) {
            throw new IllegalArgumentException("Can't insert tree after the " + position + "th daughter in " + this + "; only " + kids.length + " daughters exist!");
        }
        Tree[] newKids = new Tree[kids.length + 1];
        for (i = 0; i < position; ++i) {
            newKids[i] = kids[i];
        }
        newKids[i] = dtr;
        while (i < kids.length) {
            newKids[i + 1] = kids[i];
            ++i;
        }
        this.setChildren(newKids);
    }

    @Override
    public String value() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.value();
    }

    @Override
    public void setValue(String value) {
        Label lab = this.label();
        if (lab != null) {
            lab.setValue(value);
        }
    }

    @Override
    public void setFromString(String labelStr) {
        Label lab = this.label();
        if (lab != null) {
            lab.setFromString(labelStr);
        }
    }

    @Override
    public LabelFactory labelFactory() {
        Label lab = this.label();
        if (lab == null) {
            return null;
        }
        return lab.labelFactory();
    }

    public int leftCharEdge(Tree node) {
        MutableInteger i = new MutableInteger(0);
        if (this.leftCharEdge(node, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean leftCharEdge(Tree node, MutableInteger i) {
        if (this == node) {
            return true;
        }
        if (this.isLeaf()) {
            i.set(i.intValue() + this.value().length());
            return false;
        }
        for (Tree child : this.children()) {
            if (!child.leftCharEdge(node, i)) continue;
            return true;
        }
        return false;
    }

    public int rightCharEdge(Tree node) {
        List s = this.getLeaves();
        int length = 0;
        for (Tree leaf : s) {
            length += leaf.label().value().length();
        }
        MutableInteger i = new MutableInteger(length);
        if (this.rightCharEdge(node, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean rightCharEdge(Tree node, MutableInteger i) {
        if (this == node) {
            return true;
        }
        if (this.isLeaf()) {
            i.set(i.intValue() - this.label().value().length());
            return false;
        }
        for (int j = this.children().length - 1; j >= 0; --j) {
            if (!this.children()[j].rightCharEdge(node, i)) continue;
            return true;
        }
        return false;
    }

    public int nodeNumber(Tree root) {
        MutableInteger i = new MutableInteger(1);
        if (this.nodeNumberHelper(root, i)) {
            return i.intValue();
        }
        return -1;
    }

    private boolean nodeNumberHelper(Tree t, MutableInteger i) {
        if (this == t) {
            return true;
        }
        i.incValue(1);
        for (Tree kid : t.children()) {
            if (!this.nodeNumberHelper(kid, i)) continue;
            return true;
        }
        return false;
    }

    public Tree getNodeNumber(int i) {
        return this.getNodeNumberHelper(new MutableInteger(1), i);
    }

    private Tree getNodeNumberHelper(MutableInteger i, int target) {
        int i1 = i.intValue();
        if (i1 == target) {
            return this;
        }
        if (i1 > target) {
            throw new IndexOutOfBoundsException("Error -- tree does not contain " + i + " nodes.");
        }
        i.incValue(1);
        for (Tree kid : this.children()) {
            Tree temp = kid.getNodeNumberHelper(i, target);
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    public void indexLeaves() {
        this.indexLeaves(1, false);
    }

    public void indexLeaves(boolean overWrite) {
        this.indexLeaves(1, overWrite);
    }

    public int indexLeaves(int startIndex, boolean overWrite) {
        if (this.isLeaf()) {
            if (this.label() instanceof HasIndex) {
                HasIndex hi = (HasIndex)((Object)this.label());
                int oldIndex = hi.index();
                if (!overWrite && oldIndex >= 0) {
                    startIndex = oldIndex;
                } else {
                    hi.setIndex(startIndex);
                }
                ++startIndex;
            }
        } else {
            for (Tree kid : this.children()) {
                startIndex = kid.indexLeaves(startIndex, overWrite);
            }
        }
        return startIndex;
    }

    public void percolateHeadIndices() {
        if (this.isPreTerminal()) {
            int nodeIndex = ((HasIndex)((Object)this.firstChild().label())).index();
            ((HasIndex)((Object)this.label())).setIndex(nodeIndex);
            return;
        }
        String wordAnnotation = ((HasWord)((Object)this.label())).word();
        if (wordAnnotation == null) {
            wordAnnotation = this.value();
        }
        boolean seenHead = false;
        for (Tree child : this.children()) {
            child.percolateHeadIndices();
            String childWordAnnotation = ((HasWord)((Object)child.label())).word();
            if (childWordAnnotation == null) {
                childWordAnnotation = child.value();
            }
            if (seenHead || !wordAnnotation.equals(childWordAnnotation)) continue;
            seenHead = true;
            int nodeIndex = ((HasIndex)((Object)child.label())).index();
            ((HasIndex)((Object)this.label())).setIndex(nodeIndex);
        }
    }

    public void indexSpans() {
        this.indexSpans(0);
    }

    public void indexSpans(int startIndex) {
        this.indexSpans(new MutableInteger(startIndex));
    }

    public Pair<Integer, Integer> indexSpans(MutableInteger startIndex) {
        int start = Integer.MAX_VALUE;
        int end = Integer.MIN_VALUE;
        if (this.isLeaf()) {
            start = startIndex.intValue();
            end = startIndex.intValue() + 1;
            startIndex.incValue(1);
        } else {
            for (Tree kid : this.children()) {
                Pair<Integer, Integer> span = kid.indexSpans(startIndex);
                if ((Integer)span.first < start) {
                    start = (Integer)span.first;
                }
                if ((Integer)span.second <= end) continue;
                end = (Integer)span.second;
            }
        }
        Label label = this.label();
        if (label instanceof CoreMap) {
            CoreMap afl = (CoreMap)((Object)this.label());
            afl.set(CoreAnnotations.BeginIndexAnnotation.class, start);
            afl.set(CoreAnnotations.EndIndexAnnotation.class, end);
        }
        return new Pair<Integer, Integer>(start, end);
    }

    private static class TreeIterator
    implements Iterator<Tree> {
        private final List<Tree> treeStack = new ArrayList<Tree>();

        protected TreeIterator(Tree t) {
            this.treeStack.add(t);
        }

        @Override
        public boolean hasNext() {
            return !this.treeStack.isEmpty();
        }

        @Override
        public Tree next() {
            int lastIndex = this.treeStack.size() - 1;
            if (lastIndex < 0) {
                throw new NoSuchElementException("TreeIterator exhausted");
            }
            Tree tr = this.treeStack.remove(lastIndex);
            Tree[] kids = tr.children();
            for (int i = kids.length - 1; i >= 0; --i) {
                this.treeStack.add(kids[i]);
            }
            return tr;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "TreeIterator";
        }
    }
}

