/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.international.french;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.AbstractCollinsHeadFinder;
import edu.stanford.nlp.trees.DiskTreebank;
import edu.stanford.nlp.trees.Treebank;
import edu.stanford.nlp.trees.international.french.FrenchTreebankLanguagePack;
import edu.stanford.nlp.util.Generics;

public class FrenchHeadFinder
extends AbstractCollinsHeadFinder {
    private static final long serialVersionUID = 8747319554557223422L;

    public FrenchHeadFinder() {
        this(new FrenchTreebankLanguagePack());
    }

    public FrenchHeadFinder(FrenchTreebankLanguagePack tlp) {
        super(tlp, new String[0]);
        this.nonTerminalInfo = Generics.newHashMap();
        this.nonTerminalInfo.put(tlp.startSymbol(), new String[][]{{"left", "VN", "NP"}, {"left"}});
        this.nonTerminalInfo.put("SENT", new String[][]{{"left", "VN", "NP"}, {"left"}});
        this.nonTerminalInfo.put("AP", new String[][]{{"left", "A", "V"}, {"rightdis", "N", "ET"}, {"left"}});
        this.nonTerminalInfo.put("AdP", new String[][]{{"right", "ADV"}, {"left", "N"}, {"right"}});
        this.nonTerminalInfo.put("COORD", new String[][]{{"leftdis", "C", "CC", "ADV", "PP", "P"}, {"left"}});
        this.nonTerminalInfo.put("NP", new String[][]{{"rightdis", "N", "PRO", "NP", "A"}, {"right", "ET"}, {"right"}});
        this.nonTerminalInfo.put("PP", new String[][]{{"left", "P", "PRO", "A", "NP", "V", "PP", "ADV"}, {"left"}});
        this.nonTerminalInfo.put("VN", new String[][]{{"right", "V", "VN"}, {"right"}});
        this.nonTerminalInfo.put("VPinf", new String[][]{{"left", "VN", "V"}, {"left"}});
        this.nonTerminalInfo.put("VPpart", new String[][]{{"left", "VN", "V", "AP", "A", "AdP", "VPpart"}, {"left"}});
        this.nonTerminalInfo.put("Srel", new String[][]{{"left", "NP", "PRO", "PP", "C", "ADV"}});
        this.nonTerminalInfo.put("Ssub", new String[][]{{"left", "C", "PC", "ADV", "P", "PP"}, {"left"}});
        this.nonTerminalInfo.put("Sint", new String[][]{{"left", "VN", "V", "NP", "Sint", "Ssub", "PP"}, {"left"}});
        this.nonTerminalInfo.put("ADV", new String[][]{{"left", "ADV", "PP", "P"}});
        this.nonTerminalInfo.put("MWD", new String[][]{{"left", "D"}, {"left"}});
        this.nonTerminalInfo.put("MWA", new String[][]{{"left", "P"}, {"left", "N"}, {"right", "A"}, {"right"}});
        this.nonTerminalInfo.put("MWC", new String[][]{{"left", "C", "CS"}, {"left"}});
        this.nonTerminalInfo.put("MWN", new String[][]{{"right", "N", "ET"}, {"right"}});
        this.nonTerminalInfo.put("MWV", new String[][]{{"left", "V"}, {"left"}});
        this.nonTerminalInfo.put("MWP", new String[][]{{"left", "P", "ADV", "PRO"}, {"left"}});
        this.nonTerminalInfo.put("MWPRO", new String[][]{{"left", "PRO", "CL", "N", "A"}, {"left"}});
        this.nonTerminalInfo.put("MWCL", new String[][]{{"left", "CL"}, {"right"}});
        this.nonTerminalInfo.put("MWADV", new String[][]{{"left", "P", "ADV"}, {"left"}});
        this.nonTerminalInfo.put("MWI", new String[][]{{"left", "N", "ADV", "P"}, {"left"}});
        this.nonTerminalInfo.put("MWET", new String[][]{{"left", "ET", "N"}, {"left"}});
        this.nonTerminalInfo.put("DUMMYP", new String[][]{{"left"}});
    }

    public static void main(String[] args) {
        DiskTreebank treebank = new DiskTreebank();
        CategoryWordTag.suppressTerminalDetails = true;
        treebank.loadPath(args[0]);
        FrenchHeadFinder chf = new FrenchHeadFinder();
        ((Treebank)treebank).apply(pt -> {
            pt.percolateHeads(chf);
            pt.pennPrint();
            System.out.println();
        });
    }
}

