/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex;

import edu.stanford.nlp.trees.CollinsHeadFinder;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.PennTreebankLanguagePack;
import edu.stanford.nlp.trees.tregex.ParseException;
import edu.stanford.nlp.trees.tregex.TokenMgrError;
import edu.stanford.nlp.trees.tregex.TregexParseException;
import edu.stanford.nlp.trees.tregex.TregexParser;
import edu.stanford.nlp.trees.tregex.TregexPattern;
import edu.stanford.nlp.util.Pair;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;

public class TregexPatternCompiler {
    static final Function<String, String> DEFAULT_BASIC_CAT_FUNCTION = new PennTreebankLanguagePack().getBasicCategoryFunction();
    static final HeadFinder DEFAULT_HEAD_FINDER = new CollinsHeadFinder();
    private final Function<String, String> basicCatFunction;
    private final HeadFinder headFinder;
    private final List<Pair<String, String>> macros = new ArrayList<Pair<String, String>>();
    public static final TregexPatternCompiler defaultCompiler = new TregexPatternCompiler();

    public TregexPatternCompiler() {
        this(DEFAULT_HEAD_FINDER, DEFAULT_BASIC_CAT_FUNCTION);
    }

    public TregexPatternCompiler(Function<String, String> basicCatFunction) {
        this(DEFAULT_HEAD_FINDER, basicCatFunction);
    }

    public TregexPatternCompiler(HeadFinder headFinder) {
        this(headFinder, DEFAULT_BASIC_CAT_FUNCTION);
    }

    public TregexPatternCompiler(HeadFinder headFinder, Function<String, String> basicCatFunction) {
        this.headFinder = headFinder;
        this.basicCatFunction = basicCatFunction;
    }

    public void addMacro(String original, String replacement) {
        this.macros.add(new Pair<String, String>(original, replacement));
    }

    public TregexPattern compile(String tregex) {
        TregexPattern pattern;
        for (Pair<String, String> macro : this.macros) {
            tregex = tregex.replaceAll(macro.first(), macro.second());
        }
        try {
            TregexParser parser = new TregexParser(new StringReader(tregex + '\n'), this.basicCatFunction, this.headFinder);
            pattern = parser.Root();
        }
        catch (TokenMgrError tme) {
            throw new TregexParseException("Could not parse " + tregex, tme);
        }
        catch (ParseException e) {
            throw new TregexParseException("Could not parse " + tregex, e);
        }
        catch (IllegalStateException e) {
            throw new TregexParseException("Could not parse " + tregex, e);
        }
        pattern.setPatternString(tregex);
        return pattern;
    }
}

