/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util.concurrent;

import edu.stanford.nlp.util.RuntimeInterruptedException;
import edu.stanford.nlp.util.concurrent.MulticoreWrapper;
import edu.stanford.nlp.util.concurrent.ThreadsafeProcessor;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class InterruptibleMulticoreWrapper<I, O>
extends MulticoreWrapper<I, O> {
    private final long timeout;

    public InterruptibleMulticoreWrapper(int numThreads, ThreadsafeProcessor<I, O> processor, boolean orderResults, long timeout) {
        super(numThreads, processor, orderResults);
        this.timeout = timeout;
    }

    @Override
    protected ThreadPoolExecutor buildThreadPool(int nThreads) {
        return new FixedNamedThreadPoolExecutor(nThreads);
    }

    @Override
    protected Integer getProcessor() {
        try {
            return this.timeout <= 0L ? (Integer)this.idleProcessors.take() : (Integer)this.idleProcessors.poll(this.timeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeInterruptedException(e);
        }
    }

    public List<I> joinWithTimeout() {
        if (this.timeout <= 0L) {
            this.join();
            return new ArrayList();
        }
        if (!this.threadPool.isShutdown()) {
            try {
                int i;
                List<I> leftover = null;
                for (i = this.nThreads; i > 0; --i) {
                    if (this.idleProcessors.poll(this.timeout, TimeUnit.MILLISECONDS) != null) continue;
                    leftover = this.shutdownNow();
                    break;
                }
                if (i > 0) {
                    while (i > leftover.size()) {
                        this.idleProcessors.take();
                        --i;
                    }
                    return leftover;
                }
                this.threadPool.shutdown();
                this.threadPool.awaitTermination(10L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                throw new RuntimeInterruptedException(e);
            }
        }
        return new ArrayList();
    }

    private List<I> shutdownNow() {
        ArrayList orphans = new ArrayList();
        List<Runnable> runnables = this.threadPool.shutdownNow();
        for (Runnable runnable : runnables) {
            if (!(runnable instanceof NamedTask)) {
                throw new AssertionError((Object)"Should have gotten NamedTask");
            }
            NamedTask task = (NamedTask)runnable;
            orphans.add(task.item);
        }
        return orphans;
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        return this.threadPool.awaitTermination(timeout, unit);
    }

    private static class FixedNamedThreadPoolExecutor<I, O>
    extends ThreadPoolExecutor {
        FixedNamedThreadPoolExecutor(int nThreads) {
            super(nThreads, nThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }

        protected <V> RunnableFuture<V> newTaskFor(Callable<V> c) {
            return new NamedTask(c);
        }

        protected <V> RunnableFuture<V> newTaskFor(Runnable r, V v) {
            throw new UnsupportedOperationException();
        }
    }

    private static class NamedTask<I, O, V>
    extends FutureTask<V> {
        final I item;

        NamedTask(Callable<V> c) {
            super(c);
            if (!(c instanceof MulticoreWrapper.CallableJob)) {
                throw new AssertionError((Object)"Should have gotten a CallableJob");
            }
            MulticoreWrapper.CallableJob myCallable = (MulticoreWrapper.CallableJob)c;
            this.item = myCallable.item;
        }
    }
}

