$(document).ready(function(){

    // Form Validation & Ajax
	 $("form[name='contact-us']").validate({
        rules: {
            fname: { required: true },
            lname: { required: true },
            email: { required: true, email: true },
            number: {digits: true, min:1000000, max: 9999999999},
            message: { required: true },
        },
        errorElement: 'span',
        messages: {
            fname: " * Please enter your first name",
            lname: " * Please enter your last name",
            email: {
                required: " * Please enter email address",
                email: " * Please enter a valid email address.",
            },
            message: " * Please enter message",
        },
        submitHandler: function(form) {

                var formdata = $('#contact-us').serialize();

                $.ajax({
                url: 'sendmail.php',
                type: 'POST',
                data: formdata,
                beforeSend: function () {
                    $("#response").fadeIn(300);
                },
                complete: function () {
                    setTimeout(function () {
                        $("#response").fadeOut(4000);
                    }, 500);
                },
                success: function (data) {
                    $("#name").val('');                    
                    $("#email").val('');
                    $("#message").val('');
                    $("#response").html(data);
                    return false;
                }
            });
        }
        //alert("hello");        
    });
	
     /* Sticky header */

    $(window).scroll(function() {
        var scroll = $(window).scrollTop();
        if ($(window).width() >= 1200) {
            if (scroll > 10) {            
                $("body").addClass("is-scrolled");            
            } else {
                $("body").removeClass("is-scrolled");                        
            }
        }
        else{
            if (scroll > 10) {
                $("body").addClass("is-scrolled");
            } else {
                $("body").removeClass("is-scrolled");       
            }
        }
    });


    // Boostrap Menu Close after click
    $('.navbar-collapse a').click(function(){
        $(".navbar-collapse").collapse('hide');
    });

});


