<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Verification extends CI_Controller
{
    public function __construct(){
        parent::__construct();
        $this->load->model('api_model');
        $this->data = [];
    }

    public function email($email = "", $code = ""){
        $this->data['page_title'] = '';
        $this->data['email_verified'] = FALSE;
        if(empty($email) || empty($code)){
            $this->data['page_title'] = 'Not Found';
            show_custom_404();
        }else{
            $email = str_replace(['-at-'],['@'],$email);
            $where = ['user.email' => $email];
            $row = $this->api_model->checkIfUserExist($where);
            if(!$row){
                $this->data['page_title'] = 'Not Found';
                show_custom_404();
            }else{
                $verification = $this->api_model->getUserEmailVerificationData($row['user_id']);
                $code_expire_at = (1 * CALC_DAYS) + $verification['email_verification_sent_at'];
                if($verification['email_verification_code'] != $code || time() >= $code_expire_at){
                    $this->data['page_title'] = 'Invalid/Broken Link';
                    $this->load->web_guest_template('email-verification/fail',$this->data);
                }else{
                    $this->data['page_title'] = 'Email Verification';
                    $this->data['email_verified'] = TRUE;
                    $this->api_model->verifyEmail($row['user_id'], $code);
                    $this->load->web_guest_template('email-verification/success',$this->data);
                }
            }
        }
    }

    public function mail($email = "", $code = ""){
        $this->data['page_title'] = '';
        $this->data['email_verified'] = FALSE;
        if(empty($email) || empty($code)){
            $this->data['page_title'] = 'Not Found';
            show_custom_404();
        }else{
            $email = str_replace(['-at-'],['@'],$email);
            $postdata = ['email'=>$email, 'code'=>$code];
            $params = [
                'method' => 'POST',
                'url' => STAG_API_URL . 'verify-my-email',
                'payload' => $postdata
            ];
            $response = $this->curl->call($params);
            if(!$response['success']){
                $this->data['page_title'] = 'Invalid/Broken Link';
                $this->load->web_guest_template('email-verification/fail',$this->data);
            }else{
                $this->data['page_title'] = 'Email Verification';
                $this->data['email_verified'] = TRUE;
                $this->load->web_guest_template('email-verification/success',$this->data);
            }
        }
    }

    /* public function success(){
        $this->data['page_title'] = 'Email Verification';
        $this->data['email_verified'] = TRUE;
        $this->load->web_guest_template('email-verification/success',$this->data);
    }

    public function fail(){
        $this->data['page_title'] = 'Invalid/Broken Link';
        $this->data['email_verified'] = FALSE;
        $this->load->web_guest_template('email-verification/fail',$this->data);
    } */
}