<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Admin extends Administrator
{
    public function __construct(){
        parent::__construct();
    }

    public function index(){
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'List','url'=>''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL . 'get-'.$module.'-list';
        $this->data['columns'] = [
            ['type' => 'checkbox'],
            ['type' => 'counter'],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'admin_fullname', 'label' => 'Fullname', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'admin_email', 'label' => 'Email', 'list_params' => ['width' => '15%']],
            ['type' => 'image', 'has_filter' => FALSE, 'id' => 'admin_profilepic', 'label' => 'Profile Picture', 'list_params' => ['width' => '15%','data-orderable' => 'false','data-searchable' => 'false']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_active', 'label' => 'Status', 'options' => ACTIVE_INACTIVE_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_at', 'label' => 'Created at', 'list_params' => ['width' => '8%']],
            ['type' => 'actions', 'has_filter' => FALSE, 'label' => 'Action', 'list_params' => ['width' => '5%', 'class' => 'action-column', 'data-orderable' => 'false', 'data-searchable' => 'false']],
        ];
        $this->data['forms'] = [
            'frm_add' => ['id' => 'frm_add', 'method' => 'POST', 'autocomplete' => 'off', "enctype"=>"multipart/form-data"],
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST', 'autocomplete' => 'off', "enctype"=>"multipart/form-data"],
        ];
        $this->data['form_rules'] = [
            'frm_add' => [
                'admin_fullname' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'admin_email' => ['required' => true, 'email' => true,'minlength' => 2, 'maxlength' => 255],
                'password' => ['required' => true, 'minlength' => 6],
                'is_active' => ['required' => true],
            ],
            'frm_edit' => [
                'admin_fullname' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'admin_email' => ['required' => true, 'email' => true,'minlength' => 2, 'maxlength' => 255],
                'password' => ['required' => false, 'minlength' => 6],
                'is_active' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_add' => [
                'ajax_url' => ADMIN_AJAX_URL . 'add-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'admin_fullname' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'admin_fullname', 'id' => 'admin_fullname', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'admin_email' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'admin_email', 'id' => 'admin_email', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'is_active' => [
                    'class' => 'form-control',
                    'name' => 'is_active', 'id' => 'is_active',
                    'style' => 'display: none',
                ],
                'created_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_at', 'id' => 'created_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
            ],
        ];
        $this->load->admin_auth_template($module.'/list', $this->data);
    }

    /* public function edit($id){
        $row = $this->admin_model->getRow($id);
        if(!$row){
            show_404();
        }
        $row['admin_profilepic'] = getFilePath($row['admin_profilepic']);
        $module = $this->data['module'];
        $this->data['page_title'] = 'Update '.$this->data['singular_title'];
        $this->data['breadcrumb'] = [
            ['title'=>'Home','url'=>ADMIN_URL],
            ['title'=>$this->data['module_title'],'url'=>ADMIN_URL . $module],
            ['title'=>'Update','url'=>''],
        ];
        $this->data['forms'] = [
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST', 'autocomplete' => 'off'],
        ];
        $this->data['form_rules'] = [
            'frm_edit' => [
                'admin_fullname' => ['required' => true, 'minlength' => 2, 'maxlength' => 255],
                'admin_email' => ['required' => true, 'email' => true,'minlength' => 2, 'maxlength' => 255],
                'password' => ['required' => false, 'minlength' => 6],
                'is_active' => ['required' => true],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-'.$module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['row'] = $row;
        $this->load->admin_auth_template($module.'/edit', $this->data);
    } */
}