<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Ajax extends Administrator
{
    public function __construct()
    {
        parent::__construct();
    }

    private function checkIfUpdated($postdata, $record)
    {
        $flag = FALSE;
        foreach ($postdata as $post_key => $post_value) {
            if (isset($record[$post_key]) && $record[$post_key] != $post_value) {
                return TRUE;
            }
        }
        return $flag;
    }

    public function update_status()
    {
        $rules = [
            'id' => [
                'field' => 'id', 'label' => 'ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'status' => [
                'field' => 'status', 'label' => 'Status', 'rules' => 'required|trim',
            ],
            'module' => [
                'field' => 'module', 'label' => 'Module', 'rules' => 'required|trim|in_list[' . implode(',', MY_MODULES) . ']',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $flag = $this->datatable_model->updateStatus($postdata);
        if (!$flag) {
            $this->session->set_flashdata('error', NO_CHANGES_MADE);
            sendResponse(false, NO_CHANGES_MADE);
        }
        $msg = 'Status updated successfully.';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_status_bulk()
    {
        $rules = [
            'ids' => [
                'field' => 'ids', 'label' => 'IDs', 'rules' => 'required|trim|regex_match[/^\d+(?:,\d+)*$/]',
            ],
            'status' => [
                'field' => 'status', 'label' => 'Status', 'rules' => 'required|trim',
            ],
            'module' => [
                'field' => 'module', 'label' => 'Module', 'rules' => 'required|trim|in_list[' . implode(',', MY_MODULES) . ']',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $flag = $this->datatable_model->updateStatusBulk($postdata);
        if (!$flag) {
            $this->session->set_flashdata('error', NO_CHANGES_MADE);
            sendResponse(false, NO_CHANGES_MADE);
        }
        $msg = 'Status updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function delete_record()
    {
        $rules = [
            'id' => [
                'field' => 'ids', 'label' => 'ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'module' => [
                'field' => 'module', 'label' => 'Module', 'rules' => 'required|trim|in_list[' . implode(',', MY_MODULES) . ']',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $flag = $this->datatable_model->deleteRecord($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Record deleted successfully.';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function add_category()
    {
        $rules = [
            'category_label' => [
                'field' => 'category_label', 'label' => 'Category Label', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->category_model->checkIfExist($postdata['category_label']);
        if ($row) {
            sendResponse(false, 'Category already exist');
        }
        $flag = $this->category_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Category added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_category()
    {
        $rules = [
            'category_id' => [
                'field' => 'category_id', 'label' => 'Category ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'category_label' => [
                'field' => 'category_label', 'label' => 'Category Label', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $row = $this->category_model->getRow($postdata['category_id']);
        if (!$row) {
            sendResponse(false, 'Category details does not exist');
        }
        $flag = $this->category_model->checkIfExist($postdata['category_label'], $postdata['category_id']);
        if ($flag) {
            sendResponse(false, 'Category already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->category_model->updateExisting($postdata, $postdata['category_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Category updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function add_question()
    {
        $rules = [
            'question_category_id' => [
                'field' => 'question_category_id', 'label' => 'Question Category', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'question' => [
                'field' => 'question', 'label' => 'Question', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'question_type' => [
                'field' => 'question_type', 'label' => 'Question Type', 'rules' => 'required|trim|in_list[truth,dare]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->question_model->checkIfExist($postdata['question']);
        if ($row) {
            sendResponse(false, 'Question already exist');
        }
        $flag = $this->question_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Question added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_question()
    {
        $rules = [
            'question_id' => [
                'field' => 'question_id', 'label' => 'Question ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'question_category_id' => [
                'field' => 'question_category_id', 'label' => 'Question Category', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'question' => [
                'field' => 'question', 'label' => 'Question', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'question_type' => [
                'field' => 'question_type', 'label' => 'Question Type', 'rules' => 'required|trim|in_list[truth,dare]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $row = $this->question_model->getRow($postdata['question_id']);
        if (!$row) {
            sendResponse(false, 'Question details does not exist');
        }
        $flag = $this->question_model->checkIfExist($postdata['question'], $postdata['question_id']);
        if ($flag) {
            sendResponse(false, 'Question already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->question_model->updateExisting($postdata, $postdata['question_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Question updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_question_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->question_model->getRecords($list_params);
        $filtered_records = $this->question_model->getDatatableList($list_params);
        $params = [
            'module' => 'question',
            'primary_id' => 'question_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'select', 'column' => 'question_category_id'],
                ['type' => 'input', 'column' => 'category_label'],
                ['type' => 'input', 'column' => 'question'],
                ['type' => 'select', 'column' => 'question_type'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'que.question_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->question_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_question_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['question_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->question_model->getRecords($row_params);
        $msg = 'Question details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }


    public function get_category_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->category_model->getRecords($list_params);
        $filtered_records = $this->category_model->getDatatableList($list_params);
        $params = [
            'module' => 'category',
            'primary_id' => 'category_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'category_label'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'cat.category_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->category_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_category_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['category_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->category_model->getRecords($row_params);
        $msg = 'Category details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function update_profile()
    {
        $row = $this->data['loggedIn'];
        $rules = [
            'admin_fullname' => [
                'field' => 'admin_fullname', 'label' => 'Fullname', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'admin_email' => [
                'field' => 'admin_email', 'label' => 'Email', 'rules' => 'required|trim|valid_email',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag && $_FILES['admin_profilepic']['error'] > 0) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        if ($_FILES['admin_profilepic']['error'] == 0) {
            $admin_profilepic = upload_my_file($_FILES['admin_profilepic'], ADMIN_UPLOAD_PATH, MY_IMAGE_TYPE);
            if (!$admin_profilepic['success'] || is_null($admin_profilepic['file']) || empty($admin_profilepic['file'])) :
                sendResponse(false, $admin_profilepic['msg']);
            endif;
            $postdata['admin_profilepic'] = ADMIN_UPLOAD_PATH . $admin_profilepic['file']['name'];
        }
        $flag = $this->profile_model->updateExisting($postdata, $row['admin_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        if ($_FILES['admin_profilepic']['error'] == 0) {
            unlink_my_file($row['admin_profilepic']);
        }
        $msg = 'Profile updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function change_password()
    {
        $row = $this->data['loggedIn'];
        $rules = [
            'old_password' => [
                'field' => 'old_password', 'label' => 'Old Password', 'rules' => 'required|min_length[6]',
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        if (password_verify($postdata['old_password'], $row['admin_password'])) :
            if ($postdata['old_password'] == $postdata['new_password']) :
                $msg = 'Old & new password cannot be same';
                $this->session->set_flashdata('error', $msg);
                sendResponse(false, $msg);
            else :
                $flag = $this->profile_model->updatePassword($postdata['new_password'], $row['admin_id']);
                if ($flag === FALSE) :
                    sendResponse(false, SYSTEM_ERROR);
                endif;
                $msg = 'Password changed successfully';
                $this->session->set_flashdata('success', $msg);
                sendResponse(true, $msg);
            endif;
        else :
            $msg = 'Old password is incorrect';
            $this->session->set_flashdata('error', $msg);
            sendResponse(false, $msg);
        endif;
    }

    public function import_question()
    {
        /* $rules = [
            'import' => [
                'field' => 'import', 'label' => 'Excel File', 'rules' => 'required',
            ],
        ];
        checkIfValidated($rules); */
        $postdata = $this->input->post();
        if ($_FILES['import']['error'] == 0) {
            $import = upload_my_file($_FILES['import'], IMPORT_PATH);
            if (!$import['success'] || is_null($import['file']) || empty($import['file'])) :
                sendResponse(false, $import['msg']);
            endif;
            $postdata['import'] = IMPORT_PATH . $import['file']['name'];
        }
        $xlsx = SimpleXLSX::parse(SITE_PATH . $postdata['import']);
        if (!$xlsx) {
            sendResponse(false, 'Invalid excel file given');
        }
        // Produce array keys from the array values of 1st array element
        $header_values = $rows = [];
        foreach ($xlsx->rows() as $row_index => $row) {
            if ($row_index === 0) {
                $header_values = array_map('strtolower', $row);
                if (
                    !in_array('#', $header_values) || !in_array('question', $header_values) ||
                    !in_array('type', $header_values) || !in_array('category', $header_values)
                ) {
                    unlink_my_file($postdata['import']);
                    sendResponse(false, 'Invalid excel file given');
                }
                continue;
            }
            $rows[] = array_combine($header_values, $row);
        }
        $total_records = count($rows);
        $inserted_records = $updated_records = $skipped_records = $unchanged_records = 0;
        $insert_error_in_records = $update_error_in_records = 0;
        $questions = array_map(function ($row) use (
            &$inserted_records,
            &$updated_records,
            &$skipped_records,
            &$unchanged_records,
            &$insert_error_in_records,
            &$update_error_in_records
        ) {
            $question_category_id = $this->category_model->getRowByName($row['category'])['category_id'] ?? 0;
            $row['question_category_id'] = $question_category_id;
            $row['question_type'] = strtolower($row['type']);
            $row['is_active'] = true;
            unset($row['#']);
            unset($row['type']);
            unset($row['category']);
            if ($question_category_id > 0) {
                $question = $this->question_model->checkIfExist($row['question']);
                if (!$question) {
                    $flag = $this->question_model->addNew($row);
                    if (!$flag) {
                        $insert_error_in_records++;
                    } else {
                        $inserted_records++;
                    }
                } else {
                    if (
                        $question['question_type'] == $row['question_type'] &&
                        $question['question_category_id'] == $question_category_id
                    ) {
                        $unchanged_records++;
                    } else {
                        $flag = $this->question_model->updateExisting($row, $question['question_id']);
                        if (!$flag) {
                            $update_error_in_records++;
                        } else {
                            $updated_records++;
                        }
                    }
                }
                return $row;
            } else {
                $skipped_records++;
            }
        }, $rows);
        unlink_my_file($postdata['import']);
        $output = [
            'total' => $total_records,
            'inserted' => $inserted_records,
            'updated' => $updated_records,
            'skipped' => $skipped_records,
            'unchanged' => $unchanged_records,
            'insert_error' => $insert_error_in_records,
            'update_error' => $update_error_in_records,
        ];
        $msg = 'Data imported successfully';
        sendResponse(true, $msg, $output);
    }

    public function get_module_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->module_model->getRecords($list_params);
        $filtered_records = $this->module_model->getDatatableList($list_params);
        $params = [
            'module' => 'module',
            'primary_id' => 'module_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'module_title'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'module.module_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->module_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_module_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['module_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->module_model->getRecords($row_params);
        $module_methods = $this->module_model->getModuleMethods($row['module_id']);
        $row['module_methods[]'] = array_map(function ($module_method) {
            return $module_method['method_id'];
        }, $module_methods);
        $msg = 'Module details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function add_module()
    {
        $rules = [
            'module_title' => [
                'field' => 'module_title', 'label' => 'Module Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'module_methods[]' => [
                'field' => 'module_methods', 'label' => 'Methods', 'rules' => 'required',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $postdata['module_title'] = singular($postdata['module_title']);

        $row = $this->module_model->checkIfExist($postdata['module_title']);
        if ($row) {
            sendResponse(false, 'Module already exist');
        }

        $flag = $this->module_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Module added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_module()
    {
        $rules = [
            'module_id' => [
                'field' => 'module_id', 'label' => 'Module ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'module_title' => [
                'field' => 'module_title', 'label' => 'Module Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'module_methods[]' => [
                'field' => 'module_methods', 'label' => 'Methods', 'rules' => 'required',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $postdata['module_title'] = singular($postdata['module_title']);

        $row = $this->module_model->getRow($postdata['module_id']);
        if (!$row) {
            sendResponse(false, 'Module details does not exist');
        }
        $row['selected_methods'] = $this->module_model->getModuleMethods($row['module_id']);
        $row['selected_methods'] = array_map(function ($module_method) {
            return $module_method['method_id'];
        }, $row['selected_methods']);

        $deleted_methods = array_diff($row['selected_methods'], $postdata['module_methods']);
        $inserted_methods = array_diff($postdata['module_methods'], $row['selected_methods']);

        $flag = $this->module_model->checkIfExist($postdata['module_title'], $postdata['module_id']);
        if ($flag) {
            sendResponse(false, 'Module already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag && empty($deleted_methods) && empty($inserted_methods)) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->module_model->updateExisting($postdata, $postdata['module_id'], $inserted_methods, $deleted_methods);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Module updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_method_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->method_model->getRecords($list_params);
        $filtered_records = $this->method_model->getDatatableList($list_params);
        $params = [
            'module' => 'method',
            'primary_id' => 'method_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'method_title'],
                ['type' => 'input', 'column' => 'method_identifier'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'method.method_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->method_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_method_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['method_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->method_model->getRecords($row_params);
        $msg = 'Method details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function add_method()
    {
        $rules = [
            'method_title' => [
                'field' => 'method_title', 'label' => 'Method Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'method_identifier' => [
                'field' => 'method_identifier', 'label' => 'Method Identifier', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $postdata['method_title'] = singular($postdata['method_title']);

        $row = $this->method_model->checkIfExist($postdata['method_title']);
        if ($row) {
            sendResponse(false, 'Method already exist');
        }

        $flag = $this->method_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Method added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_method()
    {
        $rules = [
            'method_id' => [
                'field' => 'method_id', 'label' => 'Method ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'method_title' => [
                'field' => 'method_title', 'label' => 'Method Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'method_identifier' => [
                'field' => 'method_identifier', 'label' => 'Method Identifier', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $postdata['method_title'] = singular($postdata['method_title']);

        $row = $this->method_model->getRow($postdata['method_id']);
        if (!$row) {
            sendResponse(false, 'Method details does not exist');
        }
        $flag = $this->method_model->checkIfExist($postdata['method_title'], $postdata['method_id']);
        if ($flag) {
            sendResponse(false, 'Method already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->method_model->updateExisting($postdata, $postdata['method_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Method updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_role_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->role_model->getRecords($list_params);
        $filtered_records = $this->role_model->getDatatableList($list_params);
        $params = [
            'module' => 'role',
            'primary_id' => 'role_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'permission_link' => 'permission',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'role_title'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'role.role_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->role_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_role_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['role_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->role_model->getRecords($row_params);
        $msg = 'Role details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function get_role_permissions()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $selected_permissions = $this->role_model->getModulePermissions($postdata['primary_id']);
        $row['role_id'] = $postdata['primary_id'];
        $row['permissions[]'] = array_map(function ($module_method) {
            return $module_method['module_method_id'];
        }, $selected_permissions);
        $msg = 'Role details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function add_role()
    {
        $rules = [
            'role_title' => [
                'field' => 'role_title', 'label' => 'Role Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->role_model->checkIfExist($postdata['role_title']);
        if ($row) {
            sendResponse(false, 'Role already exist');
        }

        $flag = $this->role_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Role added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_role()
    {
        $rules = [
            'role_id' => [
                'field' => 'role_id', 'label' => 'Role ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'role_title' => [
                'field' => 'role_title', 'label' => 'Role Title', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->role_model->getRow($postdata['role_id']);
        if (!$row) {
            sendResponse(false, 'Role details does not exist');
        }
        $flag = $this->role_model->checkIfExist($postdata['role_title'], $postdata['role_id']);
        if ($flag) {
            sendResponse(false, 'Role already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->role_model->updateExisting($postdata, $postdata['role_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Role updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_role_permission()
    {
        $_POST['permissions'] = $_POST['permissions'] ?? [];
        $rules = [
            'role_id' => [
                'field' => 'role_id', 'label' => 'Role ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->role_model->getRow($postdata['role_id']);
        if (!$row) {
            sendResponse(false, 'Role details does not exist');
        }
        $row['selected_permissions'] = $this->role_model->getModulePermissions($row['role_id']);
        $row['selected_permissions'] = array_map(function ($module_method) {
            return $module_method['module_method_id'];
        }, $row['selected_permissions']);

        $deleted_permissions = array_diff($row['selected_permissions'], $postdata['permissions']);
        $inserted_permissions = array_diff($postdata['permissions'], $row['selected_permissions']);

        if (empty($deleted_permissions) && empty($inserted_permissions)) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->role_model->updatePermissions($postdata['role_id'], $inserted_permissions, $deleted_permissions);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Permissions updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function dashboard_user_device_stats()
    {
        $row = $this->data['loggedIn'];
        $offset = $row['set_offset'];
        $length = 12;
        $user_chartdata = $guest_chartdata = [];

        $labels = [];
        for ($i = ($length - 1); $i >= 0; $i--) :
            $labels[] = date("M, Y", strtotime(date('Y-m-01') . " -" . ($i) . " months") - $offset);
        endfor;

        $history = array_reverse($this->dashboard_model->getSubscriptionAnalytics(['limit' => $length, 'order' => ['order' => 'analytics_id', 'type' => 'DESC']]));

        $active_users = array_map(function ($stat) {
            return $stat['active_users'];
        }, $history);
        $user_chartdata[] = [
            'name' => 'Active Subscribers',
            'data' => array_values(array_map('intval', $active_users)),
            'color' => '#28A745'
        ];
        $expired_users = array_map(function ($stat) {
            return $stat['expired_users'];
        }, $history);
        $user_chartdata[] = [
            'name' => 'Expired Subscribers',
            'data' => array_values(array_map('intval', $expired_users)),
            'color' => '#DC3545'
        ];
        $active_trial_users = array_map(function ($stat) {
            return $stat['active_trial_users'];
        }, $history);
        $user_chartdata[] = [
            'name' => 'Trial Subscribers',
            'data' => array_values(array_map('intval', $active_trial_users)),
            'color' => '#FD7E14'
        ];
        $active_guests = array_map(function ($stat) {
            return $stat['active_guests'];
        }, $history);
        $guest_chartdata[] = [
            'name' => 'Active Guest Subscribers',
            'data' => array_values(array_map('intval', $active_guests)),
            'color' => '#28A745'
        ];
        $expired_guests = array_map(function ($stat) {
            return $stat['expired_guests'];
        }, $history);
        $guest_chartdata[] = [
            'name' => 'Expired Guest Subscribers',
            'data' => array_values(array_map('intval', $expired_guests)),
            'color' => '#DC3545'
        ];
        $active_trial_guests = array_map(function ($stat) {
            return $stat['active_trial_guests'];
        }, $history);
        $guest_chartdata[] = [
            'name' => 'Trial Guest Subscribers',
            'data' => array_values(array_map('intval', $active_trial_guests)),
            'color' => '#FD7E14'
        ];

        sendResponse(true, '', [
            'user_title' => 'Monthly Subscribers', 'user_series' => $user_chartdata,
            'guest_title' => 'Monthly Guest Subscribers', 'guest_series' => $guest_chartdata,
            'subtitle' => '', 'xaxistitle' => 'Month', 'yaxistitle' => 'No. of Users', 'labels' => $labels,
        ]);
    }

    /* public function dashboard_guest_user_device_stats(){
        $row = $this->data['loggedIn'];
        $offset = $row['set_offset'];
        $length = 12;
        $chartdata = [];

        $labels = [];
        for($i = 0; $i < $length; $i++):
            $labels[] = date("M, Y", strtotime( date( 'Y-m-01' )." -".($i)." months"));
        endfor;

        $history = array_reverse($this->dashboard_model->getSubscriptionAnalytics(['limit'=>$length - 1,'order'=>['order'=>'analytics_id','type'=>'DESC']]));

        $current_stat = $this->dashboard_model->getRegisteredActiveGuestSubscribers($offset);
        $active_guests = array_map(function($stat){ return $stat['active_guests']; }, $history);
        $stats = array_merge($active_guests, [$current_stat]);
        $chartdata[] = [
            'name' => 'Active Guest Subscribers',
            'data' => array_values(array_map('intval', $stats)),
            'color'=> '#28A745'
        ];
        $current_stat = $this->dashboard_model->getRegisteredExpiredGuestSubscribers($offset);
        $expired_guests = array_map(function($stat){ return $stat['expired_guests']; }, $history);
        $stats = array_merge($expired_guests, [$current_stat]);
        $chartdata[] = [
            'name' => 'Expired Guest Subscribers',
            'data' => array_values(array_map('intval', $stats)),
            'color'=> '#DC3545'
        ];
        $current_stat = $this->dashboard_model->getRegisteredTrialGuestSubscribers($offset);
        $active_trial_guests = array_map(function($stat){ return $stat['active_trial_guests']; }, $history);
        $stats = array_merge($active_trial_guests, [$current_stat]);
        $chartdata[] = [
            'name' => 'Trial Guest Subscribers',
            'data' => array_values(array_map('intval', $stats)),
            'color'=> '#FD7E14'
        ];
        sendResponse(true, '', [
            'title'=>'Monthly Guest Subscribers', 'subtitle'=>'',
            'xaxistitle'=>'Month', 'yaxistitle'=>'No. of Users',
            'labels'=>$labels, 'series'=>$chartdata
        ]);
    } */

    public function get_admin_list()
    {
        $where = ['role.role_slug' => 'admin'];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->admin_model->getRecords($list_params);
        $filtered_records = $this->admin_model->getDatatableList($list_params);
        $params = [
            'module' => 'admin',
            'primary_id' => 'admin_id',
            // 'edit_link' => 'edit',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'admin_fullname'],
                ['type' => 'input', 'column' => 'admin_email'],
                ['type' => 'image', 'column' => 'admin_profilepic'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'admin.admin_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->admin_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_admin_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['admin_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->admin_model->getRecords($row_params);
        $msg = 'Admin details fetched successfully';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function add_admin()
    {
        $rules = [
            'admin_fullname' => [
                'field' => 'admin_fullname', 'label' => 'Fullname', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'admin_email' => [
                'field' => 'admin_email', 'label' => 'Email', 'rules' => 'required|trim|valid_email',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->admin_model->checkIfExist($postdata['admin_email']);
        if ($row) {
            sendResponse(false, 'Email already exist');
        }

        if ($_FILES['admin_profilepic']['error'] == 0) {
            $admin_profilepic = upload_my_file($_FILES['admin_profilepic'], ADMIN_UPLOAD_PATH, MY_IMAGE_TYPE);
            if (!$admin_profilepic['success'] || is_null($admin_profilepic['file']) || empty($admin_profilepic['file'])) :
                sendResponse(false, $admin_profilepic['msg']);
            endif;
            $postdata['admin_profilepic'] = ADMIN_UPLOAD_PATH . $admin_profilepic['file']['name'];
        }

        $flag = $this->admin_model->addNew($postdata);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Admin added successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function update_admin()
    {
        $rules = [
            'admin_id' => [
                'field' => 'admin_id', 'label' => 'Admin ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
            'admin_fullname' => [
                'field' => 'admin_fullname', 'label' => 'Fullname', 'rules' => 'required|trim|min_length[2]|max_length[255]',
            ],
            'admin_email' => [
                'field' => 'admin_email', 'label' => 'Email', 'rules' => 'required|trim|valid_email',
            ],
            'is_active' => [
                'field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();

        $row = $this->admin_model->getRow($postdata['admin_id']);
        if (!$row) {
            sendResponse(false, 'Admin details does not exist');
        }
        $flag = $this->admin_model->checkIfExist($postdata['admin_email'], $postdata['admin_id']);
        if ($flag) {
            sendResponse(false, 'Email already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag && $_FILES['admin_profilepic']['error'] > 0 && empty($postdata['password'])) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        if ($_FILES['admin_profilepic']['error'] == 0) {
            $admin_profilepic = upload_my_file($_FILES['admin_profilepic'], ADMIN_UPLOAD_PATH, MY_IMAGE_TYPE);
            if (!$admin_profilepic['success'] || is_null($admin_profilepic['file']) || empty($admin_profilepic['file'])) :
                sendResponse(false, $admin_profilepic['msg']);
            endif;
            $postdata['admin_profilepic'] = ADMIN_UPLOAD_PATH . $admin_profilepic['file']['name'];
        }
        $flag = $this->admin_model->updateExisting($postdata, $postdata['admin_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        if ($_FILES['admin_profilepic']['error'] == 0) {
            unlink_my_file($row['admin_profilepic']);
        }
        $msg = 'Admin updated successfully.';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_user_list($get_latest = FALSE)
    {
        $where = [];
        if ($get_latest) {
            $where['user.created_at >='] = strtotime(LATEST_DATA_CRITERIA);
        }
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->user_model->getRecords($list_params);
        $list_params['where'] = array_merge($list_params['where'], ['web_subscription.is_premium_subscription' => 1]);
        $filtered_records = $this->user_model->getDatatableList($list_params);
        // showQuery();
        $params = [
            'module' => 'user',
            'primary_id' => 'user_id',
            'view_link' => 'view',
            // 'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                // ['type'=>'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'email'],
                ['type' => 'select', 'column' => 'email_verification_status'],
                ['type' => 'input', 'column' => 'wholesaler_user'],
                ['type' => 'input', 'column' => 'device_unique_id'],
                ['type' => 'input', 'column' => 'device_name'],
                ['type' => 'input', 'column' => 'product_id'],
                ['type' => 'daterange', 'column' => 'original_purchase_date_ms'],
                ['type' => 'daterange', 'column' => 'purchase_date_ms'],
                ['type' => 'daterange', 'column' => 'expires_date_ms'],
                ['type' => 'select', 'column' => 'is_trial_period'],
                ['type' => 'select', 'column' => 'is_expired'],
                ['type' => 'select', 'column' => 'is_deleted'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'daterange', 'column' => 'updated_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'user.user_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->user_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_guest_user_list($get_latest = FALSE)
    {
        $where = [];
        if ($get_latest) {
            $where['device.created_at >='] = strtotime(LATEST_DATA_CRITERIA);
        }
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->guest_user_model->getRecords($list_params);
        $list_params['where'] = array_merge($list_params['where'], ['web_subscription.is_premium_subscription' => 1]);
        $filtered_records = $this->guest_user_model->getDatatableList($list_params);
        // showQuery();
        $params = [
            'module' => 'guest-user',
            'primary_id' => 'user_device_id',
            'view_link' => 'view',
            // 'edit_modal' => 'edit',
            // 'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                // ['type'=>'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'wholesaler_user'],
                ['type' => 'input', 'column' => 'device_unique_id'],
                ['type' => 'input', 'column' => 'device_name'],
                ['type' => 'input', 'column' => 'product_id'],
                ['type' => 'daterange', 'column' => 'original_purchase_date_ms'],
                ['type' => 'daterange', 'column' => 'purchase_date_ms'],
                ['type' => 'daterange', 'column' => 'expires_date_ms'],
                ['type' => 'select', 'column' => 'is_trial_period'],
                ['type' => 'select', 'column' => 'is_expired'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'daterange', 'column' => 'updated_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'device.user_device_id', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->guest_user_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function get_country_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->country_model->getRecords($list_params);
        $filtered_records = $this->country_model->getDatatableList($list_params);
        $params = [
            'module' => 'country',
            'primary_id' => 'country_id',
            'view_link' => 'view',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                // ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'country'],
                ['type' => 'input', 'column' => 'country_code'],
                ['type' => 'select', 'column' => 'premium'],
                ['type' => 'select', 'column' => 'recommend'],
                //['type' => 'input', 'column' => 'flag'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'daterange', 'column' => 'updated_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'countries.updated_at', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->country_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function add_country()
    {
        $rules = [
            'country' => ['field' => 'country', 'label' => 'Country Name', 'rules' => 'required|trim'],
            'country_code' => ['field' => 'country_code', 'label' => 'Country Code', 'rules' => 'required|trim'],
            'premium' => ['field' => 'premium', 'label' => 'Premium', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $row = $this->country_model->checkIfExist($postdata['country']);
        if ($row) {
            sendResponse(false, 'Country name already exist.');
        }
        $insertData = $this->country_model->insertVPNServer($postdata);
        $this->session->set_flashdata('success', "Country added successfully.");
        sendResponse(true, "Success");
    }

    public function get_country_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['country_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->country_model->getRecords($row_params);
        $msg = 'Country fetched successfully.';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function update_country()
    {
        $rules = [
            'country_id' => ['field' => 'id', 'label' => 'ID', 'rules' => 'required|trim|is_natural_no_zero'],
            'country' => ['field' => 'country', 'label' => 'Country Name', 'rules' => 'required|trim'],
            'country_code' => ['field' => 'country_code', 'label' => 'Country Code', 'rules' => 'required|trim'],
            'premium' => ['field' => 'premium', 'label' => 'Premium status', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend status', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $row = $this->country_model->getRow($postdata['country_id']);
        if (!$row) {
            sendResponse(false, 'VPN details details does not exist');
        }
        $flag = $this->country_model->checkIfExist($postdata['country'], $postdata['country_id']);
        if ($flag) {
            sendResponse(false, 'Country name already exist');
        }
        $flag = $this->checkIfUpdated($postdata, $row);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->country_model->updateExisting($postdata, $postdata['country_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Country updated successfully.';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_vpn_server_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->vpn_server_model->getRecords($list_params);
        $filtered_records = $this->vpn_server_model->getDatatableList($list_params);
        $params = [
            'module' => 'vpn-server',
            'primary_id' => 'server_id',
            'view_link' => 'view',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                // ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'country_name'],
                ['type' => 'input', 'column' => 'ip_address'],
                ['type' => 'select', 'column' => 'recommend'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'daterange', 'column' => 'updated_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'vpn_servers.updated_at', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->vpn_server_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function add_vpn_server()
    {
        $rules = [
            'country_id' => ['field' => 'country_id', 'label' => 'Country Name', 'rules' => 'required|trim'],
            'ip_address' => ['field' => 'ip_address', 'label' => 'IP Address', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $flag = $this->vpn_server_model->checkIfExist($postdata['ip_address']);
        if ($flag) {
            sendResponse(false, 'Ip address already exist');
        }
        if (trim($_FILES['server_file']['name']) == '' || $_FILES['server_file']['error'] != 0 || $_FILES['server_file']['size'] == 0) {
            sendResponse(false, "Please add server file");
        }
        if ($_FILES['server_file']['error'] == 0) {
            $server_file = upload_my_file($_FILES['server_file'], SERVER_FILE_UPLOAD_PATH);
            if (!$server_file['success'] || is_null($server_file['file']) || empty($server_file['file'])) :
                sendResponse(false, $server_file['msg']);
            endif;
        }
        $getFile = $server_file['file']['name'];
        $getFile = SITE_URL . SERVER_FILE_UPLOAD_PATH . $server_file['file']['name'];
        $rows = file($getFile);
        $blacklist = "#";
        foreach ($rows as $key => $row) {
            if (preg_match("/($blacklist)/", $row)) {
                unset($rows[$key]);
            }
        }
        $data = [];
        $data[] = "client\r\n";
        foreach ($rows as $value) {
            if (!empty(trim($value))) {
                $data[] = $value;
            }
        }

        if (count($data) == 1) {
            sendResponse(false, "Please add server file");
        }
        $postdata['ovpn'] = implode("", $data);
        $insertData = $this->vpn_server_model->insertVPNServer($postdata);
        $this->session->set_flashdata('success', "Country added successfully.");
        sendResponse(true, "Success");
    }

    public function get_vpn_server_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['server_id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->vpn_server_model->getRecords($row_params);
        $msg = 'VPN server details fetched successfully.';
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function update_vpn_server()
    {
        $rules = [
            'server_id' => ['field' => 'id', 'label' => 'ID', 'rules' => 'required|trim|is_natural_no_zero'],
            'country_id' => ['field' => 'country_id', 'label' => 'Country name', 'rules' => 'required|trim'],
            'ip_address' => ['field' => 'ip_address', 'label' => 'IP address', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend status', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $singleRow = $this->vpn_server_model->getRow($postdata['server_id']);
        if (!$singleRow) {
            sendResponse(false, 'VPN details details does not exist');
        }
        $flag = $this->vpn_server_model->checkIfExist($postdata['ip_address'], $postdata['server_id']);
        // if ($flag) {
        //     sendResponse(false, 'Ip address already exist');
        // }
        if (trim($_FILES['server_file']['name']) != '' && $_FILES['server_file']['error'] == 0 && $_FILES['server_file']['size'] != 0) {
            if ($_FILES['server_file']['error'] == 0) {
                $server_file = upload_my_file($_FILES['server_file'], SERVER_FILE_UPLOAD_PATH);
                if (!$server_file['success'] || is_null($server_file['file']) || empty($server_file['file'])) :
                    sendResponse(false, $server_file['msg']);
                endif;
            }
            $getFile = $server_file['file']['name'];
            $getFile = SITE_URL . SERVER_FILE_UPLOAD_PATH . $server_file['file']['name'];
            $rows = file($getFile);
            $blacklist = "#";
            foreach ($rows as $key => $row) {
                if (preg_match("/($blacklist)/", $row)) {
                    unset($rows[$key]);
                }
            }

            $serverFileData = [];
            $serverFileData[] = "client\r\n";
            foreach ($rows as $value) {
                if (!empty(trim($value))) {
                    $serverFileData[] = $value;
                }
            }
            if (count($serverFileData) == 1) {
                sendResponse(false, "Please add valid server file");
            }
            $postdata['ovpn'] = implode("", $serverFileData);
        }
        $flag = $this->checkIfUpdated($postdata, $singleRow);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        $flag = $this->vpn_server_model->updateExisting($postdata, $postdata['server_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'VPN server updated successfully.';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }
    
    public function get_open_gate_server_list()
    {
        $where = [];
        $list_params = ['where' => $where, 'action' => 'count'];
        $total_records = $this->open_gate_server_model->getRecords($list_params);
        $filtered_records = $this->open_gate_server_model->getDatatableList($list_params);
        $params = [
            'module' => 'open-gate-server',
            'primary_id' => 'id',
            'view_link' => 'view',
            'edit_modal' => 'edit',
            'delete_link' => 'delete',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'input', 'column' => 'country'],
                ['type' => 'input', 'column' => 'country_code'],
                ['type' => 'input', 'column' => 'ip_address'],
                ['type' => 'input', 'column' => 'state'],
                ['type' => 'select', 'column' => 'premium'],
                ['type' => 'select', 'column' => 'recommend'],
                ['type' => 'select', 'column' => 'is_active'],
                ['type' => 'daterange', 'column' => 'created_at'],
                ['type' => 'actions']
            ]
        ];
        $dynamic_data = $this->datatable->generate_datatable_data($params);
        $postdata = $this->input->{$this->input->method()}();

        $list_params['action'] = 'list';
        $list_params['order'] = ['order' => 'open_get_server.updated_at', 'type' => 'DESC'];
        $list_params['limit'] = $postdata['length'];
        $list_params['offset'] = $postdata['start'];
        $list = $this->open_gate_server_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }

    public function add_open_gate_server()
    {
        $rules = [
            'country' => ['field' => 'country', 'label' => 'Country Name', 'rules' => 'required|trim'],
            'country_code' => ['field' => 'country_code', 'label' => 'Country Code', 'rules' => 'required|trim'],
            'ip_address' => ['field' => 'ip_address', 'label' => 'IP address', 'rules' => 'required|trim'],
            'state' => ['field' => 'state', 'label' => 'State name', 'rules' => 'required|trim'],
            'premium' => ['field' => 'premium', 'label' => 'Premium', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        if (trim($_FILES['server_file']['name']) == '' || $_FILES['server_file']['error'] != 0 || $_FILES['server_file']['size'] == 0) {
            sendResponse(false, "Please add server file");
        }
        if ($_FILES['server_file']['error'] == 0) {
            $server_file = upload_my_file($_FILES['server_file'], SERVER_FILE_UPLOAD_PATH);
            if (!$server_file['success'] || is_null($server_file['file']) || empty($server_file['file'])) :
                sendResponse(false, $server_file['msg']);
            endif;
        }
        $getFile = $server_file['file']['name'];
        $getFile = SITE_URL . SERVER_FILE_UPLOAD_PATH . $server_file['file']['name'];
        $rows = file($getFile);
        $blacklist = "#";
        foreach ($rows as $key => $row) {
            if (preg_match("/($blacklist)/", $row)) {
                unset($rows[$key]);
            }
        }
        $data = [];
        $data[] = "client\r\n";
        foreach ($rows as $value) {
            if (!empty(trim($value))) {
                $data[] = $value;
            }
        }

        if (count($data) == 1) {
            sendResponse(false, "Please add server file");
        }
        $postdata['ovpn'] = implode("", $data);
        $insertData = $this->open_gate_server_model->insertVPNServer($postdata);
        $msg = "Open gate server added successfully.";
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, "Success");
    }

    public function get_open_gate_server_details()
    {
        $rules = [
            'primary_id' => [
                'field' => 'primary_id', 'label' => 'Primary ID', 'rules' => 'required|trim|is_natural_no_zero',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $where = ['id' => $postdata['primary_id']];
        $row_params = ['where' => $where, 'action' => 'row'];
        $row = $this->open_gate_server_model->getRecords($row_params);
        $msg = 'Open gate server details fetched successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg, ['row' => $row]);
    }

    public function update_open_gate_server()
    {
        $rules = [
            'id' => ['field' => 'id', 'label' => 'ID', 'rules' => 'required|trim|is_natural_no_zero'],
            'country' => ['field' => 'country', 'label' => 'Country Name', 'rules' => 'required|trim'],
            'country_code' => ['field' => 'country_code', 'label' => 'Country Code', 'rules' => 'required|trim'],
            'ip_address' => ['field' => 'ip_address', 'label' => 'IP address', 'rules' => 'required|trim'],
            'state' => ['field' => 'state', 'label' => 'State name', 'rules' => 'required|trim'],
            'premium' => ['field' => 'premium', 'label' => 'Premium status', 'rules' => 'required|trim'],
            'recommend' => ['field' => 'recommend', 'label' => 'Recommend status', 'rules' => 'required|trim'],
            'is_active' => ['field' => 'is_active', 'label' => 'Status', 'rules' => 'required|trim'],
        ];
        checkIfValidated($rules);
        $postdata = $this->input->post();
        $singleRow = $this->open_gate_server_model->getRow($postdata['id']);
        if (!$singleRow) {
            sendResponse(false, 'Open gate details does not exist');
        }
        $flag = $this->open_gate_server_model->checkIfExist($postdata['country'], $postdata['id']);
        if ($flag) {
            sendResponse(false, 'Country name already exist');
        }
        

        if (trim($_FILES['server_file']['name']) != '' && $_FILES['server_file']['error'] == 0 && $_FILES['server_file']['size'] != 0) {
            if ($_FILES['server_file']['error'] == 0) {
                $server_file = upload_my_file($_FILES['server_file'], SERVER_FILE_UPLOAD_PATH);
                if (!$server_file['success'] || is_null($server_file['file']) || empty($server_file['file'])) :
                    sendResponse(false, $server_file['msg']);
                endif;
            }
            $getFile = $server_file['file']['name'];
            $getFile = SITE_URL . SERVER_FILE_UPLOAD_PATH . $server_file['file']['name'];
            $rows = file($getFile);
            $blacklist = "#";
            foreach ($rows as $key => $row) {
                if (preg_match("/($blacklist)/", $row)) {
                    unset($rows[$key]);
                }
            }
            
            $serverFileData = [];
            $serverFileData[] = "client\r\n";
            foreach ($rows as $value) {
                if (!empty(trim($value))) {
                    $serverFileData[] = $value;
                }
            }
            if (count($serverFileData) == 1) {
                sendResponse(false, "Please add valid server file");
            }
            $postdata['ovpn'] = implode("", $serverFileData);
        }
        
        $flag = $this->checkIfUpdated($postdata, $singleRow);
        if (!$flag) {
            sendResponse(false, NO_CHANGES_MADE);
        }
        
        $flag = $this->open_gate_server_model->updateExisting($postdata, $postdata['id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $msg = 'Open gate server updated successfully';
        $this->session->set_flashdata('success', $msg);
        sendResponse(true, $msg);
    }

    public function get_subscription_stat_list()
    {
        $where = [];
        $list_params = ['where' => $where,'action' => 'count'];
        $total_records = $this->subscription_stat_model->getRecords($list_params);
        $filtered_records = $this->subscription_stat_model->getDatatableList($list_params);
        $params = [
            'module' => 'Subscription Stat',
            'primary_id' => 'stat_id',
            'total_records' => $total_records,
            'filtered_records' => $filtered_records,
            'columns' => [
                ['type' => 'checkbox'],
                ['type' => 'counter', 'column' => 'counter'],
                ['type' => 'select', 'column' => 'store'],
                ['type' => 'daterange', 'column' => 'stat_date'],
                ['type' => 'input', 'column' => 'paid_subscribers'],
                ['type' => 'input', 'column' => 'trial_subscribers'],
                ['type' => 'input', 'column' => 'expired_subscribers'],
                ['type' => 'daterange', 'column' => 'created_date']
                ]
            ];
            $dynamic_data = $this->datatable->generate_datatable_data($params);
            $postdata = $this->input->{$this->input->method()}();
            $list_params['action'] = 'list';
            $list_params['order'] = ['order' => 'subscription_stats.updated_date', 'type' => 'DESC'];
            $list_params['limit'] = $postdata['length'];
            $list_params['offset'] = $postdata['start'];
            $list = $this->subscription_stat_model->getDatatableList($list_params);
        $this->datatable->get_datatable($list, $dynamic_data, $postdata);
    }
}
