<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Dashboard extends Administrator
{
    public function __construct(){
        parent::__construct();
        $this->load->model(['api_model','cron_model']);
    }

    public function index(){
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['singular_title'];
        $this->data['breadcrumb'] = [];
        $analytics = json_decode(file_get_contents(UPLOAD_PATH.'latest-analytics.json'),true);
        $this->data['stats'] = [
            'users' => $analytics['users'],
            'new_users' => $analytics['new_users'],
            'guest_users' => $analytics['guest_users'],
            'new_guest_users' => $analytics['new_guest_users'],
            'active_subscribers' => $analytics['active_users'],
            'expired_subscribers' => $analytics['expired_users'] ?? 0,
            'trial_subscribers' => $analytics['active_trial_users'],
            'auth_revenue' => $analytics['auth_revenue'],
            'active_guest_subscribers' => $analytics['active_guests'],
            'expired_guest_subscribers' => $analytics['expired_guests'],
            'trial_guest_subscribers' => $analytics['active_trial_guests'],
            'guest_revenue' => $analytics['guest_revenue'],
        ];
        $this->load->admin_auth_template($module.'/index', $this->data);
    }
}