<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Login extends Guest
{
    public function __construct(){
        parent::__construct();
        $this->data = [];
    }

    public function index(){
        $redirect = $this->session->flashdata('redirect-link');
        if(is_null($redirect)){
            $redirect = ADMIN_URL.'dashboard';
        }
        $this->data['page_title'] = 'Login';
        $this->data['forms'] = [
            'frm_login' => ['id' => 'frm_login', 'method' => 'POST'],
        ];
        $this->data['form_rules'] = [
            'frm_login' => [
                'email' => ['required' => true,'email' => true],
                'password' => ['required' => true,'minlength' => 6],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_login' => [
                'ajax_url' => ADMIN_GUEST_AJAX_URL.'check-login',
                'redirect_url' => $redirect,
            ],
        ];
        $this->load->admin_guest_template('login',$this->data);
    }
}