<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Subscription_stat extends Administrator
{
    public function __construct()
    {
        parent::__construct();
    }

    public function index(){
        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['module_title'], 'url' => ADMIN_URL . $module],
            ['title' => 'List', 'url' => ''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL . 'get-' . $module . '-list';

        $this->data['columns'] = [
            ['type' => 'counter'],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'store', 'label' => 'Store','options' => ['apple'=>'apple','android'=>'android'], 'list_params' => ['width' => '10%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'stat_date', 'label' => 'Stat Date', 'list_params' => ['width' => '10%']],
            ['type' => 'input','has_filter' => FALSE, 'id' => 'paid_subscribers', 'label' => 'Paid Subscribers','list_params' => ['width' => '8%']],
            ['type' => 'input','has_filter' => FALSE, 'id' => 'trial_subscribers', 'label' => 'Trial Subscribers','list_params' => ['width' => '8%']],
            ['type' => 'input','has_filter' => FALSE, 'id' => 'expired_subscribers', 'label' => 'Expired Subscribers','list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_date', 'label' => 'Created Date', 'list_params' => ['width' => '8%']],
        ];

        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'store' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'store', 'id' => 'store', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'stat_date' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'stat_date', 'id' => 'stat_date', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
                'created_date' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_date', 'id' => 'created_date', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ]
            ],
        ];

        $this->load->admin_auth_template($module . '/list', $this->data);
    }
}