<?php
defined('BASEPATH') or exit('No direct script access allowed');
class Vpn_server extends Administrator
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model(['open_gate_server_model']);
    }

    public function index()
    {

        $module = $this->data['module'];
        $this->data['page_title'] = $this->data['module_title'];
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['module_title'], 'url' => ADMIN_URL . $module],
            ['title' => 'List', 'url' => ''],
        ];
        $this->data['datatable_url'] = ADMIN_AJAX_URL . 'get-' . $module . '-list';
        $this->data['columns'] = [
            ['type' => 'counter'],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'country_name', 'label' => 'Country Name', 'list_params' => ['width' => '15%']],
            ['type' => 'input', 'has_filter' => TRUE, 'id' => 'ip_address', 'label' => 'IP Address', 'list_params' => ['width' => '10%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'recommend', 'label' => 'Recommend', 'options' => YES_NO_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'select', 'has_filter' => TRUE, 'id' => 'is_active', 'label' => 'Status', 'options' => ACTIVE_INACTIVE_OPTIONS, 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'created_at', 'label' => 'Created at', 'list_params' => ['width' => '8%']],
            ['type' => 'daterange', 'has_filter' => TRUE, 'id' => 'updated_at', 'label' => 'Updated at', 'list_params' => ['width' => '8%']],
            ['type' => 'actions', 'has_filter' => FALSE, 'label' => 'Action', 'list_params' => ['width' => '5%', 'class' => 'action-column', 'data-orderable' => 'false', 'data-searchable' => 'false']],
        ];
        $this->data['forms'] = [
            'frm_add' => ['id' => 'frm_add', 'method' => 'POST', 'autocomplete' => 'off', "enctype" => "multipart/form-data"],
            'frm_edit' => ['id' => 'frm_edit', 'method' => 'POST', 'autocomplete' => 'off', "enctype" => "multipart/form-data"],
        ];
        $this->data['form_rules'] = [
            'frm_add' => [
                'country_id' => ['required' => TRUE],
                'ip_address' => ['required' => TRUE],
                'recommend' => ['required' => TRUE],
                'is_active' => ['required' => TRUE],
            ],
            'frm_edit' => [
                'country_id' => ['required' => TRUE],
                'ip_address' => ['required' => TRUE],
                'recommend' => ['required' => TRUE],
                'is_active' => ['required' => TRUE],
            ],
        ];
        $this->data['form_ajax'] = [
            'frm_add' => [
                'ajax_url' => ADMIN_AJAX_URL . 'add-' . $module,
                'redirect_url' => ADMIN_URL . $module,
            ],
            'frm_edit' => [
                'ajax_url' => ADMIN_AJAX_URL . 'update-' . $module,
                'redirect_url' => ADMIN_URL . $module,
            ],
        ];
        $this->data['form_filter'] = [
            'id' => 'frm_filter',
            'class' => 'frm_filter',
            'fields' => [
                'country_name' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'country_name', 'id' => 'country_name', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'ip_address' => [
                    'class' => 'form-control',
                    'type' => 'text', 'name' => 'ip_address', 'id' => 'ip_address', 'placeholder' => 'Enter text here',
                    'style' => 'display: none',
                ],
                'premium' => [
                    'class' => 'form-control',
                    'name' => 'premium', 'id' => 'premium',
                    'style' => 'display: none',
                ],
                'recommend' => [
                    'class' => 'form-control',
                    'name' => 'recommend', 'id' => 'recommend',
                    'style' => 'display: none',
                ],
                'is_active' => [
                    'class' => 'form-control',
                    'name' => 'is_active', 'id' => 'is_active',
                    'style' => 'display: none',
                ],
                'created_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'created_at', 'id' => 'created_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
                'updated_at' => [
                    'class' => 'form-control dateranges',
                    'type' => 'text', 'name' => 'updated_at', 'id' => 'updated_at', 'placeholder' => 'Select datetime range',
                    'style' => 'display: none',
                ],
            ],
        ];
        $this->data['countries'] = $this->country_model->getRecords(['order' => ['order' => 'updated_at', 'type' => 'DESC']]);
        $this->load->admin_auth_template($module . '/list', $this->data);
    }

    public function view($id = NULL)
    {
        if (!$id) {
            show_custom_404();
        }
        $user = $this->vpn_server_model->getRow($id);
        if (!$user) {
            show_custom_404();
        }

        $module = $this->data['module'];
        $this->data['page_title'] = singular($this->data['module_title']);
        $this->data['breadcrumb'] = [
            ['title' => 'Home', 'url' => ADMIN_URL],
            ['title' => $this->data['module_title'], 'url' => ADMIN_URL . $module],
            ['title' => 'View', 'url' => ''],
        ];
        $this->data['vpn_server_details'] = $this->vpn_server_model->getRow($id, "Admin");
        $this->load->admin_auth_template($module . '/view', $this->data);
    }
}
