<?php
defined('BASEPATH') or exit('No direct script access allowed');

use \Firebase\JWT\JWT;

class V1 extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
        $_REQUEST['lang'] = $_REQUEST['lang'] ?? 'en';
        $_REQUEST['lang'] = (!empty($_REQUEST['lang'])) ? $_REQUEST['lang'] : 'en';
        $_REQUEST['lang'] = (is_dir(APPPATH . 'language/' . $_REQUEST['lang'] . '/')) ? $_REQUEST['lang'] : 'en';
        $this->lang->load('dev_messages', $_REQUEST['lang'] ?? 'en');
        $this->load->library('vpn');
        $this->load->model(['api_model', 'webhook_model']);
        mylog($this->router->fetch_method());
        mylog($this->input->request_headers());
        $this->getPostdata();
    }

    private function getPostdata()
    {
        $postdata = $this->input->post();
        $content_type = getallheaders()['Content-Type'] ?? getallheaders()['content-type'] ?? 'application/x-www-form-urlencoded';
        if ($content_type == 'application/json') {
            $jsonreq = json_decode($this->input->raw_input_stream, true);
            if (!$jsonreq) {
                sendResponse(false, INVALID_JSON_REQUEST);
            }
            $postdata = array_merge($postdata, $jsonreq);
        } elseif ($content_type == 'text/plain') {
            parse_str($this->input->raw_input_stream, $plainreq);
            $postdata = array_merge($postdata, $plainreq);
        }/* elseif(getallheaders()['Content-Type'] == 'application/x-www-form-urlencoded'){
            $postdata = $this->input->post();
        }else{
            $postdata = $this->input->post();
        } */
        $_POST = array_merge($_POST, $postdata);
        mylog($_POST);
        return $_POST;
    }

    private function checkIfAuthorized()
    {
        $authHeader = getallheaders()['Authorization'] ?? '';
        if (empty($authHeader)) {
            return false;
        }
        $jwtToken = explode(" ", $authHeader)[1];
        try {
            if ($userdata = is_sample_token($jwtToken)) {
                return $userdata;
            } else {
                $decoded = JWT::decode($jwtToken, JWT_SECRET_KEY, array('HS256'));
                $userdata = (array) $decoded->data;
                mylog("Authorization => " . json_encode($userdata));
                return $userdata;
            }
        } catch (Exception $e) {
            sendResponse(false, $e->getMessage());
        }
    }

    private function getAuthorizedUser()
    {
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        $where = ['user.user_id' => $userdata['user_id'], 'device.user_device_id' => $userdata['user_device_id'], 'user.is_deleted' => FALSE];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        return $row;
    }

    private function getAuthorizedAndroidUser()
    {
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        $where = ['user.email' => $this->input->post('email'), 'device.device_unique_id' => $userdata['device_unique_id']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        return $row;
    }

    private function getAuthorizedGuest()
    {
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        $row = $this->api_model->getDeviceDetails(['device.user_device_id' => $userdata['user_device_id']]);
        if (!$row) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        return $userdata;
    }

    public function send_email_confirmation_link()
    {
        $postdata = $this->getPostdata();
        $postdata['user_id'] = $postdata['user_id'] ?? '';
        $postdata['email'] = $postdata['email'] ?? '';
        if (!empty($postdata['user_id']) && !empty($postdata['email'])) {
            $code = $this->api_model->getUserEmailVerificationData($postdata['user_id']);
            $email_verification_link = "";
            if (IS_LIVE) {
                $email_verification_link = WEB_URL . 'verification/email/' . $postdata['email'] . '/' . $code['email_verification_code'];
            } else {
                $email_verification_link = WEB_URL . 'verification/mail/' . $postdata['email'] . '/' . $code['email_verification_code'];
            }
            $email_verification_link = str_replace(['@'], ['-at-'], $email_verification_link);
            $email_params = [
                'fullname' => 'User',
                'email_verification_link' => $email_verification_link,
                'email' => $postdata['email']
            ];
            mylog($email_params);
            $result = $this->sendmail->verify_your_email($email_params);
            mylog("Email Status - " . $result);
        } else {
            mylog('User ID or Email not found');
        }
    }

    public function send_email_confirmation_otp()
    {
        $postdata = $this->getPostdata();
        $postdata['user_id'] = $postdata['user_id'] ?? '';
        $postdata['email'] = $postdata['email'] ?? '';
        if (!empty($postdata['user_id']) && !empty($postdata['email'])) {
            $code = $this->api_model->getUserEmailVerificationData($postdata['user_id']);
            // pre($code);
            $email_params = [
                'fullname' => 'User',
                'email_verification_otp' => $code['email_verification_code'],
                'email' => $postdata['email']
            ];
            mylog($email_params);
            $result = $this->sendmail->verify_your_email_with_otp($email_params);
            mylog("Email Status - " . $result);
        } else {
            mylog('User ID or Email not found');
        }
    }

    public function send_reset_password_link()
    {
        $postdata = $this->getPostdata();
        $postdata['user_id'] = $postdata['user_id'] ?? '';
        if (!empty($postdata['user_id'])) {
            $code = $this->api_model->getPasswordResetToken($postdata['user_id']);
            if ($code) {
                $code = $this->api_model->updatePasswordResetToken($postdata['user_id']);
            } else {
                $code = $this->api_model->insertPasswordResetToken($postdata['user_id']);
            }
            $reset_password_link = "";
            if (IS_LIVE) {
                $reset_password_link = WEB_URL . 'reset-password/recover/' . $code['password_token'];
            } else {
                $reset_password_link = WEB_URL . 'reset-password/generate/' . $code['password_token'];
            }
            $email_params = [
                'fullname' => 'User',
                'reset_password_link' => $reset_password_link,
                'email' => $code['email']
            ];
            mylog($email_params);
            $result = $this->sendmail->user_reset_password($email_params);
            mylog("Email Status - " . $result);
        } else {
            mylog('User ID not found');
        }
    }

    public function send_reset_password_otp()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $postdata['user_id'] = $postdata['user_id'] ?? '';
        if (!empty($postdata['user_id'])) {
            $code = $this->api_model->getPasswordResetCode($postdata['user_id']);
            if ($code) {
                $code = $this->api_model->updatePasswordResetCode($postdata['user_id'], $postdata['email']);
            } else {
                $code = $this->api_model->insertPasswordResetCode($postdata['user_id'], $postdata['email']);
            }
            if (!$code) {
                mylog('Data not found -- ' . json_encode($postdata));
            }
            $email_params = [
                'fullname' => 'User',
                'reset_password_otp' => $code['password_token'],
                'email' => $postdata['email']
            ];
            mylog($email_params);
            $result = $this->sendmail->user_reset_password_otp($email_params);
            mylog("Email Status - " . $result);
        } else {
            mylog('User ID not found');
        }
    }

    public function guest_login()
    {
        $rules = [
            'device_unique_id' => [
                'field' => 'device_unique_id', 'label' => 'Device ID', 'rules' => 'required|trim'
            ],
            'device_name' => [
                'field' => 'device_name', 'label' => 'Device Name', 'rules' => 'required|trim'
            ],
            'device_token' => [
                'field' => 'device_token', 'label' => 'Device Token', 'rules' => 'trim'
            ],
            'app_version' => [
                'field' => 'app_version', 'label' => 'App Version', 'rules' => 'trim|required'
            ],
            'device_type' => [
                'field' => 'device_type', 'label' => 'Device Type', 'rules' => 'trim|in_list[I,A,M,H,AMZ,Other]'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();

        $where = ['device.device_unique_id' => $postdata['device_unique_id']];
        $device = $this->api_model->getDeviceDetails($where);
        if (!$device) {
            $device = $this->api_model->insertDeviceData($postdata);
        }else{
            $device = $this->api_model->updateDevice($postdata);
        }
        $userDetails = $this->api_model->getUserDeviceDetails(['device.user_device_id' => $device['user_device_id']]);
        $userDetails['user_id'] = null;
        $token = ["exp" => JWT_EXPIRE_CLAIM, "data" => $userDetails];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);

        $output = [
            'user' => formatRow($userDetails),
            'token' => $jwt,
        ];
        sendResponse(true, $this->lang->line('guest_logged_in_success'), $output);
    }

    /* public function signup(){
        $user = $this->getAuthorizedGuest();
        $_POST['signup_type'] = 'email';
        $_POST['phone'] = str_replace('-','',$_POST['phone'] ?? '');
        $postdata = $this->getPostdata();
        $user_rules = [
            'firstname'=>[
                'field'=>'firstname','label'=>'Firstname','rules'=>'trim'
            ],
            'lastname'=>[
                'field'=>'lastname','label'=>'Lastname','rules'=>'trim'
            ],
        ];
        $email_rules = [
            'email'=>[
                'field'=>'email','label'=>'Email','rules'=>'required|trim|valid_email'
            ],
        ];
        $rules = [
            'signup_type'=>[
                'field'=>'signup_type','label'=>'Signup Type','rules'=>'required|trim|in_list[email,phone]'
            ],
            'password'=>[
                'field'=>'password','label'=>'Password','rules'=>'trim|required|min_length[6]'
            ]
        ];
        $rules = array_merge($rules, $user_rules, $email_rules);
        checkIfValidated($rules);

        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if($row){
            sendResponse(false, $this->lang->line('email_already_exist'));
        }

        if(isset($_FILES['profilepic']['name']) && !empty($_FILES['profilepic']['name'])){
            $file = upload_my_file($_FILES['profilepic'], PROFILE_PIC_PATH, MY_IMAGE_TYPE);
            if (!$file['success'] || is_null($file['file']) || empty($file['file'])):
                sendResponse(false, $file['msg']);
            endif;
            $postdata['profilepic'] = PROFILE_PIC_PATH . $file['file']['name'];
        }

        $postdata['user_device_id'] = $user['user_device_id'];
        $postdata['is_profile_completed'] = 1;
        $userDetails = $this->api_model->registerUserDetails($postdata);
        if(!$userDetails){
            sendResponse(false, SYSTEM_ERROR);
        }

        // Sending verification email
        $this->send_email_confirmation_link($userDetails);

        $row = formatRow($userDetails);
        $token = ["exp" => JWT_EXPIRE_CLAIM,"data" => $row];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);
        
        $output = [
            'user'=>formatRow($row),
            'token'=>$jwt,
        ];
        sendResponse(true, $this->lang->line('user_registered_success'), $output);
    }

    public function login(){
        $user = $this->getAuthorizedGuest();
        $_POST['login_type'] = 'email';
        $email_rules = [
            'email'=>[
                'field'=>'email','label'=>'Email','rules'=>'required|trim|valid_email'
            ],
        ];
        $rules = [
            'login_type'=>[
                'field'=>'login_type','label'=>'Login Type','rules'=>'required|trim|in_list[email,phone]'
            ],
            'password'=>[
                'field'=>'password','label'=>'Password','rules'=>'trim|required|min_length[6]'
            ],
        ];
        $rules = array_merge($rules, $email_rules);
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if(!$row){
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        $deviceWhere = ['device.user_device_id' => $user['user_device_id']];
        $device = $this->api_model->getDeviceDetails($deviceWhere);
        $userPassRow = $this->api_model->getUserPassword($row['user_id']);
        if(!password_verify($postdata['password'], $userPassRow['password'])){
            sendResponse(false, $this->lang->line('incorrect_email_password'));
        }
        $flag = $this->api_model->bindUserDevice($row['user_id'], $user['user_device_id']);
        if(!$flag){
            sendResponse(false, SYSTEM_ERROR);
        }
        $where = [
            'user.email' => $postdata['email'],
            'device.device_unique_id' => $device['device_unique_id']
        ];
        $userrow = $this->api_model->checkIfUserExist($where);
        $token = ["exp" => JWT_EXPIRE_CLAIM,"data" => $userrow];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);
        
        $output = [
            'user'=>formatRow($userrow),
            'token'=>$jwt,
        ];
        sendResponse(true, $this->lang->line('login_success'), $output);
    } */

    // Login/Signup Merged
    public function login()
    {
        $user = $this->getAuthorizedGuest();
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
            'password' => [
                'field' => 'password', 'label' => 'Password', 'rules' => 'trim|required|min_length[6]'
            ],
            'verification_type' => [
                'field' => 'verification_type', 'label' => 'Verification Type', 'rules' => 'trim|in_list[link,otp]'
            ]
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if ($row) {
            $this->login_api($postdata, $user, $row);
        } else {
            if ($user['device_type'] == 'A') {
                $token = ["exp" => JWT_EXPIRE_CLAIM, "data" => $user];
                $jwt = JWT::encode($token, JWT_SECRET_KEY);

                $curl_params = [
                    'method' => 'POST',
                    'url' => STAG_API_URL . 'get-stag-user-data',
                    'payload' => $postdata,
                    'headers' => ['Authorization: Bearer ' . $jwt]
                ];
                $response = $this->curl->call($curl_params);
                if ($response['success']) {
                    $old_data = $response['data'];

                    unset($old_data['user']['user_id']);
                    $new_user_id = $this->api_model->insertUserRowIfDoesNotExist($old_data['user']);
                    if (!$new_user_id) {
                        sendResponse(false, SYSTEM_ERROR);
                    }
                    if ($old_data['pass_token']) {
                        unset($old_data['pass_token']['password_token_id']);
                        $old_data['pass_token']['user_id'] = $new_user_id;
                        $token_flag = $this->api_model->insertPasswordTokenDetails($old_data['pass_token']);
                        if (!$token_flag) {
                            sendResponse(false, SYSTEM_ERROR);
                        }
                    }
                    if ($old_data['verify_email']) {
                        unset($old_data['verify_email']['email_verification_id']);
                        $old_data['verify_email']['user_id'] = $new_user_id;
                        $verify_flag = $this->api_model->insertEmailVerificationDetails($old_data['verify_email']);
                        if (!$verify_flag) {
                            sendResponse(false, SYSTEM_ERROR);
                        }

                        if ($old_data['verify_email']['email_verification_status'] == "0") {
                            $verification_type = $postdata['verification_type'] ?? 'link';
                            if (empty($verification_type)) {
                                $verification_type = 'link';
                            }

                            // Sending verification email
                            switch ($verification_type) {
                                case 'link':
                                    // $this->send_email_confirmation_link($userDetails);
                                    mylog(API_URL . 'send-email-confirmation-link');
                                    mylog(['user_id' => $new_user_id, 'email' => $old_data['user']['email']]);
                                    $this->async->process(API_URL . 'send-email-confirmation-link', ['user_id' => $new_user_id, 'email' => $old_data['user']['email']]);
                                    break;

                                case 'otp':
                                    // $this->send_email_confirmation_otp($userDetails);
                                    mylog(API_URL . 'send-email-confirmation-otp');
                                    mylog(['user_id' => $new_user_id, 'email' => $old_data['user']['email']]);
                                    $this->async->process(API_URL . 'send-email-confirmation-otp', ['user_id' => $new_user_id, 'email' => $old_data['user']['email']]);
                                    break;
                            }
                        }
                    }

                    $new_reg_devices = [];
                    $my_device_id = NULL;
                    if ($old_data['devices'] && !empty($old_data['devices']) && count($old_data['devices']) > 0) {
                        foreach ($old_data['devices'] as $device) {
                            $temp_device = $this->api_model->regiserUserDeviceIfDoesNotExist($device);
                            if ($temp_device['device_unique_id'] == $user['device_unique_id']) {
                                $my_device_id = $temp_device['user_device_id'];
                            }
                            $new_reg_devices[$device['user_device_id']] = $temp_device;
                        }
                    }
                    if ($old_data['logins'] && !empty($old_data['logins']) && count($old_data['logins']) > 0) {
                        $old_data['logins'] = array_map(function ($login)
                        use ($new_user_id, $new_reg_devices) {
                            unset($login['user_device_login_id']);
                            $login['user_id'] = $new_user_id;
                            $login['user_device_id'] = $new_reg_devices[$login['user_device_id']]['user_device_id'];
                            return $login;
                        }, $old_data['logins']);
                        $login_import_flag = $this->api_model->importLoginData($old_data['logins']);
                        if (!$login_import_flag) {
                            sendResponse(false, SYSTEM_ERROR);
                        }
                    }
                    if ($old_data['transactions'] && !empty($old_data['transactions']) && count($old_data['transactions']) > 0) {
                        foreach ($old_data['transactions'] as $transaction_batch) {
                            $transaction_ids = array_column($transaction_batch, 'transaction_id');
                            $stored_transactions = $this->user_model->getWebhookDataFromTransactionIds($transaction_ids);
                            $stored_transaction_ids = array_column($this->user_model->getWebhookDataFromTransactionIds($transaction_ids), 'transaction_id');
                            $diff = array_diff($transaction_ids, $stored_transaction_ids);
                            if (!empty($diff) && count($diff) > 0) {
                                $new_transactions = [];
                                $diff = array_map(function ($diff_transaction) use ($transaction_batch, &$new_transactions) {
                                    $transaction_pos = array_search($diff_transaction, array_column($transaction_batch, 'transaction_id'));
                                    if ($transaction_pos) {
                                        $new_transactions[] = $transaction_batch[$transaction_pos];
                                    }
                                    return $diff_transaction;
                                }, $diff);
                                $webhook_flag = $this->api_model->importWebhookData($new_transactions);
                                if (!$webhook_flag) {
                                    sendResponse(false, SYSTEM_ERROR);
                                }
                            }
                        }
                    }
                    if ($old_data['subs_mappings'] && !empty($old_data['subs_mappings']) && count($old_data['subs_mappings']) > 0) {
                        $old_data['subs_mappings'] = array_map(function ($mapping)
                        use ($new_user_id, $new_reg_devices) {
                            unset($mapping['user_subscription_id']);
                            $mapping['user_id'] = $new_user_id;
                            $mapping['user_device_id'] = $new_reg_devices[$mapping['user_device_id']]['user_device_id'];
                            return $mapping;
                        }, $old_data['subs_mappings']);
                        $login_import_flag = $this->api_model->importUserSubscriptionData($old_data['subs_mappings']);
                        if (!$login_import_flag) {
                            sendResponse(false, SYSTEM_ERROR);
                        }
                    }
                    $this->login_api($postdata, $user);
                } else {
                    $this->signup_api($postdata, $user);
                }
            } else {
                $this->signup_api($postdata, $user);
            }
        }
    }

    private function signup_api($postdata, $user)
    {
        mylog('Signup API');
        $verification_type = $postdata['verification_type'] ?? 'link';
        if (empty($verification_type)) {
            $verification_type = 'link';
        }
        $postdata['signup_type'] = 'email';
        $postdata['user_device_id'] = $user['user_device_id'];
        $postdata['is_profile_completed'] = 1;
        $userDetails = $this->api_model->registerUserDetails($postdata);
        if (!$userDetails) {
            sendResponse(false, SYSTEM_ERROR);
        }

        // Sending verification email
        switch ($verification_type) {
            case 'link':
                // $this->send_email_confirmation_link($userDetails);
                mylog(API_URL . 'send-email-confirmation-link');
                mylog(['user_id' => $userDetails['user_id'], 'email' => $userDetails['email']]);
                $this->async->process(API_URL . 'send-email-confirmation-link', ['user_id' => $userDetails['user_id'], 'email' => $userDetails['email']]);
                break;

            case 'otp':
                // $this->send_email_confirmation_otp($userDetails);
                mylog(API_URL . 'send-email-confirmation-otp');
                mylog(['user_id' => $userDetails['user_id'], 'email' => $userDetails['email']]);
                $this->async->process(API_URL . 'send-email-confirmation-otp', ['user_id' => $userDetails['user_id'], 'email' => $userDetails['email']]);
                break;
        }

        $userrow = formatRow($userDetails);
        $token = ["exp" => JWT_EXPIRE_CLAIM, "data" => $userrow];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);

        $output = ['user' => formatRow($userrow), 'token' => $jwt];
        sendResponse(true, $this->lang->line('user_registered_success'), $output);
    }

    private function login_api($postdata, $user, $row = NULL)
    {
        mylog('Login API');
        if(!$row){
            $where = ['user.email' => $postdata['email'],'user.is_deleted' => FALSE];
            $row = $this->api_model->checkIfUserExist($where);
        }
        if(boolval($row['is_deleted'])){
            $activeFlag = $this->user_model->activateAccount($row['user_id']);
            if(!$activeFlag){
                sendResponse(false, getDBError());
            }
        }
    
        $deviceWhere = ['device.user_device_id' => $user['user_device_id']];
        $device = $this->api_model->getDeviceDetails($deviceWhere);
        $userPassRow = $this->api_model->getUserPassword($row['user_id']);
        if (!password_verify($postdata['password'], $userPassRow['password'])) {
            sendResponse(false, $this->lang->line('incorrect_email_password'));
        }
        $flag = $this->api_model->bindUserDevice($row['user_id'], $user['user_device_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $where = [
            'user.email' => $postdata['email'],
            'device.device_unique_id' => $device['device_unique_id'],
            'user.is_deleted' => FALSE
        ];
        $userrow = $this->api_model->checkIfUserExist($where);
        $token = ["exp" => JWT_EXPIRE_CLAIM, "data" => $userrow];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);

        $output = ['user' => formatRow($userrow), 'token' => $jwt];
        sendResponse(true, $this->lang->line('login_success'), $output);
    }

    public function get_stag_user_data()
    {
        $userrow = $this->getAuthorizedAndroidUser();
        if ($userrow) {
            $transaction_params = [
                'where' => ['user.user_id' => $userrow['user_id']],
                'order' => ['order' => 'web_subscription.webhook_subscription_id', 'type' => 'ASC']
            ];
            $subs_mapping_params = [
                'where' => ['user.user_id' => $userrow['user_id']],
                'order' => ['order' => 'usubscription.user_subscription_id', 'type' => 'ASC']
            ];
            $userdata = [
                'user' => $this->api_model->get_full_user_info($userrow['user_id']),
                'devices' => $this->api_model->get_full_user_devices_info($userrow['user_id'], 'device.*'),
                'logins' => $this->api_model->get_full_user_devices_info($userrow['user_id'], 'device_user.*'),
                'pass_token' => $this->api_model->get_full_user_pass_tokens_info($userrow['user_id']),
                'verify_email' => $this->api_model->get_full_user_verify_email_info($userrow['user_id']),
                'transactions' => $this->user_model->getTransactionsFull($transaction_params),
                'subs_mappings' => $this->user_model->getTransactionMappings($subs_mapping_params),
            ];
            $userdata['transactions'] = array_chunk($userdata['transactions'], 500);
            sendResponse(true, $this->lang->line('login_success'), $userdata);
        } else {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
    }

    public function forgot_password()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email'], 'user.is_deleted' => FALSE];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        // $this->send_reset_password_link($row);
        mylog(API_URL . 'send-reset-password-link');
        mylog(['user_id' => $row['user_id']]);
        $this->async->process(API_URL . 'send-reset-password-link', ['user_id' => $row['user_id']]);
        sendResponse(true, $this->lang->line('reset_password_link_sent'));
    }

    public function forgot_password_with_otp()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        // $this->send_reset_password_otp($row);
        mylog(API_URL . 'send-reset-password-otp');
        mylog(['user_id' => $row['user_id'], 'email' => $postdata['email']]);
        $this->async->process(API_URL . 'send-reset-password-otp', ['user_id' => $row['user_id'], 'email' => $postdata['email']]);
        sendResponse(true, $this->lang->line('password_reset_code_sent'));
    }

    public function check_for_valid_reset_code()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
            'otp' => [
                'field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|is_numeric|exact_length[4]'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        // $this->send_reset_password_otp($row);
        $row = $this->api_model->getPasswordCodeDetails($postdata['otp'], $postdata['email']);
        $msg = $this->lang->line('password_reset_code_verified');
        if (!boolval($row)) {
            $msg = $this->lang->line('incorrect_password_reset_code');
        }
        sendResponse(true, $msg, ['is_valid_code' => boolval($row)]);
    }

    public function reset_password_with_otp()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
            'otp' => [
                'field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|is_numeric|exact_length[4]'
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        // $this->send_reset_password_otp($row);
        $row = $this->api_model->getPasswordCodeDetails($postdata['otp'], $postdata['email']);
        if (!$row) {
            sendResponse(false, $this->lang->line('incorrect_password_reset_code'));
        }
        if (password_verify($postdata['new_password'], $row['password'])) {
            sendResponse(false, $this->lang->line('new_password_same_as_old'));
        } else {
            $flag = $this->api_model->updateUserDetails($row['user_id'], ['password' => $postdata['new_password']]);
            if ($flag === FALSE) :
                sendResponse(false, SYSTEM_ERROR);
            endif;
            $this->api_model->verifyPasswordResetToken($row['user_id']);
            sendResponse(true, $this->lang->line('password_reset_success'));
        }
    }

    public function reset_password_with_token()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
            'token' => [
                'field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|exact_length[15]'
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'required|min_length[6]',
            ],
            'confirm_password' => [
                'field' => 'confirm_password', 'label' => 'Email', 'rules' => 'required|min_length[6]|matches[new_password]',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        }
        $row = $this->api_model->getPasswordTokenDetails($postdata['token'], $postdata['email']);
        if (!$row) {
            sendResponse(false, $this->lang->line('incorrect_password_reset_code'));
        }
        if (password_verify($postdata['new_password'], $row['password'])) {
            sendResponse(false, $this->lang->line('new_password_same_as_old'));
        } else {
            $flag = $this->api_model->updateUserDetails($row['user_id'], ['password' => $postdata['new_password']]);
            if ($flag === FALSE) :
                sendResponse(false, SYSTEM_ERROR);
            endif;
            $this->api_model->verifyPasswordResetToken($row['user_id']);
            sendResponse(true, $this->lang->line('password_reset_success'));
        }
    }

    public function verify_my_email()
    {
        $rules = [
            'email' => [
                'field' => 'email', 'label' => 'Email', 'rules' => 'required|trim|valid_email'
            ],
            'code' => [
                'field' => 'code', 'label' => 'Verification Code', 'rules' => 'required|trim|exact_length[15]'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $postdata['email']];

        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        } else {
            $code = $postdata['code'];
            $verification = $this->api_model->getUserEmailVerificationData($row['user_id']);
            $code_expire_at = (1 * CALC_DAYS) + $verification['email_verification_sent_at'];
            if ($verification['email_verification_code'] != $code || time() >= $code_expire_at) {
                sendResponse(false, 'Verification link has been expired');
            } else {
                $this->api_model->verifyEmail($row['user_id'], $code);
                sendResponse(true, 'Email verified successfully');
            }
        }
    }

    public function verify_my_email_with_otp()
    {
        $user = $this->getAuthorizedUser();
        $rules = [
            'otp' => [
                'field' => 'otp', 'label' => 'OTP', 'rules' => 'required|trim|is_numeric|exact_length[4]'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['user.email' => $user['email']];
        $row = $this->api_model->checkIfUserExist($where);
        if (!$row) {
            sendResponse(false, $this->lang->line('unregistered_email'));
        } else {
            $code = $postdata['otp'];
            $verification = $this->api_model->getUserEmailVerificationData($row['user_id']);
            $code_expire_at = (14 * CALC_DAYS) + $verification['email_verification_sent_at'];
            if ($verification['email_verification_code'] != $code || time() >= $code_expire_at) {
                sendResponse(false, $this->lang->line('verification_otp_expired'));
            } else {
                $this->api_model->verifyEmail($row['user_id'], $code);
                $where = [
                    'user.email' => $user['email'],
                    'device.device_unique_id' => $user['device_unique_id'],
                ];
                $userrow = $this->api_model->checkIfUserExist($where);
                $output = ['user' => formatRow($userrow)];
                sendResponse(true, $this->lang->line('email_verified_success'), $output);
            }
        }
    }

    /* public function social_login(){
        $_POST['phone'] = str_replace('-','',$_POST['phone'] ?? '');
        $postdata = $this->getPostdata();
        $social_rules = [
            'social_id'=>[
                'field'=>'social_id','label'=>'Social ID','rules'=>'required|trim'
            ],
        ];
        $rules = [
            'signup_type'=>[
                'field'=>'signup_type','label'=>'Signup Type','rules'=>'required|trim|in_list[facebook,google,apple]'
            ],
            'device_unique_id'=>[
                'field'=>'device_unique_id','label'=>'Device ID','rules'=>'required|trim'
            ],
            'device_token'=>[
                'field'=>'device_token','label'=>'Device Token','rules'=>'trim'
            ],
        ];
        $rules = array_merge($rules, $social_rules);
        checkIfValidated($rules);
        
        $where = ['user.social_id'=>$postdata['social_id'],'user.signup_type'=>$postdata['signup_type']];
        $row = $this->api_model->checkIfUserExist($where);
        if(!$row){
            if(!empty($postdata['email'])){
                $email_rules = [
                    'email'=>[
                        'field'=>'email','label'=>'Email','rules'=>'trim|valid_email'
                    ],
                ];
                checkIfValidated($email_rules);
                $row = $this->api_model->checkIfUserExist(['user.email' => $postdata['email']]);
                if($row){
                    sendResponse(false, 'Email address already registered with another account');
                }
            }
            if(!empty($postdata['phone'])){
                $phone_rules = [
                    'std_code'=>[
                        'field'=>'std_code','label'=>'STD Code','rules'=>'trim|numeric'
                    ],
                    'phone'=>[
                        'field'=>'phone','label'=>'phone','rules'=>'trim|numeric|min_length[7]|max_length[12]'
                    ],
                ];
                checkIfValidated($phone_rules);
                $row = $this->api_model->checkIfUserExist(['user.phone' => $postdata['phone']]);
                if($row){
                    sendResponse(false, 'Phone number already registered with another account');
                }
            }
            $postdata['firstname'] = $postdata['firstname']  ?? '';
            $postdata['lastname'] = $postdata['lastname']  ?? '';
            $postdata['is_profile_completed'] = 0;
            $flag = $this->api_model->registerUserDetails($postdata);
            if(!$flag){
                sendResponse(false, SYSTEM_ERROR);
            }
        }else{
            $where['device.device_unique_id'] = $postdata['device_unique_id'];
            $devicerow = $this->api_model->checkIfUserExist($where);
            if($devicerow){
                $flag = $this->api_model->deleteDeviceToken($postdata);
            }
            $flag = $this->api_model->insertDeviceData($postdata);
            if(!$flag){
                sendResponse(false, SYSTEM_ERROR);
            }
        }

        $userrow = $devicerow = $this->api_model->checkIfUserExist($where);
        $token = ["exp" => JWT_EXPIRE_CLAIM,"data" => $userrow];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);
        
        $output = [
            'user'=>formatRow($userrow),
            'token'=>$jwt,
        ];
        sendResponse(true, 'Logged in successfully',$output);
    } */

    /* public function profile(){
        $user = $this->getAuthorizedUser();
        sendResponse(true, 'Profile fetched successfully', ['user'=>formatRow($user)]);
    } */

    public function autologin()
    {
        $user = $this->getAuthorizedUser();
        $rules = [
            'device_name' => [
                'field' => 'device_name', 'label' => 'Device Name', 'rules' => 'trim',
            ],
            'device_token' => [
                'field' => 'device_token', 'label' => 'Device Token', 'rules' => 'trim',
            ],
            'app_version' => [
                'field' => 'app_version', 'label' => 'App Version', 'rules' => 'trim',
            ]
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $update_params = [];
        if (isset($postdata['device_name']) && !empty($postdata['device_name']) && $user['device_name'] != $postdata['device_name']) {
            $update_params['device_name'] = $postdata['device_name'];
        }
        if (isset($postdata['app_version']) && !empty($postdata['app_version']) && $user['app_version'] != $postdata['app_version']) {
            $update_params['app_version'] = $postdata['app_version'];
        }
        if (isset($postdata['device_token']) && !empty($postdata['device_token']) && $user['device_token'] != $postdata['device_token']) {
            $update_params['device_token'] = $postdata['device_token'];
        }
        if (!empty($update_params)) {
            $flag = $this->api_model->updateDeviceData($update_params, $user['user_device_id']);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }
            $user = $this->getAuthorizedUser();
        }
        $token = ["exp" => JWT_EXPIRE_CLAIM, "data" => $user];
        $jwt = JWT::encode($token, JWT_SECRET_KEY);

        $output = ['user' => formatRow($user), 'token' => $jwt];
        sendResponse(true, $this->lang->line('login_success'), $output);
    }

    public function update_device_token()
    {
        $user = NULL;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
            $user = $this->getAuthorizedGuest();
        } else {
            $user = $this->getAuthorizedUser();
        }
        $rules = [
            'device_token' => [
                'field' => 'device_token', 'label' => 'Device Token', 'rules' => 'required|trim'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $deviceDetails = $this->api_model->updateDeviceToken($postdata['device_token'], $user['user_device_id']);
        if (!$deviceDetails) {
            sendResponse(false, SYSTEM_ERROR);
        }
        $user['device_token'] = $postdata['device_token'];
        sendResponse(true, $this->lang->line('device_token_update_success'), ['user' => formatRow($user)]);
    }

    public function resend_verification_mail()
    {
        $user = $this->getAuthorizedUser();
        $flag = $this->api_model->resetEmailVerificationCode($user['user_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        // Sending verification email
        // $this->send_email_confirmation_link($user);
        mylog(API_URL . 'send-email-confirmation-link');
        mylog(['user_id' => $user['user_id'], 'email' => $user['email']]);
        $this->async->process(API_URL . 'send-email-confirmation-link', ['user_id' => $user['user_id'], 'email' => $user['email']]);
        sendResponse(true, $this->lang->line('confirm_email_link_resent'));
    }

    public function resend_verification_otp()
    {
        $user = $this->getAuthorizedUser();
        $flag = $this->api_model->resetEmailVerificationCodeOTP($user['user_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        // Sending verification email
        // $this->send_email_confirmation_otp($user);
        mylog(API_URL . 'send-email-confirmation-otp');
        mylog(['user_id' => $user['user_id'], 'email' => $user['email']]);
        $this->async->process(API_URL . 'send-email-confirmation-otp', ['user_id' => $user['user_id'], 'email' => $user['email']]);
        sendResponse(true, $this->lang->line('confirm_email_code_resent'));
    }

    public function logout()
    {
        $user = $this->getAuthorizedUser();
        $flag = $this->api_model->logout($user['user_id'], $user['user_device_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        sendResponse(true, $this->lang->line('logout_success'));
    }

    public function store_subscription_details()
    {
        $user = NULL;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
            $user = $this->getAuthorizedGuest();
        } else {
            $user = $this->getAuthorizedUser();
        }
        $rules = [
            'original_transaction_id' => [
                'field' => 'original_transaction_id', 'label' => 'Original Transaction ID', 'rules' => 'required|trim'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = [
            'usubscription.original_transaction_id' => $postdata['original_transaction_id'],
            'usubscription.user_id' => $userdata['user_id'],
            'usubscription.user_device_id' => $user['user_device_id'],
        ];
        $transaction = $this->api_model->checkIfSubscriptionMappingExist($where);
        $output = ['user' => formatRow($user)];
        
        $device_where = [
            'device_type' => $user['device_type'],
            'device_unique_id' => $user['device_unique_id'],
            'original_transaction_id' => $postdata['original_transaction_id'],
        ];
        $vpn_wholesaler = get_vpn_wholesaler_credentials($device_where);
        $this->api_model->activeIsExpireSDKFlag($user['user_device_id'], ['wholesaler_user' => $vpn_wholesaler['email']]);
        if ($transaction) {
            sendResponse(true, $this->lang->line('transaction_stored_success'), $output);
        } else {
            $subscription_data = [
                'original_transaction_id' => $postdata['original_transaction_id'],
                'user_id' => $user['user_id'],
                'user_device_id' => $user['user_device_id'],
            ];
            $flag = $this->api_model->insertSubscriptionMapping($subscription_data);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }
            if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
                $user = $this->getAuthorizedGuest();
            } else {
                $user = $this->getAuthorizedUser();
            }
            $output = ['user' => formatRow($user)];
            sendResponse(true, $this->lang->line('transaction_stored_success'), $output);
        }
    }

    public function store_subscription_details_huawei()
    {
        $user = NULL;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
            $user = $this->getAuthorizedGuest();
        } else {
            $user = $this->getAuthorizedUser();
        }
        $rules = [
            'original_transaction_id' => [
                'field' => 'original_transaction_id', 'label' => 'Original Transaction ID', 'rules' => 'required|trim'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = [
            'usubscription.original_transaction_id' => $postdata['original_transaction_id'],
            'usubscription.user_id' => $userdata['user_id'],
            'usubscription.user_device_id' => $user['user_device_id'],
        ];
        $transaction = $this->api_model->checkIfSubscriptionMappingExist($where);
        $output = ['user' => formatRow($user)];
        
        $device_where = [
            'device_type' => $user['device_type'],
            'device_unique_id' => $user['device_unique_id'],
            'original_transaction_id' => $postdata['original_transaction_id'],
        ];
        $vpn_wholesaler = get_vpn_wholesaler_credentials($device_where);
        $this->api_model->activeIsExpireSDKFlag($user['user_device_id'], ['wholesaler_user' => $vpn_wholesaler['email']]);
        if ($transaction) {
            sendResponse(true, $this->lang->line('transaction_stored_success'), $output);
        } else {
            $subscription_data = [
                'original_transaction_id' => $postdata['original_transaction_id'],
                'user_id' => $user['user_id'],
                'user_device_id' => $user['user_device_id'],
            ];
            $flag = $this->api_model->insertSubscriptionMapping($subscription_data);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }
            if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
                $user = $this->getAuthorizedGuest();
            } else {
                $user = $this->getAuthorizedUser();
            }
            $output = ['user' => formatRow($user)];
            sendResponse(true, $this->lang->line('transaction_stored_success'), $output);
        }
    }

    public function set_wholesaler_user()
    {
        $user = NULL;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        $rules = [
            'wholesaler_user' => [
                'field' => 'wholesaler_user', 'label' => 'Wholesaler User', 'rules' => 'required|trim'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $flag = $this->api_model->setWholesalerUser($postdata['wholesaler_user'], $userdata['user_device_id']);
        if (!$flag) {
            sendResponse(false, SYSTEM_ERROR);
        }
        sendResponse(true, $this->lang->line('wholesaler_user_created_success'));
    }

    /* public function update_profile(){
        $user = $this->getAuthorizedUser();
        $postdata = $this->getPostdata();
        $user_rules = [
            'firstname'=>[
                'field'=>'firstname','label'=>'Firstname','rules'=>'trim'
            ],
            'lastname'=>[
                'field'=>'lastname','label'=>'Lastname','rules'=>'trim'
            ],
            'gender'=>[
                'field'=>'gender','label'=>'Gender','rules'=>'trim|in_list[m,f]'
            ],
        ];
        $email_rules = [];
        if(empty($user['email']) && !empty($postdata['email'])){
            $email_rules = [
                'email'=>[
                    'field'=>'email','label'=>'Email','rules'=>'trim|valid_email'
                ],
            ];
        }
        $phone_rules = [];
        if(empty($user['phone']) && empty($user['std_code']) && !empty($postdata['phone']) && !empty($postdata['std_code'])){
            $phone_rules = [
                'std_code'=>[
                    'field'=>'std_code','label'=>'STD Code','rules'=>'trim|numeric'
                ],
                'phone'=>[
                    'field'=>'phone','label'=>'phone','rules'=>'trim|numeric|min_length[7]|max_length[12]'
                ],
            ];
        }
        $username_rules = [];
        if(empty($user['username']) && !empty($postdata['username'])){
            $username_rules = [
                'username'=>[
                    'field'=>'username','label'=>'Username','rules'=>'trim|min_length[2]'
                ],
            ];
        }
        $rules = array_merge($user_rules, $email_rules, $phone_rules, $username_rules);
        checkIfValidated($rules);
        $where = ['user.user_id !=' => $user['user_id']];
        if(empty($user['email']) && !empty($postdata['email'])){
            $where['user.email'] = $postdata['email'];
            $row = $this->api_model->checkIfUserExist($where);
            if($row){
                sendResponse(false, 'Email address already registered with another account');
            }
        }else{
            unset($postdata['email']);
        }
        if(empty($user['phone']) && empty($user['std_code']) && !empty($postdata['phone']) && !empty($postdata['std_code'])){
            $where['user.phone'] = $postdata['phone'];
            $row = $this->api_model->checkIfUserExist($where);
            if($row){
                sendResponse(false, 'Phone number already registered with another account');
            }
        }else{
            unset($postdata['std_code']);
            unset($postdata['phone']);
        }
        if(empty($user['username']) && !empty($postdata['username'])){
            $where['user.username'] = $postdata['username'];
            $row = $this->api_model->checkIfUserExist($where);
            if($row){
                sendResponse(false, 'Username already registered with another account');
            }
            $postdata['is_profile_completed'] = true;
        }else{
            unset($postdata['username']);
        }
        if(isset($_FILES['profilepic']['name']) && !empty($_FILES['profilepic']['name'])){
            $file = upload_my_file($_FILES['profilepic'], PROFILE_PIC_PATH, MY_IMAGE_TYPE);
            if (!$file['success'] || is_null($file['file']) || empty($file['file'])):
                sendResponse(false, $file['msg']);
            endif;
            $postdata['profilepic'] = PROFILE_PIC_PATH . $file['file']['name'];
            unlink_my_file($user['profilepic']);
        }
        $flag = $this->api_model->updateUserDetails($user['user_id'], $postdata);
        if(!$flag){
            sendResponse(false, SYSTEM_ERROR);
        }

        $where = ['user.user_id' => $user['user_id'], 'device.user_device_id' => $user['user_device_id']];
        $userrow = $this->api_model->checkIfUserExist($where);
        $output = [
            'user'=>formatRow($userrow),
        ];
        sendResponse(true, 'Profile details updated successfully',$output);
    } */

    public function change_password()
    {
        $user = $this->getAuthorizedUser();
        $postdata = $this->getPostdata();
        $rules = [
            'old_password' => [
                'field' => 'old_password', 'label' => 'Old Password', 'rules' => 'trim|required|min_length[6]'
            ],
            'new_password' => [
                'field' => 'new_password', 'label' => 'New Password', 'rules' => 'trim|required|min_length[6]'
            ],
        ];
        checkIfValidated($rules);

        $userpass = $this->api_model->getUserPassword($user['user_id']);
        if (!$userpass) {
            sendResponse(false, SYSTEM_ERROR);
        }
        if ($postdata['old_password'] == $postdata['new_password']) {
            sendResponse(false, $this->lang->line('new_password_cannot_same_as_old'));
        }
        if (password_verify($postdata['old_password'], $userpass['password'])) {
            $flag = $this->api_model->updateUserDetails($user['user_id'], ['password' => $postdata['new_password']]);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }
            sendResponse(true, $this->lang->line('password_changed_success'));
        } else {
            sendResponse(false, $this->lang->line('incorrect_old_password'));
        }
    }

    public function store_subscription_details_android()
    {
        $user = NULL;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        if (is_null($userdata['user_id']) || empty($userdata['user_id'])) {
            $user = $this->getAuthorizedGuest();
        } else {
            $user = $this->getAuthorizedUser();
        }
        $rules = [
            'receipt' => [
                'field' => 'receipt', 'label' => 'Receipt', 'rules' => 'required|trim'
            ],
            'product_id' => [
                'field' => 'product_id', 'label' => 'Product ID', 'rules' => 'required|trim'
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $product_id = $postdata['product_id'];
        $receipt = $postdata['receipt'];

        //Checking receipt data
        $googleClient = new \Google_Client();
        $googleClient->setScopes([\Google_Service_AndroidPublisher::ANDROIDPUBLISHER]);
        $googleClient->setAuthConfig('pc-api-7243288005334622494-811-9c15d8bdccf4.json');
        $googleAndroidPublisher = new \Google_Service_AndroidPublisher($googleClient);
        $validator = new \ReceiptValidator\GooglePlay\Validator($googleAndroidPublisher);
        $packageName = SUBSCRIPTION_PACKAGE;
        try {
            $response = $validator->setPackageName($packageName)
                ->setProductId($product_id)
                ->setPurchaseToken($receipt)
                ->validateSubscription();
            $responseObject = array_values((array)$response)[0];
        } catch (\Exception $e) {
            sendResponse(false, json_decode($e->getMessage())->error->message ?? $e->getMessage());
        }

        //Checking subscription exists or not
        $order_id = explode('..', $responseObject['orderId'])[0];
        
        $device_where = [
            'device_type' => $user['device_type'],
            'device_unique_id' => $user['device_unique_id'],
            'original_transaction_id' => $order_id,
        ];
        $vpn_wholesaler = get_vpn_wholesaler_credentials($device_where);
        $this->api_model->activeIsExpireSDKFlag($user['user_device_id'], ['wholesaler_user' => $vpn_wholesaler['email']]);

        $where = [
            'usubscription.original_transaction_id' => $order_id,
            'usubscription.user_id' => $userdata['user_id'],
            'usubscription.user_device_id' => $user['user_device_id'],
            'usubscription.is_latest_webhook_subscription' => 1,
        ];
        $transaction = $this->api_model->checkIfSubscriptionMappingExist($where);
        if ($transaction) {
            if($user['device_type'] == 'A' && $transaction['is_expired'] == 1){
                //Insert Data 
                $params = [
                    "notification_store" => APP_STORE_ANDROID,
                    "responseObject" => $responseObject,
                    "product_id" => $product_id,
                    "receipt" => $receipt,
                    "order_id" => $order_id,
                ];
                $flag = $this->api_model->insertSubscriptionDetails($params);
                if (!$flag) {
                    sendResponse(false, SYSTEM_ERROR);
                }

                $subscription_data = [
                    'original_transaction_id' => $order_id,
                    'user_id' => $user['user_id'],
                    'user_device_id' => $user['user_device_id'],
                ];
                $flag = $this->api_model->insertSubscriptionMapping($subscription_data);
                if (!$flag) {
                    sendResponse(false, SYSTEM_ERROR);
                }
            }
            if($user['device_type'] == 'A'){
                $vpn_res = $this->vpn->login($vpn_wholesaler['email']);
                if($vpn_res['active'] == 0 && empty($vpn_res['products']['product'])){
                    $plan_type = fnmatch('*month*',$product_id) ? 1 : 12;
                    $this->vpn->renew($vpn_wholesaler['email'], $plan_type);
                }
            }
            sendResponse(true, $this->lang->line('transaction_stored_success'));
        } else {
            //Insert Data 
            $params = [
                "notification_store" => APP_STORE_ANDROID,
                "responseObject" => $responseObject,
                "product_id" => $product_id,
                "receipt" => $receipt,
                "order_id" => $order_id,
            ];
            $flag = $this->api_model->insertSubscriptionDetails($params);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }

            $subscription_data = [
                'original_transaction_id' => $order_id,
                'user_id' => $user['user_id'],
                'user_device_id' => $user['user_device_id'],
            ];
            $flag = $this->api_model->insertSubscriptionMapping($subscription_data);
            if (!$flag) {
                sendResponse(false, SYSTEM_ERROR);
            }
            sendResponse(true, $this->lang->line('transaction_stored_success'));
        }
    }

    public function get_open_gate_servers_list()
    {
        $user = null;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }

        $rules = [
            'last_modified_timestamp' => [
                'field' => 'last_modified_timestamp', 'label' => 'Last Modified Timestamp',
                'rules' => 'is_natural',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $where = ['open_get_server.updated_at >= ' => $postdata['last_modified_timestamp'] ?? 0];
        $serverList = $this->open_gate_server_model->getOpenGateServerListOld($where);
        $output['server_list'] = formatList($serverList);
        sendResponse(true, $this->lang->line('server_list_fetched_success'), $output);
    }

    public function get_country_servers_list()
    {
        $user = null;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }

        $rules = [
            'last_modified_timestamp' => [
                'field' => 'last_modified_timestamp', 'label' => 'Last Modified Timestamp',
                'rules' => 'is_natural',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $currentTime = $postdata['last_modified_timestamp'] ?? 0;
        $where = ['countries.updated_at >= ' => $currentTime];
        $serverList = $this->country_model->getOpenGateServerListOld($where, $currentTime);
        $output['server_list'] = array_values(formatList($serverList));
        sendResponse(true, $this->lang->line('server_list_fetched_success'), $output);
    }

    public function get_country_servers_list_optimized()
    {
        $user = null;
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }

        $rules = [
            'last_modified_timestamp' => [
                'field' => 'last_modified_timestamp', 'label' => 'Last Modified Timestamp',
                'rules' => 'is_natural',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $currentTime = $postdata['last_modified_timestamp'] ?? 0;

        $where = [
            'country.is_active' => true,
            'vpn_server.is_active' => true,
            'SINGLE_WHERE' => '(country.updated_at >= '.$currentTime.' OR vpn_server.updated_at >= '.$currentTime.')'
        ];

        $optimalServer = NULL;
        if(!$currentTime){
            // $optimalServer = $this->country_model->getRandomOptimalServerList($where);
            // if($optimalServer){
            //     $optimalServer['flag'] = file_exists(FLAG_PATH.strtoupper($optimalServer['country_code']).'.png') ? SITE_URL.FLAG_PATH.strtoupper($optimalServer['country_code']).'.png' : SITE_URL.FLAG_PATH.'global.png';
            // }
        }

        $where = ['SINGLE_WHERE' => '(country.updated_at >= '.$currentTime.' OR vpn_server.updated_at >= '.$currentTime.')'];
        $servers = $this->country_model->getOpenGateServerList($where);

        $my_servers = [];
        if(!empty($servers) && count($servers)){
            $country_ids = array_values(array_unique(array_column($servers, 'country_id')));
            if($optimalServer && !in_array($optimalServer['country_id'],$country_ids)){
                $countryData = [
                    "server_id" => $optimalServer["server_id"],
                    "parent_country_id" => $optimalServer["parent_country_id"],
                    "recommend" => TRUE,
                    "is_active" => $optimalServer["is_active_vpn_server"],
                    "ip_address" => $optimalServer["ip_address"],
                    "ovpn" => $optimalServer["ovpn"],
                ];
                $serverData = [
                    "country_id" => $optimalServer["country_id"],
                    "country" => $optimalServer["country"],
                    "country_code" => $optimalServer["country_code"],
                    "premium" => $optimalServer["premium"],
                    "recommend" => TRUE,
                    "is_active" => $optimalServer["is_active"],
                    "flag" => $optimalServer["flag"],
                    "servers" => [formatRow($countryData)]
                ];
                $my_servers = array_merge($servers, [formatRow($serverData)]);
            }else{
                $optimalServer['country_id'] = $optimalServer['country_id'] ?? '';
                $optimalServer['server_id'] = $optimalServer['server_id'] ?? '';
                foreach ($country_ids as $country_id) {
                    $ovpn_servers = array_values(array_filter($servers, function($server) use ($country_id){
                        return $server['country_id'] == $country_id ? $server : FALSE;
                    }));

                    $countryRow = [];
                    $ovpn_servers = array_map(function($ovpn_server) use ($optimalServer, &$countryRow, $currentTime){
                        $countryRow = [
                            "country_id" => $ovpn_server["country_id"],
                            "country" => $ovpn_server["country"],
                            "country_code" => $ovpn_server["country_code"],
                            "premium" => $ovpn_server["premium"],
                            "recommend" => boolval($optimalServer['country_id'] == $ovpn_server['country_id']),
                            "is_active" => $ovpn_server["is_active"],
                            "flag" => $ovpn_server['flag'] = file_exists(FLAG_PATH.strtoupper($ovpn_server['country_code']).'.png') ? SITE_URL.FLAG_PATH.strtoupper($ovpn_server['country_code']).'.png' : SITE_URL.FLAG_PATH.'global.png'
                        ];

                        return (!is_null($ovpn_server["server_id"]) && $ovpn_server['updated_at_vpn_server'] >= $currentTime) ? [
                            "server_id" => $ovpn_server["server_id"],
                            "parent_country_id" => $ovpn_server["parent_country_id"],
                            "recommend" => boolval($optimalServer['server_id'] == $ovpn_server['server_id']),
                            "is_active" => $ovpn_server["is_active_vpn_server"],
                            "ip_address" => $ovpn_server["ip_address"],
                            "ovpn" => $ovpn_server["ovpn"],
                        ] : FALSE;
                    }, $ovpn_servers);
                    $countryRow["servers"] = formatList(array_values(array_filter($ovpn_servers)));
                    $my_servers[] = formatRow($countryRow);
                }
            }
        }
        $output['server_list'] = formatList($my_servers);
        sendResponse(true, $this->lang->line('server_list_fetched_success'), $output);
    }

    public function get_my_optimal_server()
    {
        $userdata = $this->checkIfAuthorized();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }

        $rules = [
            'country_id' => [
                'field' => 'country_id', 'label' => 'Country ID',
                'rules' => 'is_natural',
            ],
            'page' => [
                'field' => 'page', 'label' => 'Page',
                'rules' => 'is_natural',
            ],
        ];
        checkIfValidated($rules);
        $postdata = $this->getPostdata();
        $page = $postdata['page'] ?? 1;
        $page = empty($postdata['page']) ? 1 : $postdata['page'];
        $country_id = $postdata['country_id'] ?? 0;
        $where = [
            'country.is_active' => true,
            'vpn_server.is_active' => true
        ];
        if($country_id){
            $where['vpn_server.country_id'] = $country_id;
        }
        $optimalServer = $this->country_model->getOptimalServerList($where, ($page - 1));
        if($optimalServer){
            $optimalServer['flag'] = file_exists(FLAG_PATH.strtoupper($optimalServer['country_code']).'.png') ? SITE_URL.FLAG_PATH.strtoupper($optimalServer['country_code']).'.png' : SITE_URL.FLAG_PATH.'global.png';
            $serverData = [
                "server_id" => $optimalServer["server_id"],
                "parent_country_id" => $optimalServer["parent_country_id"],
                "recommend" => TRUE,
                "is_active" => $optimalServer["is_active_vpn_server"],
                "ip_address" => $optimalServer["ip_address"],
                "ovpn" => $optimalServer["ovpn"],
            ];        
    
            $countryData = [
                "country_id" => $optimalServer["country_id"],
                "country" => $optimalServer["country"],
                "country_code" => $optimalServer["country_code"],
                "premium" => $optimalServer["premium"],
                "recommend" => TRUE,
                "is_active" => $optimalServer["is_active"],
                "flag" => $optimalServer["flag"],
                "servers" => [formatRow($serverData)]
            ];
            
            $output['optimal_server'] = formatRow($countryData);
            sendResponse(true, $this->lang->line('server_list_fetched_success'), $output);
        }else{
            sendResponse(false, $this->lang->line('optimal_server_not_found'));
        }
    }

    public function delete_account(){
        $userdata = $this->getAuthorizedUser();
        if (!$userdata) {
            sendResponse(false, UNAUTHORIZED_ACTION);
        }
        $this->getPostdata();
        $logout_flag = $this->api_model->logout($userdata['user_id'], $userdata['user_device_id']);
        if(!$logout_flag){
            sendResponse(false, $this->db->error()['message']);
        }
        $delete_flag = $this->user_model->deleteAccount($userdata['user_id']);
        if(!$delete_flag){
            sendResponse(false, $this->db->error()['message']);
        }
        sendResponse(true, $this->lang->line('delete_account_success'));
    }

    public function update_ovpn_servers(){
        mylog("update_ovpn_servers - API Start Time : ".date('d-m-Y h:i A',time()));
        $email = OVPN_SERVER_ALERT_MAIL;
        $postdata = $this->getPostdata();
        $old_servers = $postdata['old_servers'];
        $new_servers = $postdata['new_servers'];
        mylog(date('d-m-Y h:i A',time()) .' - update_ovpn_servers - '.json_encode($postdata));
        $server_array_old = [];
        $server_array_new = [];
        if(!empty($old_servers)){
            foreach($old_servers as $old_server){
                $server_array_old[] = $this->vpn_server_model->OldServersOvpn($old_server);
            }
            $this->vpn_server_model->serverCountryCheck();
        }
        $this->vpn_server_model->OldAndNewAddOrUpdateTheOVPNServers($new_servers);
        $this->vpn_server_model->serverCountryCheck();
        if(!empty($new_servers)){
            foreach($new_servers as $new_server){
                $server_array_new[] = $this->vpn_server_model->getNewRecordsForNewServers($new_server);
            }
        }        
        if(!empty($server_array_old) && !empty($server_array_new)){
            $email_params = [
                'fullname' => 'Admin',
                'servers' => $server_array_old,
                'servers_new' => $server_array_new,
                'email' => $email
            ];
            mylog("OVPN Server Mail Down - ");
            $result = $this->sendmail->server_down_alert($email_params);
            mylog("OVPN Server Mail Down - ".$result);
        }
        mylog("update_ovpn_servers - API End Time : ".date('d-m-Y h:i A',time()));
        sendResponse(true, 'ovpn servers updated successfully.');
    }

    //without authorization token api list fetched
    public function get_open_servers_list_py()
    {
        $postdata = $this->getPostdata();
        $where['where'] = ['vpn_servers.is_active'=>1,'vpn_servers.updated_at >= ' => $postdata['last_modified_timestamp'] ?? 0];
        //30-01-2024
        $serverList = $this->vpn_server_model->getPyRecords($where);
        //30-01-2024
        $output['server_list'] = formatList($serverList);
        sendResponse(true, $this->lang->line('server_list_fetched_success'), $output);
    }

    public function get_update_the_inactive_server_py()
    {
        mylog("get_update_the_inactive_server_py - API End Time : ".date('d-m-Y h:i A',time()));
        $postdata = $this->getPostdata();
        $ip_address = $postdata['ip_address'];
        if(is_array($ip_address)){
            if(!empty($ip_address)){
                $this->vpn_server_model->updateInactiveServers($ip_address);
            }
            mylog("get_update_the_inactive_server_py is_array - API End Time : ".date('d-m-Y h:i A',time()));
            sendResponse(true, 'ovpn servers updated successfully.');
        }
        mylog("get_update_the_inactive_server_py is_not_array- API End Time : ".date('d-m-Y h:i A',time()));
    }
}
