<?php
if (!function_exists('formatList')) {
    function formatList($records){
        if(!empty($records) && count($records)){
            $records = array_map(function($row){
                return formatRow($row);
            }, $records);
        }
        return $records;
    }
}

if (!function_exists('formatRow')) {
    function formatRow($row){
        // General
        //if(isset($row['is_active'])) { unset($row['is_active']); }
        if(isset($row['created_at'])) { unset($row['created_at']); }
        if(isset($row['updated_at'])) { unset($row['updated_at']); }
        if(isset($row['is_expired_from_sdk'])) { unset($row['is_expired_from_sdk']); }
        if(isset($row['is_deleted'])) { unset($row['is_deleted']); }
        
        // User
        if(array_key_exists('is_active', $row)) { $row['is_active'] = boolval($row['is_active']); }
        if(array_key_exists('user_id', $row)) { $row['user_id'] = $row['user_id'] ?? ''; }
        if(array_key_exists('signup_type', $row)) { $row['signup_type'] = $row['signup_type'] ?? ''; }
        if(array_key_exists('social_id', $row)) { $row['social_id'] = $row['social_id'] ?? ''; }
        if(array_key_exists('firstname', $row)) { $row['firstname'] = $row['firstname'] ?? ''; }
        if(array_key_exists('lastname', $row)) { $row['lastname'] = $row['lastname'] ?? ''; }
        if(array_key_exists('fullname', $row)) { $row['fullname'] = $row['fullname'] ?? ''; }
        if(array_key_exists('email', $row)) { $row['email'] = $row['email'] ?? ''; }
        if(array_key_exists('profilepic', $row)) { $row['profilepic'] = get_file_url($row['profilepic']); }
        if(array_key_exists('wholesaler_user', $row)) { $row['wholesaler_user'] = $row['wholesaler_user'] ?? ''; }
        if(array_key_exists('is_profile_completed', $row)) { $row['is_profile_completed'] = boolval($row['is_profile_completed']); }
        // if(array_key_exists('email_verification_status', $row)){ $row['email_verification_status'] = boolval($row['email_verification_status']); }
        if(array_key_exists('email_verification_status', $row)){ $row['email_verification_status'] = TRUE; }
        if(array_key_exists('is_expired_from_sdk', $row)){ $row['is_expired_from_sdk'] = (bool) $row['is_expired_from_sdk']; }
        if(array_key_exists('premium', $row)) { $row['premium'] = boolval($row['premium']); }
        if(array_key_exists('recommend', $row)) { $row['recommend'] = boolval($row['recommend']); }

        if(array_key_exists('is_profile_completed', $row)){
            $row['have_active_subscription'] = FALSE;
            $row['subscription'] = NULL;
            $CI = &get_instance();
            if(!empty($row['user_id'])){
                $where = ['user.user_id' => $row['user_id']];
                $params = [
                    'action' => 'row',
                    'where' => $where,
                    'order'=>[['order'=>'web_subscription.created_at','type'=>'DESC'],['order'=>'web_subscription.webhook_subscription_id','type'=>'DESC']]
                ];
                $row['subscription'] = formatSubscription($CI->user_model->getTransactions($params));
                if(!$row['subscription'] || is_null($row['subscription']['original_transaction_id'])){
                    $row['subscription'] = NULL;
                }else{
                    $row['subscription']['is_expired'] = $row['subscription']['is_expired'] ?? TRUE;
                    $row['have_active_subscription'] = ($row['subscription']['is_expired']) ? FALSE : TRUE;
                }
            }else{
                $where = ['device.user_device_id' => $row['user_device_id']];
                $params = [
                    'action' => 'row',
                    'where' => $where,
                    'order'=>[['order'=>'web_subscription.created_at','type'=>'DESC'],['order'=>'web_subscription.webhook_subscription_id','type'=>'DESC']]
                ];
                $row['subscription'] = formatSubscription($CI->guest_user_model->getTransactions($params));
                if(!$row['subscription'] || is_null($row['subscription']['original_transaction_id'])){
                    $row['subscription'] = NULL;
                }else{
                    $row['subscription']['is_expired'] = $row['subscription']['is_expired'] ?? TRUE;
                    $row['have_active_subscription'] = ($row['subscription']['is_expired']) ? FALSE : TRUE;
                }
            }

        }
        return $row;
    }

    function formatSubscription($subscription){
        if($subscription){
            unset($subscription['user_id']);
            unset($subscription['firstname']);
            unset($subscription['lastname']);
            unset($subscription['fullname']);
            unset($subscription['email']);
            unset($subscription['profilepic']);
            unset($subscription['webhook_subscription_id']);
            $subscription["auto_renew_status"] = boolval($subscription['auto_renew_status']);
            $subscription["auto_renew_status_change_date_ms"] = intval($subscription["auto_renew_status_change_date_ms"]);
            unset($subscription['password']);
            unset($subscription['bid']);
            unset($subscription['bvrs']);
            unset($subscription['in_app_ownership_type']);
            $subscription["purchase_date_ms"] = intval($subscription["purchase_date_ms"]);
            $subscription["original_purchase_date_ms"] = intval($subscription["original_purchase_date_ms"]);
            $subscription["expires_date_ms"] = intval($subscription["expires_date_ms"]);
            $subscription["is_trial_period"] = boolval($subscription["is_trial_period"]);
            $subscription["is_in_intro_offer_period"] = boolval($subscription["is_in_intro_offer_period"]);
            $subscription["cancellation_date_ms"] = intval($subscription["cancellation_date_ms"]);
            unset($subscription['price']);
            unset($subscription['created_at']);
            $subscription["is_expired"] = boolval($subscription["is_expired"]);
        }
        return $subscription;
    }
}
