<?php
if (!function_exists('checkIfValidated')) {
    function checkIfValidated($rules)
    {
        $CI = &get_instance();
        $CI->form_validation->set_rules($rules);
        if ($CI->form_validation->run() === false) {
            if (!empty($rules) && count($rules) > 0) {
                foreach ($rules as $rule_key => $rule) {
                    if (!empty(form_error($rule_key))) {
                        sendResponse(false, form_error($rule_key));
                    }
                }
            }
        }
    }
}

if(!function_exists('utc_local')){
    function utc_local($date){
        $date = new DateTime(date(DATETIME_FORMAT,$date), new DateTimeZone('UTC'));
        $date->setTimezone(new DateTimeZone('Asia/Kolkata'));
        $date =  $date->format(DATETIME_FORMAT);
        return $date;
    }
}

if(!function_exists('get_env_type')){
    function get_env_type(){
        if(APP_ENVIRONMENT == 'live'){
            return '';
        }elseif(APP_ENVIRONMENT == 'stag'){
            return ' - Staging';
        }else{
            return ' - Local';
        }
    }
}

if (!function_exists('sendResponse')) {
    function sendResponse($success, $message = '', $output = [], $exit = true)
    {
        $CI = &get_instance();
        $outputData = [
            'success' => $success,
            'message' => $message,
            'data' => (object) $output
        ];

        $apiVersion = debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1]['class'] ?? pathinfo(debug_backtrace(DEBUG_BACKTRACE_IGNORE_ARGS, 2)[1]['file'], PATHINFO_FILENAME);
        if ($exit) {
            if ($apiVersion == 'V2') {
                if($message == UNAUTHORIZED_ACTION){
                    http_response_code(401);
                }
                echo encrypt_this($outputData);
                exit;
            }
            if($message == UNAUTHORIZED_ACTION){
                $CI->output
                    ->set_status_header(401)
                    ->set_content_type('application/json', 'utf-8')
                    ->set_output(json_encode($outputData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES))
                    ->_display();
            }else{
                $CI->output
                    ->set_status_header(200)
                    ->set_content_type('application/json', 'utf-8')
                    ->set_output(json_encode($outputData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES))
                    ->_display();
            }
            /* $CI->output
                ->set_status_header(200)
                ->set_content_type('application/json', 'utf-8')
                ->set_output(json_encode($outputData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES))
                ->_display(); */
            exit;
        }
        $outputData['data'] = (array) $output;
        
        /* if($apiVersion == 'V2'){
            return encrypt_this($outputData);
        } */
        if($message == UNAUTHORIZED_ACTION){
            http_response_code(401);
        }
        return $outputData;
    }
}

if (!function_exists('showQuery')) {
    function showQuery()
    {
        $CI = &get_instance();
        echo '<pre>';
        echo $CI->db->last_query();
        die;
    }
}

if (!function_exists('getDBError')) {
    function getDBError()
    {
        $CI = &get_instance();
        return $CI->db->error()['message'];
    }
}

if (!function_exists('getPageTitle')) {
    function getPageTitle($title = '')
    {
        if (!empty($title)) {
            return WEBSITE_TITLE . ' | ' . $title;
        } else {
            return WEBSITE_TITLE;
        }
    }
}

if (!function_exists('getFilePath')) {
    function getFilePath($filename)
    {
        if (!empty($filename) && file_exists(SITE_PATH . $filename)) {
            return SITE_URL . $filename;
        } else {
            return PLACEHOLDER_IMAGE;
        }
    }
}

if (!function_exists('get_where')) {
    function get_where($where = [])
    {
        if (!empty($where) && count($where) > 0) {
            $ci = &get_instance();
            foreach ($where as $where_key => $where_value) {
                $field = explode(" ", trim($where_key));
                if (count($field) > 1 && $field[1] == strtoupper('IN')) {
                    $ci->db->where_in($field[0], $where_value);
                } elseif (count($field) > 1 && $field[1] == strtoupper('NOTIN')) {
                    $ci->db->where_not_in($field[0], $where_value);
                } elseif (count($field) > 1 && $field[1] == strtoupper('HAVING')) {
                    $ci->db->having($field[0], $where_value);
                } elseif (count($field) > 1 && $field[1] == strtoupper('HAVINGLIKE')) {
                    $ci->db->having($field[0] . ' LIKE ', $where_value);
                } elseif ($field[0] == strtoupper('SINGLE_WHERE')) {
                    $ci->db->where($where_value, NULL, FALSE);
                } elseif ($field[0] == strtoupper('SINGLE_HAVING')) {
                    $ci->db->having($where_value, NULL, FALSE);
                } elseif (strpos($field[0], 'wholesaler_user') !== false) {
                    $ci->db->where($field[0] . ' LIKE "%' . $where_value . '"');
                } else {
                    $ci->db->where($where_key, $where_value);
                }
            }
        }
    }
}

if (!function_exists('get_order')) {
    function get_order($order = [])
    {
        if (!empty($order) && count($order) > 0) {
            $ci = &get_instance();
            if (isset($order['order']) && !empty($order['order'])) {
                if (isset($order['type']) && !empty($order['type'])) {
                    $ci->db->order_by($order['order'], $order['type']);
                } else {
                    $ci->db->order_by($order['order'], "ASC");
                }
            } else {
                if(($order['type'] ?? '') == 'random'){
                    $ci->db->order_by('rand()');
                }else{
                    foreach ($order as $row_order) {
                        $ci->db->order_by($row_order['order'], $row_order['type']);
                    }
                }
            }
        }
    }
}

if (!function_exists('get_filter_where')) {
    function get_filter_where($fields)
    {
        $search_columns_array = $filter_array = [];
        $ci = &get_instance();
        $request = ($ci->input->method(TRUE) == 'GET') ? $_GET : $_POST;
        if (!empty($request['columns'])) {
            $k = 0;
            foreach ($request['columns'] as $column) :
                if (filter_var($column['searchable'], FILTER_VALIDATE_BOOLEAN)) :
                    $search_columns_array[] = $fields[$k];
                    if (!empty(trim($column['search']['value'])) || $column['search']['value'] == '0') {
                        $filter_array[$fields[$k]] = trim($column['search']['value']);
                    }
                endif;
                $k++;
            endforeach;
        }
        if (!empty($filter_array) && count($filter_array) > 0) {
            foreach ($filter_array as $filter_key => $filter_val) {
                if (strpos($filter_key, 'created_at') !== false || strpos($filter_key, 'updated_at') !== false) {
                    $date_range = explode("|", $filter_val);
                    $ci->db->where($filter_key . " >= ", strtotime($date_range[0]));
                    $ci->db->where($filter_key . " <= ", strtotime($date_range[1]) + ((1 * CALC_DAYS) - 1));
                } elseif (strpos($filter_key, 'created_date') !== false || strpos($filter_key, 'updated_date') !== false || strpos($filter_key, 'stat_date') !== false) {
                    $date_range = explode("|", $filter_val);
                    $ci->db->where($filter_key . " >= ", date('Y-m-d',strtotime($date_range[0])));
                    $ci->db->where($filter_key . " < ", date('Y-m-d', strtotime($date_range[1] . ' +1 day')));
                } elseif (
                    strpos($filter_key, 'original_purchase_date_ms') !== false || 
                    strpos($filter_key, 'purchase_date_ms') !== false || 
                    strpos($filter_key, 'expires_date_ms') !== false 
                ) {
                    $date_range = explode("|", $filter_val);
                    $ci->db->where($filter_key . " >= ", (strtotime($date_range[0]) * 1000));
                    $ci->db->where($filter_key . " <= ", ((strtotime($date_range[1]) + ((1 * CALC_DAYS) - 1)) * 1000));
                } elseif (strpos($filter_key, 'question_category_id') !== false) {
                    $ci->db->where($filter_key, $filter_val);
                } elseif (strpos($filter_key, 'is_active') !== false) {
                    $ci->db->where($filter_key, $filter_val);
                } elseif (strpos($filter_key, 'is_expired') !== false) {
                    $ci->db->where($filter_key, $filter_val);
                // } elseif (strpos($filter_key, 'wholesaler_user') !== false) {
                //     $ci->db->having(explode(".", $filter_key)[0] . ' LIKE "%' . $filter_val . '%"');
                } else {
                    // $ci->db->like($filter_key,$filter_val);
                    $ci->db->like('CAST(' . $filter_key . ' AS CHAR)', $filter_val);
                }
            }
        }
        if (!empty($request['search']['value'])) {
            $search_value = $ci->db->escape_string($request['search']['value']);
            $where  = $having = [];
            for ($k = 0; $k < count($search_columns_array); $k++) {
                if (!is_null($search_columns_array[$k])) :
                    $filter_key = $search_columns_array[$k];
                    if (strpos($filter_key, 'question_type') !== FALSE) {
                        $where[] = $filter_key . '=' . '"' . $search_value . '"';
                    } else {
                        $where[] = 'CAST(' . $filter_key . ' AS CHAR) LIKE "%' . $search_value . '%"';
                    }
                endif;
            }
            if (!empty($where) && count($where) > 0) :
                $where = '(' . implode(' OR ', $where) . ')';
                $ci->db->where($where);
            else :
                $where[] = '1=1';
            // $where = '(' . implode(' OR ', $where) . ')';
            // $ci->db->where($where);
            endif;
        }
    }
}

if (!function_exists('get_filter_order')) {
    function get_filter_order($request, $order, $fields)
    {
        $ci = &get_instance();
        if (isset($request['order']) && count($request['order']) > 0) {
            foreach ($request['order'] as $order) {
                $ci->db->order_by($fields[$order['column']], $order['dir']);
            }
        } elseif (!empty($order)) {
            $ci->db->order_by($order['order'], $order['type']);
        }
    }
}

if (!function_exists('get_limit')) {
    function get_limit($limit = "", $offset = "")
    {
        $ci = &get_instance();
        if (!empty($limit) && !empty($offset)) {
            $ci->db->limit($limit, $offset);
        } elseif (!empty($limit) && $limit > 0) {
            $ci->db->limit($limit);
        }
    }
}

if (!function_exists('get_field_attributes')) {
    function get_field_attributes($attributes)
    {
        $str = join(' ', array_map(function ($key) use ($attributes) {
            if (is_bool($attributes[$key])) {
                return $attributes[$key] ? $key : '';
            } elseif ($key == 'options') {
                return '';
            }
            return $key . '="' . $attributes[$key] . '"';
        }, array_keys($attributes)));
        echo $str;
    }
}

if (!function_exists('init_model_params')) {
    function init_model_params($params = [])
    {
        $params['where'] = $params['where'] ?? [];
        $params['order'] = $params['order'] ?? [];
        $params['limit'] = $params['limit'] ?? [];
        $params['offset'] = $params['offset'] ?? [];
        $params['action'] = $params['action'] ?? 'list'; // row/list/count
        return $params;
    }
}

if (!function_exists('get_data')) {
    function get_data($params, $query)
    {
        if ($params['action'] == 'row') {
            return $query->row_array();
        } elseif ($params['action'] == 'count') {
            return $query->num_rows();
        } else {
            return $query->result_array();
        }
    }
}

if (!function_exists('check_file_validations')) {
    function check_file_validations($my_file_type, $validate_type = '')
    {
        $error_response = ['success' => FALSE, 'msg' => '', 'file' => null, 'files' => []];
        $success_response = ['success' => TRUE, 'msg' => 'OK', 'file' => null, 'files' => []];

        if (!empty($validate_type)) :
            switch ($validate_type) {
                case MY_IMAGE_TYPE:
                    if (fnmatch(MY_IMAGE_TYPE . '/*', $my_file_type) === false) :
                        $error_response['msg'] = 'invalid image file selected';
                        return $error_response;
                    endif;
                    break;
                case MY_VIDEO_TYPE:
                    if (fnmatch(MY_VIDEO_TYPE . '/*', $my_file_type) === false) :
                        $error_response['msg'] = 'invalid video file selected';
                        return $error_response;
                    endif;
                    break;
                case MY_AUDIO_TYPE:
                    if (fnmatch(MY_AUDIO_TYPE . '/*', $my_file_type) === false) :
                        $error_response['msg'] = 'invalid audio file selected';
                        return $error_response;
                    endif;
                    break;
                case MY_IMAGE_PDF_TYPE:
                    if (!fnmatch(MY_IMAGE_TYPE . '/*', $my_file_type) && MY_PDF_TYPE != $my_file_type) :
                        $error_response['msg'] = 'Invalid or unsupported file type';
                        return $error_response;
                    endif;
                    break;
                default:
                    return $success_response;
                    break;
            }
        endif;
        return $success_response;
    }
}

if (!function_exists('local_file_upload')) {
    function local_file_upload($my_file, $path, $validate_type = "")
    {
        $ci = &get_instance();
        $error_response = ['success' => FALSE, 'msg' => '', 'file' => null, 'files' => []];
        $success_response = ['success' => TRUE, 'msg' => 'OK', 'file' => null, 'files' => []];

        if (!is_writable(dirname($path))) :
            $error_response['msg'] = 'Upload directory is not writable';
            return $error_response;
        endif;

        if (isset($my_file['name']) && is_array($my_file['name'])) :
            $files = [];
            for ($file_counter = 0; $file_counter < count($my_file['name']); $file_counter++) :
                if ($_FILES['file']['error'][$file_counter] != UPLOAD_ERR_OK) :
                    $error_response['msg'] = get_file_upload_error_desc($_FILES['file']['error'][$file_counter]);
                    return $error_response;
                endif;
                $error_response = check_file_validations($my_file['type'][$file_counter], $validate_type);
                if ($error_response['success'] === FALSE) :
                    return $error_response;
                endif;
                $file_extension = pathinfo($my_file['name'][$file_counter], PATHINFO_EXTENSION);
                $filename = get_unique_id(40) . time() . '.' . $file_extension;
                if (move_uploaded_file($my_file['tmp_name'][$file_counter], $path . $filename)) :
                    $files[] = [
                        'name' => $filename, 'file_name' => $my_file['name'][$file_counter],
                        'file_type' => $my_file['type'][$file_counter], 'file_size' => $my_file['size'][$file_counter],
                    ];
                endif;
            endfor;
            if (empty($files)) :
                $error_response['msg'] = 'No valid files found';
                return $error_response;
            else :
                $success_response['files'] = $files;
                return $success_response;
            endif;
        elseif (isset($my_file['name'])) :
            if ($my_file['error'] != UPLOAD_ERR_OK) :
                $error_response['msg'] = get_file_upload_error_desc($my_file['error']);
                return $error_response;
            endif;
            $error_response = check_file_validations($my_file['type'], $validate_type);
            if ($error_response['success'] === FALSE) :
                return $error_response;
            endif;
            $file_extension = pathinfo($my_file['name'], PATHINFO_EXTENSION);
            $filename = get_unique_id(40) . time() . '.' . $file_extension;
            if (move_uploaded_file($my_file['tmp_name'], $path . $filename)) :
                $success_response['file'] = [
                    'name' => $filename, 'file_name' => $my_file['name'],
                    'file_type' => $my_file['type'], 'file_size' => $my_file['size'],
                ];
                return $success_response;
            else :
                $error_response['msg'] = 'Error occcured while uploading file';
                return $error_response;
            endif;
        else :
            $file_extension = "png";
            if (count($filedata = explode(';', $my_file)) == 2) {
                if ($validate_type == MY_IMAGE_TYPE) {
                    $file_extension = str_replace('data:image/', '', $filedata[0]);
                }
                $my_file = trim(explode(',', $filedata[1])[1]);
            }
            $filename = get_unique_id(40) . time() . '.' . $file_extension;
            file_put_contents($path . $filename, base64_decode($my_file));
            $success_response['file'] = [
                'name' => $filename, 'file_name' => $filename,
                'file_type' => mime_content_type($path . $filename), 'file_size' => filesize($path . $filename),
            ];
            return $success_response;
        endif;
    }
}

if (!function_exists('s3_bucket_upload')) {
    function s3_bucket_upload($my_file, $path, $validate_type = "")
    {
        if ($_FILES['file']['error'] != UPLOAD_ERR_OK) :
            $error_response['msg'] = get_file_upload_error_desc($_FILES['file']['error']);
            return $error_response;
        endif;
        $error_response = check_file_validations($my_file['type'], $validate_type);
        if ($error_response['success'] === FALSE) :
            return $error_response;
        endif;

        $ci = &get_instance();
        $success_response = ['success' => TRUE, 'msg' => 'OK', 'file' => null, 'files' => []];

        $path = str_replace(SITE_PATH, '', $path);
        $s3 = S3Client::factory(
            array(
                'credentials' => array('key' => AWS_S3_IAM_KEY, 'secret' => AWS_S3_IAM_SECRET),
                'version' => 'latest',
                'region' => AWS_S3_REGION,
            )
        );

        $file_extension = pathinfo($my_file['name'], PATHINFO_EXTENSION);
        $filename = get_unique_id(40) . time() . '.' . $file_extension;

        $result = $s3->putObject(
            array(
                'Bucket' => AWS_S3_BUCKET_NAME,
                'Key' => $path . $filename,
                'SourceFile' => $my_file['tmp_name'],
                'ContentType' => $my_file['type'],
                'StorageClass' => 'REDUCED_REDUNDANCY',
                'ACL'        => 'public-read',
            )
        );

        // print_r($result);
        // echo $result['ObjectURL'] . "\n";
        $success_response['file'] = [
            'name' => $filename, 'file_name' => $my_file['name'],
            'file_type' => $my_file['type'], 'file_size' => $my_file['size'],
        ];
        return $success_response;
    }
}

if (!function_exists('upload_my_file')) {
    function upload_my_file($file, $path, $validate_type = "")
    {
        switch (UPLOAD_FILE_MODE) {
            case UPLOAD_FILE_MODE_S3:
            case UPLOAD_FILE_MODE_S3C:
                return s3_bucket_upload($file, $path);
                break;
            case UPLOAD_FILE_MODE_LOCAL:
                return local_file_upload($file, SITE_PATH . $path, $validate_type);
                break;
        }
    }
}

if (!function_exists('get_file_url')) {
    function get_file_url($filename, $url_prefix = SITE_URL, $path = SITE_PATH)
    {
        switch (UPLOAD_FILE_MODE) {
            case UPLOAD_FILE_MODE_S3:
            case UPLOAD_FILE_MODE_S3C:
                if (!empty($filename)) {
                    return $url_prefix . $filename;
                } else {
                    return PLACEHOLDER_IMAGE;
                }
                break;
            case UPLOAD_FILE_MODE_LOCAL:
                $file_url = "";
                if (!empty($filename) && file_exists($path . $filename)) {
                    $file_url = $url_prefix . $filename;
                } else {
                    $file_url = PLACEHOLDER_IMAGE;
                }
                return $file_url;
                break;
        }
    }
}

if (!function_exists('get_unique_id')) {
    function get_unique_id($length = 13)
    {
        if (function_exists("random_bytes")) {
            $bytes = random_bytes(ceil($length / 2));
        } elseif (function_exists("openssl_random_pseudo_bytes")) {
            $bytes = openssl_random_pseudo_bytes(ceil($length / 2));
        } else {
            throw new Exception("no cryptographically secure random function available");
        }
        return substr(bin2hex($bytes), 0, $length);
    }
}

if (!function_exists('get_unique_number')) {
    function get_unique_number($length = 4)
    {
        // $numberRandom = rand(1111111, 9999999);
        $arr = ["0", "1", "2", "3", "4", "5", "6", "7", "8", "9"];
        regenerate_now:
        shuffle($arr);
        $number_str = join("", $arr);
        $number = substr($number_str, 0, $length);
        if (strlen($number) != $length) {
            goto regenerate_now;
        }
        return $number;
    }
}

if (!function_exists('unlink_my_file')) {
    function unlink_my_file($filename)
    {
        if (!empty($filename) && file_exists(SITE_PATH . $filename)) :
            unlink(SITE_PATH . $filename);
        endif;
    }
}

if (!function_exists('reset_timezone_offset')) {
    function reset_timezone_offset($remote_tz)
    {
        $origin_dtz = new DateTimeZone('UTC');
        $remote_dtz = new DateTimeZone($remote_tz);
        $origin_dt = new DateTime("now", $origin_dtz);
        $remote_dt = new DateTime("now", $remote_dtz);
        $offset = $origin_dtz->getOffset($origin_dt) - $remote_dtz->getOffset($remote_dt);
        return $offset;
    }
}

if (!function_exists('show_custom_404')) {
    function show_custom_404()
    {
        $ci = &get_instance();
        $data['page_title'] = 'Not Found';
        $ci->output->set_status_header('404');
        echo $ci->load->admin_guest_template('404', $data, true);
        exit;
    }
}

if (!function_exists('pre')) {
    function pre($data = [], $exit = TRUE)
    {
        echo '<pre>';
        print_r($data);
        if($exit){
            die;
        }
    }
}

if (!function_exists('get_file_upload_error_desc')) {
    function get_file_upload_error_desc($error_code)
    {
        $upload_max_size = ini_get('upload_max_filesize');
        $error_desc = [
            0 => 'There is no error, the file uploaded with success',
            1 => 'Exceeds php.ini upload_max_filesize of ' . $upload_max_size,
            2 => 'The uploaded file exceeds the MAX_FILE_SIZE directive that was specified in the HTML form',
            3 => 'The uploaded file was only partially uploaded',
            4 => 'No file was uploaded',
            6 => 'Missing a temporary folder',
            7 => 'Failed to write file to disk.',
            8 => 'A PHP extension stopped the file upload.',
        ];
        return $error_desc[$error_code];
    }
}

if (!function_exists('generate_thumbnail')) {
    function generate_thumbnail($filepath, $params = [])
    {
        $gen_file_ext = $params['ext'] ?? 'png';
        $width = $params['width'] ?? 500;
        // $height = $params['height'] ?? 500;

        $thumbnail_ext = pathinfo($filepath, PATHINFO_EXTENSION);
        $thumbnail = str_replace('.' . $thumbnail_ext, '', $filepath);
        $thumbnail .= '.' . $gen_file_ext;

        // ffmpeg -ss 00:00:01.000 -i inputfile.mp4 -vframes 1 -s 500x500 -f image2 imagefile.jpg
        // $ffmpeg_cmd = ['ffmpeg','-ss 00:00:01.000','-i',$filepath,'-vframes 1','-s',$width.'x'.$height,'-f image2',$thumbnail];
        $ffmpeg_cmd = ['ffmpeg', '-ss 00:00:01.000', '-i', $filepath, '-vframes 1', '-vf', 'scale=' . $width . ':-1', '-f image2', $thumbnail];
        $ffmpeg_cmd_str = implode(' ', $ffmpeg_cmd);
        shell_exec($ffmpeg_cmd_str);
        return $thumbnail;
    }
}

if (!function_exists('calculate_offset')) {
    function calculate_offset($page, $posts_per_page)
    {
        return ($page - 1) * $posts_per_page;
    }
}

if (!function_exists('is_sample_token')) {
    function is_sample_token($token)
    {
        if (fnmatch("mytest-*-*", $token)) {
            $fields = explode('-', $token);
            return ['user_id' => $fields[1], 'user_device_id' => $fields[2]];
        } else {
            return false;
        }
    }
}

if (!function_exists('init_pagination')) {
    function init_pagination($postdata, $total)
    {
        $postdata['page'] = $postdata['page'] ?? 1;
        if (empty($postdata['page'])) {
            $postdata['page'] = 1;
        }
        $postdata['posts_per_page'] = $postdata['posts_per_page'] ?? 30;
        if (empty($postdata['posts_per_page'])) {
            $postdata['posts_per_page'] = 2;
        }
        $offset = calculate_offset($postdata['page'], $postdata['posts_per_page']);
        $postdata['offset'] = $offset;
        $postdata['max_pages'] = ceil($total / $postdata['posts_per_page']);
        $postdata['have_more_pages'] = ($postdata['page'] != $postdata['max_pages']);
        return $postdata;
    }
}

if (!function_exists('extract_hashtags')) {
    function extract_hashtags($string)
    {
        /* Match hashtags */
        preg_match_all('/#(\w+)/', $string, $matches);
        $keywords = [];
        /* Add all matches to array */
        foreach ($matches[1] as $match) {
            $keywords[] = $match;
        }
        return (array) $keywords;
    }
}

if (!function_exists('get_microtime')) {
    function get_microtime()
    {
        return round(microtime(true) * 1000);
    }
}

if (!function_exists('print_ratings')) {
    function print_ratings()
    {
        return '';
    }
}

if (!function_exists('mylog')) {
    function mylog($content)
    {
        $content = $content ?? "";
        $line = "\n--------------------------------------------------------------------------------\n";
        if (is_array($content) || is_object($content)) {
            $content = json_encode($content);
        }
        $currentYearLogPath = LOG_PATH . date('Y');
        $currentMonthLogPath = $currentYearLogPath . '/' . date('m');
        $logFile = $currentMonthLogPath . '/' . date('d') . '.log';
        if (!file_exists($currentYearLogPath)) { mkdir($currentYearLogPath, 0777, TRUE); }
        if (!file_exists($currentMonthLogPath)) { mkdir($currentMonthLogPath, 0777, TRUE); }
        file_put_contents($logFile, $content . $line, FILE_APPEND | LOCK_EX);
    }
}

if (!function_exists('extract_password_key')) {
    function extract_password_key()
    {
        return substr(PASSWORD_KEY, PASSWORD_STARTING_INDEX, PASSWORD_KEY_LENGTH);
    }
}

if (!function_exists('encrypt_this')) {
    function encrypt_this($encrypted_data = [])
    {
        $plain_data = json_encode($encrypted_data);
        $encryptor = new \RNCryptor\RNCryptor\Encryptor;
        return $encryptor->encrypt($plain_data, extract_password_key());
    }
}

if (!function_exists('decrypt_this')) {
    function decrypt_this($encryptedString)
    {
        $decryptor = new \RNCryptor\RNCryptor\Decryptor;
        $decrypted_data = $decryptor->decrypt($encryptedString, extract_password_key());
        return json_decode($decrypted_data, true);
    }
}

if (!function_exists('removeEmptyArray')) {
    function removeEmptyArray($row)
    {
        if (count($row['servers']) > 0) {
            return $row;
        }
    }
}

if (!function_exists('jwt_decode')) {
    function jwt_decode($token) {
        $tokenParts = explode(".", $token);
        $tokenHeader = base64_decode($tokenParts[0]);
        $tokenPayload = base64_decode($tokenParts[1]);
        $jwtHeader = json_decode($tokenHeader,true);
        $jwtPayload = json_decode($tokenPayload,true);
        return ['header'=>$jwtHeader,'body'=>$jwtPayload];
    }
}

if (!function_exists('ping')) {
    function ping($ip_address) {
        $ping_status = exec('ping -c 1 -W 1 '.$ip_address);
        if(!empty($ping_status)){
            $ping_values = explode(' = ',$ping_status)[1];
            $ping_count = round(substr($ping_values, 0, strpos($ping_values, '/')));
            return $ping_count;
        }else{
            return 0;
        }
    }
}

if (!function_exists('get_ovpn_file_content')) {
    function get_ovpn_file_content($ovpn, $ip) {
        $tempFileWithHash = sys_get_temp_dir().'/'.'hashed-'.$ip.'.log';
        file_put_contents($tempFileWithHash, $ovpn);
        exec("sed -E '/(^$|^#)/d' ".$tempFileWithHash, $ovpn_data);
        unlink($tempFileWithHash);
        $ovpn = implode("\n",array_values(array_filter($ovpn_data)));
        return $ovpn;
    }
}

if (!function_exists('get_vpn_wholesaler_credentials')) {
    function get_vpn_wholesaler_credentials($params) {
        $username = "";
        if($params['device_type'] == "I"){
            $username = $params['device_unique_id'];
        }else{
            $username = $params['original_transaction_id'];
        }
        $email = $username."@".VPN_WHOLESALER_DOMAIN;
        return ['email' => $email, 'password' => $username];
    }
}
