<?php
if (!defined('BASEPATH')) exit('No direct script access allowed');

class Sendmail {

    function __construct() {
        $this->ci = & get_instance();
        $this->send_mails = SEND_EMAILS_FLAG;
    }
    function preloading(){
        return [
            '{{APPNAME}}' => WEBSITE_TITLE,
            // '{{site_logo}}' => _LOGO_URL,
            // '{{bg_image}}' => ADMIN_IMAGE_URL.'bg.png',
            // '{{bg_color}}' => '#1516b2',
            // '{{support_email}}' => SUPPORT_EMAIL,
            '{{current_year}}' => date('Y')
        ];
    }

    function verify_your_email($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{USERNAME}}' => $params['fullname'],
            '{{EMAIL_VERIFICATION_LINK}}' => $params['email_verification_link'],
            '{{USER_EMAIL}}' => $params['email'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/confirm-email','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = 'VPN app Email Confirmation for Premium Servers';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function verify_your_email_with_otp($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{USERNAME}}' => $params['fullname'],
            '{{EMAIL_VERIFICATION_OTP}}' => $params['email_verification_otp'],
            '{{USER_EMAIL}}' => $params['email'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/confirm-email-with-otp','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = 'VPN app Email Confirmation for Premium Servers';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function user_reset_password($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{USERNAME}}' => $params['fullname'],
            '{{RESET_PASSWORD_LINK}}' => $params['reset_password_link'],
            '{{USER_EMAIL}}' => $params['email'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/reset-password','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = 'Reset your VPN Password';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }
    
    function user_reset_password_otp($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{USERNAME}}' => $params['fullname'],
            '{{RESET_PASSWORD_OTP}}' => $params['reset_password_otp'],
            '{{USER_EMAIL}}' => $params['email'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/reset-password-with-otp','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = 'Reset your VPN Password';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function admin_reset_password($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{USERNAME}}' => $params['fullname'],
            '{{RESET_PASSWORD_LINK}}' => $params['reset_password_link'],
            '{{USER_EMAIL}}' => $params['email'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/reset-password','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = 'Reset your VPN Password';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }
    
    function register($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{name}}' => $params['fullname'],
            '{{site_url}}' => SITE_URL,
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/register','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = WEBSITE_TITLE.' - New password request';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function forgot_password($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{name}}' => $params['fullname'],
            '{{action_url}}' => SITE_URL.'reset-password/'.$params['password_token'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/forgot_password','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = WEBSITE_TITLE.' - New password request';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function forgot_password_admin($params){
        $email_params = $this->preloading();
        $email_variables = array(
            '{{name}}' => $params['fullname'],
            '{{action_url}}' => SITE_URL.'reset-admin-password/'.$params['password_token'],
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/forgot_password','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = WEBSITE_TITLE.' - New password request';
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }

    function send_email_with_params($params = []){
        $this->ci->email->clear(TRUE);
        $this->ci->email->from($params['from'], WEBSITE_TITLE);
        $this->ci->email->to($params['to']);
        if(!empty($params['cc'] ?? [])){
            $this->ci->email->cc($params['cc']);
        }
        if(!empty($params['bcc'] ?? [])){
            $this->ci->email->bcc($params['bcc']);
        }
        $this->ci->email->subject($params['subject']);
        $this->ci->email->message($params['message']);
        if ($this->ci->email->send()) {
            return 1;
        }else {
            mylog($this->ci->email->print_debugger());
            return 0;
        }
    }

    function send_email($from,$to,$subject,$message){
        $this->ci->email->clear(TRUE);
        $env_type = get_env_type();
        $this->ci->email->from($from, WEBSITE_TITLE.$env_type);
        $this->ci->email->to($to);
        $this->ci->email->subject($subject);
        $this->ci->email->message($message);
        if ($this->ci->email->send()) {
            return 1;
        }else {
            mylog($this->ci->email->print_debugger());
            return 0;
        }
    }

    function server_down_alert($params){
        $email_params = $this->preloading();
        $table_data = '';
        $table_data_new = '';
        foreach ($params['servers'] as $server) {
            if(!empty($server)){
                $table_data .= '<tr>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['server_id'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['country_name'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['ip_address'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.utc_local($server['updated_at']).'</td>
                </tr>';
            }
        }  

        foreach ($params['servers_new'] as $server) {
            if(!empty($server)){
                $table_data_new .= '<tr>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['server_id'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['country_name'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.$server['ip_address'].'</td>
                <td style="padding: 10px; border: 1px solid #ccc;">'.utc_local($server['updated_at']).'</td>
                </tr>';
            }
        }
        $env_type = get_env_type();
        $email_variables = array(
            'name' => $params['fullname'],
            '{{ENV}}'=>$env_type,
            '{{SERVERS}}' => $table_data,
            '{{NEW_SERVERS}}' => $table_data_new,
        );
        $email_variables = array_merge($email_params,$email_variables);
        $template = $this->ci->load->view('emails/ovpn-server-down-mail-alert','',TRUE);
        $message = str_replace(array_keys($email_variables), array_values($email_variables), $template);
        $subject = WEBSITE_TITLE.' - VPNSuper OVPN Server Down'.$env_type;
        $result = ($this->send_mails) ? $this->send_email(MY_SMTP_FROM_EMAIL,$params['email'],$subject,$message) : 1;
        return $result;
    }
}