<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Admin_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
        $this->role_id = $this->db->select('role_id')->where('role_slug','admin')
        ->get($this->role_table)->row_array()['role_id'];
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['admin.admin_id'=>$id],'action'=>'row']);
    }

    public function checkIfExist($admin_email, $id = NULL)
    {
        $where = ['admin.admin_email' => $admin_email];
        if($id){ $where['admin_id != '] = $id; }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select('admin.*,role.role_slug');
        get_where($params['where']);
        $this->db->from($this->admin_table.' AS admin');
        $this->db->join($this->role_table.' AS role','role.role_id = admin.role_id');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params)
    {
        $params = init_model_params($params);
        $this->db->select('admin.*,role.role_slug');
        get_where($params['where']);
        get_filter_where(ADMINS_SEARCHABLE_FIELDS);
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], ADMINS_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->admin_table . ' AS admin');
        $this->db->join($this->role_table.' AS role','role.role_id = admin.role_id');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function addNew($postdata)
    {
        $row = [
            'admin_fullname' => $postdata['admin_fullname'],
            'admin_email' => $postdata['admin_email'],
            'admin_profilepic' => $postdata['admin_profilepic'] ?? '',
            'admin_password' => password_hash($postdata['password'], PASSWORD_BCRYPT),
            'role_id' => $this->role_id,
            'is_active' => $postdata['is_active'],
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->admin_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateExisting($postdata, $id)
    {
        $row = [
            'admin_fullname' => $postdata['admin_fullname'],
            'admin_email' => $postdata['admin_email'],
            'role_id' => $this->role_id,
            'is_active' => $postdata['is_active'],
            'updated_at' => time(),
        ];
        if(isset($postdata['admin_profilepic']) && !empty($postdata['admin_profilepic'])){
            $row['admin_profilepic'] = $postdata['admin_profilepic'];
        }
        if(isset($postdata['password']) && !empty($postdata['password'])){
            $row['admin_password'] = password_hash($postdata['password'], PASSWORD_BCRYPT);
        }
        $this->db->where('admin_id',$id);
        $flag = $this->db->update($this->admin_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }
}