<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Api_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function checkIfUserExist($where = [])
    {
        return $this->getUserDeviceDetails($where);
    }

    public function registerUserDetails($postdata)
    {
        $this->db->trans_start();
        $user_id = $this->registerUser($postdata);
        $this->bindUserDevice($user_id, $postdata['user_device_id']);
        $postdata['verification_type'] = $postdata['verification_type'] ?? 'link';
        if($postdata['verification_type'] == 'link' || $postdata['verification_type'] == ''){
            $this->registerEmailVerification($user_id);
        }elseif($postdata['verification_type'] == 'otp'){
            $this->registerEmailVerificationWithOTP($user_id);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return FALSE;
        }
        return $this->getUserDeviceDetails(['user.user_id'=>$user_id,'device.user_device_id'=>$postdata['user_device_id']]);
    }

    public function registerUser($userdata)
    {
        $user = [
            'signup_type' => $userdata['signup_type'],
            'social_id' => $userdata['social_id'] ?? null,
            'firstname' => $userdata['firstname'] ?? '',
            'lastname' => $userdata['lastname'] ?? '',
            'fullname' => ($userdata['firstname'] ?? '').' '.($userdata['lastname'] ?? ''),
            'email' => $userdata['email'] ?? '',
            'password' => (!empty($userdata['password'])) ? password_hash($userdata['password'], PASSWORD_BCRYPT) : '',
            'profilepic' => $userdata['profilepic'] ?? '',
            'is_profile_completed' => $userdata['is_profile_completed'] ?? 0,
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->user_table,$user);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateUserDetails($user_id, $userdata)
    {
        $user = [];
        if(isset($userdata['firstname']) && !empty($userdata['firstname'])){ $user['firstname'] = $userdata['firstname']; }
        if(isset($userdata['lastname']) && !empty($userdata['lastname'])){ $user['lastname'] = $userdata['lastname']; }
        if(isset($userdata['firstname']) && !empty($userdata['firstname']) && isset($userdata['lastname']) && !empty($userdata['lastname'])){
            $user['fullname'] = ($userdata['firstname'] ?? '').' '.($userdata['lastname'] ?? '');
        }
        if(isset($userdata['username']) && !empty($userdata['username'])){ $user['username'] = $userdata['username']; }
        if(isset($userdata['email']) && !empty($userdata['email'])){ $user['email'] = $userdata['email']; }
        if(isset($userdata['profilepic']) && !empty($userdata['profilepic'])){ $user['profilepic'] = $userdata['profilepic']; }
        if(isset($userdata['password']) && !empty($userdata['password'])){ $user['password'] = password_hash($userdata['password'], PASSWORD_BCRYPT); }
        if(isset($userdata['is_profile_completed']) && !empty($userdata['is_profile_completed'])){ $user['is_profile_completed'] = $userdata['is_profile_completed']; }

        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->user_table,$user);
        if(!$flag){
            return FALSE;
        }
        return $this->getUserDeviceDetails(['user.user_id'=>$user_id]);
    }

    public function registerDevice($device_data)
    {
        $device = [
            'device_unique_id' => $device_data['device_unique_id'],
            'device_name' => $device_data['device_name'],
            'device_token' => $device_data['device_token'],
            'device_type' => $device_data['device_type'] ?? ((strlen($device_data['device_unique_id']) == 36) ? "I" : "A"),
            'app_version' => $device_data['app_version'],
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->user_device_table,$device);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateDevice($device_data)
    {
        $where = [
            'device_unique_id' => $device_data['device_unique_id'],
        ];
        $device = ['updated_at' => time()];
        if(isset($device_data['device_name']) && !empty($device_data['device_name'])){ $device['device_name'] = $device_data['device_name']; }
        if(isset($device_data['device_type']) && !empty($device_data['device_type'])){ $device['device_type'] = $device_data['device_type']; }
        if(isset($device_data['device_token']) && !empty($device_data['device_token'])){ $device['device_token'] = $device_data['device_token']; }
        if(isset($device_data['app_version']) && !empty($device_data['app_version'])){ $device['app_version'] = $device_data['app_version']; }
        $this->db->where($where);
        $flag = $this->db->update($this->user_device_table,$device);
        if(!$flag){
            return FALSE;
        }
        return $this->getUserDeviceDetails(['device.device_unique_id'=>$device_data['device_unique_id']]);
    }

    public function bindUserDevice($user_id, $user_device_id)
    {
        $this->db->where('user_id', $user_id);
        $this->db->where('user_device_id', $user_device_id);
        $flag = $this->db->delete($this->user_subscription_table);
        if(!$flag){
            return FALSE;
        }
        
        $update = ['user_id' => $user_id, 'updated_at' => time()];
        $this->db->where('user_device_id', $user_device_id);
        $this->db->where('user_id', NULL);
        $this->db->update($this->user_subscription_table, $update);

        $device = [
            'user_id ' => $user_id,
            'user_device_id ' => $user_device_id,
            'login_ip' => $this->input->ip_address(),
            'login_at' => time(),
            'created_at' => time(),
        ];
        $flag = $this->db->insert($this->user_device_login_table,$device);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function registerEmailVerification($user_id)
    {
        $verify = [
            'user_id' => $user_id,
            'email_verification_code' => get_unique_id(15),
            'email_verification_status' => 0,
            'email_verification_sent_at' => time()
        ];
        $flag = $this->db->insert($this->email_verification_table,$verify);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function registerEmailVerificationWithOTP($user_id)
    {
        $verify = [
            'user_id' => $user_id,
            'email_verification_code' => get_unique_number(4),
            'email_verification_status' => 0,
            'email_verification_sent_at' => time()
        ];
        $flag = $this->db->insert($this->email_verification_table,$verify);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function insertDeviceData($device_data){
        $user_device_id = $this->registerDevice($device_data);
        return $this->getDeviceDetails(['device.user_device_id'=>$user_device_id]);
    }

    public function updateDeviceToken($device_token, $user_device_id)
    {
        $device = [
            'device_token' => $device_token,
            'updated_at' => time(),
        ];
        $this->db->where('user_device_id',$user_device_id);
        $flag = $this->db->update($this->user_device_table,$device);
        if(!$flag){
            return FALSE;
        }
        return $this->getUserDeviceDetails(['device.user_device_id'=>$user_device_id]);
    }

    public function updateDeviceData($device, $user_device_id)
    {
        $device['updated_at'] = time();
        $this->db->where('user_device_id',$user_device_id);
        $flag = $this->db->update($this->user_device_table,$device);
        if(!$flag){
            return FALSE;
        }
        return $this->getUserDeviceDetails(['device.user_device_id'=>$user_device_id]);
    }
    
    public function activeIsExpireSDKFlag($user_device_id, $postdata = [])
    {
        $device = [];
        $device['updated_at'] = time();
        $device['is_expired_from_sdk'] = 0;
        if(!empty($postdata) && !empty($postdata['wholesaler_user'])){
            $device['wholesaler_user'] = $postdata['wholesaler_user'];
        }
        $this->db->where('user_device_id',$user_device_id);
        $flag = $this->db->update($this->user_device_table,$device);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }

    public function deleteDeviceToken($device_data)
    {
        /* $this->db->where('device_unique_id',$device_data['device_unique_id']);
        $flag = $this->db->delete($this->user_device_table);
        if(!$flag){
            return FALSE;
        } */
        return TRUE;
    }

    public function getUserDeviceDetails($where=[]){
        $fields = array_merge(API_FIELDS_AUTHUSER, API_FIELDS_DEVICE, API_FIELDS_EMAIL_VERIFICATION_STATUS, ['user.is_deleted']);
        $this->db->select($fields);
        $this->db->from($this->user_device_table.' AS device');
        $this->db->join($this->user_device_login_table.' AS device_user','device.user_device_id = device_user.user_device_id','LEFT');
        $this->db->join($this->user_table.' AS user','device_user.user_id = user.user_id','LEFT');
        $this->db->join($this->email_verification_table.' AS email_verify','email_verify.user_id = user.user_id','LEFT');
        get_where($where);
        get_order(['order'=>'device_user.created_at','type'=>'desc']);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function getUserPassword($id){
        $this->db->select(API_FIELDS_PASSWORD);
        $this->db->from($this->user_table.' AS user');
        $this->db->where('user.user_id',$id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function getUserEmailVerificationData($id){
        $this->db->select(API_FIELDS_EMAIL_VERIFICATION);
        $this->db->from($this->email_verification_table.' AS email_verify');
        $this->db->where('email_verify.user_id',$id);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function verifyEmail($user_id, $code)
    {
        $verification = [
            'email_verification_code' => '',
            'email_verification_status' => 1,
            'email_verified_at' => time()
        ];
        $this->db->where('email_verification_code',$code);
        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->email_verification_table,$verification);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }

    public function resetEmailVerificationCode($user_id)
    {
        $verification = [
            'email_verification_code' => get_unique_id(15),
            'email_verification_status' => 0,
            'email_verification_sent_at' => time(),
            'email_verified_at' => NULL,
        ];
        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->email_verification_table,$verification);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }

    public function resetEmailVerificationCodeOTP($user_id)
    {
        $verification = [
            'email_verification_code' => get_unique_number(4),
            'email_verification_status' => 0,
            'email_verification_sent_at' => time(),
            'email_verified_at' => NULL,
        ];
        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->email_verification_table,$verification);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
    
    public function insertPasswordResetToken($user_id)
    {
        $password_token = get_unique_id(15);
        $token = [
            'user_id' => $user_id,
            'password_token' => $password_token,
            'token_validity' => (time() + (2 * CALC_DAYS)),
            'created_at' => time(),
        ];
        $flag = $this->db->insert($this->user_password_token_table,$token);
        if(!$flag){
            return FALSE;
        }
        return $this->getPasswordTokenDetails($password_token);
    }
    
    public function insertPasswordResetCode($user_id, $email)
    {
        $password_token = str_pad(rand(0, 9999), 4, "0", STR_PAD_LEFT);
        $token = [
            'user_id' => $user_id,
            'password_token' => $password_token,
            'token_validity' => (time() + (2 * CALC_DAYS)),
            'created_at' => time(),
        ];
        $flag = $this->db->insert($this->user_password_token_table,$token);
        if(!$flag){
            return FALSE;
        }
        return $this->getPasswordCodeDetails($password_token, $email);
    }

    public function updatePasswordResetToken($user_id)
    {
        $password_token = get_unique_id(15);
        $token = [
            'password_token' => $password_token,
            'token_validity' => (time() + (2 * CALC_DAYS)),
            'created_at' => time(),
        ];
        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->user_password_token_table,$token);
        if(!$flag){
            return FALSE;
        }
        return $this->getPasswordTokenDetails($password_token);
    }
    
    public function updatePasswordResetCode($user_id, $email)
    {
        $password_token = str_pad(rand(0,9999), 4, "0", STR_PAD_LEFT);
        $token = [
            'password_token' => $password_token,
            'token_validity' => (time() + (2 * CALC_DAYS)),
            'created_at' => time(),
        ];
        $this->db->where('user_id',$user_id);
        $flag = $this->db->update($this->user_password_token_table,$token);
        if(!$flag){
            return FALSE;
        }
        return $this->getPasswordCodeDetails($password_token, $email);
    }

    public function verifyPasswordResetToken($user_id)
    {
        $this->db->where('user_id',$user_id);
        $flag = $this->db->delete($this->user_password_token_table);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }

    public function getPasswordResetToken($user_id){
        $this->db->select(API_FIELDS_FORGOT_PASSWORD);
        $this->db->from($this->user_password_token_table.' AS passtoken');
        $this->db->where('passtoken.user_id',$user_id);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function getPasswordResetCode($user_id){
        return $this->getPasswordResetToken($user_id);
    }
    
    public function getPasswordTokenDetails($token){
        $fields = array_merge(API_FIELDS_FORGOT_PASSWORD, API_FIELDS_PASSWORD, API_FIELDS_USER);
        $this->db->select($fields);
        $this->db->from($this->user_password_token_table.' AS passtoken');
        $this->db->join($this->user_table.' AS user','user.user_id = passtoken.user_id');
        $this->db->where('passtoken.password_token',$token);
        $this->db->where('passtoken.token_validity >=',time());
        $query = $this->db->get();
        return $query->row_array();
    } 
    
    public function getPasswordCodeDetails($token, $email){
        $fields = array_merge(API_FIELDS_FORGOT_PASSWORD, API_FIELDS_PASSWORD, API_FIELDS_USER);
        $this->db->select($fields);
        $this->db->from($this->user_password_token_table.' AS passtoken');
        $this->db->join($this->user_table.' AS user','user.user_id = passtoken.user_id');
        $this->db->where('passtoken.password_token',$token);
        $this->db->where('user.email',$email);
        $this->db->where('passtoken.token_validity >=',time());
        $query = $this->db->get();
        return $query->row_array();
    } 

    public function logout($user_id, $user_device_id){
        $token = [
            'logout_ip' => $this->input->ip_address(),
            'logout_at' => time(),
        ];
        $this->db->where('user_id',$user_id);
        $this->db->where('user_device_id',$user_device_id);
        $flag = $this->db->update($this->user_device_login_table,$token);
        if(!$flag){
            return FALSE;
        }
        return $flag;
    }

    public function checkIfSubscriptionMappingExist($where){
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, ['usubscription.user_id', 'usubscription.user_device_id']);
        $this->db->select($fields);
        $this->db->from($this->user_subscription_table.' AS usubscription');
        $this->db->join($this->webhook_subscription_table.' AS web_subscription','web_subscription.original_transaction_id = usubscription.original_transaction_id AND web_subscription.is_latest_webhook = 1');
        get_where($where);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function insertSubscriptionMapping($params)
    {
        $subscription = [
            'user_id' => $params['user_id'],
            'user_device_id' => $params['user_device_id'],
            'original_transaction_id' => $params['original_transaction_id'],
            'is_latest_webhook_subscription' => TRUE,
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->user_subscription_table,$subscription);
        if(!$flag){ return FALSE; }
        $flag = $this->updateLatestFlag($subscription, $this->db->insert_id());
        if(!$flag){ return FALSE; }
        return TRUE;
    }

    function updateLatestFlag($subscription, $last_id){
        $this->db->where('user_id',$subscription['user_id']);
        $this->db->where('user_device_id',$subscription['user_device_id']);
        $this->db->where('user_subscription_id != ',$last_id);
        $flag = $this->db->update($this->user_subscription_table,['is_latest_webhook_subscription'=>FALSE]);
        return $flag;
    }

    public function getTransactionDetails($params = [])
    {
        $params = init_model_params($params);
        $fields = array_merge(API_FIELDS_WEBHOOK_SUBSCRIPTION, API_FIELDS_USER);
        $this->db->select($fields);
        get_where($params['where']);
        $this->db->from($this->webhook_subscription_table.' AS web_subscription');
        $this->db->join($this->user_subscription_table.' AS usubscription','web_subscription.original_transaction_id = usubscription.original_transaction_id','LEFT');
        $this->db->join($this->user_table.' AS user','user.user_id = usubscription.user_id','LEFT');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDeviceDetails($where = []){
        $this->db->select(API_FIELDS_DEVICE);
        $this->db->from($this->user_device_table.' AS device');
        get_where($where);
        $query = $this->db->get();
        return $query->row_array();
    }
    
    public function setWholesalerUser($wholesaler_user, $user_device_id)
    {
        $update = ['wholesaler_user' => $wholesaler_user, 'updated_at' => time()];
        $this->db->where('user_device_id', $user_device_id);
        return $this->db->update($this->user_device_table, $update);
    }

    public function insertSubscriptionDetails($params){
        $product_id = $params['product_id'];
        $notification_type = $this->webhook_model->getAndroidNotificationType($params['responseObject']);
        $expiration_intent = $this->webhook_model->getCancelReasonForAndroidReceipt($params['responseObject']['cancelReason']);
        $obj = [
            'notification_store' => $params['notification_store'],
            'notification_type' => $notification_type,
            'environment' => in_array($product_id,array_keys(ANDROID_SUBSCRIPTION_PACKAGE_LIST)) ? "PROD" : "Sandbox",
            'auto_renew_product_id' => $product_id,
            'auto_renew_status' => $params['responseObject']['autoRenewing'] ?? 0,
            'auto_renew_status_change_date_ms' => $params['responseObject']['autoResumeTimeMillis'] ?? 0,
            'latest_receipt' => $params['receipt'],
            'in_app_ownership_type' => 'PURCHASED',
            'purchase_date_ms' => $params['responseObject']['startTimeMillis'] ?? 0,
            'original_purchase_date_ms' => $params['responseObject']['startTimeMillis'] ?? 0,
            'transaction_id' => $params['order_id'],
            'original_transaction_id' => $params['order_id'],
            'expires_date_ms' => $params['responseObject']['expiryTimeMillis'] ?? 0,
            'product_id' => $product_id,
            'is_trial_period' => boolval($params['responseObject']['paymentState'] == 2),
            'cancellation_date_ms' => $params['responseObject']['userCancellationTimeMillis'] ?? 0,
            'expiration_intent' => $expiration_intent
        ];
        $flag = $this->webhook_model->formatAndSaveWebhookData($obj);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }

    public function get_full_user_info($user_id){
        return $this->db->where('user_id',$user_id)->get($this->user_table)->row_array();
    }

    public function get_full_user_devices_info($user_id, $fields){
        $this->db->select($fields);
        $this->db->from($this->user_device_login_table . ' AS device_user');
        $this->db->join($this->user_device_table . ' AS device', 'device.user_device_id = device_user.user_device_id');
        $this->db->join($this->user_table . ' AS user', 'device_user.user_id = user.user_id');
        $this->db->where('user.user_id',$user_id);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function get_full_user_pass_tokens_info($user_id){
        return $this->db->where('user_id',$user_id)->get($this->user_password_token_table)->row_array();
    }
    
    public function get_full_user_verify_email_info($user_id){
        return $this->db->where('user_id',$user_id)->get($this->email_verification_table)->row_array();
    }

    public function insertUserRowIfDoesNotExist($userdata){
        $userrow = $this->user_model->getRowByEmail($userdata['email']);
        if(!is_null($userrow) && $userrow['user_id']){
            return $userrow['user_id'];
        }else{
            $flag = $this->db->insert($this->user_table, $userdata);
            if (!$flag) {
                return false;
            }
            return $this->db->insert_id();
        }
    }

    public function insertPasswordTokenDetails($token){
        $flag = $this->db->insert($this->user_password_token_table, $token);
        if (!$flag) {
            return false;
        }
        return $this->db->insert_id();
    }

    public function insertEmailVerificationDetails($verification){
        $flag = $this->db->insert($this->email_verification_table, $verification);
        if (!$flag) {
            return false;
        }
        return $this->db->insert_id();
    }

    public function regiserUserDeviceIfDoesNotExist($device){
        $where = ['device.device_unique_id' => $device['device_unique_id']];
        $device_data = $this->getDeviceDetails($where);
        if(!$device_data){
            $device_data = $this->insertDeviceData($device);
        }
        return $device_data;
    }

    public function importLoginData($logins){
        $flag = $this->db->insert_batch($this->user_device_login_table,$logins);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
    
    public function importWebhookData($webhooks){
        $receipts = [];
        $webhooks = array_map(function($webhook_row) use (&$receipts){
            unset($webhook_row['webhook_subscription_id']);
            unset($webhook_row['is_expired']);
            $receipts[] = [
                'transaction_id' => $webhook_row['transaction_id'],
                'latest_receipt' => $webhook_row['latest_receipt']
            ];
            unset($webhook_row['latest_receipt']);
            return $webhook_row;
        }, $webhooks);
        $flag = $this->db->insert_batch($this->webhook_subscription_table,$webhooks);
        if(!$flag){
            return FALSE;
        }
        $this->db->insert_batch($this->subscription_receipt_table, $receipts);
        return TRUE;
    }

    public function importUserSubscriptionData($subscription){
        $flag = $this->db->insert_batch($this->user_subscription_table,$subscription);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
}