<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Country_model extends My_Model
{

    public function __construct()
    {
        parent::__construct();
    }

    public function getOpenGateServerListOld($where = [], $currentTime = 0)
    {
        $this->db->select(API_FIELD_COUNTRY_FIELD);
        $this->db->from($this->countries_table . ' as countries');
        $this->db->where($where);
        get_order(['order' => 'countries.updated_at', 'type' => 'DESC']);
        $query = $this->db->get();
        $data = $query->result_array();
        array_walk($data, function (&$value) use ($currentTime) {
            $value['servers'] = formatList($this->getServerList(['vpn_servers.country_id' => $value['country_id'], 'vpn_servers.updated_at >= ' => $currentTime]));
        });
        //$data = array_filter($data, "removeEmptyArray");
        return $data;
    }

    public function getOpenGateServerList($where = [])
    {
        $this->db->select(API_FIELD_OPTIMAL_SERVER_FIELD);
        $this->db->from($this->countries_table . ' as country');
        $this->db->join($this->vpn_server_table . ' as vpn_server','country.country_id = vpn_server.country_id','LEFT');
        get_where($where);
        get_order(['order' => 'vpn_server.updated_at', 'type' => 'DESC']);
        $query = $this->db->get();
        $result = $query->result_array();
        return $result;
    }

    public function getOptimalServerList($where = [], $page = 1)
    {
        $this->db->select(API_FIELD_OPTIMAL_SERVER_FIELD);
        $this->db->from($this->vpn_server_table . ' as vpn_server');
        $this->db->join($this->countries_table . ' as country','country.country_id = vpn_server.country_id');
        get_where($where);
        get_order(['order' => 'vpn_server.ping_count', 'type' => 'ASC']);
        get_limit(1, $page);
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }
    
    public function getRandomOptimalServerList($where = [])
    {
        $fields = array_merge(API_FIELD_OPTIMAL_SERVER_FIELD,['sum(vpn_server.ping_count) as total_ping_count','count(vpn_server.server_id) as total_servers']);
        $this->db->select($fields);
        $this->db->from($this->vpn_server_table . ' as vpn_server');
        $this->db->join($this->countries_table . ' as country','country.country_id = vpn_server.country_id');
        get_where($where);
        get_order(['type' => 'random']);
        get_limit(1);
        $this->db->group_by('vpn_server.country_id');
        $query = $this->db->get();
        $result = $query->row_array();
        return $result;
    }

    private function getServerList($where)
    {
        $this->db->select(API_VPN_SERVER_FIELD);
        $this->db->from($this->vpn_server_table . ' as vpn_servers');
        $this->db->where($where);
        get_order(['order' => 'vpn_servers.updated_at', 'type' => 'DESC']);
        $query = $this->db->get();
        return $query->result_array();
    }

    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(API_FIELD_COUNTRY_FIELD);
        get_where($params['where']);
        $this->db->from($this->countries_table . ' AS countries');
        if ($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'], $params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(API_FIELD_COUNTRY_FIELD);
        get_where($params['where']);
        get_filter_where(COUNTRY_ORDERABLE_FIELD);
        if ($params['action'] != 'count') {
            get_filter_order($_REQUEST, $params['order'], COUNTRY_SEARCHABLE_FIELD);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->countries_table . ' AS countries');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function insertCountry($postdata){
        $country = [];
        $country['country'] = $postdata['country'];
        $country['country_code'] = $postdata['country_code'];
        $country['premium'] = $postdata['premium'] ?? 0;
        $country['recommend'] = $postdata['recommend'] ?? 0;
        $country['flag'] = $postdata['flag'] ?? '';
        $country['is_active'] = $postdata['is_active'] ?? 0;
        $country['created_at'] = time();
        $country['updated_at'] = time();
        $this->db->insert($this->countries_table, $country);
        return $this->db->insert_id();
    }

    public function insertVPNServer($postData)
    {
        $postData['created_at'] = time();
        $postData['updated_at'] = time();
        unset($postData['country_id']);
        $this->db->insert($this->countries_table, $postData);
    }

    public function updateExisting($postdata, $id)
    {
        if($postdata['is_active'] == 1){
            $whereGetServerList = ['vpn_servers.is_active'=>1,'vpn_servers.country_id' => $id];
             $servers = formatList($this->getServerList($whereGetServerList));
             foreach($servers as $server){
                 $this->db->where('server_id', $server['server_id']);
                 $server_postdata['updated_at'] = time();
                 $flag = $this->db->update($this->vpn_server_table, $server_postdata);
                 if (!$flag) {
                    return FALSE;
                }
             }
        }
        $postdata['updated_at'] = time();
        unset($postdata['country_id']);
        $this->db->where('country_id', $id);
        $flag = $this->db->update($this->countries_table, $postdata);
        if (!$flag) {
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where' => ['countries.country_id' => $id], 'action' => 'row']);
    }

    public function checkIfExist($country_name, $id = NULL)
    {
        $where = ['countries.country' => $country_name];
        if ($id) {
            $where['country_id != '] = $id;
        }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }

    public function get_csv_list_of_inactive_countries_having_active_servers(){
        $this->db->select('GROUP_CONCAT(DISTINCT country.country_id) AS countries');
        $this->db->from($this->vpn_server_table . ' as vpn_server');
        $this->db->join($this->countries_table . ' as country','country.country_id = vpn_server.country_id','LEFT');
        $this->db->where('vpn_server.is_active', TRUE);
        $this->db->where('country.is_active', FALSE);
        $query = $this->db->get();
        $result = $query->row_array()['countries'] ?? '';
        return $result;
    }

    public function make_countries_active($countries){
        $old_records = array_map(function($country_id){
            $row = [
                'country_id' => $country_id,
                'is_active' => '1',
                'updated_at' => time()
            ];
            return $row;
        }, $countries);
        $this->db->update_batch($this->countries_table, $old_records, 'country_id');
    }

    public function get_csv_list_of_active_countries_having_active_servers(){
        $this->db->select('GROUP_CONCAT(DISTINCT country.country_id) AS countries');
        $this->db->from($this->vpn_server_table . ' as vpn_server');
        $this->db->join($this->countries_table . ' as country','country.country_id = vpn_server.country_id','LEFT');
        $this->db->where('vpn_server.is_active', TRUE);
        $this->db->where('country.is_active', TRUE);
        $query = $this->db->get();
        $result = $query->row_array()['countries'] ?? '';
        return $result;
    }

    public function make_countries_inactive($countries){
        $this->db->where_not_in('country_id',$countries);
        $this->db->where('is_active',1);
        $flag = $this->db->update($this->countries_table, ['is_active'=>0, 'updated_at'=>time()]);
        return $flag;
    }

    public function getCountry($country_code)
    {
        $this->db->from($this->countries_table . ' as country');
        $this->db->where(['country.country_code'=>$country_code]);
        $query = $this->db->get();
        return $query->row_array();
    }

    public function addCountry($postdata)
    {
        $row['country'] = $postdata['country_code'];
        $row['country_code'] = $postdata['country_code'];
        $row['premium'] = 1;
        $row['recommend'] = 0;
        $row['flag'] = '';
        $row['is_active'] = 1;
        $row['created_at'] = time();
        $row['updated_at'] = time();
        $flag = $this->db->insert($this->countries_table, $row);
        if (!$flag) {
            return FALSE;
        }
        return $this->getCountry($postdata['country_code']);
    }
    
    public function addOrUpdateCountry($postdata){
        $get_country = $this->country_model->getCountry($postdata['country_code']);
        if(empty($get_country)){
            $get_country = $this->country_model->addCountry($postdata);
            mylog('country not found in add new country : '.json_encode($get_country));
        }
        if($get_country['is_active'] == 0){
            $post_data = [
                'is_active'=>1,
                'country_id'=>$get_country['country_id'],
                'updated_at'=>time()
            ];
            $this->country_model->updateExisting($post_data,$get_country['country_id']);
        }
        return $get_country;
    }
}
