<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Dashboard_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getCounterOfRegisteredDevices($where)
    {
        $this->db->select('count(*)');
        get_where($where);
        $this->db->from($this->user_device_table.' AS device');
        return $this->db->get_compiled_select();
    }

    /* public function getRegisteredDevicesStats($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $where = [
                'SINGLE_WHERE' => 'device.created_at BETWEEN ' . $start . ' AND ' . $end,
            ];
            $sql[] = '(' . $this->getCounterOfRegisteredDevices($where) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    /* public function getRegisteredActiveSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 0,
                    'web_subscription.is_trial_period' => 0,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredActiveSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 0,
                'web_subscription.is_trial_period' => 0,
            ],
            'action' => 'count'
        ];
        return $this->user_model->getDatatableList($params);
    }

    /* public function getRegisteredExpiredSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 1,
                    'web_subscription.is_trial_period' => 0,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredExpiredSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 1,
                'web_subscription.is_trial_period' => 0,
            ],
            'action' => 'count'
        ];
        return $this->user_model->getDatatableList($params);
    }

    /* public function getRegisteredTrialSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 0,
                    'web_subscription.is_trial_period' => 1,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredTrialSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 0,
                'web_subscription.is_trial_period' => 1,
            ],
            'action' => 'count'
        ];
        return $this->user_model->getDatatableList($params);
    }

    /* public function getRegisteredActiveGuestSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 0,
                    'web_subscription.is_trial_period' => 0,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->guest_user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredActiveGuestSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 0,
                'web_subscription.is_trial_period' => 0,
            ],
            'action' => 'count'
        ];
        return $this->guest_user_model->getDatatableList($params);
    }

    /* public function getRegisteredExpiredGuestSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 1,
                    'web_subscription.is_trial_period' => 0,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->guest_user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredExpiredGuestSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 1,
                'web_subscription.is_trial_period' => 0,
            ],
            'action' => 'count'
        ];
        return $this->guest_user_model->getDatatableList($params);
    }

    /* public function getRegisteredTrialGuestSubscribers($length, $offset){
        $sql = [];
        for ($i = ($length-1); $i >= 0; $i--):
            $start_month_str = "-" . $i . " months";
            $end_month_str = "-" . ($i - 1) . " months";
            $start = strtotime(date('Y-m-01 00:00:00') . " $start_month_str") - $offset;
            $end = strtotime(date('Y-m-01 00:00:00') . " $end_month_str") - ($offset + 1);
            $params = [
                'where' => [
                    'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                    'is_expired HAVING' => 0,
                    'web_subscription.is_trial_period' => 1,
                ],
                'action' => 'count'
            ];
            $sql[] = '(' . $this->guest_user_model->getDatatableList($params) . ') AS label_' . $i;
        endfor;
        $this->db->select(implode(', ',$sql));
        $query = $this->db->get();
        return $query->row_array();
    } */

    public function getRegisteredTrialGuestSubscribers($offset){
        $start = strtotime(date('Y-m-01 00:00:00')) - $offset;
        $end = time();
        $params = [
            'where' => [
                'SINGLE_WHERE' => 'web_subscription.created_at BETWEEN ' . $start . ' AND ' . $end,
                'is_expired HAVING' => 0,
                'web_subscription.is_trial_period' => 1,
            ],
            'action' => 'count'
        ];
        return $this->guest_user_model->getDatatableList($params);
    }

    public function getSubscriptionAnalytics($params = [])
    {
        $params = init_model_params($params);
        $this->db->select(API_FIELDS_SUBSCRIPTION_ANALYTICS);
        get_where($params['where']);
        $this->db->from($this->subscription_analytics_table.' AS subscription_analytic');
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }
}