<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Profile_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function updateExisting($postdata, $id)
    {
        $row = [
            'admin_fullname' => $postdata['admin_fullname'],
            'admin_email' => $postdata['admin_email'],
            'updated_at' => time(),
        ];
        if(isset($postdata['admin_profilepic'])){
            $row['admin_profilepic'] = $postdata['admin_profilepic'];
        }
        $this->db->where('admin_id',$id);
        $flag = $this->db->update($this->admin_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function updatePassword($password, $id)
    {
        $row = [
            'admin_password' => password_hash($password, PASSWORD_BCRYPT),
            'updated_at' => time(),
        ];
        $this->db->where('admin_id',$id);
        $flag = $this->db->update($this->admin_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    public function deletePasswordTokens($id, $token)
    {
        $this->db->where('admin_id', $id);
        $this->db->where('password_token', $token);
        $flag = $this->db->delete($this->admin_password_token_table);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }
}