<?php
defined('BASEPATH') or exit('No direct script access allowed');

class Role_model extends My_Model {

    public function __construct()
    {
        parent::__construct();
    }

    public function getRow($id)
    {
        return $this->getRecords(['where'=>['role_id'=>$id],'action'=>'row']);
    }

    public function getRowByName($role_title)
    {
        return $this->getRecords(['where' => ['role_title' => $role_title], 'action' => 'row']);
    }

    public function checkIfExist($role_title, $id = NULL)
    {
        $where = ['role_title' => $role_title];
        if($id){ $where['role_id != '] = $id; }
        return $this->getRecords(['where' => $where, 'action' => 'row']);
    }
    
    public function getRecords($params = [])
    {
        $params = init_model_params($params);
        get_where($params['where']);
        $this->db->from($this->role_table);
        if($params['action'] != 'count') get_order($params['order']);
        get_limit($params['limit'],$params['offset']);
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function getDatatableList($params)
    {
        $params = init_model_params($params);
        $this->db->select('role.*');
        get_where($params['where']);
        get_filter_where(ROLES_SEARCHABLE_FIELDS);
        if($params['action'] != 'count'){
            get_filter_order($_REQUEST, $params['order'], ROLES_ORDERABLE_FIELDS);
            get_limit($params['limit'], $params['offset']);
        }
        $this->db->from($this->role_table . ' AS role');
        $query = $this->db->get();
        return get_data($params, $query);
    }

    public function addNew($postdata)
    {
        $row = [
            'role_title' => $postdata['role_title'],
            'role_slug' => url_title($postdata['role_title'],'-',TRUE),
            'is_active' => $postdata['is_active'],
            'created_at' => time(),
            'updated_at' => time(),
        ];
        $flag = $this->db->insert($this->role_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->insert_id();
    }

    public function updateExisting($postdata, $id)
    {
        $row = [
            'role_title' => $postdata['role_title'],
            'role_slug' => url_title($postdata['role_title'],'-',TRUE),
            'is_active' => $postdata['is_active'],
            'updated_at' => time(),
        ];
        $this->db->where('role_id',$id);
        $flag = $this->db->update($this->role_table,$row);
        if(!$flag){
            return FALSE;
        }
        return $this->db->affected_rows();
    }

    private function attachPermission($role_id, $module_methods)
    {
        $module_method_data = array_map(function($module_method_id) use ($role_id) {
            return [
                'role_id' => $role_id,
                'module_method_id' => $module_method_id,
            ];
        }, $module_methods);
        $flag = $this->db->insert_batch($this->role_permission_table,$module_method_data);
        if(!$flag){
            return FALSE;
        }
        return TRUE;
    }
    
    private function detachPermission($role_id, $module_methods)
    {
        $this->db->where('role_id', $role_id);
        $this->db->where_in('module_method_id', $module_methods);
        $flag = $this->db->delete($this->role_permission_table);
        if (!$flag) {
            return false;
        }
        return $this->db->affected_rows();
    }

    public function updatePermissions($id, $inserted_permissions = [], $deleted_permissions = [])
    {
        $this->db->trans_start();
        if(!empty($inserted_permissions)){
            $this->attachPermission($id, $inserted_permissions);
        }
        if(!empty($deleted_permissions)){
            $this->detachPermission($id, $deleted_permissions);
        }
        $this->db->trans_complete();
        if ($this->db->trans_status() === FALSE)
        {
            return FALSE;
        }
        return TRUE;
    }

    public function getModulePermissions($role_id)
    {
        $fields = ['permission.*'];
        $fields = array_merge($fields, ['module.module_id','module.module_title','module.module_slug']);
        $fields = array_merge($fields, ['method.method_id','method.method_title','method.method_slug','method.method_identifier']);
        $this->db->select(implode(',',$fields));
        $this->db->where('role_id',$role_id);
        $this->db->from($this->role_permission_table.' AS permission');
        $this->db->join($this->module_method_table.' AS module_method','module_method.module_method_id = permission.module_method_id');
        $this->db->join($this->module_table.' AS module','module.module_id = module_method.module_id');
        $this->db->join($this->method_table.' AS method','method.method_id = module_method.method_id');
        $query = $this->db->get();
        return $query->result_array();
    }
}